/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class DescribeAclsResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private short errorCode;
    private String errorMessage;
    private List<DescribeAclsResource> resources;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("error_message", Type.NULLABLE_STRING, "The error message, or null if there was no error."), new Field("resources", new ArrayOf(DescribeAclsResource.SCHEMA_0), "Each Resource that is referenced in an ACL."));
    public static final Schema SCHEMA_1 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("error_message", Type.NULLABLE_STRING, "The error message, or null if there was no error."), new Field("resources", new ArrayOf(DescribeAclsResource.SCHEMA_1), "Each Resource that is referenced in an ACL."));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};

    public DescribeAclsResponseData(Readable readable, short version) {
        this.resources = new ArrayList<DescribeAclsResource>();
        this.read(readable, version);
    }

    public DescribeAclsResponseData(Struct struct, short version) {
        this.resources = new ArrayList<DescribeAclsResource>();
        this.fromStruct(struct, version);
    }

    public DescribeAclsResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.errorMessage = "";
        this.resources = new ArrayList<DescribeAclsResource>();
    }

    @Override
    public short apiKey() {
        return 29;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable readable, short version) {
        this.throttleTimeMs = readable.readInt();
        this.errorCode = readable.readShort();
        this.errorMessage = readable.readNullableString();
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.resources.clear();
        } else {
            this.resources.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.resources.add(new DescribeAclsResource(readable, version));
            }
        }
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeInt(this.throttleTimeMs);
        writable.writeShort(this.errorCode);
        writable.writeNullableString(this.errorMessage);
        writable.writeInt(this.resources.size());
        for (DescribeAclsResource element : this.resources) {
            element.write(writable, version);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        this.errorCode = struct.getShort("error_code");
        this.errorMessage = struct.getString("error_message");
        Object[] nestedObjects = struct.getArray("resources");
        this.resources = new ArrayList<DescribeAclsResource>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.resources.add(new DescribeAclsResource((Struct)nestedObject, version));
        }
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        struct.set("error_code", (Object)this.errorCode);
        struct.set("error_message", (Object)this.errorMessage);
        Struct[] nestedObjects = new Struct[this.resources.size()];
        int i = 0;
        for (DescribeAclsResource element : this.resources) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("resources", (Object)nestedObjects);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 4;
        size += 2;
        size += 2;
        if (this.errorMessage != null) {
            size += MessageUtil.serializedUtf8Length(this.errorMessage);
        }
        size += 4;
        for (DescribeAclsResource element : this.resources) {
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeAclsResponseData)) {
            return false;
        }
        DescribeAclsResponseData other = (DescribeAclsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        return !(this.resources == null ? other.resources != null : !this.resources.equals(other.resources));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        hashCode = 31 * hashCode + (this.resources == null ? 0 : this.resources.hashCode());
        return hashCode;
    }

    public String toString() {
        return "DescribeAclsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", errorMessage='" + this.errorMessage + "', resources=" + MessageUtil.deepToString(this.resources.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public List<DescribeAclsResource> resources() {
        return this.resources;
    }

    public DescribeAclsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DescribeAclsResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public DescribeAclsResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }

    public DescribeAclsResponseData setResources(List<DescribeAclsResource> v) {
        this.resources = v;
        return this;
    }

    public static class AclDescription
    implements Message {
        private String principal;
        private String host;
        private byte operation;
        private byte permissionType;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public AclDescription(Readable readable, short version) {
            this.read(readable, version);
        }

        public AclDescription(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public AclDescription() {
            this.principal = "";
            this.host = "";
            this.operation = 0;
            this.permissionType = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable readable, short version) {
            this.principal = readable.readNullableString();
            this.host = readable.readNullableString();
            this.operation = readable.readByte();
            this.permissionType = readable.readByte();
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeString(this.principal);
            writable.writeString(this.host);
            writable.writeByte(this.operation);
            writable.writeByte(this.permissionType);
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.principal = struct.getString("principal");
            this.host = struct.getString("host");
            this.operation = struct.getByte("operation");
            this.permissionType = struct.getByte("permission_type");
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("principal", (Object)this.principal);
            struct.set("host", (Object)this.host);
            struct.set("operation", (Object)this.operation);
            struct.set("permission_type", (Object)this.permissionType);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.principal);
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.host);
            ++size;
            return ++size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AclDescription)) {
                return false;
            }
            AclDescription other = (AclDescription)obj;
            if (this.principal == null ? other.principal != null : !this.principal.equals(other.principal)) {
                return false;
            }
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            if (this.operation != other.operation) {
                return false;
            }
            return this.permissionType == other.permissionType;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.principal == null ? 0 : this.principal.hashCode());
            hashCode = 31 * hashCode + (this.host == null ? 0 : this.host.hashCode());
            hashCode = 31 * hashCode + this.operation;
            hashCode = 31 * hashCode + this.permissionType;
            return hashCode;
        }

        public String toString() {
            return "AclDescription(principal='" + this.principal + "', host='" + this.host + "', operation=" + this.operation + ", permissionType=" + this.permissionType + ")";
        }

        public String principal() {
            return this.principal;
        }

        public String host() {
            return this.host;
        }

        public byte operation() {
            return this.operation;
        }

        public byte permissionType() {
            return this.permissionType;
        }

        public AclDescription setPrincipal(String v) {
            this.principal = v;
            return this;
        }

        public AclDescription setHost(String v) {
            this.host = v;
            return this;
        }

        public AclDescription setOperation(byte v) {
            this.operation = v;
            return this;
        }

        public AclDescription setPermissionType(byte v) {
            this.permissionType = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("principal", Type.STRING, "The ACL principal."), new Field("host", Type.STRING, "The ACL host."), new Field("operation", Type.INT8, "The ACL operation."), new Field("permission_type", Type.INT8, "The ACL permission type."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }

    public static class DescribeAclsResource
    implements Message {
        private byte type;
        private String name;
        private byte patternType;
        private List<AclDescription> acls;
        public static final Schema SCHEMA_0 = new Schema(new Field("type", Type.INT8, "The resource type."), new Field("name", Type.STRING, "The resource name."), new Field("acls", new ArrayOf(AclDescription.SCHEMA_0), "The ACLs."));
        public static final Schema SCHEMA_1 = new Schema(new Field("type", Type.INT8, "The resource type."), new Field("name", Type.STRING, "The resource name."), new Field("pattern_type", Type.INT8, "The resource pattern type."), new Field("acls", new ArrayOf(AclDescription.SCHEMA_0), "The ACLs."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};

        public DescribeAclsResource(Readable readable, short version) {
            this.acls = new ArrayList<AclDescription>();
            this.read(readable, version);
        }

        public DescribeAclsResource(Struct struct, short version) {
            this.acls = new ArrayList<AclDescription>();
            this.fromStruct(struct, version);
        }

        public DescribeAclsResource() {
            this.type = 0;
            this.name = "";
            this.patternType = (byte)3;
            this.acls = new ArrayList<AclDescription>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable readable, short version) {
            this.type = readable.readByte();
            this.name = readable.readNullableString();
            this.patternType = version >= 1 ? readable.readByte() : (byte)3;
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.acls.clear();
            } else {
                this.acls.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.acls.add(new AclDescription(readable, version));
                }
            }
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeByte(this.type);
            writable.writeString(this.name);
            if (version >= 1) {
                writable.writeByte(this.patternType);
            }
            writable.writeInt(this.acls.size());
            for (AclDescription element : this.acls) {
                element.write(writable, version);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.type = struct.getByte("type");
            this.name = struct.getString("name");
            this.patternType = version >= 1 ? struct.getByte("pattern_type") : (byte)3;
            Object[] nestedObjects = struct.getArray("acls");
            this.acls = new ArrayList<AclDescription>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.acls.add(new AclDescription((Struct)nestedObject, version));
            }
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("type", (Object)this.type);
            struct.set("name", (Object)this.name);
            if (version >= 1) {
                struct.set("pattern_type", (Object)this.patternType);
            }
            Struct[] nestedObjects = new Struct[this.acls.size()];
            int i = 0;
            for (AclDescription element : this.acls) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("acls", (Object)nestedObjects);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            ++size;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.name);
            if (version >= 1) {
                ++size;
            } else if (this.patternType != 3) {
                throw new UnsupportedVersionException("Attempted to write a non-default patternType at version " + version);
            }
            size += 4;
            for (AclDescription element : this.acls) {
                size += element.size(version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribeAclsResource)) {
                return false;
            }
            DescribeAclsResource other = (DescribeAclsResource)obj;
            if (this.type != other.type) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.patternType != other.patternType) {
                return false;
            }
            return !(this.acls == null ? other.acls != null : !this.acls.equals(other.acls));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.type;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + this.patternType;
            hashCode = 31 * hashCode + (this.acls == null ? 0 : this.acls.hashCode());
            return hashCode;
        }

        public String toString() {
            return "DescribeAclsResource(type=" + this.type + ", name='" + this.name + "', patternType=" + this.patternType + ", acls=" + MessageUtil.deepToString(this.acls.iterator()) + ")";
        }

        public byte type() {
            return this.type;
        }

        public String name() {
            return this.name;
        }

        public byte patternType() {
            return this.patternType;
        }

        public List<AclDescription> acls() {
            return this.acls;
        }

        public DescribeAclsResource setType(byte v) {
            this.type = v;
            return this;
        }

        public DescribeAclsResource setName(String v) {
            this.name = v;
            return this;
        }

        public DescribeAclsResource setPatternType(byte v) {
            this.patternType = v;
            return this;
        }

        public DescribeAclsResource setAcls(List<AclDescription> v) {
            this.acls = v;
            return this;
        }
    }
}

