/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DescribeClientQuotasResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    String errorMessage;
    List<EntryData> entries;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", (Type)Type.INT16, "The error code, or `0` if the quota description succeeded."), new Field("error_message", (Type)Type.NULLABLE_STRING, "The error message, or `null` if the quota description succeeded."), new Field("entries", (Type)ArrayOf.nullable((Type)EntryData.SCHEMA_0), "A result entry.")});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public DescribeClientQuotasResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DescribeClientQuotasResponseData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public DescribeClientQuotasResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.errorMessage = "";
        this.entries = new ArrayList<EntryData>(0);
    }

    public short apiKey() {
        return 48;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public void read(Readable _readable, short _version) {
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        short length = _readable.readShort();
        if (length < 0) {
            this.errorMessage = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field errorMessage had invalid length " + length);
            }
            this.errorMessage = _readable.readString((int)length);
        }
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            this.entries = null;
        } else {
            ArrayList<EntryData> newCollection = new ArrayList<EntryData>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new EntryData(_readable, _version));
            }
            this.entries = newCollection;
        }
        this._unknownTaggedFields = null;
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        if (this.errorMessage == null) {
            _writable.writeShort((short)-1);
        } else {
            _stringBytes = _cache.getSerializedValue((Object)this.errorMessage);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        if (this.entries == null) {
            _writable.writeInt(-1);
        } else {
            _writable.writeInt(this.entries.size());
            _stringBytes = this.entries.iterator();
            while (_stringBytes.hasNext()) {
                EntryData entriesElement = (EntryData)_stringBytes.next();
                entriesElement.write(_writable, _cache, _version);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void fromStruct(Struct struct, short _version) {
        this._unknownTaggedFields = null;
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        this.errorCode = struct.getShort("error_code");
        this.errorMessage = struct.getString("error_message");
        Object[] _nestedObjects = struct.getArray("entries");
        if (_nestedObjects == null) {
            this.entries = null;
        } else {
            this.entries = new ArrayList<EntryData>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.entries.add(new EntryData((Struct)nestedObject, _version));
            }
        }
    }

    public Struct toStruct(short _version) {
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        struct.set("error_code", (Object)this.errorCode);
        struct.set("error_message", (Object)this.errorMessage);
        if (this.entries == null) {
            struct.set("entries", null);
        } else {
            Struct[] _nestedObjects = new Struct[this.entries.size()];
            int i = 0;
            for (EntryData element : this.entries) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("entries", (Object)_nestedObjects);
        }
        return struct;
    }

    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        _size += 4;
        _size += 2;
        if (this.errorMessage == null) {
            _size += 2;
        } else {
            byte[] _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.errorMessage, _stringBytes);
            _size += _stringBytes.length + 2;
        }
        if (this.entries == null) {
            _size += 4;
        } else {
            int _arraySize = 0;
            _arraySize += 4;
            for (EntryData entriesElement : this.entries) {
                _arraySize += entriesElement.size(_cache, _version);
            }
            _size += _arraySize;
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeClientQuotasResponseData)) {
            return false;
        }
        DescribeClientQuotasResponseData other = (DescribeClientQuotasResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.entries == null ? other.entries != null : !this.entries.equals(other.entries)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        hashCode = 31 * hashCode + (this.entries == null ? 0 : this.entries.hashCode());
        return hashCode;
    }

    public DescribeClientQuotasResponseData duplicate() {
        DescribeClientQuotasResponseData _duplicate = new DescribeClientQuotasResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
        if (this.entries == null) {
            _duplicate.entries = null;
        } else {
            ArrayList<EntryData> newEntries = new ArrayList<EntryData>(this.entries.size());
            for (EntryData _element : this.entries) {
                newEntries.add(_element.duplicate());
            }
            _duplicate.entries = newEntries;
        }
        return _duplicate;
    }

    public String toString() {
        return "DescribeClientQuotasResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", entries=" + (this.entries == null ? "null" : MessageUtil.deepToString(this.entries.iterator())) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public List<EntryData> entries() {
        return this.entries;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeClientQuotasResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DescribeClientQuotasResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public DescribeClientQuotasResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }

    public DescribeClientQuotasResponseData setEntries(List<EntryData> v) {
        this.entries = v;
        return this;
    }

    public static class ValueData
    implements Message {
        String key;
        double value;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("key", (Type)Type.STRING, "The quota configuration key."), new Field("value", (Type)Type.FLOAT64, "The quota configuration value.")});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public ValueData(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public ValueData(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public ValueData() {
            this.key = "";
            this.value = 0.0;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ValueData");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field key was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field key had invalid length " + length);
            }
            this.key = _readable.readString((int)length);
            this.value = _readable.readDouble();
            this._unknownTaggedFields = null;
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.key);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
            _writable.writeDouble(this.value);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ValueData");
            }
            this._unknownTaggedFields = null;
            this.key = struct.getString("key");
            this.value = struct.getDouble("value");
        }

        public Struct toStruct(short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of ValueData");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("key", (Object)this.key);
            struct.set("value", (Object)this.value);
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ValueData");
            }
            byte[] _stringBytes = this.key.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'key' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.key, _stringBytes);
            _size += _stringBytes.length + 2;
            _size += 8;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ValueData)) {
                return false;
            }
            ValueData other = (ValueData)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            if (this.value != other.value) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.key == null ? 0 : this.key.hashCode());
            hashCode = 31 * hashCode + Double.hashCode(this.value);
            return hashCode;
        }

        public ValueData duplicate() {
            ValueData _duplicate = new ValueData();
            _duplicate.key = this.key;
            _duplicate.value = this.value;
            return _duplicate;
        }

        public String toString() {
            return "ValueData(key=" + (this.key == null ? "null" : "'" + this.key.toString() + "'") + ", value=" + this.value + ")";
        }

        public String key() {
            return this.key;
        }

        public double value() {
            return this.value;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ValueData setKey(String v) {
            this.key = v;
            return this;
        }

        public ValueData setValue(double v) {
            this.value = v;
            return this;
        }
    }

    public static class EntityData
    implements Message {
        String entityType;
        String entityName;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("entity_type", (Type)Type.STRING, "The entity type."), new Field("entity_name", (Type)Type.NULLABLE_STRING, "The entity name, or null if the default.")});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public EntityData(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public EntityData(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public EntityData() {
            this.entityType = "";
            this.entityName = "";
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of EntityData");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field entityType was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field entityType had invalid length " + length);
            }
            this.entityType = _readable.readString((int)length);
            length = _readable.readShort();
            if (length < 0) {
                this.entityName = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field entityName had invalid length " + length);
                }
                this.entityName = _readable.readString((int)length);
            }
            this._unknownTaggedFields = null;
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.entityType);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
            if (this.entityName == null) {
                _writable.writeShort((short)-1);
            } else {
                _stringBytes = _cache.getSerializedValue((Object)this.entityName);
                _writable.writeShort((short)_stringBytes.length);
                _writable.writeByteArray(_stringBytes);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of EntityData");
            }
            this._unknownTaggedFields = null;
            this.entityType = struct.getString("entity_type");
            this.entityName = struct.getString("entity_name");
        }

        public Struct toStruct(short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of EntityData");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("entity_type", (Object)this.entityType);
            struct.set("entity_name", (Object)this.entityName);
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of EntityData");
            }
            byte[] _stringBytes = this.entityType.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'entityType' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.entityType, _stringBytes);
            _size += _stringBytes.length + 2;
            if (this.entityName == null) {
                _size += 2;
            } else {
                _stringBytes = this.entityName.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'entityName' field is too long to be serialized");
                }
                _cache.cacheSerializedValue((Object)this.entityName, _stringBytes);
                _size += _stringBytes.length + 2;
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EntityData)) {
                return false;
            }
            EntityData other = (EntityData)obj;
            if (this.entityType == null ? other.entityType != null : !this.entityType.equals(other.entityType)) {
                return false;
            }
            if (this.entityName == null ? other.entityName != null : !this.entityName.equals(other.entityName)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.entityType == null ? 0 : this.entityType.hashCode());
            hashCode = 31 * hashCode + (this.entityName == null ? 0 : this.entityName.hashCode());
            return hashCode;
        }

        public EntityData duplicate() {
            EntityData _duplicate = new EntityData();
            _duplicate.entityType = this.entityType;
            _duplicate.entityName = this.entityName == null ? null : this.entityName;
            return _duplicate;
        }

        public String toString() {
            return "EntityData(entityType=" + (this.entityType == null ? "null" : "'" + this.entityType.toString() + "'") + ", entityName=" + (this.entityName == null ? "null" : "'" + this.entityName.toString() + "'") + ")";
        }

        public String entityType() {
            return this.entityType;
        }

        public String entityName() {
            return this.entityName;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public EntityData setEntityType(String v) {
            this.entityType = v;
            return this;
        }

        public EntityData setEntityName(String v) {
            this.entityName = v;
            return this;
        }
    }

    public static class EntryData
    implements Message {
        List<EntityData> entity;
        List<ValueData> values;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("entity", (Type)new ArrayOf((Type)EntityData.SCHEMA_0), "The quota entity description."), new Field("values", (Type)new ArrayOf((Type)ValueData.SCHEMA_0), "The quota values for the entity.")});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public EntryData(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public EntryData(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public EntryData() {
            this.entity = new ArrayList<EntityData>(0);
            this.values = new ArrayList<ValueData>(0);
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public void read(Readable _readable, short _version) {
            int i;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of EntryData");
            }
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field entity was serialized as null");
            }
            ArrayList<EntityData> newCollection = new ArrayList<EntityData>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new EntityData(_readable, _version));
            }
            this.entity = newCollection;
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field values was serialized as null");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((EntityData)((Object)new ValueData(_readable, _version)));
            }
            this.values = newCollection;
            this._unknownTaggedFields = null;
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.entity.size());
            for (EntityData entityElement : this.entity) {
                entityElement.write(_writable, _cache, _version);
            }
            _writable.writeInt(this.values.size());
            for (ValueData valuesElement : this.values) {
                valuesElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of EntryData");
            }
            this._unknownTaggedFields = null;
            Object[] _nestedObjects = struct.getArray("entity");
            this.entity = new ArrayList<EntityData>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.entity.add(new EntityData((Struct)nestedObject, _version));
            }
            _nestedObjects = struct.getArray("values");
            this.values = new ArrayList<ValueData>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.values.add(new ValueData((Struct)nestedObject, _version));
            }
        }

        public Struct toStruct(short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of EntryData");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            Struct[] _nestedObjects = new Struct[this.entity.size()];
            int i = 0;
            for (EntityData entityData : this.entity) {
                _nestedObjects[i++] = entityData.toStruct(_version);
            }
            struct.set("entity", (Object)_nestedObjects);
            _nestedObjects = new Struct[this.values.size()];
            i = 0;
            for (ValueData valueData : this.values) {
                _nestedObjects[i++] = valueData.toStruct(_version);
            }
            struct.set("values", (Object)_nestedObjects);
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of EntryData");
            }
            int _arraySize = 0;
            _arraySize += 4;
            for (EntityData entityElement : this.entity) {
                _arraySize += entityElement.size(_cache, _version);
            }
            _size += _arraySize;
            _arraySize = 0;
            _arraySize += 4;
            for (ValueData valuesElement : this.values) {
                _arraySize += valuesElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EntryData)) {
                return false;
            }
            EntryData other = (EntryData)obj;
            if (this.entity == null ? other.entity != null : !this.entity.equals(other.entity)) {
                return false;
            }
            if (this.values == null ? other.values != null : !this.values.equals(other.values)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.entity == null ? 0 : this.entity.hashCode());
            hashCode = 31 * hashCode + (this.values == null ? 0 : this.values.hashCode());
            return hashCode;
        }

        public EntryData duplicate() {
            EntryData _duplicate = new EntryData();
            ArrayList<EntityData> newEntity = new ArrayList<EntityData>(this.entity.size());
            for (EntityData _element : this.entity) {
                newEntity.add(_element.duplicate());
            }
            _duplicate.entity = newEntity;
            ArrayList<ValueData> newValues = new ArrayList<ValueData>(this.values.size());
            for (ValueData _element : this.values) {
                newValues.add(_element.duplicate());
            }
            _duplicate.values = newValues;
            return _duplicate;
        }

        public String toString() {
            return "EntryData(entity=" + MessageUtil.deepToString(this.entity.iterator()) + ", values=" + MessageUtil.deepToString(this.values.iterator()) + ")";
        }

        public List<EntityData> entity() {
            return this.entity;
        }

        public List<ValueData> values() {
            return this.values;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public EntryData setEntity(List<EntityData> v) {
            this.entity = v;
            return this;
        }

        public EntryData setValues(List<ValueData> v) {
            this.values = v;
            return this;
        }
    }
}

