/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.nio.ByteBuffer;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ByteBufferInputStreamTest {
    @Test
    public void testReadUnsignedIntFromInputStream() {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.put((byte)10);
        buffer.put((byte)20);
        buffer.put((byte)30);
        buffer.rewind();
        byte[] b = new byte[6];
        ByteBufferInputStream inputStream = new ByteBufferInputStream(buffer);
        Assertions.assertEquals((int)10, (int)inputStream.read());
        Assertions.assertEquals((int)20, (int)inputStream.read());
        Assertions.assertEquals((int)3, (int)inputStream.read(b, 3, b.length - 3));
        Assertions.assertEquals((int)0, (int)inputStream.read());
        Assertions.assertEquals((int)2, (int)inputStream.read(b, 0, b.length));
        Assertions.assertEquals((int)-1, (int)inputStream.read(b, 0, b.length));
        Assertions.assertEquals((int)0, (int)inputStream.read(b, 0, 0));
        Assertions.assertEquals((int)-1, (int)inputStream.read());
    }
}

