/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.ByteUtils;

public class SimpleRecordsMessageData
implements ApiMessage {
    String topic;
    BaseRecords recordSet;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("topic", (Type)Type.STRING, "The topic name."), new Field("record_set", (Type)Type.RECORDS, "The record data.")});
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("topic", (Type)Type.COMPACT_STRING, "The topic name."), new Field("record_set", (Type)Type.COMPACT_RECORDS, "The record data."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 1;

    public SimpleRecordsMessageData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public SimpleRecordsMessageData() {
        this.topic = "";
        this.recordSet = null;
    }

    public short apiKey() {
        return -1;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 1;
    }

    public final void read(Readable _readable, short _version) {
        int length = _version >= 1 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
        if (length < 0) {
            throw new RuntimeException("non-nullable field topic was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field topic had invalid length " + length);
        }
        this.topic = _readable.readString(length);
        length = _version >= 1 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
        this.recordSet = length < 0 ? null : _readable.readRecords(length);
        this._unknownTaggedFields = null;
        if (_version >= 1) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        byte[] _stringBytes = _cache.getSerializedValue((Object)this.topic);
        if (_version >= 1) {
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
        } else {
            _writable.writeShort((short)_stringBytes.length);
        }
        _writable.writeByteArray(_stringBytes);
        if (this.recordSet == null) {
            if (_version >= 1) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeInt(-1);
            }
        } else {
            if (_version >= 1) {
                _writable.writeUnsignedVarint(this.recordSet.sizeInBytes() + 1);
            } else {
                _writable.writeInt(this.recordSet.sizeInBytes());
            }
            _writable.writeRecords(this.recordSet);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 1) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        byte[] _stringBytes = this.topic.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'topic' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.topic, _stringBytes);
        if (_version >= 1) {
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        } else {
            _size.addBytes(_stringBytes.length + 2);
        }
        if (this.recordSet == null) {
            if (_version >= 1) {
                _size.addBytes(1);
            } else {
                _size.addBytes(4);
            }
        } else {
            _size.addZeroCopyBytes(this.recordSet.sizeInBytes());
            if (_version >= 1) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.recordSet.sizeInBytes() + 1)));
            } else {
                _size.addBytes(4);
            }
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 1) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleRecordsMessageData)) {
            return false;
        }
        SimpleRecordsMessageData other = (SimpleRecordsMessageData)obj;
        if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
            return false;
        }
        if (!Objects.equals(this.recordSet, other.recordSet)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordSet);
        return hashCode;
    }

    public SimpleRecordsMessageData duplicate() {
        SimpleRecordsMessageData _duplicate = new SimpleRecordsMessageData();
        _duplicate.topic = this.topic;
        _duplicate.recordSet = this.recordSet == null ? null : MemoryRecords.readableRecords((ByteBuffer)((MemoryRecords)this.recordSet).buffer().duplicate());
        return _duplicate;
    }

    public String toString() {
        return "SimpleRecordsMessageData(topic=" + (this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ", recordSet=" + this.recordSet + ")";
    }

    public String topic() {
        return this.topic;
    }

    public BaseRecords recordSet() {
        return this.recordSet;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public SimpleRecordsMessageData setTopic(String v) {
        this.topic = v;
        return this;
    }

    public SimpleRecordsMessageData setRecordSet(BaseRecords v) {
        this.recordSet = v;
        return this;
    }
}

