/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.foreignkeyjoin;

import java.util.Arrays;
import java.util.Objects;
import org.apache.kafka.common.errors.UnsupportedVersionException;

public class SubscriptionWrapper<K> {
    static final byte CURRENT_VERSION = 0;
    private final long[] hash;
    private final Instruction instruction;
    private final byte version;
    private final K primaryKey;

    public SubscriptionWrapper(long[] hash, Instruction instruction, K primaryKey) {
        this(hash, instruction, primaryKey, 0);
    }

    public SubscriptionWrapper(long[] hash, Instruction instruction, K primaryKey, byte version) {
        Objects.requireNonNull(instruction, "instruction cannot be null. Required by downstream processor.");
        Objects.requireNonNull(primaryKey, "primaryKey cannot be null. Required by downstream processor.");
        if (version != 0) {
            throw new UnsupportedVersionException("SubscriptionWrapper does not support version " + version);
        }
        this.instruction = instruction;
        this.hash = hash;
        this.primaryKey = primaryKey;
        this.version = version;
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    public long[] getHash() {
        return this.hash;
    }

    public K getPrimaryKey() {
        return this.primaryKey;
    }

    public byte getVersion() {
        return this.version;
    }

    public String toString() {
        return "SubscriptionWrapper{version=" + this.version + ", primaryKey=" + this.primaryKey + ", instruction=" + (Object)((Object)this.instruction) + ", hash=" + Arrays.toString(this.hash) + '}';
    }

    public static enum Instruction {
        DELETE_KEY_NO_PROPAGATE(0),
        DELETE_KEY_AND_PROPAGATE(1),
        PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE(2),
        PROPAGATE_ONLY_IF_FK_VAL_AVAILABLE(3);

        private final byte value;

        private Instruction(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }

        public static Instruction fromValue(byte value) {
            for (Instruction i : Instruction.values()) {
                if (i.value != value) continue;
                return i;
            }
            throw new IllegalArgumentException("Unknown instruction byte value = " + value);
        }
    }
}

