/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.SinkNode;
import org.apache.kafka.streams.processor.internals.SourceNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorTopology {
    private final Logger log = LoggerFactory.getLogger(ProcessorTopology.class);
    private final List<ProcessorNode<?, ?, ?, ?>> processorNodes;
    private final Map<String, SourceNode<?, ?>> sourceNodesByName;
    private final Map<String, SourceNode<?, ?>> sourceNodesByTopic;
    private final Map<String, SinkNode<?, ?>> sinksByTopic;
    private final Set<String> terminalNodes;
    private final List<StateStore> stateStores;
    private final Set<String> repartitionTopics;
    private final List<StateStore> globalStateStores;
    private final Map<String, String> storeToChangelogTopic;
    private final Map<String, Optional<InternalTopologyBuilder.ReprocessFactory<?, ?, ?, ?>>> storeNameToReprocessOnRestore;

    public ProcessorTopology(List<ProcessorNode<?, ?, ?, ?>> processorNodes, Map<String, SourceNode<?, ?>> sourceNodesByTopic, Map<String, SinkNode<?, ?>> sinksByTopic, List<StateStore> stateStores, List<StateStore> globalStateStores, Map<String, String> storeToChangelogTopic, Set<String> repartitionTopics, Map<String, Optional<InternalTopologyBuilder.ReprocessFactory<?, ?, ?, ?>>> storeNameToReprocessOnRestore) {
        this.processorNodes = Collections.unmodifiableList(processorNodes);
        this.sourceNodesByTopic = new HashMap(sourceNodesByTopic);
        this.sinksByTopic = Collections.unmodifiableMap(sinksByTopic);
        this.stateStores = Collections.unmodifiableList(stateStores);
        this.globalStateStores = Collections.unmodifiableList(globalStateStores);
        this.storeToChangelogTopic = Collections.unmodifiableMap(storeToChangelogTopic);
        this.repartitionTopics = Collections.unmodifiableSet(repartitionTopics);
        this.storeNameToReprocessOnRestore = storeNameToReprocessOnRestore;
        this.terminalNodes = new HashSet<String>();
        for (ProcessorNode<?, ?, ?, ?> processorNode : processorNodes) {
            if (!processorNode.isTerminalNode()) continue;
            this.terminalNodes.add(processorNode.name());
        }
        this.sourceNodesByName = new HashMap();
        for (SourceNode sourceNode : sourceNodesByTopic.values()) {
            this.sourceNodesByName.put(sourceNode.name(), sourceNode);
        }
    }

    public Set<String> sourceTopics() {
        return this.sourceNodesByTopic.keySet();
    }

    public SourceNode<?, ?> source(String topic) {
        return this.sourceNodesByTopic.get(topic);
    }

    public Set<SourceNode<?, ?>> sources() {
        return new HashSet(this.sourceNodesByTopic.values());
    }

    public Set<String> sinkTopics() {
        return this.sinksByTopic.keySet();
    }

    public SinkNode<?, ?> sink(String topic) {
        return this.sinksByTopic.get(topic);
    }

    public Set<String> terminalNodes() {
        return this.terminalNodes;
    }

    public List<ProcessorNode<?, ?, ?, ?>> processors() {
        return this.processorNodes;
    }

    public List<StateStore> stateStores() {
        return this.stateStores;
    }

    public Map<String, Optional<InternalTopologyBuilder.ReprocessFactory<?, ?, ?, ?>>> storeNameToReprocessOnRestore() {
        return this.storeNameToReprocessOnRestore;
    }

    public List<StateStore> globalStateStores() {
        return Collections.unmodifiableList(this.globalStateStores);
    }

    public Map<String, String> storeToChangelogTopic() {
        return Collections.unmodifiableMap(this.storeToChangelogTopic);
    }

    boolean isRepartitionTopic(String topic) {
        return this.repartitionTopics.contains(topic);
    }

    boolean hasStateWithChangelogs() {
        for (StateStore stateStore : this.stateStores) {
            if (!this.storeToChangelogTopic.containsKey(stateStore.name())) continue;
            return true;
        }
        return false;
    }

    public boolean hasPersistentLocalStore() {
        for (StateStore store : this.stateStores) {
            if (!store.persistent()) continue;
            return true;
        }
        return false;
    }

    public boolean hasPersistentGlobalStore() {
        for (StateStore store : this.globalStateStores) {
            if (!store.persistent()) continue;
            return true;
        }
        return false;
    }

    public void updateSourceTopics(Map<String, List<String>> allSourceTopicsByNodeName) {
        this.sourceNodesByTopic.clear();
        for (Map.Entry<String, SourceNode<?, ?>> sourceNodeEntry : this.sourceNodesByName.entrySet()) {
            String sourceNodeName = sourceNodeEntry.getKey();
            SourceNode<?, ?> sourceNode = sourceNodeEntry.getValue();
            List<String> updatedSourceTopics = allSourceTopicsByNodeName.get(sourceNodeName);
            if (updatedSourceTopics == null) {
                this.log.error("Unable to find source node {} in updated topics map {}", (Object)sourceNodeName, allSourceTopicsByNodeName);
                throw new IllegalStateException("Node " + sourceNodeName + " not found in full topology");
            }
            this.log.trace("Updating source node {} with new topics {}", (Object)sourceNodeName, updatedSourceTopics);
            for (String topic : updatedSourceTopics) {
                if (this.sourceNodesByTopic.containsKey(topic)) {
                    this.log.error("Tried to subscribe topic {} to two nodes when updating topics from {}", (Object)topic, allSourceTopicsByNodeName);
                    throw new IllegalStateException("Topic " + topic + " was already registered to source node " + this.sourceNodesByTopic.get(topic).name());
                }
                this.sourceNodesByTopic.put(topic, sourceNode);
            }
        }
    }

    private String childrenToString(String indent, List<? extends ProcessorNode<?, ?, ?, ?>> children) {
        if (children == null || children.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(indent + "\tchildren:\t[");
        for (ProcessorNode<?, ?, ?, ?> child : children) {
            sb.append(child.name());
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append("]\n");
        for (ProcessorNode<?, ?, ?, ?> child : children) {
            sb.append(child.toString(indent)).append(this.childrenToString(indent, child.children()));
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        SourceNode source;
        HashMap<SourceNode, List> sourceToTopics = new HashMap<SourceNode, List>();
        for (Map.Entry<String, SourceNode<?, ?>> sourceNodeEntry : this.sourceNodesByTopic.entrySet()) {
            String topic = sourceNodeEntry.getKey();
            source = sourceNodeEntry.getValue();
            sourceToTopics.computeIfAbsent(source, s -> new ArrayList());
            ((List)sourceToTopics.get(source)).add(topic);
        }
        StringBuilder sb = new StringBuilder(indent + "ProcessorTopology:\n");
        for (Map.Entry sourceNodeEntry : sourceToTopics.entrySet()) {
            source = (SourceNode)sourceNodeEntry.getKey();
            List topics = (List)sourceNodeEntry.getValue();
            sb.append(source.toString(indent + "\t")).append(ProcessorTopology.topicsToString(indent + "\t", topics)).append(this.childrenToString(indent + "\t", source.children()));
        }
        return sb.toString();
    }

    private static String topicsToString(String indent, List<String> topics) {
        StringBuilder sb = new StringBuilder();
        sb.append(indent).append("\ttopics:\t\t[");
        for (String topic : topics) {
            sb.append(topic);
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append("]\n");
        return sb.toString();
    }

    public Set<String> processorConnectedStateStores(String processorName) {
        for (ProcessorNode<?, ?, ?, ?> node : this.processorNodes) {
            if (!node.name().equals(processorName)) continue;
            return node.stateStores;
        }
        return Collections.emptySet();
    }
}

