/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.test;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.ServerSocketFactory;

public class PreboundSocketFactoryManager
implements AutoCloseable {
    private boolean closed = false;
    private final Map<Integer, PreboundSocketFactory> factories = new HashMap<Integer, PreboundSocketFactory>();
    private final Map<Integer, Map<String, ServerSocketChannel>> sockets = new HashMap<Integer, Map<String, ServerSocketChannel>>();
    private final Map<Integer, Set<String>> usedSockets = new HashMap<Integer, Set<String>>();

    public synchronized ServerSocketChannel getSocketForListenerAndMarkAsUsed(int nodeId, String listener) {
        Map<String, ServerSocketChannel> socketsForNode = this.sockets.get(nodeId);
        if (socketsForNode == null) {
            return null;
        }
        ServerSocketChannel socket = socketsForNode.get(listener);
        if (socket == null) {
            return null;
        }
        this.usedSockets.computeIfAbsent(nodeId, __ -> new HashSet()).add(listener);
        return socket;
    }

    public synchronized ServerSocketFactory getOrCreateSocketFactory(int nodeId) {
        return this.factories.computeIfAbsent(nodeId, __ -> new PreboundSocketFactory(nodeId));
    }

    public synchronized int getOrCreatePortForListener(int nodeId, String listener) throws IOException {
        Map socketsForNode = this.sockets.computeIfAbsent(nodeId, __ -> new HashMap());
        ServerSocketChannel socketChannel = (ServerSocketChannel)socketsForNode.get(listener);
        if (socketChannel == null) {
            if (this.closed) {
                throw new RuntimeException("Cannot open new socket: manager is closed.");
            }
            socketChannel = ServerSocketFactory.INSTANCE.openServerSocket(listener, new InetSocketAddress(0), -1, -1);
            socketsForNode.put(listener, socketChannel);
        }
        InetSocketAddress socketAddress = (InetSocketAddress)socketChannel.getLocalAddress();
        return socketAddress.getPort();
    }

    @Override
    public synchronized void close() throws Exception {
        if (this.closed) {
            return;
        }
        this.closed = true;
        for (Map.Entry<Integer, Map<String, ServerSocketChannel>> socketsEntry : this.sockets.entrySet()) {
            Set usedListeners = this.usedSockets.getOrDefault(socketsEntry.getKey(), Set.of());
            for (Map.Entry<String, ServerSocketChannel> entry : socketsEntry.getValue().entrySet()) {
                if (usedListeners.contains(entry.getKey())) continue;
                Utils.closeQuietly((AutoCloseable)entry.getValue(), (String)"serverSocketChannel");
            }
        }
    }

    private class PreboundSocketFactory
    implements ServerSocketFactory {
        private final int nodeId;

        private PreboundSocketFactory(int nodeId) {
            this.nodeId = nodeId;
        }

        public ServerSocketChannel openServerSocket(String listenerName, InetSocketAddress socketAddress, int listenBacklogSize, int recvBufferSize) throws IOException {
            ServerSocketChannel socketChannel = PreboundSocketFactoryManager.this.getSocketForListenerAndMarkAsUsed(this.nodeId, listenerName);
            if (socketChannel != null) {
                if (socketChannel.isOpen()) {
                    return socketChannel;
                }
                socketAddress = new InetSocketAddress(socketAddress.getHostString(), socketChannel.socket().getLocalPort());
                socketChannel = ServerSocketFactory.INSTANCE.openServerSocket(listenerName, socketAddress, listenBacklogSize, recvBufferSize);
                return socketChannel;
            }
            return ServerSocketFactory.INSTANCE.openServerSocket(listenerName, socketAddress, listenBacklogSize, recvBufferSize);
        }
    }
}

