/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Properties;
import kafka.admin.DeleteTopicTest$;
import kafka.admin.RackAwareMode;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignmentFailed$;
import kafka.admin.ReassignmentStatus;
import kafka.admin.TopicCommand;
import kafka.admin.TopicCommand$;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogManager;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionZNode$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005uf\u0001B\u0001\u0003\u0001\u001d\u0011q\u0002R3mKR,Gk\u001c9jGR+7\u000f\u001e\u0006\u0003\u0007\u0011\tQ!\u00193nS:T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!B\u0003\u0002\f\t\u0005\u0011!p[\u0005\u0003\u001b)\u0011ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\b\"B\b\u0001\t\u0003\u0001\u0012A\u0002\u001fj]&$h\bF\u0001\u0012!\t\u0011\u0002!D\u0001\u0003\u0011\u001d!\u0002\u00011A\u0005\u0002U\tqa]3sm\u0016\u00148/F\u0001\u0017!\r9\u0012\u0005\n\b\u00031yq!!\u0007\u000f\u000e\u0003iQ!a\u0007\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0012!B:dC2\f\u0017BA\u0010!\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011!H\u0005\u0003E\r\u00121aU3r\u0015\ty\u0002\u0005\u0005\u0002&Q5\taE\u0003\u0002(\t\u000511/\u001a:wKJL!!\u000b\u0014\u0003\u0017-\u000bgm[1TKJ4XM\u001d\u0005\bW\u0001\u0001\r\u0011\"\u0001-\u0003-\u0019XM\u001d<feN|F%Z9\u0015\u00055\n\u0004C\u0001\u00180\u001b\u0005\u0001\u0013B\u0001\u0019!\u0005\u0011)f.\u001b;\t\u000fIR\u0013\u0011!a\u0001-\u0005\u0019\u0001\u0010J\u0019\t\rQ\u0002\u0001\u0015)\u0003\u0017\u0003!\u0019XM\u001d<feN\u0004\u0003b\u0002\u001c\u0001\u0005\u0004%\taN\u0001\u001aKb\u0004Xm\u0019;fIJ+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tG/F\u00019!\u0011Id\bQ\"\u000e\u0003iR!a\u000f\u001f\u0002\u0013%lW.\u001e;bE2,'BA\u001f!\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u007fi\u00121!T1q!\tq\u0013)\u0003\u0002CA\t\u0019\u0011J\u001c;\u0011\u0007e\"\u0005)\u0003\u0002Fu\t!A*[:u\u0011\u00199\u0005\u0001)A\u0005q\u0005QR\r\u001f9fGR,GMU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8uA!)\u0011\n\u0001C!\u0015\u0006AA/Z1s\t><h\u000eF\u0001.Q\tAE\n\u0005\u0002N%6\taJ\u0003\u0002P!\u0006)!.\u001e8ji*\t\u0011+A\u0002pe\u001eL!a\u0015(\u0003\u000b\u00053G/\u001a:\t\u000bU\u0003A\u0011\u0001&\u0002GQ,7\u000f\u001e#fY\u0016$X\rV8qS\u000e<\u0016\u000e\u001e5BY2\fE.\u001b<f%\u0016\u0004H.[2bg\"\u0012Ak\u0016\t\u0003\u001bbK!!\u0017(\u0003\tQ+7\u000f\u001e\u0005\u00067\u0002!\tAS\u0001+i\u0016\u001cHOU3tk6,G)\u001a7fi\u0016$v\u000e]5d/&$\bNU3d_Z,'/\u001a3G_2dwn^3sQ\tQv\u000bC\u0003_\u0001\u0011\u0005!*A\u0015uKN$(+Z:v[\u0016$U\r\\3uKR{\u0007/[2P]\u000e{g\u000e\u001e:pY2,'OR1jY>4XM\u001d\u0015\u0003;^CQ!\u0019\u0001\u0005\u0002)\u000b!\u0006^3tiB\u000b'\u000f^5uS>t'+Z1tg&<g.\\3oi\u0012+(/\u001b8h\t\u0016dW\r^3U_BL7\r\u000b\u0002a/\")A\r\u0001C\u0005K\u0006iq-\u001a;D_:$(o\u001c7mKJ$\u0012A\u001a\t\u0005]\u001d$\u0003)\u0003\u0002iA\t1A+\u001e9mKJBQA\u001b\u0001\u0005\n)\u000ba#\u001a8tkJ,7i\u001c8ue>dG.\u001a:Fq&\u001cHo\u001d\u0005\u0006Y\u0002!I!\\\u0001\u001dO\u0016$\u0018\t\u001c7SKBd\u0017nY1t\rJ|W.Q:tS\u001etW.\u001a8u)\u0011q70!\u0001\u0011\u0007=\u0014XO\u0004\u0002/a&\u0011\u0011\u000fI\u0001\u0007!J,G-\u001a4\n\u0005M$(aA*fi*\u0011\u0011\u000f\t\t\u0003mfl\u0011a\u001e\u0006\u0003q\u0012\t!bY8oiJ|G\u000e\\3s\u0013\tQxOA\nQCJ$\u0018\u000e^5p]\u0006sGMU3qY&\u001c\u0017\rC\u0003}W\u0002\u0007Q0A\u0003u_BL7\r\u0005\u0002p}&\u0011q\u0010\u001e\u0002\u0007'R\u0014\u0018N\\4\t\u000f\u0005\r1\u000e1\u0001\u0002\u0006\u0005Q\u0011m]:jO:lWM\u001c;\u0011\r=\f9\u0001QA\u0005\u0013\tyD\u000fE\u0002\u0018C\u0001Ca!!\u0004\u0001\t\u0003Q\u0015\u0001\f;fgRLen\u0019:fCN,\u0007+\u0019:uSRLwN\u001e8D_VtG\u000fR;sS:<G)\u001a7fi\u0016$v\u000e]5dQ\r\tYa\u0016\u0005\u0007\u0003'\u0001A\u0011\u0001&\u0002CQ,7\u000f\u001e#fY\u0016$X\rV8qS\u000e$UO]5oO\u0006#G\rU1si&$\u0018n\u001c8)\u0007\u0005Eq\u000b\u0003\u0004\u0002\u001a\u0001!\tAS\u0001\"i\u0016\u001cH/\u00113e!\u0006\u0014H/\u001b;j_:$UO]5oO\u0012+G.\u001a;f)>\u0004\u0018n\u0019\u0015\u0004\u0003/9\u0006BBA\u0010\u0001\u0011\u0005!*\u0001\u0010uKN$(+Z2sK\u0006$X\rV8qS\u000e\fe\r^3s\t\u0016dW\r^5p]\"\u001a\u0011QD,\t\r\u0005\u0015\u0002\u0001\"\u0001K\u0003i!Xm\u001d;EK2,G/\u001a(p]\u0016C\u0018n\u001d;j]\u001e$v\u000e]5dQ\r\t\u0019c\u0016\u0005\u0007\u0003W\u0001A\u0011\u0001&\u00025Q,7\u000f\u001e#fY\u0016$X\rV8qS\u000e<\u0016\u000e\u001e5DY\u0016\fg.\u001a:)\u0007\u0005%r\u000b\u0003\u0004\u00022\u0001!\tAS\u0001&i\u0016\u001cH\u000fR3mKR,Gk\u001c9jG\u0006c'/Z1es6\u000b'o[3e\u0003N$U\r\\3uK\u0012D3!a\fX\u0011\u001d\t9\u0004\u0001C\u0005\u0003s\t\u0011d\u0019:fCR,G+Z:u)>\u0004\u0018nY!oI\u000ecWo\u001d;feR9a#a\u000f\u0002>\u0005\u001d\u0003B\u0002?\u00026\u0001\u0007Q\u0010\u0003\u0006\u0002@\u0005U\u0002\u0013!a\u0001\u0003\u0003\n!\u0003Z3mKR,Gk\u001c9jG\u0016s\u0017M\u00197fIB\u0019a&a\u0011\n\u0007\u0005\u0015\u0003EA\u0004C_>dW-\u00198\t\u0015\u0005%\u0013Q\u0007I\u0001\u0002\u0004\tY%A\tsKBd\u0017nY1BgNLwM\\7f]R\u0004ba\\A\u0004\u0001\u00065\u0003\u0003B\f\u0002P\u0001K!!R\u0012\t\u000f\u0005]\u0002\u0001\"\u0003\u0002TQ9a#!\u0016\u0002X\u00055\u0004B\u0002?\u0002R\u0001\u0007Q\u0010\u0003\u0005\u0002Z\u0005E\u0003\u0019AA.\u00035\u0011'o\\6fe\u000e{gNZ5hgB!q#IA/!\u0011\ty&!\u001b\u000e\u0005\u0005\u0005$\u0002BA2\u0003K\nA!\u001e;jY*\u0011\u0011qM\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002l\u0005\u0005$A\u0003)s_B,'\u000f^5fg\"A\u0011\u0011JA)\u0001\u0004\tY\u0005C\u0004\u0002r\u0001!I!a\u001d\u0002\u0013]\u0014\u0018\u000e^3EkB\u001cH\u0003CA;\u0003s\ni(!!\u0011\t]\t\u0013q\u000f\t\u0005]\u001d\u0004\u0005\tC\u0004\u0002|\u0005=\u0004\u0019\u0001!\u0002\u000f9,XnS3zg\"9\u0011qPA8\u0001\u0004\u0001\u0015a\u00028v[\u0012+\bo\u001d\u0005\t\u0003\u0007\u000by\u00071\u0001\u0002\u0006\u0006\u0019An\\4\u0011\t\u0005\u001d\u00151R\u0007\u0003\u0003\u0013S1!a!\u0005\u0013\u0011\ti)!#\u0003\u00071{w\r\u0003\u0004\u0002\u0012\u0002!\tAS\u0001\u0017i\u0016\u001cH\u000fR5tC\ndW\rR3mKR,Gk\u001c9jG\"\u001a\u0011qR,\t\r\u0005]\u0005\u0001\"\u0001K\u0003\u0005\"Xm\u001d;EK2,G/\u001b8h!\u0006\u0014H/[1mYf$U\r\\3uK\u0012$v\u000e]5dQ\r\t)j\u0016\u0005\n\u0003;\u0003\u0011\u0013!C\u0005\u0003?\u000b1e\u0019:fCR,G+Z:u)>\u0004\u0018nY!oI\u000ecWo\u001d;fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\"*\"\u0011\u0011IARW\t\t)\u000b\u0005\u0003\u0002(\u0006EVBAAU\u0015\u0011\tY+!,\u0002\u0013Ut7\r[3dW\u0016$'bAAXA\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0016\u0011\u0016\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA\\\u0001E\u0005I\u0011BA]\u0003\r\u001a'/Z1uKR+7\u000f\u001e+pa&\u001c\u0017I\u001c3DYV\u001cH/\u001a:%I\u00164\u0017-\u001e7uIM*\"!a/+\t\u0005-\u00131\u0015")
public class DeleteTopicTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final scala.collection.immutable.Map<Object, List<Object>> expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public scala.collection.immutable.Map<Object, List<Object>> expectedReplicaAssignment() {
        return this.expectedReplicaAssignment;
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testDeleteTopicWithAllAliveReplicas() {
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
    }

    @Test
    public void testResumeDeleteTopicWithRecoveredFollower() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower2 = (KafkaServer)((TraversableLike)this.servers().filter((Function1)new Serializable(this, leaderIdOpt){
            public static final long serialVersionUID = 0L;
            private final Option leaderIdOpt$1;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)this.leaderIdOpt$1.get());
            }
            {
                this.leaderIdOpt$1 = leaderIdOpt$1;
            }
        })).last();
        follower2.shutdown();
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition, follower2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            public final TopicPartition topicPartition$1;
            public final KafkaServer follower$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((IterableLike)this.$outer.servers().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testResumeDeleteTopicWithRecoveredFollower$1 $outer;

                    public final boolean apply(KafkaServer s) {
                        return s.config().brokerId() != this.$outer.follower$1.config().brokerId();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testResumeDeleteTopicWithRecoveredFollower$1 $outer;

                    public final boolean apply(KafkaServer x$1) {
                        LogManager qual$1 = x$1.getLogManager();
                        TopicPartition x$17 = this.$outer.topicPartition$1;
                        boolean x$18 = qual$1.getLog$default$2();
                        return qual$1.getLog(x$17, x$18).isEmpty();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$1 = topicPartition$1;
                this.follower$1 = follower$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Replicas 0,1 have not deleted log.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final String topic$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkClient().isTopicMarkedForDeletion(this.topic$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Admin path /admin/delete_topic/test path deleted even when a follower replica is down";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        follower2.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
    }

    @Test
    public void testResumeDeleteTopicOnControllerFailover() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        int controllerId = BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;

            public final Nothing$ apply() {
                return this.$outer.fail("Controller doesn't exist", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        KafkaServer controller = (KafkaServer)((IterableLike)this.servers().filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$1;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() == this.controllerId$1;
            }
            {
                this.controllerId$1 = controllerId$1;
            }
        })).head();
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        KafkaServer follower2 = (KafkaServer)((TraversableLike)this.servers().filter((Function1)new Serializable(this, controllerId, leaderIdOpt){
            public static final long serialVersionUID = 0L;
            private final int controllerId$1;
            private final Option leaderIdOpt$2;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)this.leaderIdOpt$2.get()) && s.config().brokerId() != this.controllerId$1;
            }
            {
                this.controllerId$1 = controllerId$1;
                this.leaderIdOpt$2 = leaderIdOpt$2;
            }
        })).last();
        follower2.shutdown();
        this.adminZkClient().deleteTopic(topic);
        controller.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final String topic$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkClient().isTopicMarkedForDeletion(this.topic$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$2 = topic$2;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Admin path /admin/delete_topic/test path deleted even when a replica is down";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        controller.startup();
        follower2.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
    }

    @Test
    public void testPartitionReassignmentDuringDeleteTopic() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14());
        brokerConfigs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Properties p) {
                return p.setProperty("delete.topic.enable", "true");
            }
        });
        Seq allServers = (Seq)brokerConfigs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.servers_$eq((Seq<KafkaServer>)allServers);
        Seq servers = (Seq)allServers.filter((Function1)new Serializable(this, expectedReplicaAssignment){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map expectedReplicaAssignment$1;

            public final boolean apply(KafkaServer s) {
                return ((LinearSeqOptimized)this.expectedReplicaAssignment$1.apply((Object)BoxesRunTime.boxToInteger((int)0))).contains((Object)BoxesRunTime.boxToInteger((int)s.config().brokerId()));
            }
            {
                this.expectedReplicaAssignment$1 = expectedReplicaAssignment$1;
            }
        });
        AdminZkClient qual$2 = this.adminZkClient();
        String x$19 = topic;
        scala.collection.immutable.Map x$20 = expectedReplicaAssignment;
        Properties x$21 = qual$2.createOrUpdateTopicPartitionAssignmentPathInZK$default$3();
        boolean x$22 = qual$2.createOrUpdateTopicPartitionAssignmentPathInZK$default$4();
        qual$2.createOrUpdateTopicPartitionAssignmentPathInZK(x$19, (Map)x$20, x$21, x$22);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition, servers){
            public static final long serialVersionUID = 0L;
            public final TopicPartition topicPartition$2;
            private final Seq servers$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.servers$1.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testPartitionReassignmentDuringDeleteTopic$1 $outer;

                    public final boolean apply(KafkaServer x$2) {
                        LogManager qual$3 = x$2.getLogManager();
                        TopicPartition x$23 = this.$outer.topicPartition$2;
                        boolean x$24 = qual$3.getLog$default$2();
                        return qual$3.getLog(x$23, x$24).isDefined();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.topicPartition$2 = topicPartition$2;
                this.servers$1 = servers$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Replicas for topic test not created.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower2 = (KafkaServer)((TraversableLike)servers.filter((Function1)new Serializable(this, leaderIdOpt){
            public static final long serialVersionUID = 0L;
            private final Option leaderIdOpt$3;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)this.leaderIdOpt$3.get());
            }
            {
                this.leaderIdOpt$3 = leaderIdOpt$3;
            }
        })).last();
        follower2.shutdown();
        this.adminZkClient().deleteTopic(topic);
        Seq oldAssignedReplicas = this.zkClient().getReplicasForPartition(new TopicPartition(topic, 0));
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        KafkaZkClient x$25 = this.zkClient();
        None$ x$26 = None$.MODULE$;
        scala.collection.immutable.Map x$27 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)newReplicas)}));
        AdminZkClient x$28 = this.adminZkClient();
        Map x$29 = ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4();
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(x$25, (Option)x$26, (Map)x$27, x$29, x$28);
        Assert.assertTrue((String)"Partition reassignment should fail for [test,0]", (boolean)reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1(), reassignPartitionsCommand.reassignPartitions$default$2()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition, newReplicas){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final TopicPartition topicPartition$2;
            private final Seq newReplicas$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Map partitionsBeingReassigned = this.$outer.zkClient().getPartitionReassignment();
                ReassignmentStatus reassignmentStatus = ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.$outer.zkClient(), this.topicPartition$2, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition$2), (Object)this.newReplicas$1)})), partitionsBeingReassigned);
                ReassignmentFailed$ reassignmentFailed$ = ReassignmentFailed$.MODULE$;
                return !(reassignmentStatus != null ? !reassignmentStatus.equals(reassignmentFailed$) : reassignmentFailed$ != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$2 = topicPartition$2;
                this.newReplicas$1 = newReplicas$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Partition reassignment shouldn't complete.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        int controllerId = BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;

            public final Nothing$ apply() {
                return this.$outer.fail("Controller doesn't exist", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        KafkaServer controller = (KafkaServer)((IterableLike)servers.filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$2;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() == this.controllerId$2;
            }
            {
                this.controllerId$2 = controllerId$2;
            }
        })).head();
        Assert.assertFalse((String)"Partition reassignment should fail", (boolean)controller.kafkaController().controllerContext().partitionsBeingReassigned().contains((Object)topicPartition));
        Seq assignedReplicas = this.zkClient().getReplicasForPartition(new TopicPartition(topic, 0));
        Assert.assertEquals((String)"Partition should not be reassigned to 0, 1, 2", (Object)oldAssignedReplicas, (Object)assignedReplicas);
        follower2.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, (Seq<KafkaServer>)servers);
    }

    public Tuple2<KafkaServer, Object> kafka$admin$DeleteTopicTest$$getController() {
        int controllerId = BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;

            public final Nothing$ apply() {
                return this.$outer.fail("Controller doesn't exist", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        KafkaServer controller = (KafkaServer)this.servers().find((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$3;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() == this.controllerId$3;
            }
            {
                this.controllerId$3 = controllerId$3;
            }
        }).get();
        return new Tuple2((Object)controller, (Object)BoxesRunTime.boxToInteger((int)controllerId));
    }

    private void ensureControllerExists() {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                boolean bl;
                try {
                    this.$outer.kafka$admin$DeleteTopicTest$$getController();
                    bl = true;
                }
                catch (Throwable throwable) {
                    bl = false;
                }
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Controller should eventually exist";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private scala.collection.immutable.Set<PartitionAndReplica> getAllReplicasFromAssignment(String topic, scala.collection.immutable.Map<Object, Seq<Object>> assignment2) {
        return ((TraversableOnce)assignment2.flatMap((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            public final String topic$3;

            public final Seq<PartitionAndReplica> apply(Tuple2<Object, Seq<Object>> x0$1) {
                Tuple2<Object, Seq<Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    int partition = tuple2._1$mcI$sp();
                    Seq replicas = (Seq)tuple2._2();
                    Seq seq = (Seq)replicas.map((Function1)new Serializable(this, partition){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$getAllReplicasFromAssignment$1 $outer;
                        private final int partition$1;

                        public final PartitionAndReplica apply(int r) {
                            return new PartitionAndReplica(new TopicPartition(this.$outer.topic$3, this.partition$1), r);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.partition$1 = partition$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    return seq;
                }
                throw new MatchError(tuple2);
            }
            {
                this.topic$3 = topic$3;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    @Test
    public void testIncreasePartitiovnCountDuringDeleteTopic() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14());
        brokerConfigs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Properties p) {
                return p.setProperty("delete.topic.enable", "true");
            }
        });
        Seq allServers = (Seq)brokerConfigs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.servers_$eq((Seq<KafkaServer>)allServers);
        Seq servers = (Seq)allServers.filter((Function1)new Serializable(this, expectedReplicaAssignment){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map expectedReplicaAssignment$2;

            public final boolean apply(KafkaServer s) {
                return ((LinearSeqOptimized)this.expectedReplicaAssignment$2.apply((Object)BoxesRunTime.boxToInteger((int)0))).contains((Object)BoxesRunTime.boxToInteger((int)s.config().brokerId()));
            }
            {
                this.expectedReplicaAssignment$2 = expectedReplicaAssignment$2;
            }
        });
        AdminZkClient qual$4 = this.adminZkClient();
        String x$30 = topic;
        scala.collection.immutable.Map x$31 = expectedReplicaAssignment;
        Properties x$32 = qual$4.createOrUpdateTopicPartitionAssignmentPathInZK$default$3();
        boolean x$33 = qual$4.createOrUpdateTopicPartitionAssignmentPathInZK$default$4();
        qual$4.createOrUpdateTopicPartitionAssignmentPathInZK(x$30, (Map)x$31, x$32, x$33);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition, servers){
            public static final long serialVersionUID = 0L;
            public final TopicPartition topicPartition$3;
            private final Seq servers$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.servers$2.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testIncreasePartitiovnCountDuringDeleteTopic$1 $outer;

                    public final boolean apply(KafkaServer x$3) {
                        LogManager qual$5 = x$3.getLogManager();
                        TopicPartition x$34 = this.$outer.topicPartition$3;
                        boolean x$35 = qual$5.getLog$default$2();
                        return qual$5.getLog(x$34, x$35).isDefined();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.topicPartition$3 = topicPartition$3;
                this.servers$2 = servers$2;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Replicas for topic test not created.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(topicPartition);
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower2 = (KafkaServer)((TraversableLike)servers.filter((Function1)new Serializable(this, leaderIdOpt){
            public static final long serialVersionUID = 0L;
            private final Option leaderIdOpt$4;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)this.leaderIdOpt$4.get());
            }
            {
                this.leaderIdOpt$4 = leaderIdOpt$4;
            }
        })).last();
        follower2.shutdown();
        this.adminZkClient().deleteTopic(topic);
        this.ensureControllerExists();
        Tuple2<KafkaServer, Object> tuple2 = this.kafka$admin$DeleteTopicTest$$getController();
        if (tuple2 != null) {
            Tuple2 tuple22;
            KafkaServer controller = (KafkaServer)tuple2._1();
            int controllerId = tuple2._2$mcI$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)controller, (Object)BoxesRunTime.boxToInteger((int)controllerId));
            KafkaServer controller2 = (KafkaServer)tuple23._1();
            int controllerId2 = tuple23._2$mcI$sp();
            scala.collection.immutable.Set<PartitionAndReplica> allReplicasForTopic = this.getAllReplicasFromAssignment(topic, (scala.collection.immutable.Map<Object, Seq<Object>>)expectedReplicaAssignment);
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, controller2, allReplicasForTopic){
                public static final long serialVersionUID = 0L;
                private final String topic$4;
                private final KafkaServer controller$1;
                private final scala.collection.immutable.Set allReplicasForTopic$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    scala.collection.immutable.Set replicasInDeletionSuccessful = this.controller$1.kafkaController().replicaStateMachine().replicasInState(this.topic$4, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
                    scala.collection.immutable.Set offlineReplicas = this.controller$1.kafkaController().replicaStateMachine().replicasInState(this.topic$4, (ReplicaState)OfflineReplica$.MODULE$);
                    scala.collection.immutable.Set set = this.allReplicasForTopic$1;
                    Set set2 = replicasInDeletionSuccessful.union((GenSet)offlineReplicas);
                    return !(set != null ? !set.equals(set2) : set2 != null);
                }
                {
                    this.topic$4 = topic$4;
                    this.controller$1 = controller$1;
                    this.allReplicasForTopic$1 = allReplicasForTopic$1;
                }
            }, (Function0<String>)new Serializable(this, topic){
                public static final long serialVersionUID = 0L;
                private final String topic$4;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not all replicas for topic ", " are in states of either ReplicaDeletionSuccessful or OfflineReplica"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$4}));
                }
                {
                    this.topic$4 = topic$4;
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            TopicCommand.TopicCommandOptions topicCommandOptions = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--alter", "--topic", topic, "--partitions", "2"}));
            TopicCommand$.MODULE$.alterTopic(this.zkClient(), topicCommandOptions);
            int previousControllerId = controllerId2;
            controller2.shutdown();
            this.ensureControllerExists();
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, previousControllerId){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DeleteTopicTest $outer;
                private final int previousControllerId$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    Tuple2<KafkaServer, Object> tuple2 = this.$outer.kafka$admin$DeleteTopicTest$$getController();
                    if (tuple2 != null) {
                        Tuple2 tuple22;
                        KafkaServer newController = (KafkaServer)tuple2._1();
                        int newControllerId = tuple2._2$mcI$sp();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)newController, (Object)BoxesRunTime.boxToInteger((int)newControllerId));
                        KafkaServer newController2 = (KafkaServer)tuple23._1();
                        int newControllerId2 = tuple23._2$mcI$sp();
                        return newControllerId2 != this.previousControllerId$1;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.previousControllerId$1 = previousControllerId$1;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "The new controller should not have the failed controller id";
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            follower2.startup();
            controller2.startup();
            TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 2, (Seq<KafkaServer>)servers);
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testDeleteTopicDuringAddPartition() {
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower2 = (KafkaServer)((TraversableLike)this.servers().filter((Function1)new Serializable(this, leaderIdOpt){
            public static final long serialVersionUID = 0L;
            private final Option leaderIdOpt$5;

            public final boolean apply(KafkaServer x$6) {
                return x$6.config().brokerId() != BoxesRunTime.unboxToInt((Object)this.leaderIdOpt$5.get());
            }
            {
                this.leaderIdOpt$5 = leaderIdOpt$5;
            }
        })).last();
        TopicPartition newPartition = new TopicPartition(topic, 1);
        AdminZkClient qual$6 = this.adminZkClient();
        RackAwareMode x$36 = qual$6.getBrokerMetadatas$default$1();
        Option x$37 = qual$6.getBrokerMetadatas$default$2();
        Seq brokers = qual$6.getBrokerMetadatas(x$36, x$37);
        follower2.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, follower2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final KafkaServer follower$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkClient().getBroker(this.follower$2.config().brokerId()).isEmpty();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.follower$2 = follower$2;
            }
        }, (Function0<String>)new Serializable(this, follower2){
            public static final long serialVersionUID = 0L;
            private final KafkaServer follower$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Follower ", " was not removed from ZK"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.follower$2.config().brokerId())}));
            }
            {
                this.follower$2 = follower$2;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        AdminZkClient qual$7 = this.adminZkClient();
        String x$38 = topic;
        scala.collection.immutable.Map<Object, List<Object>> x$39 = this.expectedReplicaAssignment();
        Seq x$40 = brokers;
        int x$41 = 2;
        Some x$42 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})));
        boolean x$43 = qual$7.addPartitions$default$6();
        qual$7.addPartitions(x$38, x$39, x$40, x$41, (Option)x$42, x$43);
        this.adminZkClient().deleteTopic(topic);
        follower2.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, newPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            public final TopicPartition newPartition$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.servers().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testDeleteTopicDuringAddPartition$2 $outer;

                    public final boolean apply(KafkaServer x$7) {
                        LogManager qual$8 = x$7.getLogManager();
                        TopicPartition x$44 = this.$outer.newPartition$1;
                        boolean x$45 = qual$8.getLog$default$2();
                        return qual$8.getLog(x$44, x$45).isEmpty();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newPartition$1 = newPartition$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Replica logs not for new partition [test,1] not deleted after delete topic is complete.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testAddPartitionDuringDeleteTopic() {
        this.zkClient().createTopLevelPaths();
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        AdminZkClient qual$9 = this.adminZkClient();
        RackAwareMode x$46 = qual$9.getBrokerMetadatas$default$1();
        Option x$47 = qual$9.getBrokerMetadatas$default$2();
        Seq brokers = qual$9.getBrokerMetadatas(x$46, x$47);
        this.adminZkClient().deleteTopic(topic);
        TopicPartition newPartition = new TopicPartition(topic, 1);
        AdminZkClient qual$10 = this.adminZkClient();
        String x$48 = topic;
        scala.collection.immutable.Map<Object, List<Object>> x$49 = this.expectedReplicaAssignment();
        Seq x$50 = brokers;
        int x$51 = 2;
        Some x$52 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})));
        boolean x$53 = qual$10.addPartitions$default$6();
        qual$10.addPartitions(x$48, x$49, x$50, x$51, (Option)x$52, x$53);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
        Assert.assertTrue((String)"Replica logs not deleted after delete topic is complete", (boolean)this.servers().forall((Function1)new Serializable(this, newPartition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition newPartition$2;

            public final boolean apply(KafkaServer x$8) {
                LogManager qual$11 = x$8.getLogManager();
                TopicPartition x$54 = this.newPartition$2;
                boolean x$55 = qual$11.getLog$default$2();
                return qual$11.getLog(x$54, x$55).isEmpty();
            }
            {
                this.newPartition$2 = newPartition$2;
            }
        }));
    }

    @Test
    public void testRecreateTopicAfterDeletion() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
        AdminZkClient qual$12 = this.adminZkClient();
        String x$56 = topic;
        scala.collection.immutable.Map x$57 = expectedReplicaAssignment;
        Properties x$58 = qual$12.createOrUpdateTopicPartitionAssignmentPathInZK$default$3();
        boolean x$59 = qual$12.createOrUpdateTopicPartitionAssignmentPathInZK$default$4();
        qual$12.createOrUpdateTopicPartitionAssignmentPathInZK(x$56, (Map)x$57, x$58, x$59);
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topic, 0, 1000L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            public final TopicPartition topicPartition$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.servers().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testRecreateTopicAfterDeletion$1 $outer;

                    public final boolean apply(KafkaServer x$9) {
                        LogManager qual$13 = x$9.getLogManager();
                        TopicPartition x$60 = this.$outer.topicPartition$4;
                        boolean x$61 = qual$13.getLog$default$2();
                        return qual$13.getLog(x$60, x$61).isDefined();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$4 = topicPartition$4;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Replicas for topic test not created.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testDeleteNonExistingTopic() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        try {
            this.adminZkClient().deleteTopic("test2");
            throw this.fail("Expected UnknownTopicOrPartitionException", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
        }
        catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
            TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), "test2", 1, this.servers());
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DeleteTopicTest $outer;
                public final TopicPartition topicPartition$5;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.$outer.servers().forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testDeleteNonExistingTopic$1 $outer;

                        public final boolean apply(KafkaServer x$10) {
                            LogManager qual$14 = x$10.getLogManager();
                            TopicPartition x$62 = this.$outer.topicPartition$5;
                            boolean x$63 = qual$14.getLog$default$2();
                            return qual$14.getLog(x$62, x$63).isDefined();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.topicPartition$5 = topicPartition$5;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Replicas for topic test not created";
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            Assert.assertTrue((String)"Topic test mistakenly deleted", (boolean)this.zkClient().topicExists(topic));
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topic, 0, 1000L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
            return;
        }
    }

    @Test
    public void testDeleteTopicWithCleaner() {
        String topicName = "test";
        TopicPartition topicPartition = new TopicPartition(topicName, 0);
        String topic = topicPartition.topic();
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14());
        ((Properties)brokerConfigs.head()).setProperty("delete.topic.enable", "true");
        ((Properties)brokerConfigs.head()).setProperty("log.cleaner.enable", "true");
        ((Properties)brokerConfigs.head()).setProperty("log.cleanup.policy", "compact");
        ((Properties)brokerConfigs.head()).setProperty("log.segment.bytes", "100");
        ((Properties)brokerConfigs.head()).setProperty("log.cleaner.dedupe.buffer.size", "1048577");
        this.servers_$eq(this.createTestTopicAndCluster(topic, brokerConfigs, this.expectedReplicaAssignment()));
        KafkaServer server = (KafkaServer)this.servers().head();
        LogManager qual$15 = server.logManager();
        TopicPartition x$64 = topicPartition;
        boolean x$65 = qual$15.getLog$default$2();
        Log log2 = (Log)qual$15.getLog(x$64, x$65).get();
        this.writeDups(100, 3, log2);
        LogCleaner qual$16 = server.logManager().cleaner();
        TopicPartition x$66 = new TopicPartition(topicName, 0);
        long x$67 = 0L;
        long x$68 = qual$16.awaitCleaned$default$3();
        qual$16.awaitCleaned(x$66, x$67, x$68);
        this.adminZkClient().deleteTopic("test");
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), "test", 1, this.servers());
    }

    @Test
    public void testDeleteTopicAlreadyMarkedAsDeleted() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        try {
            this.adminZkClient().deleteTopic(topic);
            this.adminZkClient().deleteTopic(topic);
            throw this.fail("Expected TopicAlreadyMarkedForDeletionException", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
        }
        catch (TopicAlreadyMarkedForDeletionException topicAlreadyMarkedForDeletionException) {
            TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
            return;
        }
    }

    private Seq<KafkaServer> createTestTopicAndCluster(String topic, boolean deleteTopicEnabled, scala.collection.immutable.Map<Object, List<Object>> replicaAssignment) {
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14());
        brokerConfigs.foreach((Function1)new Serializable(this, deleteTopicEnabled){
            public static final long serialVersionUID = 0L;
            private final boolean deleteTopicEnabled$1;

            public final Object apply(Properties x$11) {
                return x$11.setProperty("delete.topic.enable", ((Object)BoxesRunTime.boxToBoolean((boolean)this.deleteTopicEnabled$1)).toString());
            }
            {
                this.deleteTopicEnabled$1 = deleteTopicEnabled$1;
            }
        });
        return this.createTestTopicAndCluster(topic, brokerConfigs, replicaAssignment);
    }

    private Seq<KafkaServer> createTestTopicAndCluster(String topic, Seq<Properties> brokerConfigs, scala.collection.immutable.Map<Object, List<Object>> replicaAssignment) {
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq servers = (Seq)brokerConfigs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        AdminZkClient qual$17 = this.adminZkClient();
        String x$69 = topic;
        scala.collection.immutable.Map<Object, List<Object>> x$70 = replicaAssignment;
        Properties x$71 = qual$17.createOrUpdateTopicPartitionAssignmentPathInZK$default$3();
        boolean x$72 = qual$17.createOrUpdateTopicPartitionAssignmentPathInZK$default$4();
        qual$17.createOrUpdateTopicPartitionAssignmentPathInZK(x$69, x$70, x$71, x$72);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition, servers){
            public static final long serialVersionUID = 0L;
            public final TopicPartition topicPartition$6;
            private final Seq servers$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.servers$3.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$createTestTopicAndCluster$1 $outer;

                    public final boolean apply(KafkaServer x$12) {
                        LogManager qual$18 = x$12.getLogManager();
                        TopicPartition x$73 = this.$outer.topicPartition$6;
                        boolean x$74 = qual$18.getLog$default$2();
                        return qual$18.getLog(x$73, x$74).isDefined();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.topicPartition$6 = topicPartition$6;
                this.servers$3 = servers$3;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Replicas for topic test not created";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        return servers;
    }

    private boolean createTestTopicAndCluster$default$2() {
        return true;
    }

    private scala.collection.immutable.Map<Object, List<Object>> createTestTopicAndCluster$default$3() {
        return this.expectedReplicaAssignment();
    }

    private Seq<Tuple2<Object, Object>> writeDups(int numKeys, int numDups, Log log2) {
        IntRef counter = IntRef.create((int)0);
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1)new Serializable(this, numKeys, log2, counter){
            public static final long serialVersionUID = 0L;
            private final int numKeys$1;
            public final Log log$1;
            public final IntRef counter$1;

            public final IndexedSeq<Tuple2<Object, Object>> apply(int _) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numKeys$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$writeDups$1 $outer;

                    public final Tuple2<Object, Object> apply(int key) {
                        int count = this.$outer.counter$1.elem;
                        this.$outer.log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(((Object)BoxesRunTime.boxToInteger((int)this.$outer.counter$1.elem)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, this.$outer.log$1.appendAsLeader$default$3());
                        ++this.$outer.counter$1.elem;
                        return new Tuple2.mcII.sp(key, count);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.numKeys$1 = numKeys$1;
                this.log$1 = log$1;
                this.counter$1 = counter$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testDisableDeleteTopic() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, false, this.createTestTopicAndCluster$default$3()));
        this.adminZkClient().deleteTopic("test");
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final String topic$5;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.$outer.zkClient().isTopicMarkedForDeletion(this.topic$5);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$5 = topic$5;
            }
        }, (Function0<String>)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$5;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Admin path /admin/delete_topic/%s path not deleted even if deleteTopic is disabled")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$5}));
            }
            {
                this.topic$5 = topic$5;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Assert.assertTrue((boolean)this.servers().forall((Function1)new Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$7;

            public final boolean apply(KafkaServer x$13) {
                LogManager qual$19 = x$13.getLogManager();
                TopicPartition x$75 = this.topicPartition$7;
                boolean x$76 = qual$19.getLog$default$2();
                return qual$19.getLog(x$75, x$76).isDefined();
            }
            {
                this.topicPartition$7 = topicPartition$7;
            }
        }));
        Assert.assertTrue((String)"Topic path disappeared", (boolean)this.zkClient().topicExists(topic));
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assert.assertTrue((String)"Leader should exist for topic test", (boolean)leaderIdOpt.isDefined());
    }

    @Test
    public void testDeletingPartiallyDeletedTopic() {
        scala.collection.immutable.Map replicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, true, (scala.collection.immutable.Map<Object, List<Object>>)replicaAssignment));
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$14) {
                x$14.shutdown();
            }
        });
        this.zkClient().deleteRecursive(TopicPartitionZNode$.MODULE$.path(new TopicPartition(topic, 0)));
        this.adminZkClient().deleteTopic(topic);
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$15) {
                x$15.startup();
            }
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.servers().exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(KafkaServer x$16) {
                        return x$16.kafkaController().isActive();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "No controller is elected";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 2, this.servers());
    }
}

