/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Properties;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignPartitionsCommandTest;
import kafka.admin.ReassignmentCompleted$;
import kafka.cluster.Broker;
import kafka.log.LogConfig$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.easymock.Capture;
import org.easymock.CaptureType;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001B\u0001\u0003\u0001\u001d\u0011QDU3bgNLwM\u001c)beRLG/[8og\u000e{W.\\1oIR+7\u000f\u001e\u0006\u0003\u0007\u0011\tQ!\u00193nS:T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0004\t\u0003\u00131i\u0011A\u0003\u0006\u0003\u0017\u0011\t!A_6\n\u00055Q!\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002\u0010%5\t\u0001C\u0003\u0002\u0012\t\u0005)Q\u000f^5mg&\u00111\u0003\u0005\u0002\b\u0019><w-\u001b8h\u0011\u0015)\u0002\u0001\"\u0001\u0017\u0003\u0019a\u0014N\\5u}Q\tq\u0003\u0005\u0002\u0019\u00015\t!\u0001C\u0004\u001b\u0001\u0001\u0007I\u0011A\u000e\u0002\u000b\r\fG\u000e\\:\u0016\u0003q\u0001\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u00111!\u00138u\u0011\u001d\u0019\u0003\u00011A\u0005\u0002\u0011\n\u0011bY1mYN|F%Z9\u0015\u0005\u0015B\u0003CA\u000f'\u0013\t9cD\u0001\u0003V]&$\bbB\u0015#\u0003\u0003\u0005\r\u0001H\u0001\u0004q\u0012\n\u0004BB\u0016\u0001A\u0003&A$\u0001\u0004dC2d7\u000f\t\u0005\u0006[\u0001!\tAL\u0001\u0019g\"|W\u000f\u001c3GS:$Wj\u001c<j]\u001e\u0014V\r\u001d7jG\u0006\u001cH#A\u0013)\u00051\u0002\u0004CA\u00197\u001b\u0005\u0011$BA\u001a5\u0003\u0015QWO\\5u\u0015\u0005)\u0014aA8sO&\u0011qG\r\u0002\u0005)\u0016\u001cH\u000fC\u0003:\u0001\u0011\u0005a&\u0001\u001ctQ>,H\u000e\u001a$j]\u0012luN^5oOJ+\u0007\u000f\\5dCN<\u0006.\u001a8Qe>\u0004xn]3e\u0013N\u001cVOY:fi>3W\t_5ti&tw\r\u000b\u00029a!)A\b\u0001C\u0001]\u0005Q3\u000f[8vY\u00124\u0015N\u001c3N_ZLgn\u001a*fa2L7-Y:Nk2$\u0018\u000e\u001d7f!\u0006\u0014H/\u001b;j_:\u001c\bFA\u001e1\u0011\u0015y\u0004\u0001\"\u0001/\u0003\u0019\u001a\bn\\;mI\u001aKg\u000eZ'pm&twMU3qY&\u001c\u0017m]'vYRL\u0007\u000f\\3U_BL7m\u001d\u0015\u0003}ABQA\u0011\u0001\u0005\u00029\n1g\u001d5pk2$g)\u001b8e\u001b>4\u0018N\\4SKBd\u0017nY1t\u001bVdG/\u001b9mKR{\u0007/[2t\u0003:$\u0007+\u0019:uSRLwN\\:)\u0005\u0005\u0003\u0004\"B#\u0001\t\u0003q\u0013AK:i_VdGMR5oIR;x.T8wS:<'+\u001a9mS\u000e\f7/\u00138TC6,\u0007+\u0019:uSRLwN\u001c\u0015\u0003\tBBQ\u0001\u0013\u0001\u0005\u00029\nAh\u001d5pk2$gj\u001c;Pm\u0016\u0014xO]5uK\u0016sG/\u001b;z\u0007>tg-[4t/\",g.\u00169eCRLgn\u001a+ie>$H\u000f\\3e%\u0016\u0004H.[2bg\"\u0012q\t\r\u0005\u0006\u0017\u0002!\tAL\u0001\u0014g\"|W\u000f\u001c3TKR\fVo\u001c;b\u0019&l\u0017\u000e\u001e\u0015\u0003\u0015BBQA\u0014\u0001\u0005\u00029\nac\u001d5pk2$W\u000b\u001d3bi\u0016\fVo\u001c;b\u0019&l\u0017\u000e\u001e\u0015\u0003\u001bBBQ!\u0015\u0001\u0005\u00029\nAg\u001d5pk2$gj\u001c;Pm\u0016\u0014xO]5uK\u0016C\u0018n\u001d;j]\u001e\u0004&o\u001c9feRLWm],iK:d\u0015.\\5u\u0013N\fE\rZ3eQ\t\u0001\u0006\u0007C\u0003U\u0001\u0011\u0005a&A\u0014tQ>,H\u000e\u001a*f[>4X\r\u00165s_R$H.\u001a'j[&$hI]8n\u00032d'I]8lKJ\u001c\bFA*1\u0011\u00159\u0006\u0001\"\u0001/\u0003a\u001a\bn\\;mIJ+Wn\u001c<f)\"\u0014x\u000e\u001e;mKJ+\u0007\u000f\\5dC2K7\u000f\u001e\"bg\u0016$wJ\u001c)s_B|7/\u001a3BgNLwM\\7f]RD#A\u0016\u0019\t\u000bi\u0003A\u0011A.\u0002\u0005%\u001cXC\u0001/`)\ti\u0006\u000e\u0005\u0002_?2\u0001A!\u00021Z\u0005\u0004\t'!\u0001+\u0012\u0005\t,\u0007CA\u000fd\u0013\t!gDA\u0004O_RD\u0017N\\4\u0011\u0005u1\u0017BA4\u001f\u0005\r\te.\u001f\u0005\u0006Sf\u0003\r!X\u0001\u0002m\")1\u000e\u0001C\u0001]\u0005)1/\u001a;va\"\u0012!.\u001c\t\u0003c9L!a\u001c\u001a\u0003\r\t+gm\u001c:f\u0011\u0015\t\b\u0001\"\u0001s\u00031\u0019H/\u001e2[\u0017\u000ec\u0017.\u001a8u)\u0011\u0019h/!\b\u0011\u0005%!\u0018BA;\u000b\u00055Y\u0015MZ6b5.\u001cE.[3oi\"9q\u000f\u001dI\u0001\u0002\u0004A\u0018AE3ySN$\u0018N\\4BgNLwM\\7f]R\u0004R!\u001f?\u0000\u0003#q!!\b>\n\u0005mt\u0012A\u0002)sK\u0012,g-\u0003\u0002~}\n\u0019Q*\u00199\u000b\u0005mt\u0002\u0003BA\u0001\u0003\u001bi!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\u0007G>lWn\u001c8\u000b\u0007\u0015\tIAC\u0002\u0002\fQ\na!\u00199bG\",\u0017\u0002BA\b\u0003\u0007\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eE\u0003\u0002\u0014\u0005eA$\u0004\u0002\u0002\u0016)\u0019\u0011q\u0003\u0010\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u001c\u0005U!aA*fc\"I\u0011q\u00049\u0011\u0002\u0003\u0007\u0011\u0011C\u0001\bEJ|7.\u001a:t\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003K\tA\u0002^8SKBd\u0017nY1TKR$B!a\n\u00024A)\u00110!\u000b\u0002.%\u0019\u00111\u0006@\u0003\u0007M+G\u000fE\u0002z\u0003_I1!!\r\u007f\u0005\u0019\u0019FO]5oO\"9\u0011QGA\u0011\u0001\u0004)\u0017a\u0006;ie>$H\u000f\\3e%\u0016\u0004H.[2bgN#(/\u001b8h\u0011%\tI\u0004AI\u0001\n\u0003\tY$\u0001\ftiV\u0014'lS\"mS\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\tiDK\u0002y\u0003\u007fY#!!\u0011\u0011\t\u0005\r\u0013QJ\u0007\u0003\u0003\u000bRA!a\u0012\u0002J\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0017r\u0012AC1o]>$\u0018\r^5p]&!\u0011qJA#\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003'\u0002\u0011\u0013!C\u0001\u0003+\nac\u001d;vEj[5\t\\5f]R$C-\u001a4bk2$HEM\u000b\u0003\u0003/RC!!\u0005\u0002@\u0001")
public class ReassignPartitionsCommandTest
extends ZooKeeperTestHarness {
    private int calls = 0;

    public int calls() {
        return this.calls;
    }

    public void calls_$eq(int x$1) {
        this.calls = x$1;
    }

    @Test
    public void shouldFindMovingReplicas() {
        Tuple2 control = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})));
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null, null, null, null);
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), control}));
        scala.collection.immutable.Map proposed = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), control}));
        public class Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$1
        extends AdminZkClient {
            private final KafkaZkClient zkClient;
            public final /* synthetic */ ReassignPartitionsCommandTest $outer;

            public KafkaZkClient zkClient() {
                return this.zkClient;
            }

            public void changeTopicConfig(String topic, Properties configChange) {
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:102"})), this.kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer().toReplicaSet(configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp())));
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:100", "0:101"})), this.kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer().toReplicaSet(configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp())));
                this.kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer().calls_$eq(this.kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer().calls() + 1);
            }

            public Properties fetchEntityConfig(String entityType, String entityName) {
                return new Properties();
            }

            public /* synthetic */ ReassignPartitionsCommandTest kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer() {
                return this.$outer;
            }

            public Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$1(ReassignPartitionsCommandTest $outer, KafkaZkClient zkClient) {
                this.zkClient = zkClient;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(zkClient);
            }
        }
        Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$1 admin = new Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$1(this, this.zkClient());
        assigner.assignThrottledReplicas((Map)existing, (Map)proposed, (AdminZkClient)admin);
        Assert.assertEquals((long)1L, (long)this.calls());
    }

    @Test
    public void shouldFindMovingReplicasWhenProposedIsSubsetOfExisting() {
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null, null, null, null);
        scala.collection.immutable.Map existingSuperset = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic3", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 102})))}));
        scala.collection.immutable.Map proposedSubset = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 102})))}));
        public class Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$2
        extends AdminZkClient {
            private final KafkaZkClient zkClient;
            public final /* synthetic */ ReassignPartitionsCommandTest $outer;

            public KafkaZkClient zkClient() {
                return this.zkClient;
            }

            public void changeTopicConfig(String topic, Properties configChange) {
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:102", "2:102"})), this.kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer().toReplicaSet(configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp())));
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:100", "0:101", "2:100", "2:101"})), this.kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer().toReplicaSet(configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp())));
                Assert.assertEquals((Object)"topic1", (Object)topic);
                this.kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer().calls_$eq(this.kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer().calls() + 1);
            }

            public Properties fetchEntityConfig(String entityType, String entityName) {
                return new Properties();
            }

            public /* synthetic */ ReassignPartitionsCommandTest kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer() {
                return this.$outer;
            }

            public Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$2(ReassignPartitionsCommandTest $outer, KafkaZkClient zkClient) {
                this.zkClient = zkClient;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(zkClient);
            }
        }
        Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$2 admin = new Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$2(this, this.zkClient());
        assigner.assignThrottledReplicas((Map)existingSuperset, (Map)proposedSubset, (AdminZkClient)admin);
        Assert.assertEquals((long)1L, (long)this.calls());
    }

    @Test
    public void shouldFindMovingReplicasMultiplePartitions() {
        Tuple2 control = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})));
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null, null, null, null);
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), control}));
        scala.collection.immutable.Map proposed = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), control}));
        public class Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$3
        extends AdminZkClient {
            private final KafkaZkClient zkClient;
            public final /* synthetic */ ReassignPartitionsCommandTest $outer;

            public KafkaZkClient zkClient() {
                return this.zkClient;
            }

            public void changeTopicConfig(String topic, Properties configChange) {
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:102", "1:102"})), this.kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer().toReplicaSet(configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp())));
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:100", "0:101", "1:100", "1:101"})), this.kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer().toReplicaSet(configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp())));
                this.kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer().calls_$eq(this.kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer().calls() + 1);
            }

            public Properties fetchEntityConfig(String entityType, String entityName) {
                return new Properties();
            }

            public /* synthetic */ ReassignPartitionsCommandTest kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer() {
                return this.$outer;
            }

            public Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$3(ReassignPartitionsCommandTest $outer, KafkaZkClient zkClient) {
                this.zkClient = zkClient;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(zkClient);
            }
        }
        Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$3 admin = new Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$3(this, this.zkClient());
        assigner.assignThrottledReplicas((Map)existing, (Map)proposed, (AdminZkClient)admin);
        Assert.assertEquals((long)1L, (long)this.calls());
    }

    @Test
    public void shouldFindMovingReplicasMultipleTopics() {
        Tuple2 control = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})));
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null, null, null, null);
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), control}));
        scala.collection.immutable.Map proposed = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102}))), control}));
        public class Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$4
        extends AdminZkClient {
            private final KafkaZkClient zkClient;
            public final /* synthetic */ ReassignPartitionsCommandTest $outer;

            public KafkaZkClient zkClient() {
                return this.zkClient;
            }

            public void changeTopicConfig(String topic, Properties configChange) {
                block4: {
                    block3: {
                        String string;
                        block2: {
                            string = topic;
                            if (!"topic1".equals(string)) break block2;
                            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:100", "0:101"})), this.kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer().toReplicaSet(configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp())));
                            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:102"})), this.kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer().toReplicaSet(configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp())));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!"topic2".equals(string)) break block4;
                        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:101", "0:102"})), this.kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer().toReplicaSet(configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp())));
                        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:100"})), this.kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer().toReplicaSet(configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp())));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    this.kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer().calls_$eq(this.kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer().calls() + 1);
                    return;
                }
                throw this.kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer().fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected topic ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})), new Position("ReassignPartitionsCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
            }

            public Properties fetchEntityConfig(String entityType, String entityName) {
                return new Properties();
            }

            public /* synthetic */ ReassignPartitionsCommandTest kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer() {
                return this.$outer;
            }

            public Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$4(ReassignPartitionsCommandTest $outer, KafkaZkClient zkClient) {
                this.zkClient = zkClient;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(zkClient);
            }
        }
        Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$4 admin = new Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$4(this, this.zkClient());
        assigner.assignThrottledReplicas((Map)existing, (Map)proposed, (AdminZkClient)admin);
        Assert.assertEquals((long)2L, (long)this.calls());
    }

    @Test
    public void shouldFindMovingReplicasMultipleTopicsAndPartitions() {
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null, null, null, null);
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102})))}));
        scala.collection.immutable.Map proposed = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 100})))}));
        public class Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$5
        extends AdminZkClient {
            private final KafkaZkClient zkClient;
            public final /* synthetic */ ReassignPartitionsCommandTest $outer;

            public KafkaZkClient zkClient() {
                return this.zkClient;
            }

            public void changeTopicConfig(String topic, Properties configChange) {
                block4: {
                    block3: {
                        String string;
                        block2: {
                            string = topic;
                            if (!"topic1".equals(string)) break block2;
                            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:102", "1:102"})), this.kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer().toReplicaSet(configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp())));
                            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:100", "0:101", "1:100", "1:101"})), this.kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer().toReplicaSet(configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp())));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!"topic2".equals(string)) break block4;
                        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:100", "1:100"})), this.kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer().toReplicaSet(configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp())));
                        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:101", "0:102", "1:101", "1:102"})), this.kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer().toReplicaSet(configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp())));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    this.kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer().calls_$eq(this.kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer().calls() + 1);
                    return;
                }
                throw this.kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer().fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected topic ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})), new Position("ReassignPartitionsCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
            }

            public Properties fetchEntityConfig(String entityType, String entityName) {
                return new Properties();
            }

            public /* synthetic */ ReassignPartitionsCommandTest kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer() {
                return this.$outer;
            }

            public Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$5(ReassignPartitionsCommandTest $outer, KafkaZkClient zkClient) {
                this.zkClient = zkClient;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(zkClient);
            }
        }
        Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$5 admin = new Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$5(this, this.zkClient());
        assigner.assignThrottledReplicas((Map)existing, (Map)proposed, (AdminZkClient)admin);
        Assert.assertEquals((long)2L, (long)this.calls());
    }

    @Test
    public void shouldFindTwoMovingReplicasInSamePartition() {
        Tuple2 control = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})));
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null, null, null, null);
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 102, 103}))), control}));
        scala.collection.immutable.Map proposed = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 104, 105}))), control}));
        public class Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$6
        extends AdminZkClient {
            private final KafkaZkClient zkClient;
            public final /* synthetic */ ReassignPartitionsCommandTest $outer;

            public KafkaZkClient zkClient() {
                return this.zkClient;
            }

            public void changeTopicConfig(String topic, Properties configChange) {
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:104", "0:105"})), this.kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer().toReplicaSet(configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp())));
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:100", "0:101", "0:102", "0:103"})), this.kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer().toReplicaSet(configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp())));
                this.kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer().calls_$eq(this.kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer().calls() + 1);
            }

            public Properties fetchEntityConfig(String entityType, String entityName) {
                return new Properties();
            }

            public /* synthetic */ ReassignPartitionsCommandTest kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer() {
                return this.$outer;
            }

            public Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$6(ReassignPartitionsCommandTest $outer, KafkaZkClient zkClient) {
                this.zkClient = zkClient;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(zkClient);
            }
        }
        Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$6 admin = new Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$6(this, this.zkClient());
        assigner.assignThrottledReplicas((Map)existing, (Map)proposed, (AdminZkClient)admin);
        Assert.assertEquals((long)1L, (long)this.calls());
    }

    @Test
    public void shouldNotOverwriteEntityConfigsWhenUpdatingThrottledReplicas() {
        Tuple2 control = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})));
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null, null, null, null);
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), control}));
        scala.collection.immutable.Map proposed = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), control}));
        Properties existingProperties = CoreUtils$.MODULE$.propsWith("some-key", "some-value");
        public class Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$7
        extends AdminZkClient {
            private final KafkaZkClient zkClient;
            public final /* synthetic */ ReassignPartitionsCommandTest $outer;
            private final Properties existingProperties$1;

            public KafkaZkClient zkClient() {
                return this.zkClient;
            }

            public void changeTopicConfig(String topic, Properties configChange) {
                Assert.assertEquals((Object)"some-value", (Object)configChange.getProperty("some-key"));
                this.kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer().calls_$eq(this.kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer().calls() + 1);
            }

            public Properties fetchEntityConfig(String entityType, String entityName) {
                return this.existingProperties$1;
            }

            public /* synthetic */ ReassignPartitionsCommandTest kafka$admin$ReassignPartitionsCommandTest$TestAdminZkClient$$$outer() {
                return this.$outer;
            }

            public Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$7(ReassignPartitionsCommandTest $outer, KafkaZkClient zkClient, Properties existingProperties$1) {
                this.zkClient = zkClient;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.existingProperties$1 = existingProperties$1;
                super(zkClient);
            }
        }
        Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$7 admin = new Kafka_admin_ReassignPartitionsCommandTest$TestAdminZkClient$7(this, this.zkClient(), existingProperties);
        assigner.assignThrottledReplicas((Map)existing, (Map)proposed, (AdminZkClient)admin);
        Assert.assertEquals((long)1L, (long)this.calls());
    }

    @Test
    public void shouldSetQuotaLimit() {
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}));
        scala.collection.mutable.Map proposed = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102})))}));
        KafkaZkClient zk = this.stubZKClient((scala.collection.immutable.Map<TopicPartition, Seq<Object>>)existing, this.stubZKClient$default$2());
        AdminZkClient admin = (AdminZkClient)EasyMock.createMock(AdminZkClient.class);
        Capture propsCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(zk, (Option)None$.MODULE$, (Map)proposed, (Map)Predef$.MODULE$.Map().empty(), admin);
        EasyMock.expect((Object)admin.fetchEntityConfig(EasyMock.anyString(), EasyMock.anyString())).andStubReturn((Object)new Properties());
        admin.changeBrokerConfig((Seq)((List)EasyMock.anyObject()), (Properties)EasyMock.capture((Capture)propsCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.replay((Object[])new Object[]{admin});
        assigner.maybeLimit(new ReassignPartitionsCommand.Throttle(1000L, ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$2(), ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$3()));
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(propsCapture.getValues()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Properties actual) {
                Assert.assertEquals((Object)"1000", (Object)actual.getProperty(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp()));
                Assert.assertEquals((Object)"1000", (Object)actual.getProperty(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp()));
            }
        });
        Assert.assertEquals((long)3L, (long)propsCapture.getValues().size());
    }

    @Test
    public void shouldUpdateQuotaLimit() {
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}));
        scala.collection.mutable.Map proposed = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102})))}));
        KafkaZkClient zk = this.stubZKClient((scala.collection.immutable.Map<TopicPartition, Seq<Object>>)existing, this.stubZKClient$default$2());
        AdminZkClient admin = (AdminZkClient)EasyMock.createMock(AdminZkClient.class);
        Capture propsCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(zk, (Option)None$.MODULE$, (Map)proposed, (Map)Predef$.MODULE$.Map().empty(), admin);
        admin.changeBrokerConfig((Seq)((List)EasyMock.anyObject()), (Properties)EasyMock.capture((Capture)propsCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        Properties existingConfigs = CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)"10"), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)"100")}));
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(ConfigType$.MODULE$.Broker()), this.is("100"))).andReturn((Object)TestUtils$.MODULE$.copyOf(existingConfigs));
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(ConfigType$.MODULE$.Broker()), this.is("101"))).andReturn((Object)TestUtils$.MODULE$.copyOf(existingConfigs));
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(ConfigType$.MODULE$.Broker()), this.is("102"))).andReturn((Object)TestUtils$.MODULE$.copyOf(existingConfigs));
        EasyMock.replay((Object[])new Object[]{admin});
        assigner.maybeLimit(new ReassignPartitionsCommand.Throttle(1000L, ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$2(), ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$3()));
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(propsCapture.getValues()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Properties actual) {
                Assert.assertEquals((Object)"1000", (Object)actual.getProperty(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp()));
                Assert.assertEquals((Object)"1000", (Object)actual.getProperty(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp()));
            }
        });
        Assert.assertEquals((long)3L, (long)propsCapture.getValues().size());
    }

    @Test
    public void shouldNotOverwriteExistingPropertiesWhenLimitIsAdded() {
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}));
        scala.collection.mutable.Map proposed = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102})))}));
        KafkaZkClient zk = this.stubZKClient((scala.collection.immutable.Map<TopicPartition, Seq<Object>>)existing, this.stubZKClient$default$2());
        AdminZkClient admin = (AdminZkClient)EasyMock.createMock(AdminZkClient.class);
        Capture propsCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(zk, (Option)None$.MODULE$, (Map)proposed, (Map)Predef$.MODULE$.Map().empty(), admin);
        admin.changeBrokerConfig((Seq)((List)EasyMock.anyObject()), (Properties)EasyMock.capture((Capture)propsCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(ConfigType$.MODULE$.Broker()), EasyMock.anyString())).andReturn((Object)CoreUtils$.MODULE$.propsWith("useful.key", "useful.value")).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{admin});
        assigner.maybeLimit(new ReassignPartitionsCommand.Throttle(1000L, ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$2(), ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$3()));
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(propsCapture.getValues()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Properties actual) {
                Assert.assertEquals((Object)"useful.value", (Object)actual.getProperty("useful.key"));
                Assert.assertEquals((Object)"1000", (Object)actual.getProperty(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp()));
                Assert.assertEquals((Object)"1000", (Object)actual.getProperty(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp()));
            }
        });
        Assert.assertEquals((long)3L, (long)propsCapture.getValues().size());
    }

    @Test
    public void shouldRemoveThrottleLimitFromAllBrokers() {
        Seq brokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 102}));
        scala.collection.mutable.Map status = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)ReassignmentCompleted$.MODULE$)}));
        Properties existingBrokerConfigs = CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)"10"), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)"100"), new Tuple2((Object)"useful.key", (Object)"value")}));
        Seq x$2 = brokers;
        scala.collection.immutable.Map<TopicPartition, Seq<Object>> x$3 = this.stubZKClient$default$1();
        KafkaZkClient zk = this.stubZKClient(x$3, (Seq<Object>)x$2);
        AdminZkClient admin = (AdminZkClient)EasyMock.createMock(AdminZkClient.class);
        Capture propsCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(ConfigType$.MODULE$.Topic()), EasyMock.anyString())).andStubReturn((Object)new Properties());
        admin.changeBrokerConfig((Seq)EasyMock.anyObject(), (Properties)EasyMock.capture((Capture)propsCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(ConfigType$.MODULE$.Broker()), this.is("100"))).andReturn((Object)TestUtils$.MODULE$.copyOf(existingBrokerConfigs));
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(ConfigType$.MODULE$.Broker()), this.is("101"))).andReturn((Object)TestUtils$.MODULE$.copyOf(existingBrokerConfigs));
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(ConfigType$.MODULE$.Broker()), this.is("102"))).andReturn((Object)TestUtils$.MODULE$.copyOf(existingBrokerConfigs));
        EasyMock.replay((Object[])new Object[]{admin});
        ReassignPartitionsCommand$.MODULE$.removeThrottle(zk, (Map)status, (Map)Predef$.MODULE$.Map().empty(), admin);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(propsCapture.getValues()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Properties capture) {
                Assert.assertEquals((Object)"value", (Object)capture.get("useful.key"));
                Assert.assertNull((Object)capture.get(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp()));
                Assert.assertNull((Object)capture.get(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp()));
            }
        });
        Assert.assertEquals((long)3L, (long)propsCapture.getValues().size());
    }

    @Test
    public void shouldRemoveThrottleReplicaListBasedOnProposedAssignment() {
        scala.collection.mutable.Map status = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)ReassignmentCompleted$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 0)), (Object)ReassignmentCompleted$.MODULE$)}));
        Properties existingConfigs = CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), (Object)"1:100:2:100"), new Tuple2((Object)LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), (Object)"1:101,2:101"), new Tuple2((Object)"useful.key", (Object)"value")}));
        Seq x$4 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}));
        scala.collection.immutable.Map<TopicPartition, Seq<Object>> x$5 = this.stubZKClient$default$1();
        KafkaZkClient zk = this.stubZKClient(x$5, (Seq<Object>)x$4);
        AdminZkClient admin = (AdminZkClient)EasyMock.createMock(AdminZkClient.class);
        Capture propsCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(ConfigType$.MODULE$.Broker()), EasyMock.anyString())).andStubReturn((Object)new Properties());
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(ConfigType$.MODULE$.Topic()), this.is("topic1"))).andStubReturn((Object)TestUtils$.MODULE$.copyOf(existingConfigs));
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(ConfigType$.MODULE$.Topic()), this.is("topic2"))).andStubReturn((Object)TestUtils$.MODULE$.copyOf(existingConfigs));
        admin.changeTopicConfig(this.is("topic1"), (Properties)EasyMock.capture((Capture)propsCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        admin.changeTopicConfig(this.is("topic2"), (Properties)EasyMock.capture((Capture)propsCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{admin});
        ReassignPartitionsCommand$.MODULE$.removeThrottle(zk, (Map)status, (Map)Predef$.MODULE$.Map().empty(), admin);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(propsCapture.getValues()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Properties actual) {
                Assert.assertEquals((Object)"value", (Object)actual.getProperty("useful.key"));
                Assert.assertNull((Object)actual.getProperty(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
                Assert.assertNull((Object)actual.getProperty(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp()));
            }
        });
        Assert.assertEquals((long)2L, (long)propsCapture.getValues().size());
    }

    public <T> T is(T v) {
        return (T)EasyMock.eq(v);
    }

    @Before
    public void setup() {
        this.calls_$eq(0);
    }

    /*
     * WARNING - void declaration
     */
    public KafkaZkClient stubZKClient(scala.collection.immutable.Map<TopicPartition, Seq<Object>> existingAssignment, Seq<Object> brokers) {
        void var3_3;
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createMock(KafkaZkClient.class);
        EasyMock.expect((Object)zkClient.getReplicaAssignmentForTopics((Set)EasyMock.anyObject())).andStubReturn(existingAssignment);
        EasyMock.expect((Object)zkClient.getAllBrokersInCluster()).andStubReturn(brokers.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Broker apply(int x$1) {
                return TestUtils$.MODULE$.createBroker(x$1, "", 1, TestUtils$.MODULE$.createBroker$default$4());
            }
        }, Seq$.MODULE$.canBuildFrom()));
        EasyMock.replay((Object[])new Object[]{zkClient});
        return var3_3;
    }

    public scala.collection.immutable.Map<TopicPartition, Seq<Object>> stubZKClient$default$1() {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public Seq<Object> stubZKClient$default$2() {
        return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public Set<String> toReplicaSet(Object throttledReplicasString) {
        return Predef$.MODULE$.refArrayOps((Object[])throttledReplicasString.toString().split(",")).toSet();
    }
}

