/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.Properties;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareTest;
import kafka.admin.RackAwareTest$class;
import kafka.admin.ReplicaDistributions;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001!4A!\u0001\u0002\u0001\u000f\tq\"+Y2l\u0003^\f'/Z!vi>$v\u000e]5d\u0007J,\u0017\r^5p]R+7\u000f\u001e\u0006\u0003\u0007\u0011\t1!\u00199j\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!q\u0001CA\u0005\r\u001b\u0005Q!BA\u0006\u0005\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u00055Q!AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B1e[&t\u0017BA\n\u0011\u00055\u0011\u0016mY6Bo\u0006\u0014X\rV3ti\")Q\u0003\u0001C\u0001-\u00051A(\u001b8jiz\"\u0012a\u0006\t\u00031\u0001i\u0011A\u0001\u0005\b5\u0001\u0011\r\u0011\"\u0001\u001c\u0003)qW/\\*feZ,'o]\u000b\u00029A\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t\u0019\u0011J\u001c;\t\r\r\u0002\u0001\u0015!\u0003\u001d\u0003-qW/\\*feZ,'o\u001d\u0011\t\u000f\u0015\u0002!\u0019!C\u00017\u0005ia.^7QCJ$\u0018\u000e^5p]NDaa\n\u0001!\u0002\u0013a\u0012A\u00048v[B\u000b'\u000f^5uS>t7\u000f\t\u0005\bS\u0001\u0011\r\u0011\"\u0001\u001c\u0003E\u0011X\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d\u0005\u0007W\u0001\u0001\u000b\u0011\u0002\u000f\u0002%I,\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000f\t\u0005\b[\u0001\u0011\r\u0011\"\u0001/\u0003=yg/\u001a:sS\u0012Lgn\u001a)s_B\u001cX#A\u0018\u0011\u0005A*T\"A\u0019\u000b\u0005I\u001a\u0014\u0001B;uS2T\u0011\u0001N\u0001\u0005U\u00064\u0018-\u0003\u00027c\tQ\u0001K]8qKJ$\u0018.Z:\t\ra\u0002\u0001\u0015!\u00030\u0003Ayg/\u001a:sS\u0012Lgn\u001a)s_B\u001c\b\u0005C\u0003;\u0001\u0011\u00051(A\bhK:,'/\u0019;f\u0007>tg-[4t+\u0005a\u0004cA\u001fF\u0011:\u0011ah\u0011\b\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003\u001a\ta\u0001\u0010:p_Rt\u0014\"A\u0010\n\u0005\u0011s\u0012a\u00029bG.\fw-Z\u0005\u0003\r\u001e\u00131aU3r\u0015\t!e\u0004\u0005\u0002J\u00196\t!J\u0003\u0002L\t\u000511/\u001a:wKJL!!\u0014&\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\b\u001f\u0002\u0011\r\u0011\"\u0003Q\u0003\u0015!x\u000e]5d+\u0005\t\u0006C\u0001*V\u001b\u0005\u0019&B\u0001+4\u0003\u0011a\u0017M\\4\n\u0005Y\u001b&AB*ue&tw\r\u0003\u0004Y\u0001\u0001\u0006I!U\u0001\u0007i>\u0004\u0018n\u0019\u0011\t\u000bi\u0003A\u0011A.\u0002'Q,7\u000f^!vi>\u001c%/Z1uKR{\u0007/[2\u0015\u0003q\u0003\"!H/\n\u0005ys\"\u0001B+oSRD#!\u00171\u0011\u0005\u00054W\"\u00012\u000b\u0005\r$\u0017!\u00026v]&$(\"A3\u0002\u0007=\u0014x-\u0003\u0002hE\n!A+Z:u\u0001")
public class RackAwareAutoTopicCreationTest
extends KafkaServerTestHarness
implements RackAwareTest {
    private final int numServers;
    private final int numPartitions;
    private final int replicationFactor;
    private final Properties overridingProps;
    private final String topic;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment2, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest$class.checkReplicaDistribution(this, assignment2, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment2, Map<Object, String> brokerRackMapping) {
        return RackAwareTest$class.getReplicaDistribution(this, assignment2, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest$class.toBrokerMetadata(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest$class.toBrokerMetadata$default$2(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest$class.checkReplicaDistribution$default$6(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest$class.checkReplicaDistribution$default$7(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest$class.checkReplicaDistribution$default$8(this);
    }

    public int numServers() {
        return this.numServers;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public int replicationFactor() {
        return this.replicationFactor;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)((TraversableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numServers()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RackAwareAutoTopicCreationTest $outer;

            public final Properties apply(int node) {
                int x$2 = node;
                String x$3 = this.$outer.zkConnect();
                boolean x$4 = false;
                Some x$5 = new Some((Object)((Object)BoxesRunTime.boxToInteger((int)(node / 2))).toString());
                boolean x$6 = TestUtils$.MODULE$.createBrokerConfig$default$4();
                int x$7 = TestUtils$.MODULE$.createBrokerConfig$default$5();
                Option<SecurityProtocol> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$6();
                Option<File> x$9 = TestUtils$.MODULE$.createBrokerConfig$default$7();
                Option<Properties> x$10 = TestUtils$.MODULE$.createBrokerConfig$default$8();
                boolean x$11 = TestUtils$.MODULE$.createBrokerConfig$default$9();
                boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$10();
                int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$11();
                boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$12();
                int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$13();
                boolean x$16 = TestUtils$.MODULE$.createBrokerConfig$default$14();
                int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$15();
                int x$18 = TestUtils$.MODULE$.createBrokerConfig$default$17();
                boolean x$19 = TestUtils$.MODULE$.createBrokerConfig$default$18();
                return TestUtils$.MODULE$.createBrokerConfig(x$2, x$3, x$4, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, (Option<String>)x$5, x$18, x$19);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RackAwareAutoTopicCreationTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.overridingProps());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private String topic() {
        return this.topic;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAutoCreateTopic() {
        String x$20 = this.brokerList();
        int x$21 = 5;
        int x$22 = TestUtils$.MODULE$.createProducer$default$2();
        long x$23 = TestUtils$.MODULE$.createProducer$default$3();
        long x$24 = TestUtils$.MODULE$.createProducer$default$4();
        long x$25 = TestUtils$.MODULE$.createProducer$default$6();
        long x$26 = TestUtils$.MODULE$.createProducer$default$7();
        SecurityProtocol x$27 = TestUtils$.MODULE$.createProducer$default$8();
        Option<File> x$28 = TestUtils$.MODULE$.createProducer$default$9();
        Option<Properties> x$29 = TestUtils$.MODULE$.createProducer$default$10();
        ByteArraySerializer x$30 = TestUtils$.MODULE$.createProducer$default$11();
        ByteArraySerializer x$31 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$32 = TestUtils$.MODULE$.createProducer$default$13();
        KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$20, x$22, x$23, x$24, x$21, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32);
        try {
            ProducerRecord record = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
            Assert.assertEquals((String)"Should have offset 0", (long)0L, (long)((RecordMetadata)producer.send(record).get()).offset());
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
            scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)this.zkClient().getReplicaAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Seq<Object>> apply(Tuple2<TopicPartition, Seq<Object>> x0$1) {
                    Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$1;
                    if (tuple2 != null) {
                        TopicPartition topicPartition = (TopicPartition)tuple2._1();
                        Seq replicas = (Seq)tuple2._2();
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())), (Object)replicas);
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
            }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
            AdminZkClient qual$1 = this.adminZkClient();
            RackAwareMode.Enforced$ x$33 = RackAwareMode.Enforced$.MODULE$;
            Option x$34 = qual$1.getBrokerMetadatas$default$2();
            Seq brokerMetadatas = qual$1.getBrokerMetadatas((RackAwareMode)x$33, x$34);
            Map expectedMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"1")}));
            Assert.assertEquals((Object)expectedMap, (Object)((TraversableOnce)brokerMetadatas.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, String> apply(BrokerMetadata b) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)b.id())), b.rack().get());
                }
            }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
            this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment2, (Map<Object, String>)expectedMap, this.numServers(), this.numPartitions(), this.replicationFactor(), this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
        }
        catch (Throwable throwable) {
            void var1_14;
            var1_14.close();
            throw throwable;
        }
        producer.close();
    }

    public RackAwareAutoTopicCreationTest() {
        RackAwareTest$class.$init$(this);
        this.numServers = 4;
        this.numPartitions = 8;
        this.replicationFactor = 2;
        this.overridingProps = new Properties();
        this.overridingProps().put(KafkaConfig$.MODULE$.NumPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.numPartitions())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), ((Object)BoxesRunTime.boxToInteger((int)this.replicationFactor())).toString());
        this.topic = "topic";
    }
}

