/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedFetch;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.FetchMetadata;
import kafka.server.FetchPartitionStatus;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaQuota;
import kafka.utils.KafkaScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005me\u0001B\u0001\u0003\u0001\u001d\u0011\u0001DU3qY&\u001c\u0017-T1oC\u001e,'/U;pi\u0006\u001cH+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\b)\u0001\u0011\r\u0011\"\u0001\u0016\u0003\u001d\u0019wN\u001c4jON,\u0012A\u0006\t\u0004/iaR\"\u0001\r\u000b\u0005eQ\u0011AC2pY2,7\r^5p]&\u00111\u0004\u0007\u0002\u0004'\u0016\f\bC\u0001\n\u001e\u0013\tq\"AA\u0006LC\u001a\\\u0017mQ8oM&<\u0007B\u0002\u0011\u0001A\u0003%a#\u0001\u0005d_:4\u0017nZ:!\u0011\u001d\u0011\u0003A1A\u0005\u0002\r\nA\u0001^5nKV\tA\u0005\u0005\u0002&Q5\taE\u0003\u0002(\t\u0005)Q\u000f^5mg&\u0011\u0011F\n\u0002\t\u001b>\u001c7\u000eV5nK\"11\u0006\u0001Q\u0001\n\u0011\nQ\u0001^5nK\u0002Bq!\f\u0001C\u0002\u0013\u0005a&A\u0004nKR\u0014\u0018nY:\u0016\u0003=\u0002\"\u0001M\u001d\u000e\u0003ER!!\f\u001a\u000b\u0005M\"\u0014AB2p[6|gN\u0003\u0002\u0006k)\u0011agN\u0001\u0007CB\f7\r[3\u000b\u0003a\n1a\u001c:h\u0013\tQ\u0014GA\u0004NKR\u0014\u0018nY:\t\rq\u0002\u0001\u0015!\u00030\u0003!iW\r\u001e:jGN\u0004\u0003b\u0002 \u0001\u0005\u0004%\taP\u0001\u0007e\u0016\u001cwN\u001d3\u0016\u0003\u0001\u0003\"!Q\"\u000e\u0003\tS!A\u0010\u001a\n\u0005\u0011\u0013%\u0001D*j[BdWMU3d_J$\u0007B\u0002$\u0001A\u0003%\u0001)A\u0004sK\u000e|'\u000f\u001a\u0011\t\u000f!\u0003!\u0019!C\u0001\u0013\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t\u0017'F\u0001K!\tYE*D\u00013\u0013\ti%G\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\r=\u0003\u0001\u0015!\u0003K\u0003A!x\u000e]5d!\u0006\u0014H/\u001b;j_:\f\u0004\u0005C\u0004R\u0001\t\u0007I\u0011A%\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]JBaa\u0015\u0001!\u0002\u0013Q\u0015\u0001\u0005;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u001a!\u0011\u001d)\u0006A1A\u0005\u0002Y\u000b\u0011BZ3uG\"LeNZ8\u0016\u0003]\u00032a\u0006\u000eY!\u0011I\u0011LS.\n\u0005iS!A\u0002+va2,'\u0007\u0005\u0002]]:\u0011Ql\u001b\b\u0003=&t!a\u00185\u000f\u0005\u0001<gBA1g\u001d\t\u0011W-D\u0001d\u0015\t!g!\u0001\u0004=e>|GOP\u0005\u0002q%\u0011agN\u0005\u0003\u000bUJ!a\r\u001b\n\u0005)\u0014\u0014\u0001\u0003:fcV,7\u000f^:\n\u00051l\u0017\u0001\u0004$fi\u000eD'+Z9vKN$(B\u000163\u0013\ty\u0007OA\u0007QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u0006\u0003Y6DaA\u001d\u0001!\u0002\u00139\u0016A\u00034fi\u000eD\u0017J\u001c4pA!IA\u000f\u0001a\u0001\u0002\u0004%\t!^\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s+\u00051\bC\u0001\nx\u0013\tA(A\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\t\u0013i\u0004\u0001\u0019!a\u0001\n\u0003Y\u0018A\u0005:fa2L7-Y'b]\u0006<WM]0%KF$\"\u0001`@\u0011\u0005%i\u0018B\u0001@\u000b\u0005\u0011)f.\u001b;\t\u0011\u0005\u0005\u00110!AA\u0002Y\f1\u0001\u001f\u00132\u0011\u001d\t)\u0001\u0001Q!\nY\fqB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\t\u0005\b\u0003\u0013\u0001A\u0011AA\u0006\u0003)\u001a\bn\\;mI\u0016C8\r\\;eKN+(m]3rk\u0016tG\u000f\u00165s_R$H.\u001a3QCJ$\u0018\u000e^5p]N$\u0012\u0001 \u0015\u0005\u0003\u000f\ty\u0001\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)bN\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u00033\t\u0019B\u0001\u0003UKN$\bbBA\u000f\u0001\u0011\u0005\u00111B\u0001:g\"|W\u000f\u001c3HKRtu.T3tg\u0006<Wm]%g#V|G/Y:Fq\u000e,W\rZ3e\u001f:\u001cVOY:fcV,g\u000e\u001e)beRLG/[8og\"\"\u00111DA\b\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003\u0017\t!e\u001d5pk2$w)\u001a;C_RDW*Z:tC\u001e,7/\u00134Rk>$\u0018m]!mY><\b\u0006BA\u0011\u0003\u001fAq!!\u000b\u0001\t\u0003\tY!\u0001\u0013tQ>,H\u000eZ%oG2,H-Z%o'ft7\r\u00165s_R$H.\u001a3SKBd\u0017nY1tQ\u0011\t9#a\u0004\t\u000f\u0005=\u0002\u0001\"\u0001\u0002\f\u0005yC/Z:u\u0007>l\u0007\u000f\\3uK&sG)\u001a7bs\u0016$g)\u001a;dQ^KG\u000f\u001b*fa2L7-\u0019+ie>$H\u000f\\5oO\"\"\u0011QFA\b\u0011\u001d\t)\u0004\u0001C\u0001\u0003o\t!b]3u+BlunY6t)\u001da\u0018\u0011HA&\u0003\u001bBq!VA\u001a\u0001\u0004\tY\u0004E\u0003\u0002>\u0005\u001d\u0003L\u0004\u0003\u0002@\u0005\rcb\u00012\u0002B%\t1\"C\u0002\u0002F)\tq\u0001]1dW\u0006<W-C\u0002\u001c\u0003\u0013R1!!\u0012\u000b\u0011!q\u00141\u0007I\u0001\u0002\u0004\u0001\u0005BCA(\u0003g\u0001\n\u00111\u0001\u0002R\u0005\u0011\"m\u001c;i%\u0016\u0004H.[2bg&s7+\u001f8d!\rI\u00111K\u0005\u0004\u0003+R!a\u0002\"p_2,\u0017M\u001c\u0005\b\u00033\u0002A\u0011AA\u0006\u0003!!X-\u0019:E_^t\u0007\u0006BA,\u0003;\u0002B!!\u0005\u0002`%!\u0011\u0011MA\n\u0005\u0015\te\r^3s\u0011\u001d\t)\u0007\u0001C\u0001\u0003O\n\u0011\"\\8dWF+x\u000e^1\u0015\t\u0005%\u0014q\u000e\t\u0004%\u0005-\u0014bAA7\u0005\ta!+\u001a9mS\u000e\f\u0017+^8uC\"A\u0011\u0011OA2\u0001\u0004\t\u0019(A\u0003c_VtG\rE\u0002\n\u0003kJ1!a\u001e\u000b\u0005\u0011auN\\4\t\u0013\u0005m\u0004!%A\u0005\u0002\u0005u\u0014\u0001F:fiV\u0003Xj\\2lg\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u0000)\u001a\u0001)!!,\u0005\u0005\r\u0005\u0003BAC\u0003\u001fk!!a\"\u000b\t\u0005%\u00151R\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!$\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003#\u000b9IA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"!&\u0001#\u0003%\t!a&\u0002)M,G/\u00169N_\u000e\\7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tIJ\u000b\u0003\u0002R\u0005\u0005\u0005")
public class ReplicaManagerQuotasTest {
    private final Seq<KafkaConfig> configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final KafkaConfig apply(Properties x$1) {
            return KafkaConfig$.MODULE$.fromProps(x$1, new Properties());
        }
    }, Seq$.MODULE$.canBuildFrom());
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final SimpleRecord record = new SimpleRecord("some-data-in-a-message".getBytes());
    private final TopicPartition topicPartition1 = new TopicPartition("test-topic", 1);
    private final TopicPartition topicPartition2 = new TopicPartition("test-topic", 2);
    private final Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>> fetchInfo = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition1()), (Object)new FetchRequest.PartitionData(0L, 0L, 100)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition2()), (Object)new FetchRequest.PartitionData(0L, 0L, 100))}));
    private ReplicaManager replicaManager;

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public SimpleRecord record() {
        return this.record;
    }

    public TopicPartition topicPartition1() {
        return this.topicPartition1;
    }

    public TopicPartition topicPartition2() {
        return this.topicPartition2;
    }

    public Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>> fetchInfo() {
        return this.fetchInfo;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    @Test
    public void shouldExcludeSubsequentThrottledPartitions() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch2 = this.replicaManager().readFromLocalLog(followerReplicaId, true, true, Integer.MAX_VALUE, false, this.fetchInfo(), quota, IsolationLevel.READ_UNCOMMITTED);
        Assert.assertEquals((String)"Given two partitions, with only one throttled, we should get the first", (long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch2.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;

            public final boolean apply(Tuple2<TopicPartition, LogReadResult> x$2) {
                Object object = x$2._1();
                TopicPartition topicPartition = this.$outer.topicPartition1();
                return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().records().batches()).asScala()).size());
        Assert.assertEquals((String)"But we shouldn't get the second", (long)0L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch2.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;

            public final boolean apply(Tuple2<TopicPartition, LogReadResult> x$3) {
                Object object = x$3._1();
                TopicPartition topicPartition = this.$outer.topicPartition2();
                return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().records().batches()).asScala()).size());
    }

    @Test
    public void shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch2 = this.replicaManager().readFromLocalLog(followerReplicaId, true, true, Integer.MAX_VALUE, false, this.fetchInfo(), quota, IsolationLevel.READ_UNCOMMITTED);
        Assert.assertEquals((String)"Given two partitions, with both throttled, we should get no messages", (long)0L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch2.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;

            public final boolean apply(Tuple2<TopicPartition, LogReadResult> x$4) {
                Object object = x$4._1();
                TopicPartition topicPartition = this.$outer.topicPartition1();
                return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().records().batches()).asScala()).size());
        Assert.assertEquals((String)"Given two partitions, with both throttled, we should get no messages", (long)0L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch2.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;

            public final boolean apply(Tuple2<TopicPartition, LogReadResult> x$5) {
                Object object = x$5._1();
                TopicPartition topicPartition = this.$outer.topicPartition2();
                return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().records().batches()).asScala()).size());
    }

    @Test
    public void shouldGetBothMessagesIfQuotasAllow() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch2 = this.replicaManager().readFromLocalLog(followerReplicaId, true, true, Integer.MAX_VALUE, false, this.fetchInfo(), quota, IsolationLevel.READ_UNCOMMITTED);
        Assert.assertEquals((String)"Given two partitions, with both non-throttled, we should get both messages", (long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch2.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;

            public final boolean apply(Tuple2<TopicPartition, LogReadResult> x$6) {
                Object object = x$6._1();
                TopicPartition topicPartition = this.$outer.topicPartition1();
                return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().records().batches()).asScala()).size());
        Assert.assertEquals((String)"Given two partitions, with both non-throttled, we should get both messages", (long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch2.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;

            public final boolean apply(Tuple2<TopicPartition, LogReadResult> x$7) {
                Object object = x$7._1();
                TopicPartition topicPartition = this.$outer.topicPartition2();
                return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().records().batches()).asScala()).size());
    }

    @Test
    public void shouldIncludeInSyncThrottledReplicas() {
        Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>> x$11 = this.fetchInfo();
        boolean x$12 = true;
        SimpleRecord x$13 = this.setUpMocks$default$2();
        this.setUpMocks(x$11, x$13, x$12);
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch2 = this.replicaManager().readFromLocalLog(followerReplicaId, true, true, Integer.MAX_VALUE, false, this.fetchInfo(), quota, IsolationLevel.READ_UNCOMMITTED);
        Assert.assertEquals((String)"Given two partitions, with only one throttled, we should get the first", (long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch2.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;

            public final boolean apply(Tuple2<TopicPartition, LogReadResult> x$8) {
                Object object = x$8._1();
                TopicPartition topicPartition = this.$outer.topicPartition1();
                return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().records().batches()).asScala()).size());
        Assert.assertEquals((String)"But we should get the second too since it's throttled but in sync", (long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch2.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;

            public final boolean apply(Tuple2<TopicPartition, LogReadResult> x$9) {
                Object object = x$9._1();
                TopicPartition topicPartition = this.$outer.topicPartition2();
                return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().records().batches()).asScala()).size());
    }

    @Test
    public void testCompleteInDelayedFetchWithReplicaThrottling() {
        Assert.assertTrue((String)"In sync replica should complete", (boolean)this.setupDelayedFetch$1(true).tryComplete());
        Assert.assertFalse((String)"Out of sync replica should not complete", (boolean)this.setupDelayedFetch$1(false).tryComplete());
    }

    public void setUpMocks(Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>> fetchInfo, SimpleRecord record, boolean bothReplicasInSync) {
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createMock(KafkaZkClient.class);
        KafkaScheduler scheduler = (KafkaScheduler)EasyMock.createNiceMock(KafkaScheduler.class);
        Log log2 = (Log)EasyMock.createNiceMock(Log.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log2.logStartOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)0L)).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log2.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)20L)).anyTimes();
        EasyMock.expect((Object)log2.logEndOffsetMetadata()).andReturn((Object)new LogOffsetMetadata(20L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)log2.read(BoxesRunTime.unboxToLong((Object)EasyMock.anyObject()), EasyMock.geq((int)1), (Option)EasyMock.anyObject(), BoxesRunTime.unboxToBoolean((Object)EasyMock.anyObject()), (IsolationLevel)EasyMock.eq((Object)IsolationLevel.READ_UNCOMMITTED))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{record}), FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4())).anyTimes();
        EasyMock.expect((Object)log2.read(BoxesRunTime.unboxToLong((Object)EasyMock.anyObject()), EasyMock.eq((int)0), (Option)EasyMock.anyObject(), BoxesRunTime.unboxToBoolean((Object)EasyMock.anyObject()), (IsolationLevel)EasyMock.eq((Object)IsolationLevel.READ_UNCOMMITTED))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4())).anyTimes();
        EasyMock.replay((Object[])new Object[]{log2});
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)logManager.getLog((TopicPartition)EasyMock.anyObject(), EasyMock.anyBoolean())).andReturn((Object)new Some((Object)log2)).anyTimes();
        EasyMock.expect((Object)logManager.liveLogDirs()).andReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)))).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        this.replicaManager_$eq(new ReplicaManager((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), zkClient, (Scheduler)scheduler, logManager, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(((KafkaConfig)this.configs().head()).brokerId()), new LogDirFailureChannel(((KafkaConfig)this.configs().head()).logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12()));
        fetchInfo.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicPartition, FetchRequest.PartitionData> check$ifrefutable$1) {
                Tuple2<TopicPartition, FetchRequest.PartitionData> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, bothReplicasInSync, log2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;
            private final boolean bothReplicasInSync$1;
            private final Log log$1;

            public final void apply(Tuple2<TopicPartition, FetchRequest.PartitionData> x$10) {
                Tuple2<TopicPartition, FetchRequest.PartitionData> tuple2 = x$10;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    TopicPartition p = (TopicPartition)tuple2._1();
                    Partition partition = this.$outer.replicaManager().getOrCreatePartition(p);
                    Replica leaderReplica = new Replica(((KafkaConfig)this.$outer.configs().head()).brokerId(), p, (Time)this.$outer.time(), 0L, (Option)new Some((Object)this.log$1));
                    leaderReplica.highWatermark_$eq(new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
                    partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)leaderReplica.brokerId())));
                    Replica followerReplica = new Replica(((KafkaConfig)this.$outer.configs().last()).brokerId(), p, (Time)this.$outer.time(), 0L, (Option)new Some((Object)this.log$1));
                    Set allReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Replica[]{leaderReplica, followerReplica}));
                    allReplicas.foreach((Function1)new Serializable(this, partition){
                        public static final long serialVersionUID = 0L;
                        private final Partition partition$1;

                        public final Replica apply(Replica replica) {
                            return this.partition$1.addReplicaIfNotExists(replica);
                        }
                        {
                            this.partition$1 = partition$1;
                        }
                    });
                    if (this.bothReplicasInSync$1) {
                        partition.inSyncReplicas_$eq(allReplicas);
                        followerReplica.highWatermark_$eq(new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        partition.inSyncReplicas_$eq((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Replica[]{leaderReplica})));
                        followerReplica.highWatermark_$eq(new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bothReplicasInSync$1 = bothReplicasInSync$1;
                this.log$1 = log$1;
            }
        });
    }

    public SimpleRecord setUpMocks$default$2() {
        return this.record();
    }

    public boolean setUpMocks$default$3() {
        return false;
    }

    @After
    public void tearDown() {
        if (this.replicaManager() != null) {
            this.replicaManager().shutdown(false);
        }
        this.metrics().close();
    }

    /*
     * WARNING - void declaration
     */
    public ReplicaQuota mockQuota(long bound) {
        void var3_2;
        ReplicaQuota quota = (ReplicaQuota)EasyMock.createMock(ReplicaQuota.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isThrottled((TopicPartition)EasyMock.anyObject()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
        return var3_2;
    }

    private final DelayedFetch setupDelayedFetch$1(boolean isReplicaInSync) {
        LogOffsetMetadata logOffsetMetadata = new LogOffsetMetadata(100L, 0L, 500);
        Replica replica = (Replica)EasyMock.createMock(Replica.class);
        EasyMock.expect((Object)replica.logEndOffset()).andReturn((Object)logOffsetMetadata).anyTimes();
        EasyMock.replay((Object[])new Object[]{replica});
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        EasyMock.expect((Object)replicaManager.getLeaderReplicaIfLocal((TopicPartition)EasyMock.anyObject())).andReturn((Object)replica).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.shouldLeaderThrottle((ReplicaQuota)EasyMock.anyObject(), (TopicPartition)EasyMock.anyObject(), BoxesRunTime.unboxToInt((Object)EasyMock.anyObject())))).andReturn((Object)BoxesRunTime.boxToBoolean((!isReplicaInSync ? 1 : 0) != 0)).anyTimes();
        EasyMock.replay((Object[])new Object[]{replicaManager});
        TopicPartition tp = new TopicPartition("t1", 0);
        FetchPartitionStatus fetchParititonStatus = new FetchPartitionStatus(new LogOffsetMetadata(50L, 0L, 250), new FetchRequest.PartitionData(50L, 0L, 1));
        FetchMetadata fetchMetadata = new FetchMetadata(1, 1000, true, true, false, true, 1, (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp, (Object)fetchParititonStatus)})));
        return new DelayedFetch(this, replicaManager, fetchMetadata){

            public boolean forceComplete() {
                return true;
            }
        };
    }
}

