/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;
import kafka.tools.ConsumerPerformance;
import kafka.utils.ToolsUtils$;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

public final class ConsumerPerformance$
implements LazyLogging {
    public static final ConsumerPerformance$ MODULE$;
    private final transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new ConsumerPerformance$();
    }

    private Logger logger$lzycompute() {
        ConsumerPerformance$ consumerPerformance$ = this;
        synchronized (consumerPerformance$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$trans$0 ? this.logger : this.logger$lzycompute();
    }

    public void main(String[] args) {
        BoxedUnit boxedUnit;
        ConsumerPerformance.ConsumerPerfConfig config = new ConsumerPerformance.ConsumerPerfConfig(args);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Starting consumer...");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        AtomicLong totalMessagesRead = new AtomicLong(0L);
        AtomicLong totalBytesRead = new AtomicLong(0L);
        Map metrics = null;
        AtomicLong joinGroupTimeInMs = new AtomicLong(0L);
        if (!config.hideHeader()) {
            this.printHeader(config.showDetailedStats());
        }
        long startMs = 0L;
        long endMs = 0L;
        KafkaConsumer consumer = new KafkaConsumer(config.props());
        consumer.subscribe(Collections.singletonList(config.topic()));
        startMs = System.currentTimeMillis();
        this.consume((KafkaConsumer<byte[], byte[]>)consumer, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{config.topic()})), config.numMessages(), config.recordFetchTimeoutMs(), config, totalMessagesRead, totalBytesRead, joinGroupTimeInMs, startMs);
        endMs = System.currentTimeMillis();
        if (config.printMetrics()) {
            metrics = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(consumer.metrics()).asScala();
        }
        consumer.close();
        double elapsedSecs = (double)(endMs - startMs) / 1000.0;
        long fetchTimeInMs = endMs - startMs - joinGroupTimeInMs.get();
        if (!config.showDetailedStats()) {
            double totalMBRead = (double)totalBytesRead.get() * 1.0 / (double)0x100000;
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("%s, %s, %.4f, %.4f, %d, %.4f, %d, %d, %.4f, %.4f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config.dateFormat().format(BoxesRunTime.boxToLong((long)startMs)), config.dateFormat().format(BoxesRunTime.boxToLong((long)endMs)), BoxesRunTime.boxToDouble((double)totalMBRead), BoxesRunTime.boxToDouble((double)(totalMBRead / elapsedSecs)), BoxesRunTime.boxToLong((long)totalMessagesRead.get()), BoxesRunTime.boxToDouble((double)((double)totalMessagesRead.get() / elapsedSecs)), BoxesRunTime.boxToLong((long)joinGroupTimeInMs.get()), BoxesRunTime.boxToLong((long)fetchTimeInMs), BoxesRunTime.boxToDouble((double)(totalMBRead / ((double)fetchTimeInMs / 1000.0))), BoxesRunTime.boxToDouble((double)((double)totalMessagesRead.get() / ((double)fetchTimeInMs / 1000.0)))})));
        }
        if (metrics != null) {
            ToolsUtils$.MODULE$.printMetrics((Map<MetricName, ? extends Metric>)metrics);
        }
    }

    public void printHeader(boolean showDetailedStats) {
        String newFieldsInHeader = ", rebalance.time.ms, fetch.time.ms, fetch.MB.sec, fetch.nMsg.sec";
        if (showDetailedStats) {
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"time, threadId, data.consumed.in.MB, MB.sec, data.consumed.in.nMsg, nMsg.sec").append((Object)newFieldsInHeader).toString());
        } else {
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"start.time, end.time, data.consumed.in.MB, MB.sec, data.consumed.in.nMsg, nMsg.sec").append((Object)newFieldsInHeader).toString());
        }
    }

    public void consume(KafkaConsumer<byte[], byte[]> consumer, List<String> topics, long count, long timeout, ConsumerPerformance.ConsumerPerfConfig config, AtomicLong totalMessagesRead, AtomicLong totalBytesRead, AtomicLong joinTime, long testStartTime) {
        LongRef bytesRead = LongRef.create((long)0L);
        LongRef messagesRead = LongRef.create((long)0L);
        LongRef lastBytesRead = LongRef.create((long)0L);
        LongRef lastMessagesRead = LongRef.create((long)0L);
        LongRef joinStart = LongRef.create((long)0L);
        LongRef joinTimeMsInSingleRound = LongRef.create((long)0L);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava(), new ConsumerRebalanceListener(joinTime, joinStart, joinTimeMsInSingleRound){
            private final AtomicLong joinTime$1;
            private final LongRef joinStart$1;
            private final LongRef joinTimeMsInSingleRound$1;

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.joinTime$1.addAndGet(System.currentTimeMillis() - this.joinStart$1.elem);
                this.joinTimeMsInSingleRound$1.elem += System.currentTimeMillis() - this.joinStart$1.elem;
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                this.joinStart$1.elem = System.currentTimeMillis();
            }
            {
                this.joinTime$1 = joinTime$1;
                this.joinStart$1 = joinStart$1;
                this.joinTimeMsInSingleRound$1 = joinTimeMsInSingleRound$1;
            }
        });
        long startMs = System.currentTimeMillis();
        LongRef lastReportTime = LongRef.create((long)startMs);
        long lastConsumedTime = System.currentTimeMillis();
        LongRef currentTimeMillis = LongRef.create((long)lastConsumedTime);
        while (messagesRead.elem < count && currentTimeMillis.elem - lastConsumedTime <= timeout) {
            Iterable records = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)consumer.poll(100L)).asScala();
            currentTimeMillis.elem = System.currentTimeMillis();
            if (records.nonEmpty()) {
                lastConsumedTime = currentTimeMillis.elem;
            }
            records.foreach((Function1)new Serializable(config, bytesRead, messagesRead, lastBytesRead, lastMessagesRead, joinTimeMsInSingleRound, lastReportTime, currentTimeMillis){
                public static final long serialVersionUID = 0L;
                private final ConsumerPerformance.ConsumerPerfConfig config$1;
                private final LongRef bytesRead$1;
                private final LongRef messagesRead$1;
                private final LongRef lastBytesRead$1;
                private final LongRef lastMessagesRead$1;
                private final LongRef joinTimeMsInSingleRound$1;
                private final LongRef lastReportTime$1;
                private final LongRef currentTimeMillis$1;

                public final void apply(ConsumerRecord<byte[], byte[]> record2) {
                    ++this.messagesRead$1.elem;
                    if (record2.key() != null) {
                        this.bytesRead$1.elem += (long)Predef$.MODULE$.byteArrayOps((byte[])record2.key()).size();
                    }
                    if (record2.value() != null) {
                        this.bytesRead$1.elem += (long)Predef$.MODULE$.byteArrayOps((byte[])record2.value()).size();
                    }
                    if (this.currentTimeMillis$1.elem - this.lastReportTime$1.elem >= (long)this.config$1.reportingInterval()) {
                        if (this.config$1.showDetailedStats()) {
                            ConsumerPerformance$.MODULE$.printConsumerProgress(0, this.bytesRead$1.elem, this.lastBytesRead$1.elem, this.messagesRead$1.elem, this.lastMessagesRead$1.elem, this.lastReportTime$1.elem, this.currentTimeMillis$1.elem, this.config$1.dateFormat(), this.joinTimeMsInSingleRound$1.elem);
                        }
                        this.joinTimeMsInSingleRound$1.elem = 0L;
                        this.lastReportTime$1.elem = this.currentTimeMillis$1.elem;
                        this.lastMessagesRead$1.elem = this.messagesRead$1.elem;
                        this.lastBytesRead$1.elem = this.bytesRead$1.elem;
                    }
                }
                {
                    this.config$1 = config$1;
                    this.bytesRead$1 = bytesRead$1;
                    this.messagesRead$1 = messagesRead$1;
                    this.lastBytesRead$1 = lastBytesRead$1;
                    this.lastMessagesRead$1 = lastMessagesRead$1;
                    this.joinTimeMsInSingleRound$1 = joinTimeMsInSingleRound$1;
                    this.lastReportTime$1 = lastReportTime$1;
                    this.currentTimeMillis$1 = currentTimeMillis$1;
                }
            });
        }
        if (messagesRead.elem < count) {
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WARNING: Exiting before consuming the expected number of messages: timeout (", " ms) exceeded. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)timeout)}))).append((Object)"You can use the --timeout option to increase the timeout.").toString());
        }
        totalMessagesRead.set(messagesRead.elem);
        totalBytesRead.set(bytesRead.elem);
    }

    public void printConsumerProgress(int id, long bytesRead, long lastBytesRead, long messagesRead, long lastMessagesRead, long startMs, long endMs, SimpleDateFormat dateFormat, long periodicJoinTimeInMs) {
        this.printBasicProgress(id, bytesRead, lastBytesRead, messagesRead, lastMessagesRead, startMs, endMs, dateFormat);
        this.printExtendedProgress(bytesRead, lastBytesRead, messagesRead, lastMessagesRead, startMs, endMs, periodicJoinTimeInMs);
        Predef$.MODULE$.println();
    }

    private void printBasicProgress(int id, long bytesRead, long lastBytesRead, long messagesRead, long lastMessagesRead, long startMs, long endMs, SimpleDateFormat dateFormat) {
        double elapsedMs = endMs - startMs;
        double totalMbRead = (double)bytesRead * 1.0 / (double)0x100000;
        double intervalMbRead = (double)(bytesRead - lastBytesRead) * 1.0 / (double)0x100000;
        double intervalMbPerSec = 1000.0 * intervalMbRead / elapsedMs;
        double intervalMessagesPerSec = (double)(messagesRead - lastMessagesRead) / elapsedMs * 1000.0;
        Predef$.MODULE$.print((Object)new StringOps(Predef$.MODULE$.augmentString("%s, %d, %.4f, %.4f, %d, %.4f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dateFormat.format(BoxesRunTime.boxToLong((long)endMs)), BoxesRunTime.boxToInteger((int)id), BoxesRunTime.boxToDouble((double)totalMbRead), BoxesRunTime.boxToDouble((double)intervalMbPerSec), BoxesRunTime.boxToLong((long)messagesRead), BoxesRunTime.boxToDouble((double)intervalMessagesPerSec)})));
    }

    private void printExtendedProgress(long bytesRead, long lastBytesRead, long messagesRead, long lastMessagesRead, long startMs, long endMs, long periodicJoinTimeInMs) {
        Tuple2.mcDD.sp sp2;
        long fetchTimeMs = endMs - startMs - periodicJoinTimeInMs;
        double intervalMbRead = (double)(bytesRead - lastBytesRead) * 1.0 / (double)0x100000;
        long intervalMessagesRead = messagesRead - lastMessagesRead;
        Tuple2.mcDD.sp sp3 = sp2 = fetchTimeMs <= 0L ? new Tuple2.mcDD.sp(0.0, 0.0) : new Tuple2.mcDD.sp(1000.0 * intervalMbRead / (double)fetchTimeMs, 1000.0 * (double)intervalMessagesRead / (double)fetchTimeMs);
        if (sp2 != null) {
            Tuple2.mcDD.sp sp4;
            double intervalMbPerSec = sp2._1$mcD$sp();
            double intervalMessagesPerSec = sp2._2$mcD$sp();
            Tuple2.mcDD.sp sp5 = sp4 = new Tuple2.mcDD.sp(intervalMbPerSec, intervalMessagesPerSec);
            double intervalMbPerSec2 = sp5._1$mcD$sp();
            double intervalMessagesPerSec2 = sp5._2$mcD$sp();
            Predef$.MODULE$.print((Object)new StringOps(Predef$.MODULE$.augmentString(", %d, %d, %.4f, %.4f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)periodicJoinTimeInMs), BoxesRunTime.boxToLong((long)fetchTimeMs), BoxesRunTime.boxToDouble((double)intervalMbPerSec2), BoxesRunTime.boxToDouble((double)intervalMessagesPerSec2)})));
            return;
        }
        throw new MatchError((Object)sp2);
    }

    private ConsumerPerformance$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

