/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.AbortedTxn;
import kafka.log.CompletedTxn;
import kafka.log.LazyOffsetIndex;
import kafka.log.LazyTimeIndex;
import kafka.log.LogConfig;
import kafka.log.LogFlushStats$;
import kafka.log.LogSegment$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetPosition;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateManager;
import kafka.log.RollParams;
import kafka.log.TimeIndex;
import kafka.log.TimestampOffset;
import kafka.log.TransactionIndex;
import kafka.log.TxnIndexSearchResult;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.LogOffsetMetadata;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.BufferSupplier;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0011}a\u0001B-[\u0001}C\u0001b\u0017\u0001\u0003\u0006\u0004%\t\u0001\u001c\u0005\tu\u0002\u0011\t\u0011)A\u0005[\"A1\u0010\u0001BC\u0002\u0013\u0005A\u0010C\u0005\u0002\u0004\u0001\u0011\t\u0011)A\u0005{\"Q\u0011Q\u0001\u0001\u0003\u0006\u0004%\t!a\u0002\t\u0015\u0005=\u0001A!A!\u0002\u0013\tI\u0001\u0003\u0006\u0002\u0012\u0001\u0011)\u0019!C\u0001\u0003'A!\"a\u0007\u0001\u0005\u0003\u0005\u000b\u0011BA\u000b\u0011)\ti\u0002\u0001BC\u0002\u0013\u0005\u0011q\u0004\u0005\u000b\u0003O\u0001!\u0011!Q\u0001\n\u0005\u0005\u0002BCA\u0015\u0001\t\u0015\r\u0011\"\u0001\u0002,!Q\u00111\u0007\u0001\u0003\u0002\u0003\u0006I!!\f\t\u0015\u0005U\u0002A!b\u0001\n\u0003\ty\u0002\u0003\u0006\u00028\u0001\u0011\t\u0011)A\u0005\u0003CA!\"!\u000f\u0001\u0005\u000b\u0007I\u0011AA\u001e\u0011)\t9\u0005\u0001B\u0001B\u0003%\u0011Q\b\u0005\t\u0003\u0013\u0002A\u0011\u0001.\u0002L!9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0004bBA5\u0001\u0011\u0005\u00111\u000e\u0005\b\u0003g\u0002A\u0011AA;\u0011\u001d\t9\t\u0001C\u0001\u0003\u0013Cq!!&\u0001\t\u0003\t9\nC\u0005\u0002\u001e\u0002\u0001\r\u0011\"\u0003\u0002 !I\u0011q\u0014\u0001A\u0002\u0013%\u0011\u0011\u0015\u0005\t\u0003O\u0003\u0001\u0015)\u0003\u0002\"!I\u0011\u0011\u0016\u0001A\u0002\u0013%\u00111\u0006\u0005\n\u0003W\u0003\u0001\u0019!C\u0005\u0003[C\u0001\"!-\u0001A\u0003&\u0011Q\u0006\u0005\n\u0003g\u0003\u0001\u0019!C\u0005\u0003kC\u0011\"!0\u0001\u0001\u0004%I!a0\t\u0011\u0005\r\u0007\u0001)Q\u0005\u0003oC\u0011\"!4\u0001\u0001\u0004%I!!.\t\u0013\u0005=\u0007\u00011A\u0005\n\u0005E\u0007\u0002CAk\u0001\u0001\u0006K!a.\t\u000f\u0005e\u0007\u0001\"\u0001\u0002\\\"9\u0011\u0011\u001d\u0001\u0005\u0002\u0005}\u0001\"CAr\u0001\u0001\u0007I\u0011BA[\u0011%\t)\u000f\u0001a\u0001\n\u0013\t9\u000f\u0003\u0005\u0002l\u0002\u0001\u000b\u0015BA\\\u0011\u001d\ty\u000f\u0001C\u0001\u0003cDq!a>\u0001\t\u0003\ty\u0002C\u0004\u0002\u0014\u0002!\t!a\u000b\t\u000f\u0005e\b\u0001\"\u0001\u0002|\"9\u0011q \u0001\u0005\u0002\t\u0005\u0001b\u0002B\u0011\u0001\u0011%!1\u0005\u0005\b\u0005O\u0001A\u0011\u0002B\u0015\u0011\u001d\u0011Y\u0004\u0001C\u0001\u0005{AqA!\u0012\u0001\t\u0003\u00119\u0005C\u0004\u0003Z\u0001!IAa\u0017\t\u0011\tE\u0004\u0001\"\u0001[\u0005gB!Ba+\u0001#\u0003%\tA\u0017BW\u0011\u001d\u0011\u0019\r\u0001C\u0001\u0005\u000bD\u0011B!;\u0001#\u0003%\tAa;\t\u0013\t=\b!%A\u0005\u0002\tE\bb\u0002B{\u0001\u0011\u0005!q\u001f\u0005\b\u0007\u000f\u0001A\u0011AB\u0005\u0011%\u0019\t\u0003AI\u0001\n\u0003\u0019\u0019\u0003C\u0004\u0004(\u0001!Ia!\u000b\t\u000f\r-\u0002\u0001\"\u0001\u0004.!91q\u0006\u0001\u0005\u0002\rE\u0002bBB!\u0001\u0011\u000531\t\u0005\b\u0007+\u0002A\u0011AB,\u0011\u001d\u0019i\u0006\u0001C\u0001\u0003?Aqa!\u0019\u0001\t\u0003\u0019I\u0003C\u0004\u0004f\u0001!\taa\u001a\t\u000f\re\u0004\u0001\"\u0001\u0004|!911\u0013\u0001\u0005\u0002\r%\u0002bBBK\u0001\u0011%1\u0011\u0006\u0005\b\u0007/\u0003A\u0011ABM\u0011\u001d\u0019\u0019\u000b\u0001C\u0001\u0007KCqaa*\u0001\t\u0003\u0019I\u000bC\u0005\u0004:\u0002\t\n\u0011\"\u0001\u0003l\"911\u0018\u0001\u0005\u0002\r%\u0002bBB_\u0001\u0011\u00051\u0011\u0006\u0005\b\u0007\u007f\u0003A\u0011AB\u0015\u0011\u001d\u0019\t\r\u0001C\u0001\u0003?AqA!\u0003\u0001\t\u0003\ty\u0002C\u0004\u0004D\u0002!\ta!2\b\u000f\ru'\f#\u0001\u0004`\u001a1\u0011L\u0017E\u0001\u0007CDq!!\u0013Q\t\u0003\u0019\u0019\u000fC\u0004\u0004fB#\taa:\t\u0013\u0011%\u0001+%A\u0005\u0002\tE\b\"\u0003C\u0006!F\u0005I\u0011\u0001BW\u0011%!i\u0001UI\u0001\n\u0003\u0011\t\u0010C\u0005\u0005\u0010A\u000b\n\u0011\"\u0001\u0005\u0012!91q\u0018)\u0005\u0002\u0011U\u0001\"\u0003C\u000f!F\u0005I\u0011\u0001C\t\u0005)aunZ*fO6,g\u000e\u001e\u0006\u00037r\u000b1\u0001\\8h\u0015\u0005i\u0016!B6bM.\f7\u0001A\n\u0004\u0001\u00014\u0007CA1e\u001b\u0005\u0011'\"A2\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0014'AB!osJ+g\r\u0005\u0002hU6\t\u0001N\u0003\u0002j9\u0006)Q\u000f^5mg&\u00111\u000e\u001b\u0002\b\u0019><w-\u001b8h+\u0005i\u0007C\u00018y\u001b\u0005y'B\u00019r\u0003\u0019\u0011XmY8sI*\u0011!o]\u0001\u0007G>lWn\u001c8\u000b\u0005u#(BA;w\u0003\u0019\t\u0007/Y2iK*\tq/A\u0002pe\u001eL!!_8\u0003\u0017\u0019KG.\u001a*fG>\u0014Hm]\u0001\u0005Y><\u0007%A\bmCjLxJ\u001a4tKRLe\u000eZ3y+\u0005i\bC\u0001@\u0000\u001b\u0005Q\u0016bAA\u00015\nyA*\u0019>z\u001f\u001a47/\u001a;J]\u0012,\u00070\u0001\tmCjLxJ\u001a4tKRLe\u000eZ3yA\u0005iA.\u0019>z)&lW-\u00138eKb,\"!!\u0003\u0011\u0007y\fY!C\u0002\u0002\u000ei\u0013Q\u0002T1{sRKW.Z%oI\u0016D\u0018A\u00047buf$\u0016.\\3J]\u0012,\u0007\u0010I\u0001\tibt\u0017J\u001c3fqV\u0011\u0011Q\u0003\t\u0004}\u0006]\u0011bAA\r5\n\u0001BK]1og\u0006\u001cG/[8o\u0013:$W\r_\u0001\nibt\u0017J\u001c3fq\u0002\n!BY1tK>3gm]3u+\t\t\t\u0003E\u0002b\u0003GI1!!\nc\u0005\u0011auN\\4\u0002\u0017\t\f7/Z(gMN,G\u000fI\u0001\u0013S:$W\r_%oi\u0016\u0014h/\u00197CsR,7/\u0006\u0002\u0002.A\u0019\u0011-a\f\n\u0007\u0005E\"MA\u0002J]R\f1#\u001b8eKbLe\u000e^3sm\u0006d')\u001f;fg\u0002\nAB]8mY*KG\u000f^3s\u001bN\fQB]8mY*KG\u000f^3s\u001bN\u0004\u0013\u0001\u0002;j[\u0016,\"!!\u0010\u0011\t\u0005}\u00121I\u0007\u0003\u0003\u0003R!![9\n\t\u0005\u0015\u0013\u0011\t\u0002\u0005)&lW-A\u0003uS6,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0013\u0003\u001b\ny%!\u0015\u0002T\u0005U\u0013qKA-\u00037\ni\u0006\u0005\u0002\u007f\u0001!)1,\u0005a\u0001[\")10\u0005a\u0001{\"9\u0011QA\tA\u0002\u0005%\u0001bBA\t#\u0001\u0007\u0011Q\u0003\u0005\b\u0003;\t\u0002\u0019AA\u0011\u0011\u001d\tI#\u0005a\u0001\u0003[Aq!!\u000e\u0012\u0001\u0004\t\t\u0003C\u0004\u0002:E\u0001\r!!\u0010\u0002\u0017=4gm]3u\u0013:$W\r_\u000b\u0003\u0003G\u00022A`A3\u0013\r\t9G\u0017\u0002\f\u001f\u001a47/\u001a;J]\u0012,\u00070A\u0005uS6,\u0017J\u001c3fqV\u0011\u0011Q\u000e\t\u0004}\u0006=\u0014bAA95\nIA+[7f\u0013:$W\r_\u0001\u000bg\"|W\u000f\u001c3S_2dG\u0003BA<\u0003{\u00022!YA=\u0013\r\tYH\u0019\u0002\b\u0005>|G.Z1o\u0011\u001d\ty\b\u0006a\u0001\u0003\u0003\u000b!B]8mYB\u000b'/Y7t!\rq\u00181Q\u0005\u0004\u0003\u000bS&A\u0003*pY2\u0004\u0016M]1ng\u0006i!/Z:ju\u0016Le\u000eZ3yKN$B!a#\u0002\u0012B\u0019\u0011-!$\n\u0007\u0005=%M\u0001\u0003V]&$\bbBAJ+\u0001\u0007\u0011QF\u0001\u0005g&TX-A\u0006tC:LG/_\"iK\u000e\\G\u0003BAF\u00033Cq!a'\u0017\u0001\u0004\t9(A\ruS6,\u0017J\u001c3fq\u001aKG.\u001a(fo2L8I]3bi\u0016$\u0017aB2sK\u0006$X\rZ\u0001\fGJ,\u0017\r^3e?\u0012*\u0017\u000f\u0006\u0003\u0002\f\u0006\r\u0006\"CAS1\u0005\u0005\t\u0019AA\u0011\u0003\rAH%M\u0001\tGJ,\u0017\r^3eA\u0005A\"-\u001f;fgNKgnY3MCN$\u0018J\u001c3fq\u0016sGO]=\u00029\tLH/Z:TS:\u001cW\rT1ti&sG-\u001a=F]R\u0014\u0018p\u0018\u0013fcR!\u00111RAX\u0011%\t)kGA\u0001\u0002\u0004\ti#A\rcsR,7oU5oG\u0016d\u0015m\u001d;J]\u0012,\u00070\u00128uef\u0004\u0013!\u0006:pY2Lgn\u001a\"bg\u0016$G+[7fgR\fW\u000e]\u000b\u0003\u0003o\u0003R!YA]\u0003CI1!a/c\u0005\u0019y\u0005\u000f^5p]\u0006I\"o\u001c7mS:<')Y:fIRKW.Z:uC6\u0004x\fJ3r)\u0011\tY)!1\t\u0013\u0005\u0015f$!AA\u0002\u0005]\u0016A\u0006:pY2Lgn\u001a\"bg\u0016$G+[7fgR\fW\u000e\u001d\u0011)\u0007}\t9\rE\u0002b\u0003\u0013L1!a3c\u0005!1x\u000e\\1uS2,\u0017AE0nCb$\u0016.\\3ti\u0006l\u0007oU8GCJ\facX7bqRKW.Z:uC6\u00048k\u001c$be~#S-\u001d\u000b\u0005\u0003\u0017\u000b\u0019\u000eC\u0005\u0002&\u0006\n\t\u00111\u0001\u00028\u0006\u0019r,\\1y)&lWm\u001d;b[B\u001cvNR1sA!\u001a!%a2\u0002+5\f\u0007\u0010V5nKN$\u0018-\u001c9T_\u001a\u000b'o\u0018\u0013fcR!\u00111RAo\u0011\u001d\tyn\ta\u0001\u0003C\t\u0011\u0002^5nKN$\u0018-\u001c9\u0002#5\f\u0007\u0010V5nKN$\u0018-\u001c9T_\u001a\u000b'/\u0001\u000e`_\u001a47/\u001a;PM6\u000b\u0007\u0010V5nKN$\u0018-\u001c9T_\u001a\u000b'/\u0001\u0010`_\u001a47/\u001a;PM6\u000b\u0007\u0010V5nKN$\u0018-\u001c9T_\u001a\u000b'o\u0018\u0013fcR!\u00111RAu\u0011%\t)KJA\u0001\u0002\u0004\t9,A\u000e`_\u001a47/\u001a;PM6\u000b\u0007\u0010V5nKN$\u0018-\u001c9T_\u001a\u000b'\u000f\t\u0015\u0004O\u0005\u001d\u0017!H8gMN,Go\u00144NCb$\u0016.\\3ti\u0006l\u0007oU8GCJ|F%Z9\u0015\t\u0005-\u00151\u001f\u0005\b\u0003kD\u0003\u0019AA\u0011\u0003\u0019ygMZ:fi\u0006IrN\u001a4tKR|e-T1y)&lWm\u001d;b[B\u001cvNR1s\u0003i\u0019\u0017M\\\"p]Z,'\u000f\u001e+p%\u0016d\u0017\r^5wK>3gm]3u)\u0011\t9(!@\t\u000f\u0005U8\u00061\u0001\u0002\"\u00051\u0011\r\u001d9f]\u0012$\"\"a#\u0003\u0004\t\u001d!1\u0002B\b\u0011\u001d\u0011)\u0001\fa\u0001\u0003C\tQ\u0002\\1sO\u0016\u001cHo\u00144gg\u0016$\bb\u0002B\u0005Y\u0001\u0007\u0011\u0011E\u0001\u0011Y\u0006\u0014x-Z:u)&lWm\u001d;b[BDqA!\u0004-\u0001\u0004\t\t#A\u000etQ\u0006dGn\\<PM\u001a\u001cX\r^(g\u001b\u0006DH+[7fgR\fW\u000e\u001d\u0005\b\u0005#a\u0003\u0019\u0001B\n\u0003\u001d\u0011XmY8sIN\u00042A\u001cB\u000b\u0013\r\u00119b\u001c\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:)\u00071\u0012Y\u0002E\u0002h\u0005;I1Aa\bi\u00055qwN\u001c;ie\u0016\fGm]1gK\u0006\u0019RM\\:ve\u0016|eMZ:fi&s'+\u00198hKR!\u00111\u0012B\u0013\u0011\u001d\t)0\fa\u0001\u0003C\t1#\u00199qK:$7\t[;oW\u001a\u0013x.\u001c$jY\u0016$\u0002\"!\f\u0003,\t5\"\u0011\u0007\u0005\u0007\u0005#q\u0003\u0019A7\t\u000f\t=b\u00061\u0001\u0002.\u0005A\u0001o\\:ji&|g\u000eC\u0004\u000349\u0002\rA!\u000e\u0002\u001d\t,hMZ3s'V\u0004\b\u000f\\5feB\u0019aNa\u000e\n\u0007\terN\u0001\bCk\u001a4WM]*vaBd\u0017.\u001a:\u0002\u001d\u0005\u0004\b/\u001a8e\rJ|WNR5mKR1\u0011Q\u0006B \u0005\u0003BaA!\u00050\u0001\u0004i\u0007b\u0002B\"_\u0001\u0007\u0011QF\u0001\u0006gR\f'\u000f^\u0001\u000fkB$\u0017\r^3Uq:Le\u000eZ3y)\u0019\tYI!\u0013\u0003T!9!1\n\u0019A\u0002\t5\u0013\u0001D2p[BdW\r^3e)bt\u0007c\u0001@\u0003P%\u0019!\u0011\u000b.\u0003\u0019\r{W\u000e\u001d7fi\u0016$G\u000b\u001f8\t\u000f\tU\u0003\u00071\u0001\u0002\"\u0005\u0001B.Y:u'R\f'\r\\3PM\u001a\u001cX\r\u001e\u0015\u0004a\tm\u0011aE;qI\u0006$X\r\u0015:pIV\u001cWM]*uCR,GCBAF\u0005;\u00129\u0007C\u0004\u0003`E\u0002\rA!\u0019\u0002)A\u0014x\u000eZ;dKJ\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s!\rq(1M\u0005\u0004\u0005KR&\u0001\u0006)s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'\u000fC\u0004\u0003jE\u0002\rAa\u001b\u0002\u000b\t\fGo\u00195\u0011\u00079\u0014i'C\u0002\u0003p=\u00141BU3d_J$')\u0019;dQ\u0006yAO]1og2\fG/Z(gMN,G\u000f\u0006\u0004\u0003v\tu%q\u0014\t\u0005\u0005o\u00129J\u0004\u0003\u0003z\tMe\u0002\u0002B>\u0005#sAA! \u0003\u0010:!!q\u0010BG\u001d\u0011\u0011\tIa#\u000f\t\t\r%\u0011R\u0007\u0003\u0005\u000bS1Aa\"_\u0003\u0019a$o\\8u}%\tq/\u0003\u0002vm&\u0011Q\f^\u0005\u0003eNL!\u0001]9\n\u0007\tUu.A\u0006GS2,'+Z2pe\u0012\u001c\u0018\u0002\u0002BM\u00057\u0013\u0011\u0003T8h\u001f\u001a47/\u001a;Q_NLG/[8o\u0015\r\u0011)j\u001c\u0005\b\u0003k\u0014\u0004\u0019AA\u0011\u0011%\u0011\tK\rI\u0001\u0002\u0004\ti#\u0001\u000bti\u0006\u0014H/\u001b8h\r&dW\rU8tSRLwN\u001c\u0015\u0004e\t\u0015\u0006cA4\u0003(&\u0019!\u0011\u00165\u0003\u0015QD'/Z1eg\u00064W-A\rue\u0006t7\u000f\\1uK>3gm]3uI\u0011,g-Y;mi\u0012\u0012TC\u0001BXU\u0011\tiC!-,\u0005\tM\u0006\u0003\u0002B[\u0005\u007fk!Aa.\u000b\t\te&1X\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!0c\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u0003\u00149LA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fAA]3bIRa!q\u0019Bj\u0005/\u0014YNa8\u0003dB!!\u0011\u001aBh\u001b\t\u0011YMC\u0002\u0003Nr\u000baa]3sm\u0016\u0014\u0018\u0002\u0002Bi\u0005\u0017\u0014QBR3uG\"$\u0015\r^1J]\u001a|\u0007b\u0002Bki\u0001\u0007\u0011\u0011E\u0001\fgR\f'\u000f^(gMN,G\u000fC\u0004\u0003ZR\u0002\r!a.\u0002\u00135\f\u0007p\u00144gg\u0016$\bb\u0002Boi\u0001\u0007\u0011QF\u0001\b[\u0006D8+\u001b>f\u0011%\u0011\t\u000f\u000eI\u0001\u0002\u0004\t\t#A\u0006nCb\u0004vn]5uS>t\u0007\"\u0003BsiA\u0005\t\u0019AA<\u00035i\u0017N\\(oK6+7o]1hK\"\u001aAG!*\u0002\u001dI,\u0017\r\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!Q\u001e\u0016\u0005\u0003C\u0011\t,\u0001\bsK\u0006$G\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\tM(\u0006BA<\u0005c\u000bQCZ3uG\",\u0006\u000f]3s\u0005>,h\u000eZ(gMN,G\u000f\u0006\u0004\u00028\ne81\u0001\u0005\b\u0005w<\u0004\u0019\u0001B\u007f\u0003M\u0019H/\u0019:u\u001f\u001a47/\u001a;Q_NLG/[8o!\rq(q`\u0005\u0004\u0007\u0003Q&AD(gMN,G\u000fU8tSRLwN\u001c\u0005\b\u0007\u000b9\u0004\u0019AA\u0017\u0003%1W\r^2i'&TX-A\u0004sK\u000e|g/\u001a:\u0015\r\u0005521BB\u0007\u0011\u001d\u0011y\u0006\u000fa\u0001\u0005CB\u0011ba\u00049!\u0003\u0005\ra!\u0005\u0002!1,\u0017\rZ3s\u000bB|7\r[\"bG\",\u0007#B1\u0002:\u000eM\u0001\u0003BB\u000b\u00077i!aa\u0006\u000b\t\re!1Z\u0001\u0006KB|7\r[\u0005\u0005\u0007;\u00199B\u0001\u000bMK\u0006$WM]#q_\u000eDg)\u001b7f\u0007\u0006\u001c\u0007.\u001a\u0015\u0004q\tm\u0011!\u0005:fG>4XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u00111Q\u0005\u0016\u0005\u0007#\u0011\t,\u0001\u000bm_\u0006$G*\u0019:hKN$H+[7fgR\fW\u000e\u001d\u000b\u0003\u0003\u0017\u000b1\u0002[1t\u001fZ,'O\u001a7poV\u0011\u0011qO\u0001\u0013G>dG.Z2u\u0003\n|'\u000f^3e)bt7\u000f\u0006\u0004\u00044\re2Q\b\t\u0004}\u000eU\u0012bAB\u001c5\n!B\u000b\u001f8J]\u0012,\u0007pU3be\u000eD'+Z:vYRDqaa\u000f=\u0001\u0004\t\t#A\u0006gKR\u001c\u0007n\u00144gg\u0016$\bbBB y\u0001\u0007\u0011\u0011E\u0001\u0011kB\u0004XM\u001d\"pk:$wJ\u001a4tKR\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0007\u000b\u0002Baa\u0012\u0004R5\u00111\u0011\n\u0006\u0005\u0007\u0017\u001ai%\u0001\u0003mC:<'BAB(\u0003\u0011Q\u0017M^1\n\t\rM3\u0011\n\u0002\u0007'R\u0014\u0018N\\4\u0002\u0015Q\u0014XO\\2bi\u0016$v\u000e\u0006\u0003\u0002.\re\u0003bBA{}\u0001\u0007\u0011\u0011\u0005\u0015\u0004}\tm\u0011A\u0004:fC\u0012tU\r\u001f;PM\u001a\u001cX\r\u001e\u0015\u0004\u007f\t\u0015\u0016!\u00024mkND\u0007f\u0001!\u0003&\u0006IQ\u000f\u001d3bi\u0016$\u0015N\u001d\u000b\u0005\u0003\u0017\u001bI\u0007C\u0004\u0004l\u0005\u0003\ra!\u001c\u0002\u0007\u0011L'\u000f\u0005\u0003\u0004p\rUTBAB9\u0015\u0011\u0019\u0019h!\u0014\u0002\u0005%|\u0017\u0002BB<\u0007c\u0012AAR5mK\u0006\u00112\r[1oO\u00164\u0015\u000e\\3Tk\u001a4\u0017\u000e_3t)\u0019\tYi! \u0004\u0010\"91q\u0010\"A\u0002\r\u0005\u0015!C8mIN+hMZ5y!\u0011\u0019\u0019ia#\u000f\t\r\u00155q\u0011\t\u0004\u0005\u0007\u0013\u0017bABEE\u00061\u0001K]3eK\u001aLAaa\u0015\u0004\u000e*\u00191\u0011\u00122\t\u000f\rE%\t1\u0001\u0004\u0002\u0006Ia.Z<Tk\u001a4\u0017\u000e_\u0001\u0018_:\u0014UmY8nK&s\u0017m\u0019;jm\u0016\u001cVmZ7f]R\fq\u0003\\8bI\u001aK'o\u001d;CCR\u001c\u0007\u000eV5nKN$\u0018-\u001c9\u0002#QLW.Z,bSR,GMR8s%>dG\u000e\u0006\u0004\u0002\"\rm5q\u0014\u0005\b\u0007;+\u0005\u0019AA\u0011\u0003\rqwn\u001e\u0005\b\u0007C+\u0005\u0019AA\u0011\u0003AiWm]:bO\u0016$\u0016.\\3ti\u0006l\u0007/\u0001\fhKR4\u0015N]:u\u0005\u0006$8\r\u001b+j[\u0016\u001cH/Y7q)\t\t\t#A\u000bgS:$wJ\u001a4tKR\u0014\u0015\u0010V5nKN$\u0018-\u001c9\u0015\r\r-61WB[!\u0015\t\u0017\u0011XBW!\u0011\u00119ha,\n\t\rE&1\u0014\u0002\u0013)&lWm\u001d;b[B\fe\u000eZ(gMN,G\u000fC\u0004\u0002`\u001e\u0003\r!!\t\t\u0013\r]v\t%AA\u0002\u0005\u0005\u0012AD:uCJ$\u0018N\\4PM\u001a\u001cX\r^\u0001 M&tGm\u00144gg\u0016$()\u001f+j[\u0016\u001cH/Y7qI\u0011,g-Y;mi\u0012\u0012\u0014!B2m_N,\u0017!D2m_N,\u0007*\u00198eY\u0016\u00148/\u0001\beK2,G/Z%g\u000bbL7\u000f^:\u0002\u00191\f7\u000f^'pI&4\u0017.\u001a3\u0002!1\f7\u000f^'pI&4\u0017.\u001a3`I\u0015\fH\u0003BBd\u0007/\u0004Ba!3\u0004T6\u001111\u001a\u0006\u0005\u0007\u001b\u001cy-\u0001\u0003gS2,'\u0002BBi\u0007\u001b\n1A\\5p\u0013\u0011\u0019)na3\u0003\tA\u000bG\u000f\u001b\u0005\b\u00073t\u0005\u0019AA\u0011\u0003\ti7\u000fK\u0002\u0001\u00057\t!\u0002T8h'\u0016<W.\u001a8u!\tq\bk\u0005\u0002QAR\u00111q\\\u0001\u0005_B,g\u000e\u0006\n\u0002N\r%81^Bw\u0007o\u001cIp!@\u0005\u0002\u0011\u0015\u0001bBB6%\u0002\u00071Q\u000e\u0005\b\u0003;\u0011\u0006\u0019AA\u0011\u0011\u001d\u0019yO\u0015a\u0001\u0007c\faaY8oM&<\u0007c\u0001@\u0004t&\u00191Q\u001f.\u0003\u00131{wmQ8oM&<\u0007bBA\u001d%\u0002\u0007\u0011Q\b\u0005\n\u0007w\u0014\u0006\u0013!a\u0001\u0003o\n\u0011CZ5mK\u0006c'/Z1es\u0016C\u0018n\u001d;t\u0011%\u0019yP\u0015I\u0001\u0002\u0004\ti#\u0001\u0007j]&$h)\u001b7f'&TX\rC\u0005\u0005\u0004I\u0003\n\u00111\u0001\u0002x\u0005Y\u0001O]3bY2|7-\u0019;f\u0011%!9A\u0015I\u0001\u0002\u0004\u0019\t)\u0001\u0006gS2,7+\u001e4gSb\fab\u001c9f]\u0012\"WMZ1vYR$S'\u0001\bpa\u0016tG\u0005Z3gCVdG\u000f\n\u001c\u0002\u001d=\u0004XM\u001c\u0013eK\u001a\fW\u000f\u001c;%o\u0005qq\u000e]3oI\u0011,g-Y;mi\u0012BTC\u0001C\nU\u0011\u0019\tI!-\u0015\u0011\u0005-Eq\u0003C\r\t7Aqaa\u001bX\u0001\u0004\u0019i\u0007C\u0004\u0002\u001e]\u0003\r!!\t\t\u0013\u0011\u001dq\u000b%AA\u0002\r\u0005\u0015\u0001\u00073fY\u0016$X-\u00134Fq&\u001cHo\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0001")
public class LogSegment
implements Logging {
    private final FileRecords log;
    private final LazyOffsetIndex lazyOffsetIndex;
    private final LazyTimeIndex lazyTimeIndex;
    private final TransactionIndex txnIndex;
    private final long baseOffset;
    private final int indexIntervalBytes;
    private final long rollJitterMs;
    private final Time time;
    private long created;
    private int bytesSinceLastIndexEntry;
    private volatile Option<Object> rollingBasedTimestamp;
    private volatile Option<Object> _maxTimestampSoFar;
    private volatile Option<Object> _offsetOfMaxTimestampSoFar;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String deleteIfExists$default$3() {
        return LogSegment$.MODULE$.deleteIfExists$default$3();
    }

    public static String open$default$8() {
        return LogSegment$.MODULE$.open$default$8();
    }

    public static boolean open$default$7() {
        return LogSegment$.MODULE$.open$default$7();
    }

    public static int open$default$6() {
        return LogSegment$.MODULE$.open$default$6();
    }

    public static boolean open$default$5() {
        return LogSegment$.MODULE$.open$default$5();
    }

    public static LogSegment open(File file, long l, LogConfig logConfig, Time time, boolean bl, int n, boolean bl2, String string) {
        return LogSegment$.MODULE$.open(file, l, logConfig, time, bl, n, bl2, string);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        LogSegment logSegment = this;
        synchronized (logSegment) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public FileRecords log() {
        return this.log;
    }

    public LazyOffsetIndex lazyOffsetIndex() {
        return this.lazyOffsetIndex;
    }

    public LazyTimeIndex lazyTimeIndex() {
        return this.lazyTimeIndex;
    }

    public TransactionIndex txnIndex() {
        return this.txnIndex;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int indexIntervalBytes() {
        return this.indexIntervalBytes;
    }

    public long rollJitterMs() {
        return this.rollJitterMs;
    }

    public Time time() {
        return this.time;
    }

    public OffsetIndex offsetIndex() {
        return this.lazyOffsetIndex().get();
    }

    public TimeIndex timeIndex() {
        return this.lazyTimeIndex().get();
    }

    public boolean shouldRoll(RollParams rollParams) {
        boolean reachedRollMs = this.timeWaitedForRoll(rollParams.now(), rollParams.maxTimestampInMessages()) > rollParams.maxSegmentMs() - this.rollJitterMs();
        return this.size() > rollParams.maxSegmentBytes() - rollParams.messagesSize() || this.size() > 0 && reachedRollMs || this.offsetIndex().isFull() || this.timeIndex().isFull() || !this.canConvertToRelativeOffset(rollParams.maxOffsetInMessages());
    }

    public void resizeIndexes(int size) {
        this.offsetIndex().resize(size);
        this.timeIndex().resize(size);
    }

    public void sanityCheck(boolean timeIndexFileNewlyCreated) {
        if (!this.lazyOffsetIndex().file().exists()) {
            throw new NoSuchFileException(new StringBuilder(33).append("Offset index file ").append(this.lazyOffsetIndex().file().getAbsolutePath()).append(" does not exist").toString());
        }
        Object object = timeIndexFileNewlyCreated ? BoxesRunTime.boxToBoolean((boolean)this.timeIndex().resize(0)) : BoxedUnit.UNIT;
        this.txnIndex().sanityCheck();
    }

    private long created() {
        return this.created;
    }

    private void created_$eq(long x$1) {
        this.created = x$1;
    }

    private int bytesSinceLastIndexEntry() {
        return this.bytesSinceLastIndexEntry;
    }

    private void bytesSinceLastIndexEntry_$eq(int x$1) {
        this.bytesSinceLastIndexEntry = x$1;
    }

    private Option<Object> rollingBasedTimestamp() {
        return this.rollingBasedTimestamp;
    }

    private void rollingBasedTimestamp_$eq(Option<Object> x$1) {
        this.rollingBasedTimestamp = x$1;
    }

    private Option<Object> _maxTimestampSoFar() {
        return this._maxTimestampSoFar;
    }

    private void _maxTimestampSoFar_$eq(Option<Object> x$1) {
        this._maxTimestampSoFar = x$1;
    }

    public void maxTimestampSoFar_$eq(long timestamp) {
        this._maxTimestampSoFar_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)timestamp)));
    }

    public long maxTimestampSoFar() {
        block0: {
            if (!this._maxTimestampSoFar().isEmpty()) break block0;
            this._maxTimestampSoFar_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.timeIndex().lastEntry().timestamp())));
        }
        return BoxesRunTime.unboxToLong((Object)this._maxTimestampSoFar().get());
    }

    private Option<Object> _offsetOfMaxTimestampSoFar() {
        return this._offsetOfMaxTimestampSoFar;
    }

    private void _offsetOfMaxTimestampSoFar_$eq(Option<Object> x$1) {
        this._offsetOfMaxTimestampSoFar = x$1;
    }

    public void offsetOfMaxTimestampSoFar_$eq(long offset) {
        this._offsetOfMaxTimestampSoFar_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)offset)));
    }

    public long offsetOfMaxTimestampSoFar() {
        block0: {
            if (!this._offsetOfMaxTimestampSoFar().isEmpty()) break block0;
            this._offsetOfMaxTimestampSoFar_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.timeIndex().lastEntry().offset())));
        }
        return BoxesRunTime.unboxToLong((Object)this._offsetOfMaxTimestampSoFar().get());
    }

    public int size() {
        return this.log().sizeInBytes();
    }

    public boolean canConvertToRelativeOffset(long offset) {
        return this.offsetIndex().canAppendOffset(offset);
    }

    public void append(long largestOffset, long largestTimestamp, long shallowOffsetOfMaxTimestamp, MemoryRecords records) {
        block3: {
            if (records.sizeInBytes() <= 0) break block3;
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Inserting ").append(records.sizeInBytes()).append(" bytes at end offset ").append(largestOffset).append(" at position ").append(this.log().sizeInBytes()).append(" ").append("with largest timestamp ").append(largestTimestamp).append(" at shallow offset ").append(shallowOffsetOfMaxTimestamp).toString());
            int physicalPosition = this.log().sizeInBytes();
            if (physicalPosition == 0) {
                this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)largestTimestamp)));
            }
            this.ensureOffsetInRange(largestOffset);
            int appendedBytes = this.log().append(records);
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Appended ").append(appendedBytes).append(" to ").append(this.log().file()).append(" at end offset ").append(largestOffset).toString());
            if (largestTimestamp > this.maxTimestampSoFar()) {
                this.maxTimestampSoFar_$eq(largestTimestamp);
                this.offsetOfMaxTimestampSoFar_$eq(shallowOffsetOfMaxTimestamp);
            }
            if (this.bytesSinceLastIndexEntry() > this.indexIntervalBytes()) {
                this.offsetIndex().append(largestOffset, physicalPosition);
                TimeIndex qual$1 = this.timeIndex();
                long x$1 = this.maxTimestampSoFar();
                long x$2 = this.offsetOfMaxTimestampSoFar();
                boolean x$3 = qual$1.maybeAppend$default$3();
                qual$1.maybeAppend(x$1, x$2, x$3);
                this.bytesSinceLastIndexEntry_$eq(0);
            }
            this.bytesSinceLastIndexEntry_$eq(this.bytesSinceLastIndexEntry() + records.sizeInBytes());
        }
    }

    private void ensureOffsetInRange(long offset) {
        if (!this.canConvertToRelativeOffset(offset)) {
            throw new LogSegmentOffsetOverflowException(this, offset);
        }
    }

    private int appendChunkFromFile(FileRecords records, int position, BufferSupplier bufferSupplier) {
        IntRef bytesToAppend = IntRef.create((int)0);
        LongRef maxTimestamp = LongRef.create((long)Long.MIN_VALUE);
        LongRef offsetOfMaxTimestamp = LongRef.create((long)Long.MIN_VALUE);
        LongRef maxOffset = LongRef.create((long)Long.MIN_VALUE);
        ObjectRef readBuffer = ObjectRef.create((Object)bufferSupplier.get(0x100000));
        Iterator nextBatches = ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batchesFrom(position)).asScala()).iterator();
        nextBatches.takeWhile((Function1 & Serializable & scala.Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)this.canAppend$1(batch, bytesToAppend, readBuffer))).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            LogSegment.$anonfun$appendChunkFromFile$2(maxTimestamp, offsetOfMaxTimestamp, maxOffset, bytesToAppend, batch);
            return BoxedUnit.UNIT;
        });
        if (bytesToAppend.elem > 0) {
            if (((ByteBuffer)readBuffer.elem).capacity() < bytesToAppend.elem) {
                readBuffer.elem = bufferSupplier.get(bytesToAppend.elem);
            }
            ((ByteBuffer)readBuffer.elem).limit(bytesToAppend.elem);
            records.readInto((ByteBuffer)readBuffer.elem, position);
            this.append(maxOffset.elem, maxTimestamp.elem, offsetOfMaxTimestamp.elem, MemoryRecords.readableRecords((ByteBuffer)((ByteBuffer)readBuffer.elem)));
        }
        bufferSupplier.release((ByteBuffer)readBuffer.elem);
        return bytesToAppend.elem;
    }

    public int appendFromFile(FileRecords records, int start) {
        int position;
        int bytesAppended;
        BufferSupplier.GrowableBufferSupplier bufferSupplier = new BufferSupplier.GrowableBufferSupplier();
        for (position = start; position < start + records.sizeInBytes(); position += bytesAppended) {
            bytesAppended = this.appendChunkFromFile(records, position, (BufferSupplier)bufferSupplier);
            if (bytesAppended != 0) continue;
            return position - start;
        }
        return position - start;
    }

    public void updateTxnIndex(CompletedTxn completedTxn, long lastStableOffset) {
        block0: {
            if (!completedTxn.isAborted()) break block0;
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Writing aborted transaction ").append(completedTxn).append(" to transaction index, last stable offset is ").append(lastStableOffset).toString());
            this.txnIndex().append(new AbortedTxn(completedTxn, lastStableOffset));
        }
    }

    private void updateProducerState(ProducerStateManager producerStateManager, RecordBatch batch) {
        if (batch.hasProducerId()) {
            long producerId = batch.producerId();
            ProducerAppendInfo appendInfo = producerStateManager.prepareUpdate(producerId, false);
            Option<CompletedTxn> maybeCompletedTxn = appendInfo.append(batch);
            producerStateManager.update(appendInfo);
            maybeCompletedTxn.foreach((Function1 & Serializable & scala.Serializable)completedTxn -> {
                LogSegment.$anonfun$updateProducerState$1(this, producerStateManager, completedTxn);
                return BoxedUnit.UNIT;
            });
        }
        producerStateManager.updateMapEndOffset(batch.lastOffset() + 1L);
    }

    public FileRecords.LogOffsetPosition translateOffset(long offset, int startingFilePosition) {
        OffsetPosition mapping = this.offsetIndex().lookup(offset);
        return this.log().searchForOffsetWithSize(offset, package$.MODULE$.max(mapping.position(), startingFilePosition));
    }

    public int translateOffset$default$2() {
        return 0;
    }

    public FetchDataInfo read(long startOffset, Option<Object> maxOffset, int maxSize, long maxPosition, boolean minOneMessage) {
        int n;
        int adjustedMaxSize;
        if (maxSize < 0) {
            throw new IllegalArgumentException(new StringBuilder(44).append("Invalid max size ").append(maxSize).append(" for log read from segment ").append(this.log()).toString());
        }
        int logSize = this.log().sizeInBytes();
        FileRecords.LogOffsetPosition startOffsetAndSize = this.translateOffset(startOffset, this.translateOffset$default$2());
        if (startOffsetAndSize == null) {
            return null;
        }
        int startPosition = startOffsetAndSize.position;
        LogOffsetMetadata offsetMetadata = new LogOffsetMetadata(startOffset, this.baseOffset(), startPosition);
        int n2 = adjustedMaxSize = minOneMessage ? package$.MODULE$.max(maxSize, startOffsetAndSize.size) : maxSize;
        if (adjustedMaxSize == 0) {
            return new FetchDataInfo(offsetMetadata, (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4());
        }
        Option<Object> option = maxOffset;
        if (None$.MODULE$.equals(option)) {
            n = package$.MODULE$.min((int)(maxPosition - (long)startPosition), adjustedMaxSize);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            long offset = BoxesRunTime.unboxToLong((Object)some.value());
            if (offset < startOffset) {
                return new FetchDataInfo(offsetMetadata, (Records)MemoryRecords.EMPTY, false, FetchDataInfo$.MODULE$.apply$default$4());
            }
            FileRecords.LogOffsetPosition mapping = this.translateOffset(offset, startPosition);
            int endPosition = mapping == null ? logSize : mapping.position;
            n = (int)package$.MODULE$.min(package$.MODULE$.min(maxPosition, (long)endPosition) - (long)startPosition, (long)adjustedMaxSize);
        } else {
            throw new MatchError(option);
        }
        int fetchSize = n;
        return new FetchDataInfo(offsetMetadata, (Records)this.log().slice(startPosition, fetchSize), adjustedMaxSize < startOffsetAndSize.size, FetchDataInfo$.MODULE$.apply$default$4());
    }

    public long read$default$4() {
        return this.size();
    }

    public boolean read$default$5() {
        return false;
    }

    public Option<Object> fetchUpperBoundOffset(OffsetPosition startOffsetPosition, int fetchSize) {
        return this.offsetIndex().fetchUpperBoundOffset(startOffsetPosition, fetchSize).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.offset()));
    }

    public int recover(ProducerStateManager producerStateManager, Option<LeaderEpochFileCache> leaderEpochCache) {
        this.offsetIndex().reset();
        this.timeIndex().reset();
        this.txnIndex().reset();
        IntRef validBytes = IntRef.create((int)0);
        IntRef lastIndexEntry = IntRef.create((int)0);
        this.maxTimestampSoFar_$eq(-1L);
        try {
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(this.log().batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                LogSegment.$anonfun$recover$1(this, validBytes, lastIndexEntry, leaderEpochCache, producerStateManager, batch);
                return BoxedUnit.UNIT;
            });
        }
        catch (CorruptRecordException e) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Found invalid messages in log segment %s at byte offset %d: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log().file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)validBytes$1.elem), e.getMessage()})));
        }
        int truncated = this.log().sizeInBytes() - validBytes.elem;
        if (truncated > 0) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Truncated ").append(truncated).append(" invalid bytes at the end of segment ").append(this.log().file().getAbsoluteFile()).append(" during recovery").toString());
        }
        this.log().truncateTo(validBytes.elem);
        this.offsetIndex().trimToValidSize();
        this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestampSoFar(), true);
        this.timeIndex().trimToValidSize();
        return truncated;
    }

    public Option<LeaderEpochFileCache> recover$default$2() {
        return None$.MODULE$;
    }

    private void loadLargestTimestamp() {
        block0: {
            TimestampOffset lastTimeIndexEntry = this.timeIndex().lastEntry();
            this.maxTimestampSoFar_$eq(lastTimeIndexEntry.timestamp());
            this.offsetOfMaxTimestampSoFar_$eq(lastTimeIndexEntry.offset());
            OffsetPosition offsetPosition = this.offsetIndex().lookup(lastTimeIndexEntry.offset());
            FileRecords.TimestampAndOffset maxTimestampOffsetAfterLastEntry = this.log().largestTimestampAfter(offsetPosition.position());
            if (maxTimestampOffsetAfterLastEntry.timestamp <= lastTimeIndexEntry.timestamp()) break block0;
            this.maxTimestampSoFar_$eq(maxTimestampOffsetAfterLastEntry.timestamp);
            this.offsetOfMaxTimestampSoFar_$eq(maxTimestampOffsetAfterLastEntry.offset);
        }
    }

    public boolean hasOverflow() {
        long nextOffset = this.readNextOffset();
        return nextOffset > this.baseOffset() && !this.canConvertToRelativeOffset(nextOffset - 1L);
    }

    public TxnIndexSearchResult collectAbortedTxns(long fetchOffset, long upperBoundOffset) {
        return this.txnIndex().collectAbortedTxns(fetchOffset, upperBoundOffset);
    }

    public String toString() {
        return new StringBuilder(30).append("LogSegment(baseOffset=").append(this.baseOffset()).append(", size=").append(this.size()).append(")").toString();
    }

    public int truncateTo(long offset) {
        int bytesTruncated;
        block1: {
            FileRecords.LogOffsetPosition mapping = this.translateOffset(offset, this.translateOffset$default$2());
            this.offsetIndex().truncateTo(offset);
            this.timeIndex().truncateTo(offset);
            this.txnIndex().truncateTo(offset);
            this.offsetIndex().resize(this.offsetIndex().maxIndexSize());
            this.timeIndex().resize(this.timeIndex().maxIndexSize());
            int n = bytesTruncated = mapping == null ? 0 : this.log().truncateTo(mapping.position);
            if (this.log().sizeInBytes() == 0) {
                this.created_$eq(this.time().milliseconds());
                this.rollingBasedTimestamp_$eq((Option<Object>)None$.MODULE$);
            }
            this.bytesSinceLastIndexEntry_$eq(0);
            if (this.maxTimestampSoFar() < 0L) break block1;
            this.loadLargestTimestamp();
        }
        return bytesTruncated;
    }

    public long readNextOffset() {
        FetchDataInfo fetchData = this.read(this.offsetIndex().lastOffset(), (Option<Object>)None$.MODULE$, this.log().sizeInBytes(), this.read$default$4(), this.read$default$5());
        return fetchData == null ? this.baseOffset() : BoxesRunTime.unboxToLong((Object)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).lastOption().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.nextOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.baseOffset()));
    }

    public void flush() {
        LogFlushStats$.MODULE$.logFlushTimer().time((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.log().flush();
            this.offsetIndex().flush();
            this.timeIndex().flush();
            this.txnIndex().flush();
        });
    }

    public void updateDir(File dir) {
        this.log().setFile(new File(dir, this.log().file().getName()));
        this.lazyOffsetIndex().file_$eq(new File(dir, this.lazyOffsetIndex().file().getName()));
        this.lazyTimeIndex().file_$eq(new File(dir, this.lazyTimeIndex().file().getName()));
        this.txnIndex().file_$eq(new File(dir, this.txnIndex().file().getName()));
    }

    public void changeFileSuffixes(String oldSuffix, String newSuffix) {
        this.log().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.log().file().getPath(), oldSuffix, newSuffix)));
        this.offsetIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.lazyOffsetIndex().file().getPath(), oldSuffix, newSuffix)));
        this.timeIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.lazyTimeIndex().file().getPath(), oldSuffix, newSuffix)));
        this.txnIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.txnIndex().file().getPath(), oldSuffix, newSuffix)));
    }

    public void onBecomeInactiveSegment() {
        this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestampSoFar(), true);
        this.offsetIndex().trimToValidSize();
        this.timeIndex().trimToValidSize();
        this.log().trim();
    }

    private void loadFirstBatchTimestamp() {
        block0: {
            java.util.Iterator iter;
            if (!this.rollingBasedTimestamp().isEmpty() || !(iter = this.log().batches().iterator()).hasNext()) break block0;
            this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)((FileLogInputStream.FileChannelRecordBatch)iter.next()).maxTimestamp())));
        }
    }

    public long timeWaitedForRoll(long now, long messageTimestamp) {
        Some some;
        long t;
        this.loadFirstBatchTimestamp();
        Option<Object> option = this.rollingBasedTimestamp();
        long l = option instanceof Some && (t = BoxesRunTime.unboxToLong((Object)(some = (Some)option).value())) >= 0L ? messageTimestamp - t : now - this.created();
        return l;
    }

    public long getFirstBatchTimestamp() {
        Some some;
        long t;
        this.loadFirstBatchTimestamp();
        Option<Object> option = this.rollingBasedTimestamp();
        long l = option instanceof Some && (t = BoxesRunTime.unboxToLong((Object)(some = (Some)option).value())) >= 0L ? t : Long.MAX_VALUE;
        return l;
    }

    public Option<FileRecords.TimestampAndOffset> findOffsetByTimestamp(long timestamp, long startingOffset) {
        TimestampOffset timestampOffset = this.timeIndex().lookup(timestamp);
        int position = this.offsetIndex().lookup(package$.MODULE$.max(timestampOffset.offset(), startingOffset)).position();
        return Option$.MODULE$.apply((Object)this.log().searchForTimestamp(timestamp, position, startingOffset));
    }

    public long findOffsetByTimestamp$default$2() {
        return this.baseOffset();
    }

    public void close() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestampSoFar(), true), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.offsetIndex().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.timeIndex().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.log().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.txnIndex().close(), this, CoreUtils$.MODULE$.swallow$default$3());
    }

    public void closeHandlers() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.offsetIndex().closeHandler(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.timeIndex().closeHandler(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.log().closeHandlers(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.txnIndex().close(), this, CoreUtils$.MODULE$.swallow$default$3());
    }

    public void deleteIfExists() {
        CoreUtils$.MODULE$.tryAll((Seq<Function0<BoxedUnit>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.delete$1((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.log().deleteIfExists(), "log", this.log().file(), true), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            OffsetIndex offsetIndex = this.offsetIndex();
            this.delete$1((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> offsetIndex.deleteIfExists(), "offset index", this.lazyOffsetIndex().file(), true);
        }, (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TimeIndex timeIndex = this.timeIndex();
            this.delete$1((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> timeIndex.deleteIfExists(), "time index", this.lazyTimeIndex().file(), true);
        }, (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.delete$1((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.txnIndex().deleteIfExists(), "transaction index", this.txnIndex().file(), false)}))));
    }

    public long lastModified() {
        return this.log().file().lastModified();
    }

    public long largestTimestamp() {
        return this.maxTimestampSoFar() >= 0L ? this.maxTimestampSoFar() : this.lastModified();
    }

    public Path lastModified_$eq(long ms) {
        FileTime fileTime = FileTime.fromMillis(ms);
        Files.setLastModifiedTime(this.log().file().toPath(), fileTime);
        Files.setLastModifiedTime(this.lazyOffsetIndex().file().toPath(), fileTime);
        return Files.setLastModifiedTime(this.lazyTimeIndex().file().toPath(), fileTime);
    }

    private final boolean canAppend$1(RecordBatch batch, IntRef bytesToAppend$1, ObjectRef readBuffer$1) {
        return this.canConvertToRelativeOffset(batch.lastOffset()) && (bytesToAppend$1.elem == 0 || bytesToAppend$1.elem + batch.sizeInBytes() < ((ByteBuffer)readBuffer$1.elem).capacity());
    }

    public static final /* synthetic */ void $anonfun$appendChunkFromFile$2(LongRef maxTimestamp$1, LongRef offsetOfMaxTimestamp$1, LongRef maxOffset$1, IntRef bytesToAppend$1, FileLogInputStream.FileChannelRecordBatch batch) {
        if (batch.maxTimestamp() > maxTimestamp$1.elem) {
            maxTimestamp$1.elem = batch.maxTimestamp();
            offsetOfMaxTimestamp$1.elem = batch.lastOffset();
        }
        maxOffset$1.elem = batch.lastOffset();
        bytesToAppend$1.elem += batch.sizeInBytes();
    }

    public static final /* synthetic */ void $anonfun$updateProducerState$1(LogSegment $this, ProducerStateManager producerStateManager$1, CompletedTxn completedTxn) {
        long lastStableOffset = producerStateManager$1.lastStableOffset(completedTxn);
        $this.updateTxnIndex(completedTxn, lastStableOffset);
        producerStateManager$1.completeTxn(completedTxn);
    }

    public static final /* synthetic */ void $anonfun$recover$2(FileLogInputStream.FileChannelRecordBatch batch$1, LeaderEpochFileCache cache) {
        block0: {
            if (batch$1.partitionLeaderEpoch() <= 0 || !cache.latestEpoch().forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> batch$1.partitionLeaderEpoch() > x$2)) break block0;
            cache.assign(batch$1.partitionLeaderEpoch(), batch$1.baseOffset());
        }
    }

    public static final /* synthetic */ void $anonfun$recover$1(LogSegment $this, IntRef validBytes$1, IntRef lastIndexEntry$1, Option leaderEpochCache$1, ProducerStateManager producerStateManager$2, FileLogInputStream.FileChannelRecordBatch batch) {
        block2: {
            batch.ensureValid();
            $this.ensureOffsetInRange(batch.lastOffset());
            if (batch.maxTimestamp() > $this.maxTimestampSoFar()) {
                $this.maxTimestampSoFar_$eq(batch.maxTimestamp());
                $this.offsetOfMaxTimestampSoFar_$eq(batch.lastOffset());
            }
            if (validBytes$1.elem - lastIndexEntry$1.elem > $this.indexIntervalBytes()) {
                $this.offsetIndex().append(batch.lastOffset(), validBytes$1.elem);
                TimeIndex qual$1 = $this.timeIndex();
                long x$1 = $this.maxTimestampSoFar();
                long x$2 = $this.offsetOfMaxTimestampSoFar();
                boolean x$3 = qual$1.maybeAppend$default$3();
                qual$1.maybeAppend(x$1, x$2, x$3);
                lastIndexEntry$1.elem = validBytes$1.elem;
            }
            validBytes$1.elem += batch.sizeInBytes();
            if (batch.magic() < 2) break block2;
            leaderEpochCache$1.foreach((Function1 & Serializable & scala.Serializable)cache -> {
                LogSegment.$anonfun$recover$2(batch, cache);
                return BoxedUnit.UNIT;
            });
            $this.updateProducerState(producerStateManager$2, (RecordBatch)batch);
        }
    }

    private final void delete$1(Function0 delete, String fileType, File file, boolean logIfMissing) {
        try {
            if (delete.apply$mcZ$sp()) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Deleted ").append(fileType).append(" ").append(file.getAbsolutePath()).append(".").toString());
            } else if (logIfMissing) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(fileType).append(" ").append(file.getAbsolutePath()).append(" because it does not exist.").toString());
            }
        }
        catch (IOException e) {
            throw new IOException(new StringBuilder(19).append("Delete of ").append(fileType).append(" ").append(file.getAbsolutePath()).append(" failed.").toString(), e);
        }
    }

    public LogSegment(FileRecords log, LazyOffsetIndex lazyOffsetIndex, LazyTimeIndex lazyTimeIndex, TransactionIndex txnIndex, long baseOffset, int indexIntervalBytes, long rollJitterMs, Time time) {
        this.log = log;
        this.lazyOffsetIndex = lazyOffsetIndex;
        this.lazyTimeIndex = lazyTimeIndex;
        this.txnIndex = txnIndex;
        this.baseOffset = baseOffset;
        this.indexIntervalBytes = indexIntervalBytes;
        this.rollJitterMs = rollJitterMs;
        this.time = time;
        Logging.$init$(this);
        this.created = time.milliseconds();
        this.bytesSinceLastIndexEntry = 0;
        this.rollingBasedTimestamp = None$.MODULE$;
        this._maxTimestampSoFar = None$.MODULE$;
        this._offsetOfMaxTimestampSoFar = None$.MODULE$;
    }
}

