/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kafka.api.AbstractConsumerTest;
import kafka.api.FixedPortTestUtils$;
import kafka.log.Log;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.GroupMaxSizeReachedException;
import org.apache.kafka.common.message.FindCoordinatorRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Builder;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\u0005g\u0001\u0002\u00180\u0001QBQa\u0010\u0001\u0005\u0002\u0001CqA\u0011\u0001C\u0002\u0013\u00051\t\u0003\u0004K\u0001\u0001\u0006I\u0001\u0012\u0005\b\u0017\u0002\u0011\r\u0011\"\u0001M\u0011\u0019\u0019\u0006\u0001)A\u0005\u001b\"9A\u000b\u0001b\u0001\n\u0003)\u0006B\u00021\u0001A\u0003%a\u000bC\u0004b\u0001\t\u0007I\u0011\u00012\t\r=\u0004\u0001\u0015!\u0003d\u0011\u0015\u0001\b\u0001\"\u0011r\u0011\u0015a\b\u0001\"\u0003~\u0011%\t)\u0002AI\u0001\n\u0013\t9\u0002C\u0004\u0002.\u0001!\t%a\f\t\u000f\u0005%\u0003\u0001\"\u0001\u00020!9\u00111\f\u0001\u0005\u0002\u0005u\u0003bBA:\u0001\u0011\u0005\u0011q\u0006\u0005\b\u0003o\u0002A\u0011AA=\u0011\u001d\ti\b\u0001C\u0001\u0003_Aq!!!\u0001\t\u0003\ty\u0003C\u0004\u0002\u0006\u0002!I!a\"\t\u000f\u0005E\u0005\u0001\"\u0003\u0002\u0014\"9\u0011q\u0014\u0001\u0005\n\u0005\u0005\u0006bBAT\u0001\u0011%\u0011\u0011\u0016\u0005\b\u0003k\u0003A\u0011AA\u0018\u0011\u001d\tI\f\u0001C\u0001\u0003_Aq!!0\u0001\t\u0003\ty\u0003C\u0004\u0002B\u0002!I!a1\t\u000f\u0005}\u0007\u0001\"\u0003\u0002b\"9!Q\u0002\u0001\u0005\n\t=\u0001\"\u0003B\r\u0001E\u0005I\u0011\u0002B\u000e\u0011\u001d\u0011y\u0002\u0001C\u0005\u0005CAqAa\u0011\u0001\t\u0013\u0011)E\u0002\u0004\u0003N\u0001!!q\n\u0005\n\u0003C\n#Q1A\u0005\u0002\rC\u0011Ba\u0016\"\u0005\u0003\u0005\u000b\u0011\u0002#\t\r}\nC\u0011\u0001B-\u0011!\u0011y&\ta\u0001\n\u0003\u0019\u0005\"\u0003B1C\u0001\u0007I\u0011\u0001B2\u0011\u001d\u0011I'\tQ!\n\u0011CqAa\u001b\"\t\u0003\ny\u0003C\u0004\u0003n\u0001!IAa\u001c\t\u0013\te\u0005!%A\u0005\n\tm\u0005b\u0002BP\u0001\u0011%!\u0011\u0015\u0005\n\u0005s\u0003\u0011\u0013!C\u0005\u0003/A\u0011Ba/\u0001#\u0003%IA!0\u0003%\r{gn];nKJ\u0014u.\u001e8dKR+7\u000f\u001e\u0006\u0003aE\n1!\u00199j\u0015\u0005\u0011\u0014!B6bM.\f7\u0001A\n\u0004\u0001UJ\u0004C\u0001\u001c8\u001b\u0005y\u0013B\u0001\u001d0\u0005Q\t%m\u001d;sC\u000e$8i\u001c8tk6,'\u000fV3tiB\u0011!(P\u0007\u0002w)\u0011A(M\u0001\u0006kRLGn]\u0005\u0003}m\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002\u0003B\u0011a\u0007A\u0001\r[\u0006DxI]8vaNK'0Z\u000b\u0002\tB\u0011Q\tS\u0007\u0002\r*\tq)A\u0003tG\u0006d\u0017-\u0003\u0002J\r\n\u0019\u0011J\u001c;\u0002\u001b5\f\u0007p\u0012:pkB\u001c\u0016N_3!\u0003M9'/Y2fMVd7\t\\8tKRKW.Z't+\u0005i\u0005cA#O!&\u0011qJ\u0012\u0002\u0005'>lW\r\u0005\u0002F#&\u0011!K\u0012\u0002\u0005\u0019>tw-\u0001\u000bhe\u0006\u001cWMZ;m\u00072|7/\u001a+j[\u0016l5\u000fI\u0001\tKb,7-\u001e;peV\ta\u000b\u0005\u0002X=6\t\u0001L\u0003\u0002Z5\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005mc\u0016\u0001B;uS2T\u0011!X\u0001\u0005U\u00064\u0018-\u0003\u0002`1\nA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002\u0013\u0015DXmY;u_J\u0004\u0013aD2p]N,X.\u001a:Q_2dWM]:\u0016\u0003\r\u00042\u0001Z5l\u001b\u0005)'B\u00014h\u0003\u001diW\u000f^1cY\u0016T!\u0001\u001b$\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002kK\n1!)\u001e4gKJ\u0004\"\u0001\\7\u000e\u0003\u0001I!A\\\u001c\u00031\r{gn];nKJ\f5o]5h]6,g\u000e\u001e)pY2,'/\u0001\td_:\u001cX/\\3s!>dG.\u001a:tA\u0005yq-\u001a8fe\u0006$XmQ8oM&<7/F\u0001s!\r\u0019HO^\u0007\u0002O&\u0011Qo\u001a\u0002\u0004'\u0016\f\bCA<{\u001b\u0005A(BA=2\u0003\u0019\u0019XM\u001d<fe&\u00111\u0010\u001f\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u000bhK:,'/\u0019;f\u0017\u000647.Y\"p]\u001aLwm\u001d\u000b\u0003ezDqAQ\u0006\u0011\u0002\u0003\u0007q\u0010\u0005\u0003\u0002\u0002\u0005=a\u0002BA\u0002\u0003\u0017\u00012!!\u0002G\u001b\t\t9AC\u0002\u0002\nM\na\u0001\u0010:p_Rt\u0014bAA\u0007\r\u00061\u0001K]3eK\u001aLA!!\u0005\u0002\u0014\t11\u000b\u001e:j]\u001eT1!!\u0004G\u0003y9WM\\3sCR,7*\u00194lC\u000e{gNZ5hg\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u001a)\u001aq0a\u0007,\u0005\u0005u\u0001\u0003BA\u0010\u0003Si!!!\t\u000b\t\u0005\r\u0012QE\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\nG\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003W\t\tCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001\u0002^3be\u0012{wO\u001c\u000b\u0003\u0003c\u00012!RA\u001a\u0013\r\t)D\u0012\u0002\u0005+:LG\u000fK\u0002\u000e\u0003s\u0001B!a\u000f\u0002F5\u0011\u0011Q\b\u0006\u0005\u0003\u007f\t\t%A\u0003kk:LGO\u0003\u0002\u0002D\u0005\u0019qN]4\n\t\u0005\u001d\u0013Q\b\u0002\u0006\u0003\u001a$XM]\u0001\"i\u0016\u001cHoQ8ogVl\u0007\u000f^5p]^KG\u000f\u001b\"s_.,'OR1jYV\u0014Xm\u001d\u0015\u0004\u001d\u00055\u0003\u0003BA\u001e\u0003\u001fJA!!\u0015\u0002>\t1\u0011j\u001a8pe\u0016D3ADA+!\u0011\tY$a\u0016\n\t\u0005e\u0013Q\b\u0002\u0005)\u0016\u001cH/A\rd_:\u001cX/\\3XSRD'I]8lKJ4\u0015-\u001b7ve\u0016\u001cH\u0003BA\u0019\u0003?Ba!!\u0019\u0010\u0001\u0004!\u0015\u0001\u00038v[&#XM]:)\u000f=\t)'!\u001c\u0002pA!\u0011qMA5\u001b\t\t)#\u0003\u0003\u0002l\u0005\u0015\"A\u00028po\u0006\u0014h.A\u0003wC2,X-\t\u0002\u0002r\u0005y1-\u0019;>I\u0016\u0004(/Z2bi&|g.A\u0012uKN$8+Z3l\u0003:$7i\\7nSR<\u0016\u000e\u001e5Ce>\\WM\u001d$bS2,(/Z:)\u0007A\t)&A\u0010tK\u0016\\\u0017I\u001c3D_6l\u0017\u000e^,ji\"\u0014%o\\6fe\u001a\u000b\u0017\u000e\\;sKN$B!!\r\u0002|!1\u0011\u0011M\tA\u0002\u0011\u000b\u0011\u0005^3tiN+(m]2sS\n,w\u000b[3o)>\u0004\u0018nY+oCZ\f\u0017\u000e\\1cY\u0016D3AEA+\u0003%!Xm\u001d;DY>\u001cX\rK\u0002\u0014\u0003+\n!c\u00195fG.\u001cEn\\:f\u000f>|G\rU1uQR1\u0011\u0011GAE\u0003\u001bCa!a#\u0015\u0001\u0004!\u0015A\u00038v[J+7m\u001c:eg\"1\u0011q\u0012\u000bA\u0002}\fqa\u001a:pkBLE-\u0001\u0011dQ\u0016\u001c7n\u00117pg\u0016<\u0016\u000e\u001e5D_>\u0014H-\u001b8bi>\u0014h)Y5mkJ,G\u0003CA\u0019\u0003+\u000b9*a'\t\r\u0005-U\u00031\u0001E\u0011\u0019\tI*\u0006a\u0001\u007f\u0006aA-\u001f8b[&\u001cwI]8va\"1\u0011QT\u000bA\u0002}\f1\"\\1ok\u0006dwI]8va\u0006ya-\u001b8e\u0007>|'\u000fZ5oCR|'\u000fF\u0002E\u0003GCa!!*\u0017\u0001\u0004y\u0018!B4s_V\u0004\u0018\u0001H2iK\u000e\\7\t\\8tK^KG\u000f[\"mkN$XM\u001d$bS2,(/\u001a\u000b\t\u0003c\tY+!,\u00022\"1\u00111R\fA\u0002\u0011Ca!a,\u0018\u0001\u0004y\u0018AB4s_V\u0004\u0018\u0007\u0003\u0004\u00024^\u0001\ra`\u0001\u0007OJ|W\u000f\u001d\u001a\u0002\rR,7\u000f\u001e*pY2Lgn\u001a\"s_.,'OU3ti\u0006\u0014Ho],ji\"\u001cV.\u00197mKJl\u0015\r_$s_V\u00048+\u001b>f\u0007>tg-[4ESN\u0014X\u000f\u001d;t\u0005&<wI]8va\"\u001a\u0001$!\u0016\u0002qQ,7\u000f^\"p]N,X.\u001a:SK\u000e,\u0017N^3t\r\u0006$\u0018\r\\#yG\u0016\u0004H/[8o/\",gn\u0012:pkB\u0004\u0016m]:fg6\u000b\u0007pU5{K\"\u001a\u0011$!\u0016\u00021Q,7\u000f^\"m_N,G)\u001e:j]\u001e\u0014VMY1mC:\u001cW\rK\u0002\u001b\u0003+\n\u0011d\u00195fG.\u001cEn\\:f\tV\u0014\u0018N\\4SK\n\fG.\u00198dKRQ\u0011\u0011GAc\u0003\u000f\fY-a5\t\r\u0005=5\u00041\u0001\u0000\u0011\u0019\tIm\u0007a\u0001\u007f\u0006)Ao\u001c9jG\"1Ak\u0007a\u0001\u0003\u001b\u00042aVAh\u0013\r\t\t\u000e\u0017\u0002\u0010\u000bb,7-\u001e;peN+'O^5dK\"9\u0011Q[\u000eA\u0002\u0005]\u0017a\u00072s_.,'o]!wC&d\u0017M\u00197f\tV\u0014\u0018N\\4DY>\u001cX\rE\u0002F\u00033L1!a7G\u0005\u001d\u0011un\u001c7fC:DsaGA3\u0003[\ny'\u0001\rde\u0016\fG/Z\"p]N,X.\u001a:B]\u0012\u0014VmY3jm\u0016$\u0002\"a9\u0003\u0006\t\u001d!1\u0002\t\t\u0003K\f)0!?\u0002z6\u0011\u0011q\u001d\u0006\u0005\u0003S\fY/\u0001\u0005d_:\u001cX/\\3s\u0015\u0011\ti/a<\u0002\u000f\rd\u0017.\u001a8ug*\u0019!'!=\u000b\t\u0005M\u0018\u0011I\u0001\u0007CB\f7\r[3\n\t\u0005]\u0018q\u001d\u0002\u000e\u0017\u000647.Y\"p]N,X.\u001a:\u0011\u000b\u0015\u000bY0a@\n\u0007\u0005uhIA\u0003BeJ\f\u0017\u0010E\u0002F\u0005\u0003I1Aa\u0001G\u0005\u0011\u0011\u0015\u0010^3\t\r\u0005=E\u00041\u0001\u0000\u0011\u001d\u0011I\u0001\ba\u0001\u0003/\fA\"\\1ok\u0006d\u0017i]:jO:Da!a#\u001d\u0001\u0004!\u0015a\u0005:fG\u0016Lg/Z#yC\u000e$(+Z2pe\u0012\u001cH\u0003CA\u0019\u0005#\u0011\u0019B!\u0006\t\r\u0005%X\u00041\u0001l\u0011\u0019\tY)\ba\u0001\t\"A!qC\u000f\u0011\u0002\u0003\u0007\u0001+A\u0005uS6,w.\u001e;Ng\u0006i\"/Z2fSZ,W\t_1diJ+7m\u001c:eg\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\u001e)\u001a\u0001+a\u0007\u0002-M,(-\\5u\u00072|7/Z!oIZ\u000bG.\u001b3bi\u0016$\"Ba\t\u00030\tE\"Q\u0007B !\u00159&Q\u0005B\u0015\u0013\r\u00119\u0003\u0017\u0002\u0007\rV$XO]3\u0011\u0007\u0015\u0013Y#C\u0002\u0003.\u0019\u00131!\u00118z\u0011\u001d\tIo\ba\u0001\u0003GDaAa\r \u0001\u0004\u0001\u0016AD2m_N,G+[7f_V$Xj\u001d\u0005\b\u0005oy\u0002\u0019\u0001B\u001d\u00039i\u0017N\\\"m_N,G+[7f\u001bN\u0004B!\u0012B\u001e!&\u0019!Q\b$\u0003\r=\u0003H/[8o\u0011\u001d\u0011\te\ba\u0001\u0005s\ta\"\\1y\u00072|7/\u001a+j[\u0016l5/\u0001\tdQ\u0016\u001c7n\u00117pg\u0016$7\u000b^1uKR1\u0011\u0011\u0007B$\u0005\u0013Ba!a$!\u0001\u0004y\bB\u0002B&A\u0001\u0007A)\u0001\td_6l\u0017\u000e\u001e;fIJ+7m\u001c:eg\n)\"i\\;oG\u0016\u0014%o\\6feN\u001b\u0007.\u001a3vY\u0016\u00148cA\u0011\u0003RA\u0019!Ha\u0015\n\u0007\tU3H\u0001\nTQV$Hm\\<oC\ndW\r\u00165sK\u0006$\u0017!\u00038v[&#XM]:!)\u0011\u0011YF!\u0018\u0011\u00051\f\u0003BBA1I\u0001\u0007A)\u0001\u0003ji\u0016\u0014\u0018\u0001C5uKJ|F%Z9\u0015\t\u0005E\"Q\r\u0005\t\u0005O2\u0013\u0011!a\u0001\t\u0006\u0019\u0001\u0010J\u0019\u0002\u000b%$XM\u001d\u0011\u0002\r\u0011|wk\u001c:l\u0003U\u0019'/Z1uKR{\u0007/[2QCJ$\u0018\u000e^5p]N$\"B!\u001d\u0003\u0004\n\u0015%\u0011\u0012BG!\u0019\t\tAa\u001d\u0003x%!!QOA\n\u0005\r\u0019V\r\u001e\t\u0005\u0005s\u0012y(\u0004\u0002\u0003|)!!QPAx\u0003\u0019\u0019w.\\7p]&!!\u0011\u0011B>\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Da!!3*\u0001\u0004y\bB\u0002BDS\u0001\u0007A)A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\u0005\u0007\u0005\u0017K\u0003\u0019\u0001#\u0002#I,\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000fC\u0005\u0003\u0010&\u0002\n\u00111\u0001\u0003\u0012\u0006YAo\u001c9jG\u000e{gNZ5h!\u0011\u0011\u0019J!&\u000e\u0003iK1Aa&[\u0005)\u0001&o\u001c9feRLWm]\u0001 GJ,\u0017\r^3U_BL7\rU1si&$\u0018n\u001c8tI\u0011,g-Y;mi\u0012\"TC\u0001BOU\u0011\u0011\t*a\u0007\u0002\u0017M,g\u000e\u001a*fG>\u0014Hm\u001d\u000b\u000b\u0003c\u0011\u0019K!-\u00034\nU\u0006b\u0002BSW\u0001\u0007!qU\u0001\taJ|G-^2feBA!\u0011\u0016BW\u0003s\fI0\u0004\u0002\u0003,*!!QUAv\u0013\u0011\u0011yKa+\u0003\u001b-\u000bgm[1Qe>$WoY3s\u0011\u0019\tYi\u000ba\u0001\t\"A\u0011\u0011Z\u0016\u0011\u0002\u0003\u0007q\u0010C\u0005\u0003\b.\u0002\n\u00111\u0001\u00038B!QIa\u000fE\u0003U\u0019XM\u001c3SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIM\nQc]3oIJ+7m\u001c:eg\u0012\"WMZ1vYR$C'\u0006\u0002\u0003@*\"!qWA\u000e\u0001")
public class ConsumerBounceTest
extends AbstractConsumerTest {
    private final int maxGroupSize;
    private final Some<Object> gracefulCloseTimeMs = new Some((Object)1000L);
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(2);
    private final Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);

    public int maxGroupSize() {
        return this.maxGroupSize;
    }

    public Some<Object> gracefulCloseTimeMs() {
        return this.gracefulCloseTimeMs;
    }

    public ScheduledExecutorService executor() {
        return this.executor;
    }

    public Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers() {
        return this.consumerPollers;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return this.generateKafkaConfigs(this.generateKafkaConfigs$default$1());
    }

    private Seq<KafkaConfig> generateKafkaConfigs(String maxGroupSize) {
        Properties properties = new Properties();
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.put(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "10");
        properties.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        properties.put(KafkaConfig$.MODULE$.GroupMaxSizeProp(), maxGroupSize);
        properties.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "true");
        properties.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), "false");
        return (Seq)FixedPortTestUtils$.MODULE$.createBrokerConfigs(this.brokerCount(), this.zkConnect(), false, false).map((Function1 & Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, properties));
    }

    private String generateKafkaConfigs$default$1() {
        return ((Object)this.maxGroupSize()).toString();
    }

    @Override
    @After
    public void tearDown() {
        try {
            this.consumerPollers().foreach((Function1 & Serializable)x$2 -> {
                x$2.shutdown();
                return BoxedUnit.UNIT;
            });
            this.executor().shutdownNow();
            Assert.assertTrue((String)"Executor did not terminate", (boolean)this.executor().awaitTermination(5000L, TimeUnit.MILLISECONDS));
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    @Ignore
    public void testConsumptionWithBrokerFailures() {
        this.consumeWithBrokerFailures(10);
    }

    /*
     * WARNING - void declaration
     */
    public void consumeWithBrokerFailures(int numIters) {
        LongRef longRef;
        int numRecords = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.topic(), (Option<Object>)None$.MODULE$);
        long create_e = 0L;
        LongRef longRef2 = longRef = new LongRef(create_e);
        longRef = null;
        LongRef consumed = longRef2;
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe(Collections.singletonList(this.topic()));
        BounceBrokerScheduler scheduler = new BounceBrokerScheduler(this, numIters);
        scheduler.start();
        while (scheduler.isRunning()) {
            void apply_elems;
            void apply_elems2;
            Iterable records = AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.lang.Iterable)consumer.poll(100L)).asScala();
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()});
            if (set$ == null) {
                throw null;
            }
            arraySeq = null;
            Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems2), (Object)AsScalaExtensions.SetHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.Set)consumer.assignment()).asScala());
            records.foreach((Function1 & Serializable)record -> {
                ConsumerBounceTest.$anonfun$consumeWithBrokerFailures$1(consumed, record);
                return BoxedUnit.UNIT;
            });
            if (!records.nonEmpty()) continue;
            consumer.commitSync();
            Set$ set$2 = Predef$.MODULE$.Set();
            ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()});
            if (set$2 == null) {
                throw null;
            }
            arraySeq2 = null;
            Assert.assertEquals((long)consumer.position(this.tp()), (long)((OffsetAndMetadata)consumer.committed(AsJavaExtensions.SetHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Set)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems))).asJava()).get(this.tp())).offset());
            if (consumer.position(this.tp()) != (long)numRecords) continue;
            consumer.seekToBeginning(Collections.emptyList());
            consumed.elem = 0L;
        }
        scheduler.shutdown();
    }

    @Test
    public void testSeekAndCommitWithBrokerFailures() {
        this.seekAndCommitWithBrokerFailures(5);
    }

    /*
     * WARNING - void declaration
     */
    public void seekAndCommitWithBrokerFailures(int numIters) {
        int numRecords = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.topic(), (Option<Object>)None$.MODULE$);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign(Collections.singletonList(this.tp()));
        consumer.seek(this.tp(), 0L);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerBounceTest.$anonfun$seekAndCommitWithBrokerFailures$1(this, numRecords)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("Failed to update high watermark for followers after timeout", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
        BounceBrokerScheduler scheduler = new BounceBrokerScheduler(this, numIters);
        scheduler.start();
        while (scheduler.isRunning()) {
            void apply_elems;
            int coin = TestUtils$.MODULE$.random().nextInt(3);
            if (coin == 0) {
                this.info((Function0<String>)(Function0 & Serializable)() -> "Seeking to end of log");
                consumer.seekToEnd(Collections.emptyList());
                Assert.assertEquals((long)numRecords, (long)consumer.position(this.tp()));
                continue;
            }
            if (coin == 1) {
                long pos = TestUtils$.MODULE$.random().nextInt(numRecords);
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(11).append("Seeking to ").append(pos).toString());
                consumer.seek(this.tp(), pos);
                Assert.assertEquals((long)pos, (long)consumer.position(this.tp()));
                continue;
            }
            if (coin != 2) continue;
            this.info((Function0<String>)(Function0 & Serializable)() -> "Committing offset.");
            consumer.commitSync();
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()});
            if (set$ == null) {
                throw null;
            }
            arraySeq = null;
            Assert.assertEquals((long)consumer.position(this.tp()), (long)((OffsetAndMetadata)consumer.committed(AsJavaExtensions.SetHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Set)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems))).asJava()).get(this.tp())).offset());
        }
    }

    @Test
    public void testSubscribeWhenTopicUnavailable() {
        int numRecords = 1000;
        String newtopic = "newtopic";
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe(Collections.singleton(newtopic));
        this.executor().schedule(new Runnable(this, newtopic){
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final String newtopic$1;

            public void run() {
                this.$outer.createTopic(this.newtopic$1, this.$outer.brokerCount(), this.$outer.brokerCount(), this.$outer.createTopic$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newtopic$1 = newtopic$1;
            }
        }, 2L, TimeUnit.SECONDS);
        consumer.poll(Duration.ZERO);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        AbstractConsumerTest.ConsumerAssignmentPoller poller = new AbstractConsumerTest.ConsumerAssignmentPoller((AbstractConsumerTest)this, (Consumer<byte[], byte[]>)consumer, (List<String>)new .colon.colon((Object)newtopic, (List)Nil$.MODULE$));
        Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> buffer = this.consumerPollers();
        if (buffer == null) {
            throw null;
        }
        buffer.addOne((Object)poller);
        poller.start();
        this.sendRecords$1(numRecords, newtopic, producer);
        this.receiveExactRecords(poller, numRecords, 10000L);
        poller.shutdown();
        this.servers().foreach((Function1 & Serializable)server -> {
            this.killBroker(server.config().brokerId());
            return BoxedUnit.UNIT;
        });
        Thread.sleep(500L);
        this.restartDeadBrokers();
        AbstractConsumerTest.ConsumerAssignmentPoller poller2 = new AbstractConsumerTest.ConsumerAssignmentPoller((AbstractConsumerTest)this, (Consumer<byte[], byte[]>)consumer, (List<String>)new .colon.colon((Object)newtopic, (List)Nil$.MODULE$));
        Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> buffer2 = this.consumerPollers();
        if (buffer2 == null) {
            throw null;
        }
        buffer2.addOne((Object)poller2);
        poller2.start();
        this.sendRecords$1(numRecords, newtopic, producer);
        this.receiveExactRecords(poller, numRecords, 10000L);
    }

    @Test
    public void testClose() {
        int numRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.topic(), (Option<Object>)None$.MODULE$);
        this.checkCloseGoodPath(numRecords, "group1");
        this.checkCloseWithCoordinatorFailure(numRecords, "group2", "group3");
        this.checkCloseWithClusterFailure(numRecords, "group4", "group5");
    }

    private void checkCloseGoodPath(int numRecords, String groupId) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerAndReceive(groupId, false, numRecords);
        this.submitCloseAndValidate(consumer, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)this.gracefulCloseTimeMs()).get();
        this.checkClosedState(groupId, numRecords);
    }

    private void checkCloseWithCoordinatorFailure(int numRecords, String dynamicGroup, String manualGroup) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerAndReceive(dynamicGroup, false, numRecords);
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerAndReceive(manualGroup, true, numRecords);
        this.killBroker(this.findCoordinator(dynamicGroup));
        this.killBroker(this.findCoordinator(manualGroup));
        Future<Object> future1 = this.submitCloseAndValidate(consumer1, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)this.gracefulCloseTimeMs());
        Future<Object> future2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)this.gracefulCloseTimeMs());
        future1.get();
        future2.get();
        this.restartDeadBrokers();
        this.checkClosedState(dynamicGroup, 0);
        this.checkClosedState(manualGroup, numRecords);
    }

    private int findCoordinator(String group) {
        int n;
        FindCoordinatorRequest request = (FindCoordinatorRequest)new FindCoordinatorRequest.Builder(new FindCoordinatorRequestData().setKeyType(FindCoordinatorRequest.CoordinatorType.GROUP.id()).setKey(group)).build();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            FindCoordinatorResponse $anonfun$findCoordinator$1_response = (FindCoordinatorResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FindCoordinatorResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
            n = $anonfun$findCoordinator$1_response.node().id();
            Errors errors = $anonfun$findCoordinator$1_response.error();
            Errors errors2 = Errors.NONE;
            boolean bl = !(errors != null ? !errors.equals(errors2) : errors2 != null);
            Object var9_6 = null;
            errors2 = null;
            if (bl) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail(ConsumerBounceTest.$anonfun$findCoordinator$2(group), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
        return n;
    }

    private void checkCloseWithClusterFailure(int numRecords, String group1, String group2) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerAndReceive(group1, false, numRecords);
        int requestTimeout = 6000;
        this.consumerConfig().setProperty("session.timeout.ms", "5000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("request.timeout.ms", ((Object)requestTimeout).toString());
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerAndReceive(group2, true, numRecords);
        this.servers().foreach((Function1 & Serializable)server -> {
            this.killBroker(server.config().brokerId());
            return BoxedUnit.UNIT;
        });
        int closeTimeout = 2000;
        Future<Object> future1 = this.submitCloseAndValidate(consumer1, closeTimeout, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)closeTimeout));
        Future<Object> future2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)new Some((Object)requestTimeout), (Option<Object>)new Some((Object)requestTimeout));
        future1.get();
        future2.get();
    }

    @Test
    public void testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup() {
        String group = "group-max-size-test";
        String topic = "group-max-size-test";
        int maxGroupSize = 2;
        int consumerCount = maxGroupSize + 1;
        int partitionCount = consumerCount * 2;
        this.consumerConfig().setProperty("max.poll.interval.ms", "60000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        scala.collection.immutable.Set<TopicPartition> partitions = this.createTopicPartitions(topic, partitionCount, this.brokerCount(), new Properties());
        this.addConsumersToGroupAndWaitForGroupAssignment(consumerCount, (Buffer<KafkaConsumer<byte[], byte[]>>)((Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), this.consumerPollers(), (List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), partitions, group);
        Seq<KafkaConfig> newConfigs = this.generateKafkaConfigs(((Object)maxGroupSize).toString());
        Range range = this.servers().indices();
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                ConsumerBounceTest.$anonfun$testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup$1(this, newConfigs, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var8_8 = null;
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 10000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerBounceTest.$anonfun$testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup$3(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail("The remaining consumers in the group could not fetch the expected records", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, l));
        }
        Seq seq = this.raisedExceptions$1();
        if (seq == null) {
            throw null;
        }
        Assert.assertEquals((long)1L, (long)seq.length());
        Assert.assertTrue((boolean)(this.raisedExceptions$1().head() instanceof GroupMaxSizeReachedException));
    }

    @Test
    public void testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize() {
        String group = "fatal-exception-test";
        String topic = "fatal-exception-test";
        this.consumerConfig().setProperty("max.poll.interval.ms", "60000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        scala.collection.immutable.Set<TopicPartition> partitions = this.createTopicPartitions(topic, this.maxGroupSize(), this.brokerCount(), new Properties());
        this.addConsumersToGroupAndWaitForGroupAssignment(this.maxGroupSize(), (Buffer<KafkaConsumer<byte[], byte[]>>)((Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), this.consumerPollers(), (List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), partitions, group);
        Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>> tuple2 = this.addConsumersToGroup(1, (Buffer<KafkaConsumer<byte[], byte[]>>)((Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)((Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), partitions, group);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Buffer buffer = (Buffer)tuple2._2();
        AbstractConsumerTest.ConsumerAssignmentPoller rejectedConsumer = (AbstractConsumerTest.ConsumerAssignmentPoller)((Object)buffer.head());
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerBounceTest.$anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$1(rejectedConsumer)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("Extra consumer did not throw an exception", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
        Assert.assertTrue((boolean)(rejectedConsumer.thrownException().get() instanceof GroupMaxSizeReachedException));
        this.sendRecords(this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()), this.maxGroupSize() * 100, topic, (Option<Object>)new Some((Object)partitions.size()));
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs = 10000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ConsumerBounceTest.$anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$3(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail("The consumers in the group could not fetch the expected records", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, l3));
        }
    }

    @Test
    public void testCloseDuringRebalance() {
        String topic = "closetest";
        this.createTopic(topic, 10, this.brokerCount(), this.createTopic$default$4());
        this.consumerConfig().setProperty("max.poll.interval.ms", "60000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.checkCloseDuringRebalance("group1", topic, this.executor(), true);
    }

    private void checkCloseDuringRebalance(String groupId, String topic, ExecutorService executor, boolean brokersAvailableDuringClose) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerWithGroupId(groupId);
        ConsumerBounceTest.waitForRebalance$1(2000L, ConsumerBounceTest.subscribeAndPoll$1(consumer1, (Option)None$.MODULE$, executor, topic), (scala.collection.immutable.Seq)Nil$.MODULE$);
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerWithGroupId(groupId);
        ConsumerBounceTest.waitForRebalance$1(2000L, ConsumerBounceTest.subscribeAndPoll$1(consumer2, (Option)None$.MODULE$, executor, topic), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[]{consumer1}));
        Future rebalanceFuture = this.createConsumerToRebalance$1(groupId, executor, topic);
        Future<Object> closeFuture1 = this.submitCloseAndValidate(consumer1, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)this.gracefulCloseTimeMs());
        ConsumerBounceTest.waitForRebalance$1(2000L, rebalanceFuture, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[]{consumer2}));
        this.createConsumerToRebalance$1(groupId, executor, topic);
        this.servers().foreach((Function1 & Serializable)server -> {
            this.killBroker(server.config().brokerId());
            return BoxedUnit.UNIT;
        });
        Future<Object> closeFuture2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)0L));
        closeFuture1.get(2000L, TimeUnit.MILLISECONDS);
        closeFuture2.get(2000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    private KafkaConsumer<byte[], byte[]> createConsumerAndReceive(String groupId, boolean manualAssign, int numRecords) {
        AbstractConsumerTest.ConsumerAssignmentPoller consumerAssignmentPoller;
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerWithGroupId(groupId);
        if (manualAssign) {
            void apply_elems;
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()});
            if (set$ == null) {
                throw null;
            }
            arraySeq = null;
            consumerAssignmentPoller = this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, (List<String>)Nil$.MODULE$, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)));
        } else {
            consumerAssignmentPoller = this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, (List<String>)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$), this.subscribeConsumerAndStartPolling$default$3());
        }
        AbstractConsumerTest.ConsumerAssignmentPoller consumerPoller = consumerAssignmentPoller;
        this.receiveExactRecords(consumerPoller, numRecords, 60000L);
        consumerPoller.shutdown();
        return consumer;
    }

    private void receiveExactRecords(AbstractConsumerTest.ConsumerAssignmentPoller consumer, int numRecords, long timeoutMs) {
        long l = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerBounceTest.$anonfun$receiveExactRecords$1(consumer, numRecords)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + timeoutMs) {
                throw Assertions$.MODULE$.fail(ConsumerBounceTest.$anonfun$receiveExactRecords$2(numRecords, consumer), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(timeoutMs, l));
        }
    }

    private long receiveExactRecords$default$3() {
        return 60000L;
    }

    private Future<Object> submitCloseAndValidate(KafkaConsumer<byte[], byte[]> consumer, long closeTimeoutMs, Option<Object> minCloseTimeMs, Option<Object> maxCloseTimeMs) {
        return this.executor().submit(() -> {
            int closeGraceTimeMs = 2000;
            long startMs = System.currentTimeMillis();
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Closing consumer with timeout ").append(closeTimeoutMs).append(" ms.").toString());
            consumer.close(Duration.ofMillis(closeTimeoutMs));
            long timeTakenMs = System.currentTimeMillis() - startMs;
            if (maxCloseTimeMs == null) {
                throw null;
            }
            if (!maxCloseTimeMs.isEmpty()) {
                long l = BoxesRunTime.unboxToLong((Object)maxCloseTimeMs.get());
                ConsumerBounceTest.$anonfun$submitCloseAndValidate$3(timeTakenMs, closeGraceTimeMs, l);
            }
            if (minCloseTimeMs == null) {
                throw null;
            }
            if (!minCloseTimeMs.isEmpty()) {
                long l = BoxesRunTime.unboxToLong((Object)minCloseTimeMs.get());
                ConsumerBounceTest.$anonfun$submitCloseAndValidate$4(timeTakenMs, l);
            }
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("consumer.close() completed in ").append(timeTakenMs).append(" ms.").toString());
        }, 0);
    }

    /*
     * WARNING - void declaration
     */
    private void checkClosedState(String groupId, int committedRecords) {
        Semaphore assignSemaphore = new Semaphore(0);
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerWithGroupId(groupId);
        consumer.subscribe(Collections.singletonList(this.topic()), new ConsumerRebalanceListener(null, assignSemaphore){
            private final Semaphore assignSemaphore$1;

            public void onPartitionsLost(Collection<TopicPartition> x$1) {
                super.onPartitionsLost(x$1);
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.assignSemaphore$1.release();
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.assignSemaphore$1 = assignSemaphore$1;
            }
        });
        consumer.poll(Duration.ofSeconds(3L));
        Assert.assertTrue((String)"Assignment did not complete on time", (boolean)assignSemaphore.tryAcquire(1L, TimeUnit.SECONDS));
        if (committedRecords > 0) {
            void apply_elems;
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()});
            if (set$ == null) {
                throw null;
            }
            arraySeq = null;
            Assert.assertEquals((long)committedRecords, (long)((OffsetAndMetadata)consumer.committed(AsJavaExtensions.SetHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Set)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems))).asJava()).get(this.tp())).offset());
        }
        consumer.close();
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Set<TopicPartition> createTopicPartitions(String topic, int numPartitions, int replicationFactor, Properties topicConfig) {
        TopicPartition topicPartition;
        void apply_start;
        this.createTopic(topic, numPartitions, replicationFactor, topicConfig);
        boolean bl = false;
        if (package$.MODULE$.Range() == null) {
            throw null;
        }
        Range.Exclusive map_this = new Range.Exclusive((int)apply_start, numPartitions, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it = map_this.iterator();
        while (map_strictOptimizedMap_it.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            TopicPartition topicPartition2;
            TopicPartition topicPartition3;
            int $anonfun$createTopicPartitions$1_part = BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next());
            TopicPartition topicPartition4 = topicPartition3 = new TopicPartition(topic, $anonfun$createTopicPartitions$1_part);
            topicPartition3 = null;
            TopicPartition topicPartition5 = topicPartition2 = topicPartition4;
            topicPartition2 = null;
            topicPartition = topicPartition5;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            topicPartition = null;
        }
        Object var5_6 = null;
        Object var6_7 = null;
        Object var7_8 = null;
        topicPartition = null;
        return ((IndexedSeq)map_strictOptimizedMap_b.result()).toSet();
    }

    private Properties createTopicPartitions$default$4() {
        return new Properties();
    }

    /*
     * WARNING - void declaration
     */
    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, String topic, Option<Object> numPartitions) {
        Future future;
        int n = 0;
        int n2 = 0;
        Range.Exclusive map_this = new Range.Exclusive(n2, numRecords, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it = map_this.iterator();
        while (map_strictOptimizedMap_it.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            Future future2;
            Future future3;
            int n3;
            int $anonfun$sendRecords$1_i = BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next());
            if (numPartitions instanceof Some) {
                int $anonfun$sendRecords$1_getPartition$1_partitions = BoxesRunTime.unboxToInt((Object)((Some)numPartitions).value());
                int $anonfun$sendRecords$1_getPartition$1_nextPart = n % $anonfun$sendRecords$1_getPartition$1_partitions;
                ++n;
                n3 = $anonfun$sendRecords$1_getPartition$1_nextPart;
            } else if (None$.MODULE$.equals(numPartitions)) {
                n3 = this.part();
            } else {
                throw new MatchError(numPartitions);
            }
            Future future4 = future3 = producer.send(new ProducerRecord(topic, Integer.valueOf(n3), (Object)((Object)$anonfun$sendRecords$1_i).toString().getBytes(), (Object)((Object)$anonfun$sendRecords$1_i).toString().getBytes()));
            future3 = null;
            Future future5 = future2 = future4;
            future2 = null;
            future = future5;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            future = null;
        }
        Object var6_7 = null;
        Object var7_8 = null;
        Object var8_9 = null;
        future = null;
        ((IndexedSeq)map_strictOptimizedMap_b.result()).map((Function1 & Serializable)x$4 -> (RecordMetadata)x$4.get());
    }

    private String sendRecords$default$3() {
        return this.topic();
    }

    private Option<Object> sendRecords$default$4() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$consumeWithBrokerFailures$1(LongRef consumed$1, ConsumerRecord record) {
        Assert.assertEquals((long)consumed$1.elem, (long)record.offset());
        ++consumed$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$seekAndCommitWithBrokerFailures$2(ConsumerBounceTest $this, int numRecords$1, KafkaServer server) {
        return ((Log)server.replicaManager().localLog($this.tp()).get()).highWatermark() == (long)numRecords$1;
    }

    public static final /* synthetic */ boolean $anonfun$seekAndCommitWithBrokerFailures$1(ConsumerBounceTest $this, int numRecords$1) {
        return $this.servers().forall((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)ConsumerBounceTest.$anonfun$seekAndCommitWithBrokerFailures$2($this, numRecords$1, server)));
    }

    public static final /* synthetic */ String $anonfun$seekAndCommitWithBrokerFailures$3() {
        return "Failed to update high watermark for followers after timeout";
    }

    public static final /* synthetic */ void $anonfun$testSubscribeWhenTopicUnavailable$2(IntRef remainingRecords$1, Future future) {
        try {
            future.get();
            --remainingRecords$1.elem;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void sendRecords$1(int numRecords, String topic, KafkaProducer producer$1) {
        IntRef intRef;
        IntRef intRef2 = intRef = new IntRef(numRecords);
        intRef = null;
        IntRef remainingRecords = intRef2;
        long endTimeMs = System.currentTimeMillis() + 20000L;
        while (remainingRecords.elem > 0 && System.currentTimeMillis() < endTimeMs) {
            Future future2;
            int n = 0;
            int until$extension_end = remainingRecords.elem;
            Range.Exclusive map_this = new Range.Exclusive(n, until$extension_end, 1);
            map_this.scala$collection$immutable$Range$$validateMaxLength();
            Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
            for (Object object : map_this) {
                void map_strictOptimizedMap_$plus$eq_elem;
                Future future3;
                Future future4 = future3 = producer$1.send(new ProducerRecord(topic, Integer.valueOf(this.part()), (Object)((Object)BoxesRunTime.unboxToInt((Object)object)).toString().getBytes(), (Object)((Object)BoxesRunTime.unboxToInt((Object)object)).toString().getBytes()));
                future3 = null;
                future2 = future4;
                if (map_strictOptimizedMap_b == null) {
                    throw null;
                }
                map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
                future2 = null;
            }
            Object var8_8 = null;
            Object var9_9 = null;
            Object var10_10 = null;
            future2 = null;
            ((IndexedSeq)map_strictOptimizedMap_b.result()).map((Function1 & Serializable)future -> {
                ConsumerBounceTest.$anonfun$testSubscribeWhenTopicUnavailable$2(remainingRecords, future);
                return BoxedUnit.UNIT;
            });
        }
        Assert.assertEquals((long)0L, (long)remainingRecords.elem);
    }

    public static final /* synthetic */ boolean $anonfun$findCoordinator$1(ConsumerBounceTest $this, FindCoordinatorRequest request$1, IntRef nodeId$1) {
        FindCoordinatorResponse response = (FindCoordinatorResponse)$this.connectAndReceive((AbstractRequest)request$1, $this.connectAndReceive$default$2(), $this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FindCoordinatorResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        nodeId$1.elem = response.node().id();
        Errors errors = response.error();
        Errors errors2 = Errors.NONE;
        return !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ String $anonfun$findCoordinator$2(String group$1) {
        return new StringBuilder(37).append("Failed to find coordinator for group ").append(group$1).toString();
    }

    public static final /* synthetic */ void $anonfun$testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup$1(ConsumerBounceTest $this, Seq newConfigs$1, int serverIdx) {
        $this.killBroker(serverIdx);
        KafkaConfig config = (KafkaConfig)newConfigs$1.apply(serverIdx);
        Time createServer_time = $this.brokerTime(config.brokerId());
        Object var4_4 = null;
        $this.servers().update(serverIdx, (Object)TestUtils$.MODULE$.createServer(config, createServer_time, (Option<String>)None$.MODULE$));
        $this.restartDeadBrokers();
    }

    private final Seq raisedExceptions$1() {
        return (Seq)this.consumerPollers().flatten((Function1 & Serializable)x$3 -> x$3.thrownException());
    }

    public static final /* synthetic */ boolean $anonfun$testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup$3(ConsumerBounceTest $this) {
        return $this.raisedExceptions$1().nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup$4() {
        return "The remaining consumers in the group could not fetch the expected records";
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$1(AbstractConsumerTest.ConsumerAssignmentPoller rejectedConsumer$1) {
        return rejectedConsumer$1.thrownException().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$2() {
        return "Extra consumer did not throw an exception";
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$4(AbstractConsumerTest.ConsumerAssignmentPoller p) {
        return p.receivedMessages() >= 100;
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$3(ConsumerBounceTest $this) {
        return $this.consumerPollers().forall((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ConsumerBounceTest.$anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$4(p)));
    }

    public static final /* synthetic */ String $anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$5() {
        return "The consumers in the group could not fetch the expected records";
    }

    private static final Future subscribeAndPoll$1(KafkaConsumer consumer, Option revokeSemaphore, ExecutorService executor$1, String topic$2) {
        return executor$1.submit(() -> {
            consumer.subscribe(Collections.singletonList(topic$2));
            if (revokeSemaphore == null) {
                throw null;
            }
            if (!revokeSemaphore.isEmpty()) {
                ((Semaphore)revokeSemaphore.get()).release();
            }
            consumer.poll(0L);
        }, 0);
    }

    private static final Option subscribeAndPoll$default$2$1() {
        return None$.MODULE$;
    }

    private static final void waitForRebalance$1(long timeoutMs, Future future, scala.collection.immutable.Seq otherConsumers) {
        long startMs = System.currentTimeMillis();
        while (System.currentTimeMillis() < startMs + timeoutMs && !future.isDone()) {
            otherConsumers.foreach((Function1 & Serializable)consumer -> consumer.poll(Duration.ofMillis(100L)));
        }
        Assert.assertTrue((String)"Rebalance did not complete in time", (boolean)future.isDone());
    }

    private final Future createConsumerToRebalance$1(String groupId$1, ExecutorService executor$1, String topic$2) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerWithGroupId(groupId$1);
        Semaphore rebalanceSemaphore = new Semaphore(0);
        Future future = ConsumerBounceTest.subscribeAndPoll$1(consumer, (Option)new Some((Object)rebalanceSemaphore), executor$1, topic$2);
        Assert.assertTrue((String)"Rebalance not triggered", (boolean)rebalanceSemaphore.tryAcquire(2000L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((String)"Rebalance completed too early", (boolean)future.isDone());
        return future;
    }

    public static final /* synthetic */ boolean $anonfun$receiveExactRecords$1(AbstractConsumerTest.ConsumerAssignmentPoller consumer$2, int numRecords$2) {
        return consumer$2.receivedMessages() == numRecords$2;
    }

    public static final /* synthetic */ String $anonfun$receiveExactRecords$2(int numRecords$2, AbstractConsumerTest.ConsumerAssignmentPoller consumer$2) {
        return new StringBuilder(48).append("Consumer did not receive expected ").append(numRecords$2).append(". It received ").append(consumer$2.receivedMessages()).toString();
    }

    public static final /* synthetic */ void $anonfun$submitCloseAndValidate$3(long timeTakenMs$1, int closeGraceTimeMs$1, long ms) {
        Assert.assertTrue((String)new StringBuilder(20).append("Close took too long ").append(timeTakenMs$1).toString(), (timeTakenMs$1 < ms + (long)closeGraceTimeMs$1 ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$submitCloseAndValidate$4(long timeTakenMs$1, long ms) {
        Assert.assertTrue((String)new StringBuilder(27).append("Close finished too quickly ").append(timeTakenMs$1).toString(), (timeTakenMs$1 >= ms ? 1 : 0) != 0);
    }

    public static final /* synthetic */ TopicPartition $anonfun$createTopicPartitions$1(String topic$3, int part) {
        return new TopicPartition(topic$3, part);
    }

    private final int getPartition$1(Option numPartitions$1, IntRef partitionIndex$1) {
        int n;
        if (numPartitions$1 instanceof Some) {
            int partitions = BoxesRunTime.unboxToInt((Object)((Some)numPartitions$1).value());
            int nextPart = partitionIndex$1.elem % partitions;
            ++partitionIndex$1.elem;
            n = nextPart;
        } else if (None$.MODULE$.equals(numPartitions$1)) {
            n = this.part();
        } else {
            throw new MatchError((Object)numPartitions$1);
        }
        return n;
    }

    public static final /* synthetic */ Future $anonfun$sendRecords$1(ConsumerBounceTest $this, KafkaProducer producer$2, String topic$4, Option numPartitions$1, IntRef partitionIndex$1, int i) {
        int n;
        if (numPartitions$1 instanceof Some) {
            int getPartition$1_partitions = BoxesRunTime.unboxToInt((Object)((Some)numPartitions$1).value());
            int getPartition$1_nextPart = partitionIndex$1.elem % getPartition$1_partitions;
            ++partitionIndex$1.elem;
            n = getPartition$1_nextPart;
        } else if (None$.MODULE$.equals(numPartitions$1)) {
            n = $this.part();
        } else {
            throw new MatchError((Object)numPartitions$1);
        }
        return producer$2.send(new ProducerRecord(topic$4, Integer.valueOf(n), (Object)((Object)i).toString().getBytes(), (Object)((Object)i).toString().getBytes()));
    }

    public ConsumerBounceTest() {
        this.maxGroupSize = 5;
        this.consumerConfig().setProperty("enable.auto.commit", "true");
    }

    public static final /* synthetic */ TopicPartition $anonfun$createTopicPartitions$1$adapted(String topic$3, Object part) {
        return ConsumerBounceTest.$anonfun$createTopicPartitions$1(topic$3, BoxesRunTime.unboxToInt((Object)part));
    }

    public static final /* synthetic */ Future $anonfun$sendRecords$1$adapted(ConsumerBounceTest $this, KafkaProducer producer$2, String topic$4, Option numPartitions$1, IntRef partitionIndex$1, Object i) {
        return ConsumerBounceTest.$anonfun$sendRecords$1($this, producer$2, topic$4, numPartitions$1, partitionIndex$1, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ Future $anonfun$testSubscribeWhenTopicUnavailable$1$adapted(ConsumerBounceTest $this, KafkaProducer producer$1, String topic$1, Object i) {
        return producer$1.send(new ProducerRecord(topic$1, Integer.valueOf($this.part()), (Object)((Object)BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(), (Object)((Object)BoxesRunTime.unboxToInt((Object)i)).toString().getBytes()));
    }

    public static final /* synthetic */ Object $anonfun$checkCloseDuringRebalance$2$adapted(Semaphore s) {
        s.release();
        return BoxedUnit.UNIT;
    }

    public class BounceBrokerScheduler
    extends ShutdownableThread {
        private final int numIters;
        private int iter;
        public final /* synthetic */ ConsumerBounceTest $outer;

        public int numIters() {
            return this.numIters;
        }

        public int iter() {
            return this.iter;
        }

        public void iter_$eq(int x$1) {
            this.iter = x$1;
        }

        public void doWork() {
            this.kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer().killRandomBroker();
            Thread.sleep(500L);
            this.kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer().restartDeadBrokers();
            this.iter_$eq(this.iter() + 1);
            if (this.iter() == this.numIters()) {
                this.initiateShutdown();
                return;
            }
            Thread.sleep(500L);
        }

        public /* synthetic */ ConsumerBounceTest kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer() {
            return this.$outer;
        }

        public BounceBrokerScheduler(ConsumerBounceTest $outer, int numIters) {
            this.numIters = numIters;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("daemon-bounce-broker", false);
            this.iter = 0;
        }
    }
}

