/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kafka.api.LeaderAndIsr;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReplicaAssignment;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.ZkAdminManager$;
import kafka.utils.Logging;
import kafka.zk.AdminZkClient;
import kafka.zk.ConfigEntityTypeZNode$;
import kafka.zk.ConfigEntityZNode$;
import kafka.zk.FailedRegistrationResult;
import kafka.zk.KRaftRegistrationResult;
import kafka.zk.KafkaZkClient;
import kafka.zk.ProducerIdBlockZNode$;
import kafka.zk.SuccessfulRegistrationResult;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zk.TopicPartitionZNode$;
import kafka.zk.TopicPartitionsZNode$;
import kafka.zk.TopicZNode;
import kafka.zk.TopicZNode$;
import kafka.zk.ZkVersion$;
import kafka.zookeeper.AsyncResponse;
import kafka.zookeeper.CreateRequest;
import kafka.zookeeper.SetDataRequest;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.kafka.common.metadata.ClientQuotaRecord;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.ProducerIdsRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.migration.MigrationClient;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.ProducerIdsBlock;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.Iterable;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tec\u0001B\r\u001b\u0001}A\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\u0006\u0001\u0002!\t!\u0011\u0005\u0006\t\u0002!\t%\u0012\u0005\u0006\u0017\u0002!\t\u0005\u0014\u0005\u0006\u001f\u0002!\t\u0005\u0015\u0005\u0006%\u0002!\te\u0015\u0005\u0006+\u0002!\tA\u0016\u0005\u0006}\u0002!\ta \u0005\b\u0003\u000b\u0001A\u0011AA\u0004\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001fAq!!\u0006\u0001\t\u0003\n9\u0002C\u0004\u0002 \u0001!\t%!\t\t\u000f\u0005%\u0002\u0001\"\u0011\u0002\"!9\u00111\u0006\u0001\u0005B\u00055\u0002bBA6\u0001\u0011%\u0011Q\u000e\u0005\b\u0003\u000b\u0003A\u0011BAD\u0011\u001d\tY\u000b\u0001C\u0005\u0003[Cq!!.\u0001\t\u0013\t9\fC\u0004\u0002F\u0002!\t%a2\t\u000f\u0005E\u0007\u0001\"\u0001\u0002T\"9\u0011\u0011 \u0001\u0005B\u0005m\bb\u0002B\t\u0001\u0011\u0005#1\u0003\u0005\b\u0005C\u0001A\u0011\tB\u0012\u0011\u001d\u0011Y\u0004\u0001C!\u0005{\u0011\u0011CW6NS\u001e\u0014\u0018\r^5p]\u000ec\u0017.\u001a8u\u0015\tYB$\u0001\u0002{W*\tQ$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001\u0001\u0003&\u000e\t\u0003C\u0019j\u0011A\t\u0006\u0003G\u0011\nA\u0001\\1oO*\tQ%\u0001\u0003kCZ\f\u0017BA\u0014#\u0005\u0019y%M[3diB\u0011\u0011fM\u0007\u0002U)\u00111\u0006L\u0001\n[&<'/\u0019;j_:T!!\f\u0018\u0002\u00115,G/\u00193bi\u0006T!!H\u0018\u000b\u0005A\n\u0014AB1qC\u000eDWMC\u00013\u0003\ry'oZ\u0005\u0003i)\u0012q\"T5he\u0006$\u0018n\u001c8DY&,g\u000e\u001e\t\u0003mej\u0011a\u000e\u0006\u0003qq\tQ!\u001e;jYNL!AO\u001c\u0003\u000f1{wmZ5oO\u0006A!p[\"mS\u0016tG\u000f\u0005\u0002>}5\t!$\u0003\u0002@5\ti1*\u00194lCj[7\t\\5f]R\fa\u0001P5oSRtDC\u0001\"D!\ti\u0004\u0001C\u0003<\u0005\u0001\u0007A(A\u0011hKR|%o\u0011:fCR,W*[4sCRLwN\u001c*fG>4XM]=Ti\u0006$X\r\u0006\u0002G\u0013B\u0011\u0011fR\u0005\u0003\u0011*\u0012!DW6NS\u001e\u0014\u0018\r^5p]2+\u0017\rZ3sg\"L\u0007o\u0015;bi\u0016DQAS\u0002A\u0002\u0019\u000bA\"\u001b8ji&\fGn\u0015;bi\u0016\f\u0011d]3u\u001b&<'/\u0019;j_:\u0014VmY8wKJL8\u000b^1uKR\u0011a)\u0014\u0005\u0006\u001d\u0012\u0001\rAR\u0001\u0006gR\fG/Z\u0001\u001aG2\f\u0017.\\\"p]R\u0014x\u000e\u001c7fe2+\u0017\rZ3sg\"L\u0007\u000f\u0006\u0002G#\")a*\u0002a\u0001\r\u0006Y\"/\u001a7fCN,7i\u001c8ue>dG.\u001a:MK\u0006$WM]:iSB$\"A\u0012+\t\u000b93\u0001\u0019\u0001$\u0002\u001b5LwM]1uKR{\u0007/[2t)\u00119Vl\u001a=\u0011\u0005a[V\"A-\u000b\u0003i\u000bQa]2bY\u0006L!\u0001X-\u0003\tUs\u0017\u000e\u001e\u0005\u0006=\u001e\u0001\raX\u0001\u0010[\u0016$\u0018\rZ1uCZ+'o]5p]B\u0011\u0001-Z\u0007\u0002C*\u0011!mY\u0001\u0007G>lWn\u001c8\u000b\u0005\u0011t\u0013AB:feZ,'/\u0003\u0002gC\nyQ*\u001a;bI\u0006$\u0018MV3sg&|g\u000eC\u0003i\u000f\u0001\u0007\u0011.\u0001\bsK\u000e|'\u000fZ\"p]N,X.\u001a:\u0011\u0007)|\u0017/D\u0001l\u0015\taW.\u0001\u0005gk:\u001cG/[8o\u0015\tqG%\u0001\u0003vi&d\u0017B\u00019l\u0005!\u0019uN\\:v[\u0016\u0014\bc\u0001:tk6\tQ.\u0003\u0002u[\n!A*[:u!\t\u0001g/\u0003\u0002xC\n!\u0012\t]5NKN\u001c\u0018mZ3B]\u00124VM]:j_:DQ!_\u0004A\u0002i\f\u0001C\u0019:pW\u0016\u0014\u0018\nZ\"p]N,X.\u001a:\u0011\u0007)|7\u0010\u0005\u0002\"y&\u0011QP\t\u0002\b\u0013:$XmZ3s\u0003Qi\u0017n\u001a:bi\u0016\u0014%o\\6fe\u000e{gNZ5hgR)q+!\u0001\u0002\u0004!)a\f\u0003a\u0001?\")\u0001\u000e\u0003a\u0001S\u0006\u0019R.[4sCR,7\t\\5f]R\fVo\u001c;bgR)q+!\u0003\u0002\f!)a,\u0003a\u0001?\")\u0001.\u0003a\u0001S\u0006\tR.[4sCR,\u0007K]8ek\u000e,'/\u00133\u0015\u000b]\u000b\t\"a\u0005\t\u000byS\u0001\u0019A0\t\u000b!T\u0001\u0019A5\u0002\u001fI,\u0017\rZ!mY6+G/\u00193bi\u0006$RaVA\r\u0003;Aa!a\u0007\f\u0001\u0004I\u0017!\u00042bi\u000eD7i\u001c8tk6,'\u000fC\u0003z\u0017\u0001\u0007!0A\u0007sK\u0006$'I]8lKJLEm\u001d\u000b\u0003\u0003G\u0001BA]A\u0013w&\u0019\u0011qE7\u0003\u0007M+G/A\u0011sK\u0006$'I]8lKJLEm\u001d$s_6$v\u000e]5d\u0003N\u001c\u0018n\u001a8nK:$8/A\u0006de\u0016\fG/\u001a+pa&\u001cG#\u0003$\u00020\u0005%\u0013qKA5\u0011\u001d\t\tD\u0004a\u0001\u0003g\t\u0011\u0002^8qS\u000et\u0015-\\3\u0011\t\u0005U\u00121\t\b\u0005\u0003o\ty\u0004E\u0002\u0002:ek!!a\u000f\u000b\u0007\u0005ub$\u0001\u0004=e>|GOP\u0005\u0004\u0003\u0003J\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002F\u0005\u001d#AB*ue&twMC\u0002\u0002BeCq!a\u0013\u000f\u0001\u0004\ti%A\u0004u_BL7-\u00133\u0011\t\u0005=\u00131K\u0007\u0003\u0003#R!A\u0019\u0018\n\t\u0005U\u0013\u0011\u000b\u0002\u0005+VLG\rC\u0004\u0002Z9\u0001\r!a\u0017\u0002\u0015A\f'\u000f^5uS>t7\u000f\u0005\u0004s\u0003;Z\u0018\u0011M\u0005\u0004\u0003?j'aA'baB!\u00111MA3\u001b\u0005a\u0013bAA4Y\t)\u0002+\u0019:uSRLwN\u001c*fO&\u001cHO]1uS>t\u0007\"\u0002(\u000f\u0001\u00041\u0015\u0001F2sK\u0006$X\rV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0003\u0002p\u0005m\u0004\u0003BA9\u0003oj!!a\u001d\u000b\u0007\u0005UD$A\u0005{_>\\W-\u001a9fe&!\u0011\u0011PA:\u00055\u0019%/Z1uKJ+\u0017/^3ti\"9\u0011QP\bA\u0002\u0005}\u0014A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0005\u0003\u001f\n\t)\u0003\u0003\u0002\u0004\u0006E#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u001aa\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f!\u0006$\b.\u00118e\t\u0006$\u0018\r\u0006\u0005\u0002\n\u0006m\u0015QTAQ!\u001dA\u00161RA\u001a\u0003\u001fK1!!$Z\u0005\u0019!V\u000f\u001d7feA)\u0001,!%\u0002\u0016&\u0019\u00111S-\u0003\u000b\u0005\u0013(/Y=\u0011\u0007a\u000b9*C\u0002\u0002\u001af\u0013AAQ=uK\"9\u0011Q\u0010\tA\u0002\u0005}\u0004bBAP!\u0001\u0007\u0011\u0011M\u0001\u0016a\u0006\u0014H/\u001b;j_:\u0014VmZ5tiJ\fG/[8o\u0011\u001d\t\u0019\u000b\u0005a\u0001\u0003K\u000bqbY8oiJ|G\u000e\\3s\u000bB|7\r\u001b\t\u00041\u0006\u001d\u0016bAAU3\n\u0019\u0011J\u001c;\u00023\r\u0014X-\u0019;f)>\u0004\u0018n\u0019)beRLG/[8o'R\fG/\u001a\u000b\t\u0003_\ny+!-\u00024\"9\u0011QP\tA\u0002\u0005}\u0004bBAP#\u0001\u0007\u0011\u0011\r\u0005\b\u0003G\u000b\u0002\u0019AAS\u0003e)\b\u000fZ1uKR{\u0007/[2QCJ$\u0018\u000e^5p]N#\u0018\r^3\u0015\u0011\u0005e\u0016qXAa\u0003\u0007\u0004B!!\u001d\u0002<&!\u0011QXA:\u00059\u0019V\r\u001e#bi\u0006\u0014V-];fgRDq!! \u0013\u0001\u0004\ty\bC\u0004\u0002 J\u0001\r!!\u0019\t\u000f\u0005\r&\u00031\u0001\u0002&\u0006)R\u000f\u001d3bi\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cH#\u0002$\u0002J\u0006=\u0007bBAf'\u0001\u0007\u0011QZ\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogB9!/!\u0018\u00024\u0005m\u0003\"\u0002(\u0014\u0001\u00041\u0015\u0001\u0006;ss^\u0013\u0018\u000e^3F]RLG/_\"p]\u001aLw\r\u0006\u0007\u0002V\u0006m\u0017q\\Ar\u0003[\f9\u0010\u0005\u0003Y\u0003/4\u0015bAAm3\n1q\n\u001d;j_:Dq!!8\u0015\u0001\u0004\t\u0019$\u0001\u0006f]RLG/\u001f+za\u0016Dq!!9\u0015\u0001\u0004\t\u0019$\u0001\u0003qCRD\u0007bBAs)\u0001\u0007\u0011q]\u0001\u0006aJ|\u0007o\u001d\t\u0004e\u0006%\u0018bAAv[\nQ\u0001K]8qKJ$\u0018.Z:\t\u000f\u0005=H\u00031\u0001\u0002r\u000611M]3bi\u0016\u00042\u0001WAz\u0013\r\t)0\u0017\u0002\b\u0005>|G.Z1o\u0011\u0015qE\u00031\u0001G\u0003E9(/\u001b;f\u00072LWM\u001c;Rk>$\u0018m\u001d\u000b\b\r\u0006u(1\u0001B\b\u0011\u001d\ty0\u0006a\u0001\u0005\u0003\ta!\u001a8uSRL\bc\u0002:\u0002^\u0005M\u00121\u0007\u0005\b\u0005\u000b)\u0002\u0019\u0001B\u0004\u0003\u0019\tXo\u001c;bgB9!/!\u0018\u00024\t%\u0001cA\u0011\u0003\f%\u0019!Q\u0002\u0012\u0003\r\u0011{WO\u00197f\u0011\u0015qU\u00031\u0001G\u0003=9(/\u001b;f!J|G-^2fe&#G#\u0002$\u0003\u0016\t}\u0001b\u0002B\f-\u0001\u0007!\u0011D\u0001\u000f]\u0016DH\u000f\u0015:pIV\u001cWM]%e!\rA&1D\u0005\u0004\u0005;I&\u0001\u0002'p]\u001eDQA\u0014\fA\u0002\u0019\u000bAb\u001e:ji\u0016\u001cuN\u001c4jON$rA\u0012B\u0013\u0005k\u0011I\u0004C\u0004\u0003(]\u0001\rA!\u000b\u0002\u0011I,7o\\;sG\u0016\u0004BAa\u000b\u000325\u0011!Q\u0006\u0006\u0005\u0005_\t\t&\u0001\u0004d_:4\u0017nZ\u0005\u0005\u0005g\u0011iC\u0001\bD_:4\u0017n\u001a*fg>,(oY3\t\u000f\t]r\u00031\u0001\u0003\u0002\u000591m\u001c8gS\u001e\u001c\b\"\u0002(\u0018\u0001\u00041\u0015!H<sSR,W*\u001a;bI\u0006$\u0018\rR3mi\u0006$vNW8pW\u0016,\u0007/\u001a:\u0015\u000f\u0019\u0013yDa\u0014\u0003X!9!\u0011\t\rA\u0002\t\r\u0013!\u00023fYR\f\u0007\u0003\u0002B#\u0005\u0017j!Aa\u0012\u000b\u0007\t%c&A\u0003j[\u0006<W-\u0003\u0003\u0003N\t\u001d#!D'fi\u0006$\u0017\r^1EK2$\u0018\rC\u0004\u0003Ja\u0001\rA!\u0015\u0011\t\t\u0015#1K\u0005\u0005\u0005+\u00129EA\u0007NKR\fG-\u0019;b\u00136\fw-\u001a\u0005\u0006\u001db\u0001\rA\u0012")
public class ZkMigrationClient
implements MigrationClient,
Logging {
    private final KafkaZkClient zkClient;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ZkMigrationLeadershipState getOrCreateMigrationRecoveryState(ZkMigrationLeadershipState initialState) {
        this.zkClient.createTopLevelPaths();
        return this.zkClient.getOrCreateMigrationState(initialState);
    }

    public ZkMigrationLeadershipState setMigrationRecoveryState(ZkMigrationLeadershipState state) {
        return this.zkClient.updateMigrationState(state);
    }

    public ZkMigrationLeadershipState claimControllerLeadership(ZkMigrationLeadershipState state) {
        KRaftRegistrationResult kRaftRegistrationResult = this.zkClient.tryRegisterKRaftControllerAsActiveController(state.kraftControllerId(), state.kraftControllerEpoch());
        if (kRaftRegistrationResult instanceof SuccessfulRegistrationResult) {
            SuccessfulRegistrationResult successfulRegistrationResult = (SuccessfulRegistrationResult)kRaftRegistrationResult;
            int controllerEpoch = successfulRegistrationResult.zkControllerEpoch();
            int controllerEpochZkVersion = successfulRegistrationResult.controllerEpochZkVersion();
            return state.withZkController(controllerEpoch, controllerEpochZkVersion);
        }
        if (kRaftRegistrationResult instanceof FailedRegistrationResult) {
            return state.withUnknownZkController();
        }
        throw new MatchError((Object)kRaftRegistrationResult);
    }

    public ZkMigrationLeadershipState releaseControllerLeadership(ZkMigrationLeadershipState state) {
        try {
            this.zkClient.deleteController(state.zkControllerEpochZkVersion());
            return state.withUnknownZkController();
        }
        catch (ControllerMovedException controllerMovedException) {
            return state.withUnknownZkController();
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not release controller leadership due to underlying error", t);
        }
    }

    public void migrateTopics(MetadataVersion metadataVersion, Consumer<java.util.List<ApiMessageAndVersion>> recordConsumer, Consumer<Integer> brokerIdConsumer) {
        scala.collection.immutable.Set<String> topics = this.zkClient.getAllTopicsInCluster(this.zkClient.getAllTopicsInCluster$default$1());
        Map<String, Properties> topicConfigs = this.zkClient.getEntitiesConfigs(ConfigType$.MODULE$.Topic(), topics);
        this.zkClient.getReplicaAssignmentAndTopicIdForTopics(topics).foreach((Function1 & Serializable)x0$1 -> {
            ZkMigrationClient.$anonfun$migrateTopics$1(this, brokerIdConsumer, topicConfigs, recordConsumer, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void migrateBrokerConfigs(MetadataVersion metadataVersion, Consumer<java.util.List<ApiMessageAndVersion>> recordConsumer) {
        Seq<String> brokerEntities = this.zkClient.getAllEntitiesWithConfig(ConfigType$.MODULE$.Broker());
        ArrayList batch = new ArrayList();
        this.zkClient.getEntitiesConfigs(ConfigType$.MODULE$.Broker(), (scala.collection.immutable.Set<String>)brokerEntities.toSet()).foreach((Function1 & Serializable)x0$1 -> {
            ZkMigrationClient.$anonfun$migrateBrokerConfigs$1(batch, x0$1);
            return BoxedUnit.UNIT;
        });
        if (!batch.isEmpty()) {
            recordConsumer.accept(batch);
            return;
        }
    }

    public void migrateClientQuotas(MetadataVersion metadataVersion, Consumer<java.util.List<ApiMessageAndVersion>> recordConsumer) {
        AdminZkClient adminZkClient = new AdminZkClient(this.zkClient);
        String migrateEntityType$1_entityType = ConfigType$.MODULE$.User();
        adminZkClient.fetchAllEntityConfigs(migrateEntityType$1_entityType).foreach((Function1 & Serializable)x0$1 -> {
            ZkMigrationClient.$anonfun$migrateClientQuotas$1(migrateEntityType$1_entityType, recordConsumer, x0$1);
            return BoxedUnit.UNIT;
        });
        Object var4_4 = null;
        String migrateEntityType$1_entityType2 = ConfigType$.MODULE$.Client();
        adminZkClient.fetchAllEntityConfigs(migrateEntityType$1_entityType2).foreach((Function1 & Serializable)x0$1 -> {
            ZkMigrationClient.$anonfun$migrateClientQuotas$1(migrateEntityType$1_entityType, recordConsumer, x0$1);
            return BoxedUnit.UNIT;
        });
        Object var5_5 = null;
        adminZkClient.fetchAllChildEntityConfigs(ConfigType$.MODULE$.User(), ConfigType$.MODULE$.Client()).foreach((Function1 & Serializable)x0$1 -> {
            ZkMigrationClient.$anonfun$migrateClientQuotas$3(recordConsumer, x0$1);
            return BoxedUnit.UNIT;
        });
        String migrateEntityType$1_entityType3 = ConfigType$.MODULE$.Ip();
        adminZkClient.fetchAllEntityConfigs(migrateEntityType$1_entityType3).foreach((Function1 & Serializable)x0$1 -> {
            ZkMigrationClient.$anonfun$migrateClientQuotas$1(migrateEntityType$1_entityType, recordConsumer, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public void migrateProducerId(MetadataVersion metadataVersion, Consumer<java.util.List<ApiMessageAndVersion>> recordConsumer) {
        void var4_4;
        Tuple2<Option<byte[]>, Object> tuple2 = this.zkClient.getDataAndVersion("/latest_producer_id_block");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option dataOpt = (Option)tuple2._1();
        if (var4_4 instanceof Some) {
            byte[] data = (byte[])((Some)var4_4).value();
            ProducerIdsBlock producerIdBlock = ProducerIdBlockZNode$.MODULE$.parseProducerIdBlockData(data);
            recordConsumer.accept(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new ProducerIdsRecord().setBrokerEpoch(-1L).setBrokerId(producerIdBlock.assignedBrokerId()).setNextProducerId(producerIdBlock.firstProducerId()), 0), (List)Nil$.MODULE$)).asJava());
            return;
        }
        if (None$.MODULE$.equals(var4_4)) {
            return;
        }
        throw new MatchError((Object)var4_4);
    }

    public void readAllMetadata(Consumer<java.util.List<ApiMessageAndVersion>> batchConsumer, Consumer<Integer> brokerIdConsumer) {
        this.migrateTopics(MetadataVersion.latest(), batchConsumer, brokerIdConsumer);
        this.migrateBrokerConfigs(MetadataVersion.latest(), batchConsumer);
        this.migrateClientQuotas(MetadataVersion.latest(), batchConsumer);
        this.migrateProducerId(MetadataVersion.latest(), batchConsumer);
    }

    public java.util.Set<Integer> readBrokerIds() {
        return CollectionConverters$.MODULE$.SetHasAsJava((Set)((IterableOnceOps)this.zkClient.getSortedBrokerList().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).toSet()).asJava();
    }

    public java.util.Set<Integer> readBrokerIdsFromTopicAssignments() {
        scala.collection.immutable.Set<String> topics = this.zkClient.getAllTopicsInCluster(this.zkClient.getAllTopicsInCluster$default$1());
        scala.collection.immutable.Set<TopicZNode.TopicIdReplicaAssignment> replicaAssignmentAndTopicIds = this.zkClient.getReplicaAssignmentAndTopicIdForTopics(topics);
        HashSet<Integer> brokersWithAssignments = new HashSet<Integer>();
        replicaAssignmentAndTopicIds.foreach((Function1 & Serializable)x0$1 -> {
            ZkMigrationClient.$anonfun$readBrokerIdsFromTopicAssignments$1(brokersWithAssignments, x0$1);
            return BoxedUnit.UNIT;
        });
        return brokersWithAssignments;
    }

    /*
     * WARNING - void declaration
     */
    public ZkMigrationLeadershipState createTopic(String topicName, Uuid topicId, java.util.Map<Integer, PartitionRegistration> partitions, ZkMigrationLeadershipState state) {
        void var14_14;
        Iterable createPartitionZNodeReqs;
        scala.collection.mutable.Map assignments = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(partitions).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                void apply_removingReplicas;
                void apply_addingReplicas;
                Integer partitionId = (Integer)x0$1._1();
                PartitionRegistration partition = (PartitionRegistration)x0$1._2();
                ArraySeq.ofInt ofInt2 = Predef$.MODULE$.wrapIntArray(partition.removingReplicas);
                ArraySeq.ofInt ofInt3 = Predef$.MODULE$.wrapIntArray(partition.addingReplicas);
                ArraySeq.ofInt apply_replicas = Predef$.MODULE$.wrapIntArray(partition.replicas);
                Object var4_6 = null;
                ofInt3 = null;
                ofInt2 = null;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topicName, Predef$.MODULE$.Integer2int(partitionId))), (Object)new ReplicaAssignment((Seq<Object>)apply_replicas, (Seq<Object>)apply_addingReplicas, (Seq<Object>)apply_removingReplicas));
            }
            throw new MatchError(null);
        });
        String path = TopicZNode$.MODULE$.path(topicName);
        CreateRequest createTopicZNode = new CreateRequest(path, TopicZNode$.MODULE$.encode((Option<Uuid>)new Some((Object)topicId), (Map<TopicPartition, ReplicaAssignment>)assignments), this.zkClient.defaultAcls(path), CreateMode.PERSISTENT, (Option<Object>)None$.MODULE$);
        String path2 = TopicPartitionsZNode$.MODULE$.path(topicName);
        CreateRequest createPartitionsZNode = new CreateRequest(path2, null, this.zkClient.defaultAcls(path2), CreateMode.PERSISTENT, (Option<Object>)None$.MODULE$);
        Seq requests = (Seq)new .colon.colon((Object)createTopicZNode, (List)new .colon.colon((Object)createPartitionsZNode, (List)Nil$.MODULE$)).$plus$plus((IterableOnce)(createPartitionZNodeReqs = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(partitions).asScala().flatMap((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                Integer partitionId = (Integer)x0$2._1();
                PartitionRegistration partition = (PartitionRegistration)x0$2._2();
                TopicPartition topicPartition = new TopicPartition(topicName, Predef$.MODULE$.Integer2int(partitionId));
                return new .colon.colon((Object)this.createTopicPartition(topicPartition), (List)new .colon.colon((Object)this.createTopicPartitionState(topicPartition, partition, state.kraftControllerEpoch()), (List)Nil$.MODULE$));
            }
            throw new MatchError(null);
        })));
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = this.zkClient.retryMigrationRequestsUntilConnected(requests, state);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        scala.collection.immutable.Map resultCodes = ((IterableOnceOps)var14_14.map((Function1 & Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.path()), (Object)response.resultCode()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (((Enum)resultCodes.apply((Object)TopicZNode$.MODULE$.path(topicName))).equals(KeeperException.Code.NODEEXISTS)) {
            return state;
        }
        if (resultCodes.forall((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationClient.$anonfun$createTopic$4(x0$3)))) {
            void var13_13;
            return state.withMigrationZkVersion((int)var13_13);
        }
        throw new RuntimeException(new StringBuilder(60).append("Failed to create or update topic ").append(topicName).append(". ZK operation had results ").append(resultCodes).toString());
    }

    private CreateRequest createTopicPartition(TopicPartition topicPartition) {
        String path = TopicPartitionZNode$.MODULE$.path(topicPartition);
        return new CreateRequest(path, null, this.zkClient.defaultAcls(path), CreateMode.PERSISTENT, (Option<Object>)new Some((Object)topicPartition));
    }

    private Tuple2<String, byte[]> partitionStatePathAndData(TopicPartition topicPartition, PartitionRegistration partitionRegistration, int controllerEpoch) {
        String path = TopicPartitionStateZNode$.MODULE$.path(topicPartition);
        byte[] data = TopicPartitionStateZNode$.MODULE$.encode(new LeaderIsrAndControllerEpoch(new LeaderAndIsr(partitionRegistration.leader, partitionRegistration.leaderEpoch, (List<Object>)Predef$.MODULE$.wrapIntArray(partitionRegistration.isr).toList(), partitionRegistration.leaderRecoveryState, partitionRegistration.partitionEpoch), controllerEpoch));
        return new Tuple2((Object)path, (Object)data);
    }

    /*
     * WARNING - void declaration
     */
    private CreateRequest createTopicPartitionState(TopicPartition topicPartition, PartitionRegistration partitionRegistration, int controllerEpoch) {
        void var6_6;
        void var5_5;
        Tuple2<String, byte[]> tuple2 = this.partitionStatePathAndData(topicPartition, partitionRegistration, controllerEpoch);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String path = (String)tuple2._1();
        byte[] data = (byte[])tuple2._2();
        return new CreateRequest((String)var5_5, (byte[])var6_6, this.zkClient.defaultAcls((String)var5_5), CreateMode.PERSISTENT, (Option<Object>)new Some((Object)topicPartition));
    }

    /*
     * WARNING - void declaration
     */
    private SetDataRequest updateTopicPartitionState(TopicPartition topicPartition, PartitionRegistration partitionRegistration, int controllerEpoch) {
        void var6_6;
        void var5_5;
        Tuple2<String, byte[]> tuple2 = this.partitionStatePathAndData(topicPartition, partitionRegistration, controllerEpoch);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String path = (String)tuple2._1();
        byte[] data = (byte[])tuple2._2();
        return new SetDataRequest((String)var5_5, (byte[])var6_6, ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)new Some((Object)topicPartition));
    }

    /*
     * WARNING - void declaration
     */
    public ZkMigrationLeadershipState updateTopicPartitions(java.util.Map<String, java.util.Map<Integer, PartitionRegistration>> topicPartitions, ZkMigrationLeadershipState state) {
        void var6_6;
        Iterable requests = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(topicPartitions).asScala().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topicName = (String)x0$1._1();
                java.util.Map partitionRegistrations = (java.util.Map)x0$1._2();
                return (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(partitionRegistrations).asScala().flatMap((Function1 & Serializable)x0$2 -> {
                    if (x0$2 != null) {
                        Integer partitionId = (Integer)x0$2._1();
                        PartitionRegistration partitionRegistration = (PartitionRegistration)x0$2._2();
                        TopicPartition topicPartition = new TopicPartition(topicName, Predef$.MODULE$.Integer2int(partitionId));
                        return new .colon.colon((Object)this.updateTopicPartitionState(topicPartition, partitionRegistration, state.kraftControllerEpoch()), (List)Nil$.MODULE$);
                    }
                    throw new MatchError(null);
                });
            }
            throw new MatchError(null);
        });
        if (requests.isEmpty()) {
            return state;
        }
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = this.zkClient.retryMigrationRequestsUntilConnected(requests.toSeq(), state);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        scala.collection.immutable.Map resultCodes = ((IterableOnceOps)var6_6.map((Function1 & Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.path()), (Object)response.resultCode()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (resultCodes.forall((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationClient.$anonfun$updateTopicPartitions$4(x0$3)))) {
            void var5_5;
            return state.withMigrationZkVersion((int)var5_5);
        }
        throw new RuntimeException(new StringBuilder(64).append("Failed to update partition states: ").append(topicPartitions).append(". ZK transaction had results ").append(resultCodes).toString());
    }

    /*
     * WARNING - void declaration
     */
    public Option<ZkMigrationLeadershipState> tryWriteEntityConfig(String entityType, String path, Properties props, boolean create, ZkMigrationLeadershipState state) {
        void var10_10;
        byte[] configData = ConfigEntityZNode$.MODULE$.encode(props);
        .colon.colon requests = create ? new .colon.colon((Object)new CreateRequest(ConfigEntityZNode$.MODULE$.path(entityType, path), configData, this.zkClient.defaultAcls(path), CreateMode.PERSISTENT, (Option<Object>)None$.MODULE$), (List)Nil$.MODULE$) : new .colon.colon((Object)new SetDataRequest(ConfigEntityZNode$.MODULE$.path(entityType, path), configData, ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$), (List)Nil$.MODULE$);
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = this.zkClient.retryMigrationRequestsUntilConnected(requests, state);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        if (!create && ((AsyncResponse)var10_10.head()).resultCode().equals((Object)KeeperException.Code.NONODE)) {
            return None$.MODULE$;
        }
        if (((AsyncResponse)var10_10.head()).resultCode().equals((Object)KeeperException.Code.OK)) {
            void var9_9;
            return new Some((Object)state.withMigrationZkVersion((int)var9_9));
        }
        throw KeeperException.create((KeeperException.Code)((AsyncResponse)var10_10.head()).resultCode(), (String)path);
    }

    /*
     * WARNING - void declaration
     */
    public ZkMigrationLeadershipState writeClientQuotas(java.util.Map<String, String> entity, java.util.Map<String, Double> quotas, ZkMigrationLeadershipState state) {
        void var9_10;
        void var10_11;
        None$ none$;
        Some some;
        scala.collection.mutable.Map entityMap = CollectionConverters$.MODULE$.MapHasAsScala(entity).asScala();
        boolean hasUser = entityMap.contains((Object)"user");
        boolean hasClient = entityMap.contains((Object)"client-id");
        boolean hasIp = entityMap.contains((Object)"ip");
        Properties props = new Properties();
        quotas.forEach((x0$1, x1$1) -> props.put(x0$1, x1$1.toString()));
        if (hasUser && !hasClient) {
            some = new Some((Object)ConfigType$.MODULE$.User());
            none$ = new Some(entityMap.apply((Object)"user"));
        } else if (hasUser && hasClient) {
            some = new Some((Object)ConfigType$.MODULE$.User());
            none$ = new Some((Object)new StringBuilder(9).append(entityMap.apply((Object)"user")).append("/clients/").append(entityMap.apply((Object)"client-id")).toString());
        } else if (hasClient) {
            some = new Some((Object)ConfigType$.MODULE$.Client());
            none$ = new Some(entityMap.apply((Object)"client-id"));
        } else if (hasIp) {
            some = new Some((Object)ConfigType$.MODULE$.Ip());
            none$ = new Some(entityMap.apply((Object)"ip"));
        } else {
            some = None$.MODULE$;
            none$ = None$.MODULE$;
        }
        None$ none$2 = none$;
        Option configType = (Option)some;
        Option path = (Option)none$2;
        if (var10_11.isEmpty()) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("Skipping unknown client quota entity ").append(entity).toString());
            return state;
        }
        Option<ZkMigrationLeadershipState> option = this.tryWriteEntityConfig((String)var9_10.get(), (String)var10_11.get(), props, false, state);
        if (option instanceof Some) {
            return (ZkMigrationLeadershipState)((Some)option).value();
        }
        if (None$.MODULE$.equals(option)) {
            String createPath = hasUser && hasClient ? new StringBuilder(9).append(ConfigEntityTypeZNode$.MODULE$.path((String)var9_10.get())).append("/").append(entityMap.apply((Object)"user")).append("/clients").toString() : ConfigEntityTypeZNode$.MODULE$.path((String)var9_10.get());
            byte[] x$3 = this.zkClient.createRecursive$default$2();
            this.zkClient.createRecursive(createPath, x$3, false);
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(74).append("Recursively creating ZNode ").append(createPath).append(" and attempting to write ").append(entity).append(" quotas a second time.").toString());
            Option<ZkMigrationLeadershipState> option2 = this.tryWriteEntityConfig((String)var9_10.get(), (String)var10_11.get(), props, true, state);
            if (option2 instanceof Some) {
                return (ZkMigrationLeadershipState)((Some)option2).value();
            }
            if (None$.MODULE$.equals(option2)) {
                throw new RuntimeException(new StringBuilder(89).append("Could not write client quotas for ").append(entity).append(" on second attempt when using Create instead of SetData").toString());
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    /*
     * WARNING - void declaration
     */
    public ZkMigrationLeadershipState writeProducerId(long nextProducerId, ZkMigrationLeadershipState state) {
        void var7_6;
        byte[] newProducerIdBlockData = ProducerIdBlockZNode$.MODULE$.generateProducerIdBlockJson(new ProducerIdsBlock(-1, nextProducerId, 1000));
        SetDataRequest request = new SetDataRequest("/latest_producer_id_block", newProducerIdBlockData, ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$);
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = this.zkClient.retryMigrationRequestsUntilConnected(new .colon.colon((Object)request, (List)Nil$.MODULE$), state);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        return state.withMigrationZkVersion((int)var7_6);
    }

    public ZkMigrationLeadershipState writeConfigs(ConfigResource resource, java.util.Map<String, String> configs, ZkMigrationLeadershipState state) {
        ConfigResource.Type type = resource.type();
        Some configType = ConfigResource.Type.BROKER.equals(type) ? new Some((Object)ConfigType$.MODULE$.Broker()) : (ConfigResource.Type.TOPIC.equals(type) ? new Some((Object)ConfigType$.MODULE$.Topic()) : None$.MODULE$);
        String configName = resource.name();
        if (configType.isDefined()) {
            Properties props = new Properties();
            configs.forEach((x0$1, x1$1) -> props.put(x0$1, x1$1));
            Option<ZkMigrationLeadershipState> option = this.tryWriteEntityConfig((String)configType.get(), configName, props, false, state);
            if (option instanceof Some) {
                return (ZkMigrationLeadershipState)((Some)option).value();
            }
            if (None$.MODULE$.equals(option)) {
                String createPath = ConfigEntityTypeZNode$.MODULE$.path((String)configType.get());
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("Recursively creating ZNode ").append(createPath).append(" and attempting to write ").append(resource).append(" configs a second time.").toString());
                byte[] x$3 = this.zkClient.createRecursive$default$2();
                this.zkClient.createRecursive(createPath, x$3, false);
                Option<ZkMigrationLeadershipState> option2 = this.tryWriteEntityConfig((String)configType.get(), configName, props, true, state);
                if (option2 instanceof Some) {
                    return (ZkMigrationLeadershipState)((Some)option2).value();
                }
                if (None$.MODULE$.equals(option2)) {
                    throw new RuntimeException(new StringBuilder(80).append("Could not write ").append(configType.get()).append(" configs on second attempt when using Create instead of SetData.").toString());
                }
                throw new MatchError(option2);
            }
            throw new MatchError(option);
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Not updating ZK for ").append(resource).append(" since it is not a Broker or Topic entity.").toString());
        return state;
    }

    public ZkMigrationLeadershipState writeMetadataDeltaToZookeeper(MetadataDelta delta, MetadataImage image, ZkMigrationLeadershipState state) {
        return state;
    }

    public static final /* synthetic */ boolean $anonfun$migrateTopics$2(ZkMigrationClient $this, Consumer brokerIdConsumer$1, Option topicIdOpt$1, Map leaderIsrAndControllerEpochs$1, ArrayList topicBatch$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$2._1();
            ReplicaAssignment replicaAssignment = (ReplicaAssignment)x0$2._2();
            replicaAssignment.replicas().foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> brokerIdConsumer$1.accept(Predef$.MODULE$.int2Integer(x$1)));
            replicaAssignment.addingReplicas().foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> brokerIdConsumer$1.accept(Predef$.MODULE$.int2Integer(x$2)));
            java.util.List replicaList = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicaAssignment.replicas().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava();
            PartitionRecord record = new PartitionRecord().setTopicId((Uuid)topicIdOpt$1.get()).setPartitionId(topicPartition.partition()).setReplicas(replicaList).setAddingReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicaAssignment.addingReplicas().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setRemovingReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicaAssignment.removingReplicas().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava());
            Option option = leaderIsrAndControllerEpochs$1.get((Object)topicPartition);
            if (option instanceof Some) {
                LeaderIsrAndControllerEpoch leaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)((Some)option).value();
                record.setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)leaderIsrAndEpoch.leaderAndIsr().isr().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setLeader(leaderIsrAndEpoch.leaderAndIsr().leader()).setLeaderEpoch(leaderIsrAndEpoch.leaderAndIsr().leaderEpoch()).setPartitionEpoch(leaderIsrAndEpoch.leaderAndIsr().partitionEpoch()).setLeaderRecoveryState(leaderIsrAndEpoch.leaderAndIsr().leaderRecoveryState().value());
            } else if (None$.MODULE$.equals(option)) {
                $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(101).append("Could not find partition state in ZK for ").append(topicPartition).append(". Initializing this partition ").append("with ISR={").append(replicaList).append("} and leaderEpoch=0.").toString());
                record.setIsr(replicaList).setLeader(Predef$.MODULE$.Integer2int((Integer)replicaList.get(0))).setLeaderEpoch(0).setPartitionEpoch(0).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED.value());
            } else {
                throw new MatchError((Object)option);
            }
            return topicBatch$1.add(new ApiMessageAndVersion((ApiMessage)record, 0));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$migrateTopics$1(ZkMigrationClient $this, Consumer brokerIdConsumer$1, Map topicConfigs$1, Consumer recordConsumer$1, TopicZNode.TopicIdReplicaAssignment x0$1) {
        if (x0$1 != null) {
            String topic = x0$1.topic();
            Option<Uuid> topicIdOpt = x0$1.topicId();
            Map<TopicPartition, ReplicaAssignment> partitionAssignments = x0$1.assignment();
            scala.collection.immutable.Seq partitions = partitionAssignments.keys().toSeq();
            Map<TopicPartition, LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochs = $this.zkClient.getTopicPartitionStates((Seq<TopicPartition>)partitions);
            ArrayList<ApiMessageAndVersion> topicBatch = new ArrayList<ApiMessageAndVersion>();
            topicBatch.add(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName(topic).setTopicId((Uuid)topicIdOpt.get()), 0));
            partitionAssignments.foreach((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationClient.$anonfun$migrateTopics$2($this, brokerIdConsumer$1, topicIdOpt, leaderIsrAndControllerEpochs, topicBatch, x0$2)));
            ((Properties)topicConfigs$1.apply((Object)topic)).forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(x0$3, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$3, x1$1);
                if (x0$3 != null && x1$1 != null) {
                    topicBatch.add(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName(topic).setName(x0$3.toString()).setValue(x1$1.toString()), 0));
                    return;
                }
                throw new MatchError((Object)tuple2);
            }));
            recordConsumer$1.accept(topicBatch);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$migrateBrokerConfigs$1(ArrayList batch$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String broker = (String)x0$1._1();
            Properties props = (Properties)x0$1._2();
            String string = broker;
            String string2 = ConfigEntityName$.MODULE$.Default();
            String brokerResource = !(string != null ? !string.equals(string2) : string2 != null) ? "" : broker;
            props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(x0$2, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$2, x1$1);
                if (x0$2 != null && x1$1 != null) {
                    batch$1.add(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName(brokerResource).setName(x0$2.toString()).setValue(x1$1.toString()), 0));
                    return;
                }
                throw new MatchError((Object)tuple2);
            }));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$migrateClientQuotas$2(ArrayList batch$2, ClientQuotaRecord.EntityData entity$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            String key = (String)x0$2._1();
            double value = x0$2._2$mcD$sp();
            if (key != null) {
                return batch$2.add(new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)entity$1, (List)Nil$.MODULE$)).asJava()).setKey(key).setValue(value), 0));
            }
        }
        throw new MatchError((Object)x0$2);
    }

    public static final /* synthetic */ void $anonfun$migrateClientQuotas$1(String entityType$1, Consumer recordConsumer$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            String name = (String)x0$1._1();
            Properties props = (Properties)x0$1._2();
            ClientQuotaRecord.EntityData entity = new ClientQuotaRecord.EntityData().setEntityType(entityType$1).setEntityName(name);
            ArrayList batch = new ArrayList();
            ZkAdminManager$.MODULE$.clientQuotaPropsToDoubleMap((Map<String, String>)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala()).foreach((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationClient.$anonfun$migrateClientQuotas$2(batch, entity, x0$2)));
            recordConsumer$2.accept(batch);
            return;
        }
        throw new MatchError(null);
    }

    private static final void migrateEntityType$1(String entityType, AdminZkClient adminZkClient$1, Consumer recordConsumer$2) {
        adminZkClient$1.fetchAllEntityConfigs(entityType).foreach((Function1 & Serializable)x0$1 -> {
            ZkMigrationClient.$anonfun$migrateClientQuotas$1(migrateEntityType$1_entityType, recordConsumer, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$migrateClientQuotas$4(ArrayList batch$3, List entity$2, Tuple2 x0$2) {
        if (x0$2 != null) {
            String key = (String)x0$2._1();
            double value = x0$2._2$mcD$sp();
            if (key != null) {
                return batch$3.add(new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)entity$2).asJava()).setKey(key).setValue(value), 0));
            }
        }
        throw new MatchError((Object)x0$2);
    }

    public static final /* synthetic */ void $anonfun$migrateClientQuotas$3(Consumer recordConsumer$2, Tuple2 x0$1) {
        block2: {
            Object[] components;
            Properties props;
            block4: {
                String name;
                block3: {
                    if (x0$1 == null) break block2;
                    name = (String)x0$1._1();
                    props = (Properties)x0$1._2();
                    components = name.split("/");
                    if (ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(components)) != 3) break block3;
                    Object object = components[1];
                    String string = "clients";
                    if (object != null && object.equals(string)) break block4;
                }
                throw new IllegalArgumentException(new StringBuilder(24).append("Unexpected config path: ").append(name).toString());
            }
            .colon.colon entity = new .colon.colon((Object)new ClientQuotaRecord.EntityData().setEntityType(ConfigType$.MODULE$.User()).setEntityName((String)components[0]), (List)new .colon.colon((Object)new ClientQuotaRecord.EntityData().setEntityType(ConfigType$.MODULE$.Client()).setEntityName((String)components[2]), (List)Nil$.MODULE$));
            ArrayList batch = new ArrayList();
            ZkAdminManager$.MODULE$.clientQuotaPropsToDoubleMap((Map<String, String>)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala()).foreach(arg_0 -> ZkMigrationClient.$anonfun$migrateClientQuotas$4$adapted(batch, (List)entity, arg_0));
            recordConsumer$2.accept(batch);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$readBrokerIdsFromTopicAssignments$2(HashSet brokersWithAssignments$1, ReplicaAssignment assignment) {
        assignment.replicas().foreach((Function1)(JFunction1.mcZI.sp & Serializable)brokerId -> brokersWithAssignments$1.add(Predef$.MODULE$.int2Integer(brokerId)));
    }

    public static final /* synthetic */ void $anonfun$readBrokerIdsFromTopicAssignments$1(HashSet brokersWithAssignments$1, TopicZNode.TopicIdReplicaAssignment x0$1) {
        if (x0$1 != null) {
            x0$1.assignment().values().foreach((Function1 & Serializable)assignment -> {
                ZkMigrationClient.$anonfun$readBrokerIdsFromTopicAssignments$2(brokersWithAssignments$1, assignment);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$createTopic$4(Tuple2 x0$3) {
        if (x0$3 != null) {
            return ((KeeperException.Code)x0$3._2()).equals((Object)KeeperException.Code.OK);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$updateTopicPartitions$4(Tuple2 x0$3) {
        if (x0$3 != null) {
            return ((KeeperException.Code)x0$3._2()).equals((Object)KeeperException.Code.OK);
        }
        throw new MatchError(null);
    }

    public ZkMigrationClient(KafkaZkClient zkClient) {
        this.zkClient = zkClient;
    }

    public static final /* synthetic */ Object $anonfun$migrateClientQuotas$4$adapted(ArrayList batch$3, List entity$2, Tuple2 x0$2) {
        return BoxesRunTime.boxToBoolean((boolean)ZkMigrationClient.$anonfun$migrateClientQuotas$4(batch$3, entity$2, x0$2));
    }
}

