/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kafka.metrics.KafkaMetricsReporter$;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$;
import kafka.server.KafkaRaftServer$BrokerRole$;
import kafka.server.KafkaRaftServer$ControllerRole$;
import kafka.server.MetaProperties;
import kafka.server.Server;
import kafka.server.Server$;
import kafka.server.SharedServer;
import kafka.server.StandardFaultHandlerFactory;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Mx4jLoader$;
import kafka.utils.VerifiableProperties$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t5d\u0001B\u001e=\u0001\u0005C\u0001B\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\t-\u0002\u0011\t\u0011)A\u0005/\")1\r\u0001C\u0001I\"Q\u0001\u000e\u0001I\u0001\u0002\u0007\u0005\u000b\u0011B5\t\u0013\u0005E\u0001A1A\u0005\n\u0005M\u0001bBA\u000b\u0001\u0001\u0006I\u0001\u001c\u0005\n\u0003/\u0001!\u0019!C\u0005\u00033Aq!a\u0007\u0001A\u0003%q\u000eC\u0005\u0002\u001e\u0001\u0011\r\u0011\"\u0003\u0002 !9\u0011\u0011\u0005\u0001!\u0002\u00139\b\"CA\u0012\u0001\t\u0007I\u0011BA\u0013\u0011!\t\t\u0004\u0001Q\u0001\n\u0005\u001d\u0002\"CA\u001a\u0001\t\u0007I\u0011BA\u001b\u0011!\t\u0019\b\u0001Q\u0001\n\u0005]\u0002\"CA;\u0001\t\u0007I\u0011BA<\u0011!\ty\b\u0001Q\u0001\n\u0005e\u0004\"CAA\u0001\t\u0007I\u0011BAB\u0011!\t\t\n\u0001Q\u0001\n\u0005\u0015\u0005\"CAJ\u0001\t\u0007I\u0011BAK\u0011!\ty\n\u0001Q\u0001\n\u0005]\u0005bBAQ\u0001\u0011\u0005\u00131\u0015\u0005\b\u0003W\u0003A\u0011IAR\u0011\u001d\ti\u000b\u0001C!\u0003G;q!a,=\u0011\u0003\t\tL\u0002\u0004<y!\u0005\u00111\u0017\u0005\u0007Gf!\t!!.\t\u0013\u0005]\u0016D1A\u0005\u0002\u0005e\u0006\u0002CA`3\u0001\u0006I!a/\t\u0013\u0005\u0005\u0017D1A\u0005\u0002\u0005\r\u0007\u0002CAg3\u0001\u0006I!!2\t\u0013\u0005=\u0017D1A\u0005\u0002\u0005E\u0007\u0002CAm3\u0001\u0006I!a5\u0007\u0013\u0005m\u0017\u0004%A\u0012\"\u0005uwa\u0002B+3!\u0005%1\u0001\u0004\b\u0003CL\u0002\u0012QAr\u0011\u0019\u00197\u0005\"\u0001\u0003\u0002!9!QA\u0012\u0005B\t\u001d\u0001\"\u0003B\u0005G\u0005\u0005I\u0011IA]\u0011%\u0011YaIA\u0001\n\u0003\u0011i\u0001C\u0005\u0003\u0016\r\n\t\u0011\"\u0001\u0003\u0018!I!\u0011E\u0012\u0002\u0002\u0013\u0005#1\u0005\u0005\n\u0005W\u0019\u0013\u0011!C\u0001\u0005[A\u0011Ba\u000e$\u0003\u0003%\tE!\u000f\t\u0013\tm2%!A\u0005\n\tura\u0002B,3!\u0005%1\n\u0004\b\u0005\u000bJ\u0002\u0012\u0011B$\u0011\u0019\u0019g\u0006\"\u0001\u0003J!9!Q\u0001\u0018\u0005B\t\u001d\u0001\"\u0003B\u0005]\u0005\u0005I\u0011IA]\u0011%\u0011YALA\u0001\n\u0003\u0011i\u0001C\u0005\u0003\u00169\n\t\u0011\"\u0001\u0003N!I!\u0011\u0005\u0018\u0002\u0002\u0013\u0005#1\u0005\u0005\n\u0005Wq\u0013\u0011!C\u0001\u0005#B\u0011Ba\u000e/\u0003\u0003%\tE!\u000f\t\u0013\tmb&!A\u0005\n\tu\u0002b\u0002B-3\u0011\u0005!1\f\u0005\n\u0005?J\"\u0019!C\u0001\u0005CB\u0001Ba\u001b\u001aA\u0003%!1\r\u0002\u0010\u0017\u000647.\u0019*bMR\u001cVM\u001d<fe*\u0011QHP\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003}\nQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001\u0005\"c\u0005CA\"G\u001b\u0005!%\"A#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d#%AB!osJ+g\r\u0005\u0002J\u00156\tA(\u0003\u0002Ly\t11+\u001a:wKJ\u0004\"!\u0014)\u000e\u00039S!a\u0014 \u0002\u000bU$\u0018\u000e\\:\n\u0005Es%a\u0002'pO\u001eLgnZ\u0001\u0007G>tg-[4\u0011\u0005%#\u0016BA+=\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\tQLW.\u001a\t\u00031\u0006l\u0011!\u0017\u0006\u0003\u001fjS!a\u0017/\u0002\r\r|W.\\8o\u0015\tyTL\u0003\u0002_?\u00061\u0011\r]1dQ\u0016T\u0011\u0001Y\u0001\u0004_J<\u0017B\u00012Z\u0005\u0011!\u0016.\\3\u0002\rqJg.\u001b;?)\r)gm\u001a\t\u0003\u0013\u0002AQAU\u0002A\u0002MCQAV\u0002A\u0002]\u000b1\u0001\u001f\u00132!\u0015\u0019%\u000e\\8x\u0013\tYGI\u0001\u0004UkBdWm\r\t\u0003\u00136L!A\u001c\u001f\u0003\u001d5+G/\u0019)s_B,'\u000f^5fgB\u0011\u0001/^\u0007\u0002c*\u0011!o]\u0001\nE>|Go\u001d;sCBT!\u0001\u001e/\u0002\u00115,G/\u00193bi\u0006L!A^9\u0003#\t{w\u000e^:ue\u0006\u0004X*\u001a;bI\u0006$\u0018\rE\u0002ywvl\u0011!\u001f\u0006\u0003u\u0012\u000b!bY8mY\u0016\u001cG/[8o\u0013\ta\u0018PA\u0002TKF\u00042A`A\u0006\u001d\ry\u0018q\u0001\t\u0004\u0003\u0003!UBAA\u0002\u0015\r\t)\u0001Q\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005%A)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001b\tyA\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0013!\u0015!C7fi\u0006\u0004&o\u001c9t+\u0005a\u0017AC7fi\u0006\u0004&o\u001c9tA\u0005\t\"m\\8ugR\u0014\u0018\r]'fi\u0006$\u0017\r^1\u0016\u0003=\f!CY8piN$(/\u00199NKR\fG-\u0019;bA\u0005YqN\u001a4mS:,G)\u001b:t+\u00059\u0018\u0001D8gM2Lg.\u001a#jeN\u0004\u0013aB7fiJL7m]\u000b\u0003\u0003O\u0001B!!\u000b\u0002.5\u0011\u00111\u0006\u0006\u0004\u0003GQ\u0016\u0002BA\u0018\u0003W\u0011q!T3ue&\u001c7/\u0001\u0005nKR\u0014\u0018nY:!\u0003q\u0019wN\u001c;s_2dWM])v_J,XNV8uKJ\u001ch)\u001e;ve\u0016,\"!a\u000e\u0011\r\u0005e\u0012qIA&\u001b\t\tYD\u0003\u0003\u0002>\u0005}\u0012AC2p]\u000e,(O]3oi*!\u0011\u0011IA\"\u0003\u0011)H/\u001b7\u000b\u0005\u0005\u0015\u0013\u0001\u00026bm\u0006LA!!\u0013\u0002<\t\t2i\\7qY\u0016$\u0018M\u00197f\rV$XO]3\u0011\u0011\u00055\u0013qJA*\u0003?j!!a\u0010\n\t\u0005E\u0013q\b\u0002\u0004\u001b\u0006\u0004\b\u0003BA+\u00037j!!a\u0016\u000b\t\u0005e\u00131I\u0001\u0005Y\u0006tw-\u0003\u0003\u0002^\u0005]#aB%oi\u0016<WM\u001d\t\u0005\u0003C\niG\u0004\u0003\u0002d\u0005%TBAA3\u0015\r\t9\u0007X\u0001\u0005e\u00064G/\u0003\u0003\u0002l\u0005\u0015\u0014A\u0003*bMR\u001cuN\u001c4jO&!\u0011qNA9\u0005-\tE\r\u001a:fgN\u001c\u0006/Z2\u000b\t\u0005-\u0014QM\u0001\u001eG>tGO]8mY\u0016\u0014\u0018+^8sk64v\u000e^3sg\u001a+H/\u001e:fA\u0005a1\u000f[1sK\u0012\u001cVM\u001d<feV\u0011\u0011\u0011\u0010\t\u0004\u0013\u0006m\u0014bAA?y\ta1\u000b[1sK\u0012\u001cVM\u001d<fe\u0006i1\u000f[1sK\u0012\u001cVM\u001d<fe\u0002\naA\u0019:pW\u0016\u0014XCAAC!\u0015\u0019\u0015qQAF\u0013\r\tI\t\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007%\u000bi)C\u0002\u0002\u0010r\u0012AB\u0011:pW\u0016\u00148+\u001a:wKJ\fqA\u0019:pW\u0016\u0014\b%\u0001\u0006d_:$(o\u001c7mKJ,\"!a&\u0011\u000b\r\u000b9)!'\u0011\u0007%\u000bY*C\u0002\u0002\u001er\u0012\u0001cQ8oiJ|G\u000e\\3s'\u0016\u0014h/\u001a:\u0002\u0017\r|g\u000e\u001e:pY2,'\u000fI\u0001\bgR\f'\u000f^;q)\t\t)\u000bE\u0002D\u0003OK1!!+E\u0005\u0011)f.\u001b;\u0002\u0011MDW\u000f\u001e3po:\fQ\"Y<bSR\u001c\u0006.\u001e;e_^t\u0017aD&bM.\f'+\u00194u'\u0016\u0014h/\u001a:\u0011\u0005%K2CA\rC)\t\t\t,A\u0007NKR\fG-\u0019;b)>\u0004\u0018nY\u000b\u0003\u0003w\u0003B!!\u0016\u0002>&!\u0011QBA,\u00039iU\r^1eCR\fGk\u001c9jG\u0002\n\u0011#T3uC\u0012\fG/\u0019)beRLG/[8o+\t\t)\r\u0005\u0003\u0002H\u0006%W\"\u0001.\n\u0007\u0005-'L\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002%5+G/\u00193bi\u0006\u0004\u0016M\u001d;ji&|g\u000eI\u0001\u0010\u001b\u0016$\u0018\rZ1uCR{\u0007/[2JIV\u0011\u00111\u001b\t\u0005\u0003\u000f\f).C\u0002\u0002Xj\u0013A!V;jI\u0006\u0001R*\u001a;bI\u0006$\u0018\rV8qS\u000eLE\r\t\u0002\f!J|7-Z:t%>dWm\u0005\u0002\"\u0005&\u001a\u0011e\t\u0018\u0003\u0015\t\u0013xn[3s%>dWm\u0005\u0005$\u0005\u0006\u0015\u0018\u0011^Ax!\r\t9/I\u0007\u00023A\u00191)a;\n\u0007\u00055HIA\u0004Qe>$Wo\u0019;\u0011\t\u0005E\u00181 \b\u0005\u0003g\f9P\u0004\u0003\u0002\u0002\u0005U\u0018\"A#\n\u0007\u0005eH)A\u0004qC\u000e\\\u0017mZ3\n\t\u0005u\u0018q \u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0004\u0003s$EC\u0001B\u0002!\r\t9oI\u0001\ti>\u001cFO]5oOR\tQ0A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005\u001f\u00012a\u0011B\t\u0013\r\u0011\u0019\u0002\u0012\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u00053\u0011y\u0002E\u0002D\u00057I1A!\bE\u0005\r\te.\u001f\u0005\tQ\"\n\t\u00111\u0001\u0003\u0010\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003&A)\u0001Pa\n\u0003\u001a%\u0019!\u0011F=\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005_\u0011)\u0004E\u0002D\u0005cI1Aa\rE\u0005\u001d\u0011un\u001c7fC:D\u0001\u0002\u001b\u0016\u0002\u0002\u0003\u0007!\u0011D\u0001\tQ\u0006\u001c\bnQ8eKR\u0011!qB\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005\u007f\u0001B!!\u0016\u0003B%!!1IA,\u0005\u0019y%M[3di\nq1i\u001c8ue>dG.\u001a:S_2,7\u0003\u0003\u0018C\u0003K\fI/a<\u0015\u0005\t-\u0003cAAt]Q!!\u0011\u0004B(\u0011!A7'!AA\u0002\t=A\u0003\u0002B\u0018\u0005'B\u0001\u0002[\u001b\u0002\u0002\u0003\u0007!\u0011D\u0001\u000b\u0005J|7.\u001a:S_2,\u0017AD\"p]R\u0014x\u000e\u001c7feJ{G.Z\u0001\u0012S:LG/[1mSj,Gj\\4ESJ\u001cHcA5\u0003^!)!\u000b\u000fa\u0001'\u0006a1m\u001c8gS\u001e\u001c6\r[3nCV\u0011!1\r\t\u0005\u0005K\u00129'D\u0001t\u0013\r\u0011Ig\u001d\u0002\u0012\u0017\u000647.Y\"p]\u001aLwmU2iK6\f\u0017!D2p]\u001aLwmU2iK6\f\u0007\u0005")
public class KafkaRaftServer
implements Server,
Logging {
    private final KafkaConfig config;
    private final Time time;
    private final /* synthetic */ Tuple3 x$1;
    private final MetaProperties metaProps;
    private final BootstrapMetadata bootstrapMetadata;
    private final Seq<String> offlineDirs;
    private final Metrics metrics;
    private final CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final SharedServer sharedServer;
    private final Option<BrokerServer> broker;
    private final Option<ControllerServer> controller;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static KafkaConfigSchema configSchema() {
        return KafkaRaftServer$.MODULE$.configSchema();
    }

    public static Tuple3<MetaProperties, BootstrapMetadata, Seq<String>> initializeLogDirs(KafkaConfig config) {
        return KafkaRaftServer$.MODULE$.initializeLogDirs(config);
    }

    public static Uuid MetadataTopicId() {
        return KafkaRaftServer$.MODULE$.MetadataTopicId();
    }

    public static TopicPartition MetadataPartition() {
        return KafkaRaftServer$.MODULE$.MetadataPartition();
    }

    public static String MetadataTopic() {
        return KafkaRaftServer$.MODULE$.MetadataTopic();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private MetaProperties metaProps() {
        return this.metaProps;
    }

    private BootstrapMetadata bootstrapMetadata() {
        return this.bootstrapMetadata;
    }

    private Seq<String> offlineDirs() {
        return this.offlineDirs;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    private SharedServer sharedServer() {
        return this.sharedServer;
    }

    private Option<BrokerServer> broker() {
        return this.broker;
    }

    private Option<ControllerServer> controller() {
        return this.controller;
    }

    @Override
    public void startup() {
        Mx4jLoader$.MODULE$.maybeLoad();
        this.controller().foreach((Function1 & Serializable)x$2 -> {
            x$2.startup();
            return BoxedUnit.UNIT;
        });
        this.broker().foreach((Function1 & Serializable)x$3 -> {
            x$3.startup();
            return BoxedUnit.UNIT;
        });
        AppInfoParser.registerAppInfo((String)Server$.MODULE$.MetricsPrefix(), (String)Integer.toString(this.config.brokerId()), (Metrics)this.metrics(), (long)this.time.milliseconds());
        this.info((Function0<String>)(Function0 & Serializable)() -> KafkaBroker$.MODULE$.STARTED_MESSAGE());
    }

    @Override
    public void shutdown() {
        this.broker().foreach((Function1 & Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        this.controller().foreach((Function1 & Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> AppInfoParser.unregisterAppInfo((String)Server$.MODULE$.MetricsPrefix(), (String)Integer.toString($this.config.brokerId()), (Metrics)this.metrics()), this, Level.WARN);
    }

    @Override
    public void awaitShutdown() {
        this.broker().foreach((Function1 & Serializable)x$6 -> {
            x$6.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        this.controller().foreach((Function1 & Serializable)x$7 -> {
            x$7.awaitShutdown();
            return BoxedUnit.UNIT;
        });
    }

    public KafkaRaftServer(KafkaConfig config, Time time) {
        this.config = config;
        this.time = time;
        this.logIdent_$eq(new StringBuilder(26).append("[KafkaRaftServer nodeId=").append(config.nodeId()).append("] ").toString());
        KafkaMetricsReporter$.MODULE$.startReporters(VerifiableProperties$.MODULE$.apply(config.originals()));
        KafkaYammerMetrics.INSTANCE.configure(config.originals());
        Tuple3<MetaProperties, BootstrapMetadata, Seq<String>> tuple3 = KafkaRaftServer$.MODULE$.initializeLogDirs(config);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        MetaProperties metaProps = (MetaProperties)tuple3._1();
        BootstrapMetadata bootstrapMetadata = (BootstrapMetadata)tuple3._2();
        Seq offlineDirs = (Seq)tuple3._3();
        this.x$1 = new Tuple3((Object)metaProps, (Object)bootstrapMetadata, (Object)offlineDirs);
        this.metaProps = (MetaProperties)this.x$1._1();
        this.bootstrapMetadata = (BootstrapMetadata)this.x$1._2();
        this.offlineDirs = (Seq)this.x$1._3();
        this.metrics = Server$.MODULE$.initializeMetrics(config, time, this.metaProps().clusterId());
        this.controllerQuorumVotersFuture = CompletableFuture.completedFuture(RaftConfig.parseVoterConnections(config.quorumVoters()));
        this.sharedServer = new SharedServer(config, this.metaProps(), time, this.metrics(), this.controllerQuorumVotersFuture(), new StandardFaultHandlerFactory());
        this.broker = config.processRoles().contains((Object)KafkaRaftServer$BrokerRole$.MODULE$) ? new Some((Object)new BrokerServer(this.sharedServer(), this.offlineDirs())) : None$.MODULE$;
        this.controller = config.processRoles().contains((Object)KafkaRaftServer$ControllerRole$.MODULE$) ? new Some((Object)new ControllerServer(this.sharedServer(), KafkaRaftServer$.MODULE$.configSchema(), this.bootstrapMetadata())) : None$.MODULE$;
    }

    public static interface ProcessRole {
    }
}

