/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import kafka.network.SocketServer;
import kafka.server.AlterCredentialsTest;
import kafka.server.BaseRequestTest;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.message.AlterUserScramCredentialsRequestData;
import org.apache.kafka.common.message.AlterUserScramCredentialsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005e\u0001B\u0007\u000f\u0001MAQ\u0001\u0007\u0001\u0005\u0002eAQa\u0007\u0001\u0005BqAQ!\f\u0001\u0005B9Bqa\u0011\u0001C\u0002\u0013%A\t\u0003\u0004L\u0001\u0001\u0006I!\u0012\u0005\b\u0019\u0002\u0011\r\u0011\"\u0003E\u0011\u0019i\u0005\u0001)A\u0005\u000b\")a\n\u0001C\u0001\u001f\")\u0001\u000f\u0001C\u0001c\")a\u000f\u0001C\u0005o\"I\u0011\u0011\u0005\u0001\u0012\u0002\u0013%\u00111\u0005\u0005\b\u0003s\u0001A\u0011BA\u001e\u0005E\nE\u000e^3s+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKF,Xm\u001d;O_R\fU\u000f\u001e5pe&TX\r\u001a+fgRT!a\u0004\t\u0002\rM,'O^3s\u0015\u0005\t\u0012!B6bM.\f7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\f\u000e\u00039I!a\u0006\b\u0003\u001f\t\u000b7/\u001a*fcV,7\u000f\u001e+fgR\fa\u0001P5oSRtD#\u0001\u000e\u0011\u0005U\u0001\u0011a\u00062s_.,'\u000f\u0015:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t)\ti2\u0005\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0003V]&$\b\"\u0002\u0013\u0003\u0001\u0004)\u0013A\u00039s_B,'\u000f^5fgB\u0011aeK\u0007\u0002O)\u0011\u0001&K\u0001\u0005kRLGNC\u0001+\u0003\u0011Q\u0017M^1\n\u00051:#A\u0003)s_B,'\u000f^5fg\u000612N]1gi\u000e{g\u000e\u001e:pY2,'oQ8oM&<7\u000f\u0006\u00020kA\u0019\u0001gM\u0013\u000e\u0003ER!AM\u0010\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u00025c\t\u00191+Z9\t\u000bY\u001a\u0001\u0019A\u001c\u0002\u0011Q,7\u000f^%oM>\u0004\"\u0001O!\u000e\u0003eR!AO\u001e\u0002\u0007\u0005\u0004\u0018N\u0003\u0002={\u00059!.\u001e9ji\u0016\u0014(B\u0001 @\u0003\u0015QWO\\5u\u0015\u0005\u0001\u0015aA8sO&\u0011!)\u000f\u0002\t)\u0016\u001cH/\u00138g_\u0006)Qo]3scU\tQ\t\u0005\u0002G\u00136\tqI\u0003\u0002IS\u0005!A.\u00198h\u0013\tQuI\u0001\u0004TiJLgnZ\u0001\u0007kN,'/\r\u0011\u0002\u000bU\u001cXM\u001d\u001a\u0002\rU\u001cXM\u001d\u001a!\u0003u!Xm\u001d;BYR,'OT8uQ&twMT8u\u0003V$\bn\u001c:ju\u0016$GCA\u000fQ\u0011\u0015\t\u0006\u00021\u0001S\u0003\u0019\tXo\u001c:v[B\u00111K\u0017\b\u0003)b\u0003\"!V\u0010\u000e\u0003YS!a\u0016\n\u0002\rq\u0012xn\u001c;?\u0013\tIv$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0015nS!!W\u0010)\u0005!i\u0006C\u00010b\u001b\u0005y&B\u00011<\u0003\u0019\u0001\u0018M]1ng&\u0011!m\u0018\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\b\u0006\u0002\u0005eU.\u0004\"!\u001a5\u000e\u0003\u0019T!aZ0\u0002\u0011A\u0014xN^5eKJL!!\u001b4\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\tag.I\u0001n\u0003\u0015Y'/\u00194uC\u0005y\u0017A\u0001>l\u0003}!Xm\u001d;BYR,'oU8nKRD\u0017N\\4O_R\fU\u000f\u001e5pe&TX\r\u001a\u000b\u0003;IDQ!U\u0005A\u0002IC#!C/)\t%!'.\u001e\u0017\u0003Y:\fAe]3oI\u0006cG/\u001a:Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fcV,7\u000f\u001e\u000b\u0006q\u0006\u001d\u0011\u0011\u0003\t\u0004s\u0006\rQ\"\u0001>\u000b\u0005md\u0018\u0001\u0003:fcV,7\u000f^:\u000b\u0005ut\u0018AB2p[6|gN\u0003\u0002\u0012\u007f*\u0019\u0011\u0011A \u0002\r\u0005\u0004\u0018m\u00195f\u0013\r\t)A\u001f\u0002\"\u00032$XM]+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7OU3ta>t7/\u001a\u0005\b\u0003\u0013Q\u0001\u0019AA\u0006\u0003\u001d\u0011X-];fgR\u00042!_A\u0007\u0013\r\tyA\u001f\u0002!\u00032$XM]+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7OU3rk\u0016\u001cH\u000fC\u0005\u0002\u0014)\u0001\n\u00111\u0001\u0002\u0016\u0005a1o\\2lKR\u001cVM\u001d<feB!\u0011qCA\u000f\u001b\t\tIBC\u0002\u0002\u001cA\tqA\\3uo>\u00148.\u0003\u0003\u0002 \u0005e!\u0001D*pG.,GoU3sm\u0016\u0014\u0018AL:f]\u0012\fE\u000e^3s+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKF,Xm\u001d;%I\u00164\u0017-\u001e7uII*\"!!\n+\t\u0005U\u0011qE\u0016\u0003\u0003S\u0001B!a\u000b\u000265\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t$A\u0005v]\u000eDWmY6fI*\u0019\u00111G\u0010\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00028\u00055\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\t3\r[3dW\u0006cG.\u0012:s_J\u001c\u0018\t\u001c;fe&twm\u0011:fI\u0016tG/[1mgR9Q$!\u0010\u0002n\u0005u\u0004bBA \u0019\u0001\u0007\u0011\u0011I\u0001\u000fe\u0016\u001cX\u000f\u001c;t)>\u001c\u0005.Z2l!\u00151\u00131IA$\u0013\r\t)e\n\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002J\u0005\u001dd\u0002BA&\u0003CrA!!\u0014\u0002^9!\u0011qJA.\u001d\u0011\t\t&!\u0017\u000f\t\u0005M\u0013q\u000b\b\u0004+\u0006U\u0013\"\u0001!\n\u0007\u0005\u0005q(\u0003\u0002\u0012\u007f&\u0011QP`\u0005\u0004\u0003?b\u0018aB7fgN\fw-Z\u0005\u0005\u0003G\n)'A\u0013BYR,'/V:feN\u001b'/Y7De\u0016$WM\u001c;jC2\u001c(+Z:q_:\u001cX\rR1uC*\u0019\u0011q\f?\n\t\u0005%\u00141\u000e\u0002 \u00032$XM]+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7OU3tk2$(\u0002BA2\u0003KBq!a\u001c\r\u0001\u0004\t\t(A\u0007fqB,7\r^3e\u000bJ\u0014xN\u001d\t\u0005\u0003g\nI(\u0004\u0002\u0002v)\u0019\u0011q\u000f?\u0002\u0011A\u0014x\u000e^8d_2LA!a\u001f\u0002v\t1QI\u001d:peNDa!a \r\u0001\u0004\u0011\u0016AC2p]R,\u0007\u0010^'tO\u0002")
public class AlterUserScramCredentialsRequestNotAuthorizedTest
extends BaseRequestTest {
    private final String user1;
    private final String user2;

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put("controlled.shutdown.enable", "false");
        if (this.isKRaftTest()) {
            properties.put("authorizer.class.name", AlterCredentialsTest.TestStandardAuthorizer.class.getName());
        } else {
            properties.put("authorizer.class.name", AlterCredentialsTest.TestAuthorizer.class.getName());
        }
        properties.put("principal.builder.class", AlterCredentialsTest.TestPrincipalBuilderReturningUnauthorized.class.getName());
    }

    @Override
    public Seq<Properties> kraftControllerConfigs(TestInfo testInfo) {
        Seq<Properties> controllerConfigs = super.kraftControllerConfigs(testInfo);
        ((Hashtable)controllerConfigs.head()).put("authorizer.class.name", AlterCredentialsTest.TestStandardAuthorizer.class.getName());
        ((Hashtable)controllerConfigs.head()).put("principal.builder.class", AlterCredentialsTest.TestPrincipalBuilderReturningUnauthorized.class.getName());
        return controllerConfigs;
    }

    private String user1() {
        return this.user1;
    }

    private String user2() {
        return this.user2;
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterNothingNotAuthorized(String quorum) {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(new ArrayList()).setUpsertions(new ArrayList())).build();
        List results = this.sendAlterUserScramCredentialsRequest(request, this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)0, (int)results.size());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterSomethingNotAuthorized(String quorum) {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()))).setUpsertions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_512.type())))).build();
        List results = this.sendAlterUserScramCredentialsRequest(request, this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)2, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.CLUSTER_AUTHORIZATION_FAILED, "when not authorized");
    }

    private AlterUserScramCredentialsResponse sendAlterUserScramCredentialsRequest(AlterUserScramCredentialsRequest request, SocketServer socketServer) {
        return (AlterUserScramCredentialsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AlterUserScramCredentialsResponse.class));
    }

    private SocketServer sendAlterUserScramCredentialsRequest$default$2() {
        return this.adminSocketServer();
    }

    private void checkAllErrorsAlteringCredentials(List<AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult> resultsToCheck, Errors expectedError, String contextMsg) {
        Assertions.assertEquals((int)0, (int)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestNotAuthorizedTest.$anonfun$checkAllErrorsAlteringCredentials$1(expectedError, x$1)))).size(), (String)new StringBuilder(49).append("Expected all '").append(expectedError.name()).append("' errors when altering credentials ").append(contextMsg).toString());
    }

    public static final /* synthetic */ boolean $anonfun$checkAllErrorsAlteringCredentials$1(Errors expectedError$1, AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult x$1) {
        return x$1.errorCode() == expectedError$1.code();
    }

    public AlterUserScramCredentialsRequestNotAuthorizedTest() {
        this.user1 = "user1";
        this.user2 = "user2";
    }
}

