/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import kafka.metrics.KafkaMetricsReporter$;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$;
import kafka.server.Server;
import kafka.server.Server$;
import kafka.server.SharedServer;
import kafka.server.StandardFaultHandlerFactory;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Mx4jLoader$;
import kafka.utils.VerifiableProperties$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.properties.MetaPropertiesEnsemble;
import org.apache.kafka.raft.QuorumConfig;
import org.apache.kafka.server.ProcessRole;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005%e\u0001\u0002\u0011\"\u0001\u0019B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\tw\u0001\u0011\t\u0011)A\u0005y!)\u0001\n\u0001C\u0001\u0013\"QQ\n\u0001I\u0001\u0002\u0007\u0005\u000b\u0011\u0002(\t\u000f}\u0003!\u0019!C\u0005A\"1\u0011\r\u0001Q\u0001\nECqA\u0019\u0001C\u0002\u0013%1\r\u0003\u0004e\u0001\u0001\u0006I!\u0017\u0005\bK\u0002\u0011\r\u0011\"\u0003g\u0011\u0019a\u0007\u0001)A\u0005O\"9Q\u000e\u0001b\u0001\n\u0013q\u0007B\u0002:\u0001A\u0003%q\u000eC\u0004t\u0001\t\u0007I\u0011\u0002;\t\rm\u0004\u0001\u0015!\u0003v\u0011\u001da\bA1A\u0005\nuDq!!\u0002\u0001A\u0003%a\u0010C\u0004\u0002\b\u0001!\t%!\u0003\t\u000f\u0005E\u0001\u0001\"\u0011\u0002\n!9\u00111\u0003\u0001\u0005B\u0005%qaBA\u000bC!\u0005\u0011q\u0003\u0004\u0007A\u0005B\t!!\u0007\t\r!+B\u0011AA\u000e\u0011%\ti\"\u0006b\u0001\n\u0003\ty\u0002\u0003\u0005\u00022U\u0001\u000b\u0011BA\u0011\u0011%\t\u0019$\u0006b\u0001\n\u0003\t)\u0004\u0003\u0005\u0002@U\u0001\u000b\u0011BA\u001c\u0011%\t\t%\u0006b\u0001\n\u0003\t\u0019\u0005\u0003\u0005\u0002LU\u0001\u000b\u0011BA#\u0011\u001d\ti%\u0006C\u0001\u0003\u001fB\u0011\"a\u001f\u0016\u0005\u0004%\t!! \t\u0011\u0005\u001dU\u0003)A\u0005\u0003\u007f\u0012qbS1gW\u0006\u0014\u0016M\u001a;TKJ4XM\u001d\u0006\u0003E\r\naa]3sm\u0016\u0014(\"\u0001\u0013\u0002\u000b-\fgm[1\u0004\u0001M!\u0001aJ\u00172!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0019\te.\u001f*fMB\u0011afL\u0007\u0002C%\u0011\u0001'\t\u0002\u0007'\u0016\u0014h/\u001a:\u0011\u0005I*T\"A\u001a\u000b\u0005Q\u001a\u0013!B;uS2\u001c\u0018B\u0001\u001c4\u0005\u001daunZ4j]\u001e\faaY8oM&<\u0007C\u0001\u0018:\u0013\tQ\u0014EA\u0006LC\u001a\\\u0017mQ8oM&<\u0017\u0001\u0002;j[\u0016\u0004\"!\u0010$\u000e\u0003yR!\u0001N \u000b\u0005\u0001\u000b\u0015AB2p[6|gN\u0003\u0002%\u0005*\u00111\tR\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\u000b1a\u001c:h\u0013\t9eH\u0001\u0003US6,\u0017A\u0002\u001fj]&$h\bF\u0002K\u00172\u0003\"A\f\u0001\t\u000b]\u001a\u0001\u0019\u0001\u001d\t\u000bm\u001a\u0001\u0019\u0001\u001f\u0002\u0007a$\u0013\u0007\u0005\u0003)\u001fFK\u0016B\u0001)*\u0005\u0019!V\u000f\u001d7feA\u0011!kV\u0007\u0002'*\u0011A+V\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c(B\u0001,B\u0003!iW\r^1eCR\f\u0017B\u0001-T\u0005YiU\r^1Qe>\u0004XM\u001d;jKN,en]3nE2,\u0007C\u0001.^\u001b\u0005Y&B\u0001/V\u0003%\u0011wn\u001c;tiJ\f\u0007/\u0003\u0002_7\n\t\"i\\8ugR\u0014\u0018\r]'fi\u0006$\u0017\r^1\u0002#5,G/\u0019)s_B\u001cXI\\:f[\ndW-F\u0001R\u0003IiW\r^1Qe>\u00048/\u00128tK6\u0014G.\u001a\u0011\u0002#\t|w\u000e^:ue\u0006\u0004X*\u001a;bI\u0006$\u0018-F\u0001Z\u0003I\u0011wn\u001c;tiJ\f\u0007/T3uC\u0012\fG/\u0019\u0011\u0002\u000f5,GO]5dgV\tq\r\u0005\u0002iU6\t\u0011N\u0003\u0002f\u007f%\u00111.\u001b\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013\u0001D:iCJ,GmU3sm\u0016\u0014X#A8\u0011\u00059\u0002\u0018BA9\"\u00051\u0019\u0006.\u0019:fIN+'O^3s\u00035\u0019\b.\u0019:fIN+'O^3sA\u00051!M]8lKJ,\u0012!\u001e\t\u0004QYD\u0018BA<*\u0005\u0019y\u0005\u000f^5p]B\u0011a&_\u0005\u0003u\u0006\u0012AB\u0011:pW\u0016\u00148+\u001a:wKJ\fqA\u0019:pW\u0016\u0014\b%\u0001\u0006d_:$(o\u001c7mKJ,\u0012A \t\u0004QY|\bc\u0001\u0018\u0002\u0002%\u0019\u00111A\u0011\u0003!\r{g\u000e\u001e:pY2,'oU3sm\u0016\u0014\u0018aC2p]R\u0014x\u000e\u001c7fe\u0002\nqa\u001d;beR,\b\u000f\u0006\u0002\u0002\fA\u0019\u0001&!\u0004\n\u0007\u0005=\u0011F\u0001\u0003V]&$\u0018\u0001C:ikR$wn\u001e8\u0002\u001b\u0005<\u0018-\u001b;TQV$Hm\\<o\u0003=Y\u0015MZ6b%\u00064GoU3sm\u0016\u0014\bC\u0001\u0018\u0016'\t)r\u0005\u0006\u0002\u0002\u0018\u0005iQ*\u001a;bI\u0006$\u0018\rV8qS\u000e,\"!!\t\u0011\t\u0005\r\u0012QF\u0007\u0003\u0003KQA!a\n\u0002*\u0005!A.\u00198h\u0015\t\tY#\u0001\u0003kCZ\f\u0017\u0002BA\u0018\u0003K\u0011aa\u0015;sS:<\u0017AD'fi\u0006$\u0017\r^1U_BL7\rI\u0001\u0012\u001b\u0016$\u0018\rZ1uCB\u000b'\u000f^5uS>tWCAA\u001c!\u0011\tI$a\u000f\u000e\u0003}J1!!\u0010@\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f!#T3uC\u0012\fG/\u0019)beRLG/[8oA\u0005yQ*\u001a;bI\u0006$\u0018\rV8qS\u000eLE-\u0006\u0002\u0002FA!\u0011\u0011HA$\u0013\r\tIe\u0010\u0002\u0005+VLG-\u0001\tNKR\fG-\u0019;b)>\u0004\u0018nY%eA\u0005\t\u0012N\\5uS\u0006d\u0017N_3M_\u001e$\u0015N]:\u0015\u000f9\u000b\t&a\u0015\u0002d!)q'\ba\u0001q!9\u0011QK\u000fA\u0002\u0005]\u0013a\u00017pOB!\u0011\u0011LA0\u001b\t\tYFC\u0002\u0002^\u0011\u000bQa\u001d7gi)LA!!\u0019\u0002\\\t1Aj\\4hKJDq!!\u001a\u001e\u0001\u0004\t9'A\u0005m_\u001e\u0004&/\u001a4jqB!\u0011\u0011NA<\u001d\u0011\tY'a\u001d\u0011\u0007\u00055\u0014&\u0004\u0002\u0002p)\u0019\u0011\u0011O\u0013\u0002\rq\u0012xn\u001c;?\u0013\r\t)(K\u0001\u0007!J,G-\u001a4\n\t\u0005=\u0012\u0011\u0010\u0006\u0004\u0003kJ\u0013\u0001D2p]\u001aLwmU2iK6\fWCAA@!\u0011\t\t)a!\u000e\u0003UK1!!\"V\u0005EY\u0015MZ6b\u0007>tg-[4TG\",W.Y\u0001\u000eG>tg-[4TG\",W.\u0019\u0011")
public class KafkaRaftServer
implements Server,
Logging {
    private final KafkaConfig config;
    private final Time time;
    private final /* synthetic */ Tuple2 x$1;
    private final MetaPropertiesEnsemble metaPropsEnsemble;
    private final BootstrapMetadata bootstrapMetadata;
    private final Metrics metrics;
    private final SharedServer sharedServer;
    private final Option<BrokerServer> broker;
    private final Option<ControllerServer> controller;
    private com.typesafe.scalalogging.Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static KafkaConfigSchema configSchema() {
        return KafkaRaftServer$.MODULE$.configSchema();
    }

    public static Tuple2<MetaPropertiesEnsemble, BootstrapMetadata> initializeLogDirs(KafkaConfig config, Logger log, String logPrefix) {
        return KafkaRaftServer$.MODULE$.initializeLogDirs(config, log, logPrefix);
    }

    public static Uuid MetadataTopicId() {
        return KafkaRaftServer$.MODULE$.MetadataTopicId();
    }

    public static TopicPartition MetadataPartition() {
        return KafkaRaftServer$.MODULE$.MetadataPartition();
    }

    public static String MetadataTopic() {
        return KafkaRaftServer$.MODULE$.MetadataTopic();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private com.typesafe.scalalogging.Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public com.typesafe.scalalogging.Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private MetaPropertiesEnsemble metaPropsEnsemble() {
        return this.metaPropsEnsemble;
    }

    private BootstrapMetadata bootstrapMetadata() {
        return this.bootstrapMetadata;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private SharedServer sharedServer() {
        return this.sharedServer;
    }

    private Option<BrokerServer> broker() {
        return this.broker;
    }

    private Option<ControllerServer> controller() {
        return this.controller;
    }

    @Override
    public void startup() {
        Mx4jLoader$.MODULE$.maybeLoad();
        this.controller().foreach((Function1 & Serializable)x$2 -> {
            x$2.startup();
            return BoxedUnit.UNIT;
        });
        this.broker().foreach((Function1 & Serializable)x$3 -> {
            x$3.startup();
            return BoxedUnit.UNIT;
        });
        AppInfoParser.registerAppInfo((String)Server$.MODULE$.MetricsPrefix(), (String)Integer.toString(this.config.brokerId()), (Metrics)this.metrics(), (long)this.time.milliseconds());
        this.info((Function0<String>)(Function0 & Serializable)() -> KafkaBroker$.MODULE$.STARTED_MESSAGE());
    }

    @Override
    public void shutdown() {
        this.broker().foreach((Function1 & Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        this.controller().foreach((Function1 & Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> AppInfoParser.unregisterAppInfo((String)Server$.MODULE$.MetricsPrefix(), (String)Integer.toString($this.config.brokerId()), (Metrics)this.metrics()), this, Level.WARN);
    }

    @Override
    public void awaitShutdown() {
        this.broker().foreach((Function1 & Serializable)x$6 -> {
            x$6.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        this.controller().foreach((Function1 & Serializable)x$7 -> {
            x$7.awaitShutdown();
            return BoxedUnit.UNIT;
        });
    }

    public KafkaRaftServer(KafkaConfig config, Time time) {
        this.config = config;
        this.time = time;
        this.logIdent_$eq(new StringBuilder(26).append("[KafkaRaftServer nodeId=").append(config.nodeId()).append("] ").toString());
        KafkaMetricsReporter$.MODULE$.startReporters(VerifiableProperties$.MODULE$.apply(config.originals()));
        KafkaYammerMetrics.INSTANCE.configure(config.originals());
        Tuple2<MetaPropertiesEnsemble, BootstrapMetadata> tuple2 = KafkaRaftServer$.MODULE$.initializeLogDirs(config, this.logger().underlying(), this.logIdent());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        MetaPropertiesEnsemble metaPropsEnsemble = (MetaPropertiesEnsemble)tuple2._1();
        BootstrapMetadata bootstrapMetadata = (BootstrapMetadata)tuple2._2();
        this.x$1 = new Tuple2((Object)metaPropsEnsemble, (Object)bootstrapMetadata);
        this.metaPropsEnsemble = (MetaPropertiesEnsemble)this.x$1._1();
        this.bootstrapMetadata = (BootstrapMetadata)this.x$1._2();
        this.metrics = Server$.MODULE$.initializeMetrics(config, time, (String)this.metaPropsEnsemble().clusterId().get());
        this.sharedServer = new SharedServer(config, this.metaPropsEnsemble(), time, this.metrics(), CompletableFuture.completedFuture(QuorumConfig.parseVoterConnections(config.quorumVoters())), QuorumConfig.parseBootstrapServers(config.quorumBootstrapServers()), new StandardFaultHandlerFactory());
        this.broker = config.processRoles().contains((Object)ProcessRole.BrokerRole) ? new Some((Object)new BrokerServer(this.sharedServer())) : None$.MODULE$;
        this.controller = config.processRoles().contains((Object)ProcessRole.ControllerRole) ? new Some((Object)new ControllerServer(this.sharedServer(), KafkaRaftServer$.MODULE$.configSchema(), this.bootstrapMetadata())) : None$.MODULE$;
    }
}

