/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import kafka.api.LeaderAndIsr;
import kafka.server.AlterPartitionManager;
import kafka.server.IsrChangePropagationConfig;
import kafka.server.ZkAlterPartitionManager$;
import kafka.utils.Logging;
import kafka.utils.ReplicationUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidUpdateVersionException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.Scheduler;
import scala.Function0;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Set;
import scala.collection.mutable.HashSet;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005s!\u0002\f\u0018\u0011\u0003ab!\u0002\u0010\u0018\u0011\u0003y\u0002\"\u0002\u0014\u0002\t\u00039\u0003b\u0002\u0015\u0002\u0001\u0004%\t!\u000b\u0005\b[\u0005\u0001\r\u0011\"\u0001/\u0011\u0019!\u0014\u0001)Q\u0005U\u0019!ad\u0006\u0001:\u0011!\u0019eA!A!\u0002\u0013!\u0005\u0002\u0003)\u0007\u0005\u0003\u0005\u000b\u0011B)\t\u0011a3!\u0011!Q\u0001\neCQA\n\u0004\u0005\u0002}Cq\u0001\u001a\u0004C\u0002\u0013%\u0011\u0006\u0003\u0004f\r\u0001\u0006IA\u000b\u0005\tM\u001a\u0011\r\u0011\"\u0001\u0018O\"1AO\u0002Q\u0001\n!Dq!\u001e\u0004C\u0002\u0013%a\u000fC\u0004\u0002\u0006\u0019\u0001\u000b\u0011B<\t\u0011\u0005\u001daA1A\u0005\nYDq!!\u0003\u0007A\u0003%q\u000fC\u0004\u0002\f\u0019!\t%!\u0004\t\u000f\u0005=a\u0001\"\u0011\u0002\u0012!A\u0011q\b\u0004\u0005\u0002]\ti!A\f[W\u0006cG/\u001a:QCJ$\u0018\u000e^5p]6\u000bg.Y4fe*\u0011\u0001$G\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003i\tQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002\u001e\u00035\tqCA\f[W\u0006cG/\u001a:QCJ$\u0018\u000e^5p]6\u000bg.Y4feN\u0011\u0011\u0001\t\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005a\u0012a\u0007#fM\u0006,H\u000e^%teB\u0013x\u000e]1hCRLwN\\\"p]\u001aLw-F\u0001+!\ti2&\u0003\u0002-/\tQ\u0012j\u001d:DQ\u0006tw-\u001a)s_B\fw-\u0019;j_:\u001cuN\u001c4jO\u0006yB)\u001a4bk2$\u0018j\u001d:Qe>\u0004\u0018mZ1uS>t7i\u001c8gS\u001e|F%Z9\u0015\u0005=\u0012\u0004CA\u00111\u0013\t\t$E\u0001\u0003V]&$\bbB\u001a\u0005\u0003\u0003\u0005\rAK\u0001\u0004q\u0012\n\u0014\u0001\b#fM\u0006,H\u000e^%teB\u0013x\u000e]1hCRLwN\\\"p]\u001aLw\r\t\u0015\u0003\u000bY\u0002\"!I\u001c\n\u0005a\u0012#\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0014\t\u0019\u0001#(\u0010\t\u0003;mJ!\u0001P\f\u0003+\u0005cG/\u001a:QCJ$\u0018\u000e^5p]6\u000bg.Y4feB\u0011a(Q\u0007\u0002\u007f)\u0011\u0001)G\u0001\u0006kRLGn]\u0005\u0003\u0005~\u0012q\u0001T8hO&tw-A\u0005tG\",G-\u001e7feB\u0011QIT\u0007\u0002\r*\u0011q\tS\u0001\u0005kRLGN\u0003\u0002\u0019\u0013*\u0011!D\u0013\u0006\u0003\u00172\u000ba!\u00199bG\",'\"A'\u0002\u0007=\u0014x-\u0003\u0002P\r\nI1k\u00195fIVdWM]\u0001\u0005i&lW\r\u0005\u0002S-6\t1K\u0003\u0002A)*\u0011Q+S\u0001\u0007G>lWn\u001c8\n\u0005]\u001b&\u0001\u0002+j[\u0016\f\u0001B_6DY&,g\u000e\u001e\t\u00035vk\u0011a\u0017\u0006\u00039f\t!A_6\n\u0005y[&!D&bM.\f'l[\"mS\u0016tG\u000f\u0006\u0003aC\n\u001c\u0007CA\u000f\u0007\u0011\u0015\u0019%\u00021\u0001E\u0011\u0015\u0001&\u00021\u0001R\u0011\u0015A&\u00021\u0001Z\u0003mI7O]\"iC:<WMT8uS\u001aL7-\u0019;j_:\u001cuN\u001c4jO\u0006a\u0012n\u001d:DQ\u0006tw-\u001a(pi&4\u0017nY1uS>t7i\u001c8gS\u001e\u0004\u0013\u0001D5te\u000eC\u0017M\\4f'\u0016$X#\u00015\u0011\u0007%t\u0007/D\u0001k\u0015\tYG.A\u0004nkR\f'\r\\3\u000b\u00055\u0014\u0013AC2pY2,7\r^5p]&\u0011qN\u001b\u0002\u0004'\u0016$\bCA9s\u001b\u0005!\u0016BA:U\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fQ\"[:s\u0007\"\fgnZ3TKR\u0004\u0013a\u00047bgRL5O]\"iC:<W-T:\u0016\u0003]\u00042\u0001_A\u0001\u001b\u0005I(B\u0001>|\u0003\u0019\tGo\\7jG*\u0011A0`\u0001\u000bG>t7-\u001e:sK:$(BA$\u007f\u0015\u0005y\u0018\u0001\u00026bm\u0006L1!a\u0001z\u0005)\tEo\\7jG2{gnZ\u0001\u0011Y\u0006\u001cH/S:s\u0007\"\fgnZ3Ng\u0002\nA\u0003\\1ti&\u001b(\u000f\u0015:pa\u0006<\u0017\r^5p]6\u001b\u0018!\u00067bgRL5O\u001d)s_B\fw-\u0019;j_:l5\u000fI\u0001\u0006gR\f'\u000f\u001e\u000b\u0002_\u000511/\u001e2nSR$\u0002\"a\u0005\u0002(\u0005E\u0012Q\u0007\t\u0007\u0003+\t9\"a\u0007\u000e\u0003mL1!!\u0007|\u0005E\u0019u.\u001c9mKR\f'\r\\3GkR,(/\u001a\t\u0005\u0003;\t\u0019#\u0004\u0002\u0002 )\u0019\u0011\u0011E\r\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002&\u0005}!\u0001\u0004'fC\u0012,'/\u00118e\u0013N\u0014\bbBA\u0015)\u0001\u0007\u00111F\u0001\u0011i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u00042!]A\u0017\u0013\r\ty\u0003\u0016\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:Dq!a\r\u0015\u0001\u0004\tY\"\u0001\u0007mK\u0006$WM]!oI&\u001b(\u000fC\u0004\u00028Q\u0001\r!!\u000f\u0002\u001f\r|g\u000e\u001e:pY2,'/\u00129pG\"\u00042!IA\u001e\u0013\r\tiD\t\u0002\u0004\u0013:$\u0018\u0001G7bs\n,\u0007K]8qC\u001e\fG/Z%te\u000eC\u0017M\\4fg\u0002")
public class ZkAlterPartitionManager
implements AlterPartitionManager,
Logging {
    private final Scheduler scheduler;
    private final Time time;
    private final KafkaZkClient zkClient;
    private final IsrChangePropagationConfig isrChangeNotificationConfig;
    private final scala.collection.mutable.Set<TopicPartition> isrChangeSet;
    private final AtomicLong lastIsrChangeMs;
    private final AtomicLong lastIsrPropagationMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void DefaultIsrPropagationConfig_$eq(IsrChangePropagationConfig x$1) {
        ZkAlterPartitionManager$.MODULE$.DefaultIsrPropagationConfig_$eq(x$1);
    }

    public static IsrChangePropagationConfig DefaultIsrPropagationConfig() {
        return ZkAlterPartitionManager$.MODULE$.DefaultIsrPropagationConfig();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public void shutdown() {
        AlterPartitionManager.shutdown$(this);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private IsrChangePropagationConfig isrChangeNotificationConfig() {
        return this.isrChangeNotificationConfig;
    }

    public scala.collection.mutable.Set<TopicPartition> isrChangeSet() {
        return this.isrChangeSet;
    }

    private AtomicLong lastIsrChangeMs() {
        return this.lastIsrChangeMs;
    }

    private AtomicLong lastIsrPropagationMs() {
        return this.lastIsrPropagationMs;
    }

    @Override
    public void start() {
        this.scheduler.schedule("isr-change-propagation", () -> this.maybePropagateIsrChanges(), 0L, this.isrChangeNotificationConfig().checkIntervalMs());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompletableFuture<LeaderAndIsr> submit(TopicIdPartition topicIdPartition, LeaderAndIsr leaderAndIsr, int controllerEpoch) {
        void var5_5;
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(58).append("Writing new ISR ").append(leaderAndIsr.isr()).append(" to ZooKeeper with version ").append(leaderAndIsr.partitionEpoch()).append(" for partition ").append(topicIdPartition).toString());
        Tuple2<Object, Object> tuple2 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkClient, topicIdPartition.topicPartition(), leaderAndIsr, controllerEpoch);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean updateSucceeded = tuple2._1$mcZ$sp();
        int newVersion = tuple2._2$mcI$sp();
        CompletableFuture<LeaderAndIsr> future = new CompletableFuture<LeaderAndIsr>();
        if (var5_5 != false) {
            void var6_6;
            scala.collection.mutable.Set<TopicPartition> set = this.isrChangeSet();
            synchronized (set) {
                this.isrChangeSet().$plus$eq((Object)topicIdPartition.topicPartition());
                this.lastIsrChangeMs().set(this.time.milliseconds());
            }
            future.complete(leaderAndIsr.withPartitionEpoch((int)var6_6));
        } else {
            future.completeExceptionally((Throwable)new InvalidUpdateVersionException(new StringBuilder(86).append("ISR update ").append(leaderAndIsr).append(" for partition ").append(topicIdPartition).append(" with controller epoch ").append(controllerEpoch).append(" ").append("failed with an invalid version error").toString()));
        }
        return future;
    }

    public void maybePropagateIsrChanges() {
        long now = this.time.milliseconds();
        scala.collection.mutable.Set<TopicPartition> set = this.isrChangeSet();
        synchronized (set) {
            if (this.isrChangeSet().nonEmpty() && (this.lastIsrChangeMs().get() + this.isrChangeNotificationConfig().lingerMs() < now || this.lastIsrPropagationMs().get() + this.isrChangeNotificationConfig().maxDelayMs() < now)) {
                this.zkClient.propagateIsrChanges((Set<TopicPartition>)this.isrChangeSet());
                this.isrChangeSet().clear();
                this.lastIsrPropagationMs().set(now);
            }
            return;
        }
    }

    public ZkAlterPartitionManager(Scheduler scheduler, Time time, KafkaZkClient zkClient) {
        this.scheduler = scheduler;
        this.time = time;
        this.zkClient = zkClient;
        this.isrChangeNotificationConfig = ZkAlterPartitionManager$.MODULE$.DefaultIsrPropagationConfig();
        this.isrChangeSet = new HashSet();
        this.lastIsrChangeMs = new AtomicLong(time.milliseconds());
        this.lastIsrPropagationMs = new AtomicLong(time.milliseconds());
    }
}

