/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.common.TopicAndPartition;
import kafka.log.Cleaner;
import kafka.log.CleanerConfig;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.Log;
import kafka.log.LogCleaner$;
import kafka.log.LogCleaner$CleanerThread$;
import kafka.log.LogCleanerManager;
import kafka.log.LogToClean;
import kafka.log.SkimpyOffsetMap;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.ShutdownableThread;
import kafka.utils.Throttler;
import kafka.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005]h\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h\u00072,\u0017M\\3s\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0015\u0001\u0001\u0002\u0005\f\u001d!\tIa\"D\u0001\u000b\u0015\tYA\"\u0001\u0003mC:<'\"A\u0007\u0002\t)\fg/Y\u0005\u0003\u001f)\u0011aa\u00142kK\u000e$\bCA\t\u0015\u001b\u0005\u0011\"BA\n\u0005\u0003\u0015)H/\u001b7t\u0013\t)\"CA\u0004M_\u001e<\u0017N\\4\u0011\u0005]QR\"\u0001\r\u000b\u0005e!\u0011aB7fiJL7m]\u0005\u00037a\u0011\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011\r\u0002!Q1A\u0005\u0002\u0011\naaY8oM&<W#A\u0013\u0011\u0005\u0019:S\"\u0001\u0002\n\u0005!\u0012!!D\"mK\u0006tWM]\"p]\u001aLw\r\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003&\u0003\u001d\u0019wN\u001c4jO\u0002B\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!L\u0001\bY><G)\u001b:t+\u0005q\u0003cA\u000f0c%\u0011\u0001G\b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003eUj\u0011a\r\u0006\u0003i1\t!![8\n\u0005Y\u001a$\u0001\u0002$jY\u0016D\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006IAL\u0001\tY><G)\u001b:tA!A!\b\u0001BC\u0002\u0013\u00051(\u0001\u0003m_\u001e\u001cX#\u0001\u001f\u0011\tEit(R\u0005\u0003}I\u0011A\u0001U8pYB\u0011\u0001iQ\u0007\u0002\u0003*\u0011!\tB\u0001\u0007G>lWn\u001c8\n\u0005\u0011\u000b%!\u0005+pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]B\u0011aER\u0005\u0003\u000f\n\u00111\u0001T8h\u0011!I\u0005A!A!\u0002\u0013a\u0014!\u00027pON\u0004\u0003\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\u0002\tQLW.\u001a\t\u0003#5K!A\u0014\n\u0003\tQKW.\u001a\u0005\u0006!\u0002!\t!U\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bI\u001bF+\u0016,\u0011\u0005\u0019\u0002\u0001\"B\u0012P\u0001\u0004)\u0003\"\u0002\u0017P\u0001\u0004q\u0003\"\u0002\u001eP\u0001\u0004a\u0004bB&P!\u0003\u0005\r\u0001\u0014\u0005\b1\u0002\u0011\r\u0011\"\u0003Z\u00039\u0019G.Z1oKJl\u0015M\\1hKJ,\u0012A\u0017\t\u0003MmK!\u0001\u0018\u0002\u0003#1{wm\u00117fC:,'/T1oC\u001e,'\u000f\u0003\u0004_\u0001\u0001\u0006IAW\u0001\u0010G2,\u0017M\\3s\u001b\u0006t\u0017mZ3sA!9\u0001\r\u0001b\u0001\n\u0013\t\u0017!\u0003;ie>$H\u000f\\3s+\u0005\u0011\u0007CA\td\u0013\t!'CA\u0005UQJ|G\u000f\u001e7fe\"1a\r\u0001Q\u0001\n\t\f!\u0002\u001e5s_R$H.\u001a:!\u0011\u001dA\u0007A1A\u0005\n%\f\u0001b\u00197fC:,'o]\u000b\u0002UB\u00191\u000e\u001d:\u000e\u00031T!!\u001c8\u0002\u0013%lW.\u001e;bE2,'BA8\u001f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003c2\u0014!\"\u00138eKb,GmU3r!\t\u0019H/D\u0001\u0001\r\u0011)\b\u0001\u0002<\u0003\u001b\rcW-\u00198feRC'/Z1e'\r!x\u000f\b\t\u0003#aL!!\u001f\n\u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\r\u001a\u0005\twR\u0014\t\u0011)A\u0005y\u0006AA\u000f\u001b:fC\u0012LE\r\u0005\u0002\u001e{&\u0011aP\b\u0002\u0004\u0013:$\bB\u0002)u\t\u0003\t\t\u0001F\u0002s\u0003\u0007AQa_@A\u0002qD\u0011\"a\u0002u\u0005\u0004%\t%!\u0003\u0002\u00151|wmZ3s\u001d\u0006lW-\u0006\u0002\u0002\fA\u0019\u0011\"!\u0004\n\u0007\u0005=!B\u0001\u0004TiJLgn\u001a\u0005\t\u0003'!\b\u0015!\u0003\u0002\f\u0005YAn\\4hKJt\u0015-\\3!\u0011%\t9\u0002\u001eb\u0001\n\u0003\tI\"A\u0004dY\u0016\fg.\u001a:\u0016\u0005\u0005m\u0001c\u0001\u0014\u0002\u001e%\u0019\u0011q\u0004\u0002\u0003\u000f\rcW-\u00198fe\"A\u00111\u0005;!\u0002\u0013\tY\"\u0001\u0005dY\u0016\fg.\u001a:!\u0011%\t9\u0003\u001ea\u0001\n\u0003\tI#A\u0005mCN$8\u000b^1ugV\u0011\u00111\u0006\t\u0004M\u00055\u0012bAA\u0018\u0005\ta1\t\\3b]\u0016\u00148\u000b^1ug\"I\u00111\u0007;A\u0002\u0013\u0005\u0011QG\u0001\u000eY\u0006\u001cHo\u0015;biN|F%Z9\u0015\t\u0005]\u0012Q\b\t\u0004;\u0005e\u0012bAA\u001e=\t!QK\\5u\u0011)\ty$!\r\u0002\u0002\u0003\u0007\u00111F\u0001\u0004q\u0012\n\u0004\u0002CA\"i\u0002\u0006K!a\u000b\u0002\u00151\f7\u000f^*uCR\u001c\b\u0005\u000b\u0003\u0002B\u0005\u001d\u0003cA\u000f\u0002J%\u0019\u00111\n\u0010\u0003\u0011Y|G.\u0019;jY\u0016Dq!a\u0014u\t\u0013\t\t&A\u0005dQ\u0016\u001c7\u000eR8oKR!\u0011qGA*\u0011\u001d\t)&!\u0014A\u0002}\n\u0011\u0003^8qS\u000e\fe\u000e\u001a)beRLG/[8o\u0011\u001d\tI\u0006\u001eC!\u00037\na\u0001Z8X_J\\GCAA\u001c\u0011\u001d\ty\u0006\u001eC\u0005\u00037\nAb\u00197fC:|%o\u00157fKBDq!a\u0019u\t\u0003\t)'A\u0006sK\u000e|'\u000fZ*uCR\u001cH\u0003DA\u001c\u0003O\nY'a\u001f\u0002\u0006\u0006%\u0005bBA5\u0003C\u0002\r\u0001`\u0001\u0003S\u0012D\u0001\"!\u001c\u0002b\u0001\u0007\u0011qN\u0001\u0005]\u0006lW\r\u0005\u0003\u0002r\u0005]dbA\u000f\u0002t%\u0019\u0011Q\u000f\u0010\u0002\rA\u0013X\rZ3g\u0013\u0011\ty!!\u001f\u000b\u0007\u0005Ud\u0004\u0003\u0005\u0002~\u0005\u0005\u0004\u0019AA@\u0003\u00111'o\\7\u0011\u0007u\t\t)C\u0002\u0002\u0004z\u0011A\u0001T8oO\"A\u0011qQA1\u0001\u0004\ty(\u0001\u0002u_\"A\u00111RA1\u0001\u0004\tY#A\u0003ti\u0006$8\u000fC\u0004\u0002\u0010\u0002\u0001\u000b\u0011\u00026\u0002\u0013\rdW-\u00198feN\u0004\u0003bBAJ\u0001\u0011\u0005\u00111L\u0001\bgR\f'\u000f^;q\u0011\u001d\t9\n\u0001C\u0001\u00037\n\u0001b\u001d5vi\u0012|wO\u001c\u0005\b\u00037\u0003A\u0011AAO\u00035\t'm\u001c:u\u00072,\u0017M\\5oOR!\u0011qGAP\u0011\u001d\t)&!'A\u0002}Bq!a)\u0001\t\u0003\t)+A\u000bbE>\u0014H/\u00118e!\u0006,8/Z\"mK\u0006t\u0017N\\4\u0015\t\u0005]\u0012q\u0015\u0005\b\u0003+\n\t\u000b1\u0001@\u0011\u001d\tY\u000b\u0001C\u0001\u0003[\u000baB]3tk6,7\t\\3b]&tw\r\u0006\u0003\u00028\u0005=\u0006bBA+\u0003S\u0003\ra\u0010\u0005\b\u0003g\u0003A\u0011AA[\u00031\tw/Y5u\u00072,\u0017M\\3e))\t9$a.\u0002<\u0006}\u00161\u0019\u0005\t\u0003s\u000b\t\f1\u0001\u0002p\u0005)Ao\u001c9jG\"9\u0011QXAY\u0001\u0004a\u0018\u0001\u00029beRD\u0001\"!1\u00022\u0002\u0007\u0011qP\u0001\u0007_\u001a47/\u001a;\t\u0015\u0005\u0015\u0017\u0011\u0017I\u0001\u0002\u0004\ty(A\u0004uS6,w.\u001e;\t\u0013\u0005%\u0007!%A\u0005\u0002\u0005-\u0017AF1xC&$8\t\\3b]\u0016$G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u00055'\u0006BA@\u0003\u001f\\#!!5\u0011\t\u0005M\u0017Q\\\u0007\u0003\u0003+TA!a6\u0002Z\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00037t\u0012AC1o]>$\u0018\r^5p]&!\u0011q\\Ak\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0004\n\u0003G\u0014\u0011\u0011!E\u0003\u0003K\f!\u0002T8h\u00072,\u0017M\\3s!\r1\u0013q\u001d\u0004\t\u0003\t\t\t\u0011#\u0002\u0002jN!\u0011q\u001d\u0005\u001d\u0011\u001d\u0001\u0016q\u001dC\u0001\u0003[$\"!!:\t\u0015\u0005E\u0018q]I\u0001\n\u0003\t\u00190\u0001\bj]&$H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005U(f\u0001'\u0002P\u0002")
public class LogCleaner
implements KafkaMetricsGroup {
    private final CleanerConfig config;
    private final File[] logDirs;
    private final Pool<TopicAndPartition, Log> logs;
    public final Time kafka$log$LogCleaner$$time;
    private final LogCleanerManager kafka$log$LogCleaner$$cleanerManager;
    private final Throttler kafka$log$LogCleaner$$throttler;
    private final IndexedSeq<CleanerThread> kafka$log$LogCleaner$$cleaners;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final Time init$default$4() {
        return LogCleaner$.MODULE$.init$default$4();
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        LogCleaner logCleaner = this;
        synchronized (logCleaner) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public CleanerConfig config() {
        return this.config;
    }

    public File[] logDirs() {
        return this.logDirs;
    }

    public Pool<TopicAndPartition, Log> logs() {
        return this.logs;
    }

    public final LogCleanerManager kafka$log$LogCleaner$$cleanerManager() {
        return this.kafka$log$LogCleaner$$cleanerManager;
    }

    public final Throttler kafka$log$LogCleaner$$throttler() {
        return this.kafka$log$LogCleaner$$throttler;
    }

    public final IndexedSeq<CleanerThread> kafka$log$LogCleaner$$cleaners() {
        return this.kafka$log$LogCleaner$$cleaners;
    }

    public void startup() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Starting the log cleaner";
            }
        });
        this.kafka$log$LogCleaner$$cleaners().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(CleanerThread cleanerThread) {
                cleanerThread.start();
            }
        });
    }

    public void shutdown() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Shutting down the log cleaner.";
            }
        });
        this.kafka$log$LogCleaner$$cleaners().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(CleanerThread cleanerThread) {
                cleanerThread.shutdown();
            }
        });
    }

    public void abortCleaning(TopicAndPartition topicAndPartition) {
        this.kafka$log$LogCleaner$$cleanerManager().abortCleaning(topicAndPartition);
    }

    public void abortAndPauseCleaning(TopicAndPartition topicAndPartition) {
        this.kafka$log$LogCleaner$$cleanerManager().abortAndPauseCleaning(topicAndPartition);
    }

    public void resumeCleaning(TopicAndPartition topicAndPartition) {
        this.kafka$log$LogCleaner$$cleanerManager().resumeCleaning(topicAndPartition);
    }

    public void awaitCleaned(String topic, int part, long offset, long timeout) {
        while (!this.kafka$log$LogCleaner$$cleanerManager().allCleanerCheckpoints().contains((Object)new TopicAndPartition(topic, part))) {
            Thread.sleep(10L);
        }
        return;
    }

    public long awaitCleaned$default$4() {
        return 30000L;
    }

    public LogCleaner(CleanerConfig config, File[] logDirs, Pool<TopicAndPartition, Log> logs, Time time) {
        this.config = config;
        this.logDirs = logDirs;
        this.logs = logs;
        this.kafka$log$LogCleaner$$time = time;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.kafka$log$LogCleaner$$cleanerManager = new LogCleanerManager(logDirs, logs);
        this.kafka$log$LogCleaner$$throttler = new Throttler(config.maxIoBytesPerSecond(), 300L, true, "cleaner-io", "bytes", time);
        this.kafka$log$LogCleaner$$cleaners = (IndexedSeq)Predef$.MODULE$.intWrapper(0).until(config.numThreads()).map((Function1)new $anonfun$1(this), IndexedSeq$.MODULE$.canBuildFrom());
        this.newGauge("max-buffer-utilization-percent", new Gauge<Object>(this){
            private final LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final CleanerStats apply(CleanerThread cleanerThread) {
                        return cleanerThread.lastStats();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final double apply(CleanerStats cleanerStats) {
                        return (double)100 * cleanerStats.bufferUtilization();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.newGauge("cleaner-recopy-percent", new Gauge<Object>(this){
            private final LogCleaner $outer;

            public int value() {
                IndexedSeq stats = (IndexedSeq)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final CleanerStats apply(CleanerThread cleanerThread) {
                        return cleanerThread.lastStats();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                double recopyRate = (double)BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final long apply(CleanerStats cleanerStats) {
                        return cleanerStats.bytesWritten();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final long apply(CleanerStats cleanerStats) {
                        return cleanerStats.bytesRead();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
                return (int)((double)100 * recopyRate);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.newGauge("max-clean-time-secs", new Gauge<Object>(this){
            private final LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final CleanerStats apply(CleanerThread cleanerThread) {
                        return cleanerThread.lastStats();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final double apply(CleanerStats cleanerStats) {
                        return cleanerStats.elapsedSecs();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public class CleanerThread
    extends ShutdownableThread
    implements ScalaObject {
        private final String loggerName;
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;
        public final LogCleaner $outer;

        public String loggerName() {
            return this.loggerName;
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats cleanerStats) {
            this.lastStats = cleanerStats;
        }

        public final void kafka$log$LogCleaner$CleanerThread$$checkDone(TopicAndPartition topicAndPartition) {
            if (this.isRunning().get()) {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$cleanerManager().checkCleaningAborted(topicAndPartition);
                return;
            }
            throw new ThreadShutdownException();
        }

        public void doWork() {
            this.cleanOrSleep();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void cleanOrSleep() {
            LogToClean logToClean;
            Option<LogToClean> option = this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$cleanerManager().grabFilthiestLog();
            None$ none$ = None$.MODULE$;
            Option<LogToClean> option2 = option;
            if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time.sleep(this.kafka$log$LogCleaner$CleanerThread$$$outer().config().backOffMs());
                return;
            }
            if (!(option instanceof Some)) throw new MatchError(option);
            Some some = (Some)option;
            LogToClean cleanable = logToClean = (LogToClean)some.x();
            long endOffset = cleanable.firstDirtyOffset();
            try {
                endOffset = this.cleaner().clean(cleanable);
                this.recordStats(this.cleaner().id(), cleanable.log().name(), cleanable.firstDirtyOffset(), endOffset, this.cleaner().stats());
                return;
            }
            catch (LogCleaningAbortedException logCleaningAbortedException) {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().dir().getParentFile(), endOffset);
            }
            return;
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().dir().getParentFile(), endOffset);
            }
        }

        public void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            this.lastStats_$eq(stats);
            this.cleaner().statsUnderlying().swap();
            String message$1 = new StringBuilder().append((Object)Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append((Object)Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)this.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))}))).append((Object)Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)(this.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append((Object)Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append((Object)Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)(this.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append((Object)Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append((Object)Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append((Object)Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).toString();
            this.info((Function0<String>)new Serializable(this, message$1){
                public static final long serialVersionUID;
                private final String message$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return this.message$1;
                }
                {
                    this.message$1 = string;
                }
            });
        }

        public LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return this.$outer;
        }

        private final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(LogCleaner $outer, int threadId) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(new StringBuilder().append((Object)"kafka-log-cleaner-thread-").append((Object)BoxesRunTime.boxToInteger((int)threadId)).toString(), false);
            this.loggerName = LogCleaner.class.getName();
            if ($outer.config().dedupeBufferSize() / (long)$outer.config().numThreads() > Integer.MAX_VALUE) {
                this.warn((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...";
                    }
                });
            }
            this.cleaner = new Cleaner(threadId, new SkimpyOffsetMap((int)package$.MODULE$.min($outer.config().dedupeBufferSize() / (long)$outer.config().numThreads(), Integer.MAX_VALUE), $outer.config().hashAlgorithm()), $outer.config().ioBufferSize() / $outer.config().numThreads() / 2, $outer.config().maxMessageSize(), $outer.config().dedupeBufferLoadFactor(), $outer.kafka$log$LogCleaner$$throttler(), $outer.kafka$log$LogCleaner$$time, (Function1<TopicAndPartition, BoxedUnit>)new CleanerThread$$anonfun$6(this));
            this.lastStats = new CleanerStats(CleanerStats$.MODULE$.init$default$1());
        }
    }
}

