/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.SocketChannel;
import kafka.common.ErrorMapping$;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.network.Send;
import kafka.network.Send$class;
import kafka.network.Transmission$class;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001i4Q!\u0001\u0002\u0001\u0005\u0019\u0011a\"T3tg\u0006<WmU3u'\u0016tGM\u0003\u0002\u0004\t\u000511/\u001a:wKJT\u0011!B\u0001\u0006W\u000647.Y\n\u0005\u0001\u001dyQ\u0003\u0005\u0002\t\u001b5\t\u0011B\u0003\u0002\u000b\u0017\u0005!A.\u00198h\u0015\u0005a\u0011\u0001\u00026bm\u0006L!AD\u0005\u0003\r=\u0013'.Z2u!\t\u00012#D\u0001\u0012\u0015\t\u0011B!A\u0004oKR<xN]6\n\u0005Q\t\"\u0001B*f]\u0012\u0004\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u00111bU2bY\u0006|%M[3di\"AA\u0004\u0001BC\u0002\u0013\u0005a$\u0001\u0005nKN\u001c\u0018mZ3t\u0007\u0001)\u0012a\b\t\u0003A\rj\u0011!\t\u0006\u0003E\u0011\tq!\\3tg\u0006<W-\u0003\u0002%C\tQQ*Z:tC\u001e,7+\u001a;\t\u0011\u0019\u0002!\u0011!Q\u0001\n}\t\u0011\"\\3tg\u0006<Wm\u001d\u0011\t\u0011!\u0002!Q1A\u0005\u0002%\n\u0011\"\u001a:s_J\u001cu\u000eZ3\u0016\u0003)\u0002\"AF\u0016\n\u00051:\"!B*i_J$\b\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\u0002\u0015\u0015\u0014(o\u001c:D_\u0012,\u0007\u0005C\u00031\u0001\u0011\u0005\u0011'\u0001\u0004=S:LGO\u0010\u000b\u0004eQ*\u0004CA\u001a\u0001\u001b\u0005\u0011\u0001\"\u0002\u000f0\u0001\u0004y\u0002\"\u0002\u00150\u0001\u0004Q\u0003bB\u001c\u0001\u0001\u0004%I\u0001O\u0001\u0005g\u0016tG/F\u0001:!\t1\"(\u0003\u0002</\t\u0019\u0011J\u001c;\t\u000fu\u0002\u0001\u0019!C\u0005}\u0005A1/\u001a8u?\u0012*\u0017\u000f\u0006\u0002@\u0005B\u0011a\u0003Q\u0005\u0003\u0003^\u0011A!\u00168ji\"91\tPA\u0001\u0002\u0004I\u0014a\u0001=%c!1Q\t\u0001Q!\ne\nQa]3oi\u0002Bqa\u0012\u0001C\u0002\u0013%\u0001(\u0001\u0003tSj,\u0007BB%\u0001A\u0003%\u0011(A\u0003tSj,\u0007\u0005C\u0004L\u0001\t\u0007I\u0011\u0002'\u0002\r!,\u0017\rZ3s+\u0005i\u0005C\u0001(R\u001b\u0005y%B\u0001)\f\u0003\rq\u0017n\\\u0005\u0003%>\u0013!BQ=uK\n+hMZ3s\u0011\u0019!\u0006\u0001)A\u0005\u001b\u00069\u0001.Z1eKJ\u0004\u0003b\u0002,\u0001\u0001\u0004%\taV\u0001\tG>l\u0007\u000f\\3uKV\t\u0001\f\u0005\u0002\u00173&\u0011!l\u0006\u0002\b\u0005>|G.Z1o\u0011\u001da\u0006\u00011A\u0005\u0002u\u000bAbY8na2,G/Z0%KF$\"a\u00100\t\u000f\r[\u0016\u0011!a\u00011\"1\u0001\r\u0001Q!\na\u000b\u0011bY8na2,G/\u001a\u0011\t\u000bA\u0002A\u0011\u00012\u0015\u0005I\u001a\u0007\"\u0002\u000fb\u0001\u0004y\u0002\"\u0002\u0019\u0001\t\u0003)G#\u0001\u001a\t\u000b\u001d\u0004A\u0011\u00015\u0002\u000f]\u0014\u0018\u000e^3U_R\u0011\u0011(\u001b\u0005\u0006U\u001a\u0004\ra[\u0001\bG\"\fgN\\3m!\taw.D\u0001n\u0015\tqw*\u0001\u0005dQ\u0006tg.\u001a7t\u0013\t\u0001XN\u0001\u000bHCRDWM]5oO\nKH/Z\"iC:tW\r\u001c\u0005\u0006e\u0002!\t\u0001O\u0001\tg\u0016tGmU5{K\"\u0012\u0001\u0001\u001e\t\u0003kbl\u0011A\u001e\u0006\u0003o\u0012\tQ!\u001e;jYNL!!\u001f<\u0003\u001b9|g\u000e\u001e5sK\u0006$7/\u00194f\u0001")
public class MessageSetSend
implements Send {
    private final MessageSet messages;
    private final short errorCode;
    private int sent;
    private final int size;
    private final ByteBuffer header;
    private boolean complete;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public int writeCompletely(GatheringByteChannel channel) {
        return Send$class.writeCompletely(this, channel);
    }

    @Override
    public void expectIncomplete() {
        Transmission$class.expectIncomplete(this);
    }

    @Override
    public void expectComplete() {
        Transmission$class.expectComplete(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        MessageSetSend messageSetSend = this;
        synchronized (messageSetSend) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public MessageSet messages() {
        return this.messages;
    }

    public short errorCode() {
        return this.errorCode;
    }

    private int sent() {
        return this.sent;
    }

    private void sent_$eq(int n) {
        this.sent = n;
    }

    private int size() {
        return this.size;
    }

    private ByteBuffer header() {
        return this.header;
    }

    @Override
    public boolean complete() {
        return this.complete;
    }

    public void complete_$eq(boolean bl) {
        this.complete = bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int writeTo(GatheringByteChannel channel) {
        void var2_2;
        this.expectIncomplete();
        int written = 0;
        if (this.header().hasRemaining()) {
            written += channel.write(this.header());
        }
        if (!this.header().hasRemaining()) {
            int fileBytesSent = this.messages().writeTo(channel, this.sent(), this.size() - this.sent());
            written += fileBytesSent;
            this.sent_$eq(this.sent() + fileBytesSent);
        }
        if (this.logger().isTraceEnabled() && channel instanceof SocketChannel) {
            SocketChannel socketChannel = (SocketChannel)channel;
            this.logger().trace((Object)new StringBuilder().append(this.sent()).append((Object)" bytes written to ").append((Object)socketChannel.socket().getRemoteSocketAddress()).append((Object)" expecting to send ").append((Object)BoxesRunTime.boxToInteger((int)this.size())).append((Object)" bytes").toString());
        }
        if (this.sent() >= this.size()) {
            this.complete_$eq(true);
        }
        return (int)var2_2;
    }

    public int sendSize() {
        return this.size() + this.header().capacity();
    }

    public MessageSetSend(MessageSet messages, short errorCode) {
        this.messages = messages;
        this.errorCode = errorCode;
        Logging$class.$init$(this);
        Transmission$class.$init$(this);
        Send$class.$init$(this);
        this.sent = 0;
        this.size = messages.sizeInBytes();
        this.header = ByteBuffer.allocate(6);
        this.header().putInt(this.size() + 2);
        this.header().putShort(errorCode);
        this.header().rewind();
        this.complete = false;
    }

    public MessageSetSend(MessageSet messages) {
        this(messages, ErrorMapping$.MODULE$.NoError());
    }

    public MessageSetSend() {
        this(MessageSet$.MODULE$.Empty());
    }
}

