/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.impl;

import java.io.File;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.karaf.jaas.boot.ProxyLoginModule;
import org.apache.karaf.jaas.config.JaasRealm;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class KarafRealm
implements JaasRealm,
ManagedService {
    private static final String KARAF_ETC = System.getProperty("karaf.base") + File.separatorChar + "etc";
    private static final String REALM = "karaf";
    private static final String PROPERTIES_MODULE = "org.apache.karaf.jaas.modules.properties.PropertiesLoginModule";
    private static final String PUBLIC_KEY_MODULE = "org.apache.karaf.jaas.modules.publickey.PublickeyLoginModule";
    private static final String ENCRYPTION_NAME = "encryption.name";
    private static final String ENCRYPTION_ENABLED = "encryption.enabled";
    private static final String ENCRYPTION_PREFIX = "encryption.prefix";
    private static final String ENCRYPTION_SUFFIX = "encryption.suffix";
    private static final String ENCRYPTION_ALGORITHM = "encryption.algorithm";
    private static final String ENCRYPTION_ENCODING = "encryption.encoding";
    private static final String MODULE = "org.apache.karaf.jaas.module";
    private final BundleContext bundleContext;
    private volatile Map<String, Object> properties;

    public KarafRealm(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.properties = new HashMap<String, Object>();
        this.populateDefault(this.properties);
    }

    private void populateDefault(Map<String, Object> props) {
        props.put("detailed.login.exception", "false");
        props.put(ENCRYPTION_NAME, "");
        props.put(ENCRYPTION_ENABLED, "false");
        props.put(ENCRYPTION_PREFIX, "{CRYPT}");
        props.put(ENCRYPTION_SUFFIX, "{CRYPT}");
        props.put(ENCRYPTION_ALGORITHM, "MD5");
        props.put(ENCRYPTION_ENCODING, "hexadecimal");
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        this.populateDefault(props);
        Enumeration<String> keyEnum = properties.keys();
        while (keyEnum.hasMoreElements()) {
            String key = keyEnum.nextElement();
            props.put(key, properties.get(key));
        }
        this.properties = props;
    }

    public String getName() {
        return REALM;
    }

    public int getRank() {
        return 0;
    }

    public AppConfigurationEntry[] getEntries() {
        HashMap<String, Object> propertiesOptions = new HashMap<String, Object>();
        propertiesOptions.putAll(this.properties);
        propertiesOptions.put(BundleContext.class.getName(), this.bundleContext);
        propertiesOptions.put(MODULE, PROPERTIES_MODULE);
        propertiesOptions.put("org.apache.karaf.jaas.bundle", Long.toString(this.bundleContext.getBundle().getBundleId()));
        propertiesOptions.put("users", KARAF_ETC + File.separatorChar + "users.properties");
        HashMap<String, Object> publicKeyOptions = new HashMap<String, Object>();
        publicKeyOptions.putAll(this.properties);
        publicKeyOptions.put(BundleContext.class.getName(), this.bundleContext);
        publicKeyOptions.put(MODULE, PUBLIC_KEY_MODULE);
        publicKeyOptions.put("org.apache.karaf.jaas.bundle", Long.toString(this.bundleContext.getBundle().getBundleId()));
        publicKeyOptions.put("users", KARAF_ETC + File.separatorChar + "keys.properties");
        return new AppConfigurationEntry[]{new AppConfigurationEntry(ProxyLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT, propertiesOptions), new AppConfigurationEntry(ProxyLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT, publicKeyOptions)};
    }
}

