/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.commands.basic;

import java.util.Hashtable;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.basic.AbstractCommand;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.command.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCommand
extends AbstractCommand {
    private Class<? extends Action> actionClass;

    public SimpleCommand() {
    }

    public SimpleCommand(Class<? extends Action> actionClass) {
        this.actionClass = actionClass;
    }

    @Override
    public Class<? extends Action> getActionClass() {
        return this.actionClass;
    }

    public void setActionClass(Class<? extends Action> actionClass) {
        this.actionClass = actionClass;
    }

    @Override
    public Action createNewAction() {
        try {
            return this.actionClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static ServiceRegistration export(BundleContext context, Class<? extends Action> actionClass) {
        Command cmd = actionClass.getAnnotation(Command.class);
        if (cmd == null) {
            throw new IllegalArgumentException("Action class is not annotated with @Command");
        }
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("osgi.command.scope", cmd.scope());
        props.put("osgi.command.function", cmd.name());
        SimpleCommand command = new SimpleCommand(actionClass);
        return context.registerService(Function.class.getName(), (Object)command, props);
    }
}

