/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import jline.Terminal;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.CommandException;
import org.apache.felix.gogo.commands.basic.AbstractCommand;
import org.apache.felix.gogo.runtime.lang.Support;
import org.apache.felix.gogo.runtime.shell.CommandShellImpl;
import org.apache.felix.gogo.runtime.threadio.ThreadIOImpl;
import org.apache.karaf.shell.console.jline.Console;
import org.apache.karaf.shell.console.jline.TerminalFactory;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.osgi.service.command.CommandSession;
import org.osgi.service.command.Function;
import org.osgi.service.threadio.ThreadIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    private String application = System.getProperty("karaf.name", "root");
    private String user = "karaf";

    public static void main(String[] args) throws Exception {
        Main main = new Main();
        main.run(args);
    }

    public void run(String[] args) throws Exception {
        ThreadIOImpl threadio = new ThreadIOImpl();
        threadio.start();
        CommandShellImpl commandProcessor = new CommandShellImpl();
        commandProcessor.setThreadio(threadio);
        commandProcessor.setConverter(new Support());
        ClassLoader cl = Main.class.getClassLoader();
        if (args.length > 0 && args[0].startsWith("--classpath=")) {
            String base = args[0].substring("--classpath=".length());
            List<URL> urls = Main.getFiles(new File(base));
            cl = new URLClassLoader(urls.toArray(new URL[urls.size()]), cl);
            String[] a = new String[args.length - 1];
            System.arraycopy(args, 1, a, 0, a.length);
            args = a;
        }
        this.discoverCommands(commandProcessor, cl);
        InputStream in = Main.unwrap(System.in);
        PrintStream out = Main.wrap(Main.unwrap(System.out));
        PrintStream err = Main.wrap(Main.unwrap(System.err));
        this.run(commandProcessor, args, in, out, err);
    }

    public void run(CommandSession parent, String[] args) throws Exception {
        CommandShellImpl commandProcessor = new CommandShellImpl();
        commandProcessor.setThreadio(new ThreadIO(){

            public void setStreams(InputStream in, PrintStream out, PrintStream err) {
            }

            public void close() {
            }
        });
        commandProcessor.setConverter(new Support());
        ClassLoader cl = Main.class.getClassLoader();
        if (args.length > 0 && args[0].startsWith("--classpath=")) {
            String base = args[0].substring("--classpath=".length());
            List<URL> urls = Main.getFiles(new File(base));
            cl = new URLClassLoader(urls.toArray(new URL[urls.size()]), cl);
            String[] a = new String[args.length - 1];
            System.arraycopy(args, 1, a, 0, a.length);
            args = a;
        }
        this.discoverCommands(commandProcessor, cl);
        InputStream in = parent.getKeyboard();
        PrintStream out = parent.getConsole();
        PrintStream err = parent.getConsole();
        this.run(commandProcessor, args, in, out, err);
    }

    private void run(CommandShellImpl commandProcessor, String[] args, InputStream in, PrintStream out, PrintStream err) throws Exception {
        TerminalFactory terminalFactory;
        block7: {
            terminalFactory = new TerminalFactory();
            Terminal terminal = terminalFactory.getTerminal();
            Console console = this.createConsole(commandProcessor, in, out, err, terminal);
            CommandSession session = console.getSession();
            session.put("USER", this.user);
            session.put("APPLICATION", this.application);
            session.put("LINES", Integer.toString(terminal.getTerminalHeight()));
            session.put("COLUMNS", Integer.toString(terminal.getTerminalWidth()));
            session.put(".jline.terminal", terminal);
            session.put("MULTI_SCOPE_MODE", Boolean.toString(this.isMultiScopeMode()));
            if (args.length > 0) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < args.length; ++i) {
                    if (i > 0) {
                        sb.append(" ");
                    }
                    sb.append(args[i]);
                }
                try {
                    session.execute(sb);
                }
                catch (Throwable t) {
                    if (t instanceof CommandException) {
                        session.getConsole().println(((CommandException)t).getNiceHelp());
                        break block7;
                    }
                    session.getConsole().print(Ansi.ansi().fg(Ansi.Color.RED).toString());
                    t.printStackTrace(session.getConsole());
                    session.getConsole().print(Ansi.ansi().fg(Ansi.Color.DEFAULT).toString());
                }
            } else {
                console.run();
            }
        }
        terminalFactory.destroy();
    }

    protected Console createConsole(CommandShellImpl commandProcessor, InputStream in, PrintStream out, PrintStream err, Terminal terminal) throws Exception {
        return new Console(commandProcessor, in, out, err, terminal, null);
    }

    public String getDiscoveryResource() {
        return "META-INF/services/org/apache/karaf/shell/commands";
    }

    private void discoverCommands(CommandShellImpl commandProcessor, ClassLoader cl) throws IOException, ClassNotFoundException {
        Enumeration<URL> urls = cl.getResources(this.getDiscoveryResource());
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            BufferedReader r = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = r.readLine();
            while (line != null) {
                if ((line = line.trim()).length() > 0 && line.charAt(0) != '#') {
                    final Class<?> actionClass = cl.loadClass(line);
                    Command cmd = actionClass.getAnnotation(Command.class);
                    AbstractCommand function = new AbstractCommand(){

                        public Action createNewAction() {
                            try {
                                return (Action)actionClass.newInstance();
                            }
                            catch (InstantiationException e) {
                                throw new RuntimeException(e);
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    };
                    this.addCommand(cmd, function, commandProcessor);
                }
                line = r.readLine();
            }
            r.close();
        }
    }

    protected void addCommand(Command cmd, Function function, CommandShellImpl commandProcessor) {
        try {
            commandProcessor.addCommand(cmd.scope(), (Object)function, cmd.name());
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public boolean isMultiScopeMode() {
        return true;
    }

    private static PrintStream wrap(PrintStream stream) {
        OutputStream o = AnsiConsole.wrapOutputStream(stream);
        if (o instanceof PrintStream) {
            return (PrintStream)o;
        }
        return new PrintStream(o);
    }

    private static <T> T unwrap(T stream) {
        try {
            Method mth = stream.getClass().getMethod("getRoot", new Class[0]);
            return (T)mth.invoke(stream, new Object[0]);
        }
        catch (Throwable t) {
            return stream;
        }
    }

    private static List<URL> getFiles(File base) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        Main.getFiles(base, urls);
        return urls;
    }

    private static void getFiles(File base, List<URL> urls) throws MalformedURLException {
        for (File f : base.listFiles()) {
            if (f.isDirectory()) {
                Main.getFiles(f, urls);
                continue;
            }
            if (!f.getName().endsWith(".jar")) continue;
            urls.add(f.toURI().toURL());
        }
    }
}

