/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console.jline;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import jline.Terminal;
import org.apache.karaf.shell.console.jline.Console;
import org.apache.karaf.shell.console.jline.TerminalFactory;
import org.fusesource.jansi.AnsiConsole;
import org.osgi.framework.BundleContext;
import org.osgi.service.command.CommandProcessor;
import org.osgi.service.command.CommandSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleFactory {
    private BundleContext bundleContext;
    private CommandProcessor commandProcessor;
    private TerminalFactory terminalFactory;
    private Console console;
    private boolean start;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public synchronized void registerCommandProcessor(CommandProcessor commandProcessor) throws Exception {
        this.commandProcessor = commandProcessor;
        this.start();
    }

    public synchronized void unregisterCommandProcessor(CommandProcessor commandProcessor) throws Exception {
        this.commandProcessor = null;
        this.stop();
    }

    public void setTerminalFactory(TerminalFactory terminalFactory) {
        this.terminalFactory = terminalFactory;
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    protected void start() throws Exception {
        if (this.start) {
            InputStream in = ConsoleFactory.unwrap(System.in);
            PrintStream out = ConsoleFactory.unwrap(System.out);
            PrintStream err = ConsoleFactory.unwrap(System.err);
            Runnable callback = new Runnable(){

                public void run() {
                    try {
                        ConsoleFactory.this.bundleContext.getBundle(0L).stop();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            Terminal terminal = this.terminalFactory.getTerminal();
            this.console = new Console(this.commandProcessor, in, ConsoleFactory.wrap(out), ConsoleFactory.wrap(err), terminal, callback);
            CommandSession session = this.console.getSession();
            session.put("USER", "karaf");
            session.put("APPLICATION", System.getProperty("karaf.name", "root"));
            session.put("LINES", Integer.toString(terminal.getTerminalHeight()));
            session.put("COLUMNS", Integer.toString(terminal.getTerminalWidth()));
            session.put(".jline.terminal", terminal);
            new Thread((Runnable)this.console, "Karaf Shell Console Thread").start();
        }
    }

    protected void stop() throws Exception {
        if (this.console != null) {
            this.console.close();
        }
    }

    private static PrintStream wrap(PrintStream stream) {
        OutputStream o = AnsiConsole.wrapOutputStream(stream);
        if (o instanceof PrintStream) {
            return (PrintStream)o;
        }
        return new PrintStream(o);
    }

    private static <T> T unwrap(T stream) {
        try {
            Method mth = stream.getClass().getMethod("getRoot", new Class[0]);
            return (T)mth.invoke(stream, new Object[0]);
        }
        catch (Throwable t) {
            return stream;
        }
    }
}

