/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.security.impl;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.felix.gogo.api.CommandSessionListener;
import org.apache.felix.gogo.runtime.CommandProcessorImpl;
import org.apache.felix.gogo.runtime.CommandProxy;
import org.apache.felix.service.command.Converter;
import org.apache.felix.service.threadio.ThreadIO;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.shell.util.ShellUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

@Deprecated
public class SecuredCommandProcessorImpl
extends CommandProcessorImpl {
    private final BundleContext bundleContext;
    private final ServiceReference<ThreadIO> threadIOServiceReference;
    private final ServiceTracker<Object, Object> commandTracker;
    private final ServiceTracker<Converter, Converter> converterTracker;
    private final ServiceTracker<CommandSessionListener, CommandSessionListener> listenerTracker;

    public SecuredCommandProcessorImpl(BundleContext bc) {
        this(bc, (ServiceReference<ThreadIO>)bc.getServiceReference(ThreadIO.class));
    }

    private SecuredCommandProcessorImpl(BundleContext bc, ServiceReference<ThreadIO> sr) {
        super((ThreadIO)bc.getService(sr));
        this.bundleContext = bc;
        this.threadIOServiceReference = sr;
        AccessControlContext acc = AccessController.getContext();
        Subject sub = Subject.getSubject(acc);
        if (sub == null) {
            throw new SecurityException("No current Subject in the Access Control Context");
        }
        Set<RolePrincipal> rolePrincipals = sub.getPrincipals(RolePrincipal.class);
        if (rolePrincipals.size() == 0) {
            throw new SecurityException("Current user " + ShellUtil.getCurrentUserName() + " has no associated roles.");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(|");
        for (RolePrincipal rp : rolePrincipals) {
            sb.append('(');
            sb.append("org.apache.karaf.service.guard.roles");
            sb.append('=');
            sb.append(rp.getName());
            sb.append(')');
        }
        sb.append("(!(org.apache.karaf.service.guard.roles=*))");
        sb.append(')');
        String roleClause = sb.toString();
        this.addConstant(".context", bc);
        this.addCommand("osgi", (Object)this, "addCommand");
        this.addCommand("osgi", (Object)this, "removeCommand");
        this.addCommand("osgi", (Object)this, "eval");
        try {
            this.commandTracker = this.trackCommands(bc, roleClause);
            this.commandTracker.open();
            this.converterTracker = this.trackConverters(bc);
            this.converterTracker.open();
            this.listenerTracker = this.trackListeners(bc);
            this.listenerTracker.open();
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        this.commandTracker.close();
        this.converterTracker.close();
        this.listenerTracker.close();
        this.bundleContext.ungetService(this.threadIOServiceReference);
    }

    private ServiceTracker<Object, Object> trackCommands(BundleContext context, String roleClause) throws InvalidSyntaxException {
        Filter filter = context.createFilter(String.format("(&(%s=*)(%s=*)%s)", "osgi.command.scope", "osgi.command.function", roleClause));
        return new ServiceTracker<Object, Object>(context, filter, null){

            public Object addingService(ServiceReference<Object> reference) {
                Object scope = reference.getProperty("osgi.command.scope");
                Object function = reference.getProperty("osgi.command.function");
                ArrayList<CommandProxy> commands = new ArrayList<CommandProxy>();
                if (scope != null && function != null) {
                    if (function.getClass().isArray()) {
                        for (Object f : (Object[])function) {
                            CommandProxy target = new CommandProxy(this.context, reference, f.toString());
                            SecuredCommandProcessorImpl.this.addCommand(scope.toString(), (Object)target, f.toString());
                            commands.add(target);
                        }
                    } else {
                        CommandProxy target = new CommandProxy(this.context, reference, function.toString());
                        SecuredCommandProcessorImpl.this.addCommand(scope.toString(), (Object)target, function.toString());
                        commands.add(target);
                    }
                    return commands;
                }
                return null;
            }

            public void removedService(ServiceReference<Object> reference, Object service) {
                Object scope = reference.getProperty("osgi.command.scope");
                Object function = reference.getProperty("osgi.command.function");
                if (scope != null && function != null) {
                    if (!function.getClass().isArray()) {
                        SecuredCommandProcessorImpl.this.removeCommand(scope.toString(), function.toString());
                    } else {
                        for (Object func : (Object[])function) {
                            SecuredCommandProcessorImpl.this.removeCommand(scope.toString(), func.toString());
                        }
                    }
                }
                super.removedService(reference, service);
            }
        };
    }

    private ServiceTracker<Converter, Converter> trackConverters(BundleContext context) {
        return new ServiceTracker<Converter, Converter>(context, Converter.class.getName(), null){

            public Converter addingService(ServiceReference<Converter> reference) {
                Converter converter = (Converter)super.addingService(reference);
                SecuredCommandProcessorImpl.this.addConverter(converter);
                return converter;
            }

            public void removedService(ServiceReference<Converter> reference, Converter service) {
                SecuredCommandProcessorImpl.this.removeConverter(service);
                super.removedService(reference, (Object)service);
            }
        };
    }

    private ServiceTracker<CommandSessionListener, CommandSessionListener> trackListeners(BundleContext context) {
        return new ServiceTracker<CommandSessionListener, CommandSessionListener>(context, CommandSessionListener.class.getName(), null){

            public CommandSessionListener addingService(ServiceReference<CommandSessionListener> reference) {
                CommandSessionListener listener = (CommandSessionListener)super.addingService(reference);
                SecuredCommandProcessorImpl.this.addListener(listener);
                return listener;
            }

            public void removedService(ServiceReference<CommandSessionListener> reference, CommandSessionListener service) {
                SecuredCommandProcessorImpl.this.removeListener(service);
                super.removedService(reference, (Object)service);
            }
        };
    }
}

