/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.obr;

import java.util.List;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.Resource;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.obr.ObrCommandSupport;
import org.osgi.framework.Version;

@Command(scope="obr", name="list", description="Lists OBR bundles")
public class ListCommand
extends ObrCommandSupport {
    @Argument(index=0, name="args", description="The arguments", required=false, multiValued=true)
    List<String> args;

    protected void doExecute(RepositoryAdmin admin) throws Exception {
        String substr = null;
        if (this.args != null) {
            for (String arg : this.args) {
                substr = substr == null ? "" : substr + " ";
                substr = substr + arg;
            }
        }
        StringBuffer sb = new StringBuffer();
        if (substr == null || substr.length() == 0) {
            sb.append("(|(presentationname=*)(symbolicname=*))");
        } else {
            sb.append("(|(presentationname=*");
            sb.append(substr);
            sb.append("*)(symbolicname=*");
            sb.append(substr);
            sb.append("*))");
        }
        Resource[] resources = admin.discoverResources(sb.toString());
        for (int resIdx = 0; resources != null && resIdx < resources.length; ++resIdx) {
            String name = resources[resIdx].getPresentationName();
            Version version = resources[resIdx].getVersion();
            if (version != null) {
                System.out.println(name + " (" + version + ")");
                continue;
            }
            System.out.println(name);
        }
        if (resources == null) {
            System.out.println("No matching bundles.");
        }
    }
}

