/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.karaf.profile.assembly.Builder;
import org.apache.karaf.tooling.utils.IoUtils;
import org.apache.karaf.tooling.utils.MavenUtil;
import org.apache.karaf.tooling.utils.MojoSupport;
import org.apache.karaf.tools.utils.model.KarafPropertyEdits;
import org.apache.karaf.tools.utils.model.io.stax.KarafPropertyInstructionsModelStaxReader;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="assembly", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class AssemblyMojo
extends MojoSupport {
    @Parameter(defaultValue="${project.basedir}/src/main/resources/assembly")
    protected File sourceDirectory;
    @Parameter(defaultValue="${project.build.directory}/assembly")
    protected File workDirectory;
    @Parameter(defaultValue="${project.build.directory}/assembly/etc/org.apache.karaf.features.cfg")
    protected File featuresCfgFile;
    @Parameter(defaultValue="${project.build.directory}/assembly/etc/startup.properties")
    protected File startupPropertiesFile;
    @Parameter(defaultValue="${project.build.directory}/assembly/system")
    protected File systemDirectory;
    @Parameter
    protected int defaultStartLevel = 30;
    @Parameter
    private List<String> startupRepositories;
    @Parameter
    private List<String> bootRepositories;
    @Parameter
    private List<String> installedRepositories;
    @Parameter
    private List<String> blacklistedRepositories;
    @Parameter
    private List<String> startupFeatures;
    @Parameter
    private List<String> bootFeatures;
    @Parameter
    private List<String> installedFeatures;
    @Parameter
    private List<String> blacklistedFeatures;
    @Parameter
    private List<String> startupBundles;
    @Parameter
    private List<String> bootBundles;
    @Parameter
    private List<String> installedBundles;
    @Parameter
    private List<String> blacklistedBundles;
    @Parameter
    private String profilesUri;
    @Parameter
    private List<String> bootProfiles;
    @Parameter
    private List<String> startupProfiles;
    @Parameter
    private List<String> installedProfiles;
    @Parameter
    private List<String> blacklistedProfiles;
    @Parameter
    private Builder.BlacklistPolicy blacklistPolicy = Builder.BlacklistPolicy.Discard;
    @Parameter(defaultValue="false")
    protected boolean ignoreDependencyFlag;
    @Parameter
    protected List<String> featureRepositories;
    @Parameter
    protected List<String> libraries;
    @Parameter(defaultValue="false")
    protected boolean useReferenceUrls;
    @Parameter(defaultValue="true")
    protected boolean includeBuildOutputDirectory;
    @Parameter
    protected boolean installAllFeaturesByDefault = true;
    @Parameter
    protected Builder.KarafVersion karafVersion = Builder.KarafVersion.v4x;
    @Parameter(defaultValue="1.8")
    protected String javase;
    @Parameter
    protected String framework;
    @Parameter(defaultValue="${project.basedir}/src/main/karaf/assembly-property-edits.xml")
    protected String propertyFileEdits;
    @Parameter
    protected List<String> pidsToExtract = Collections.singletonList("*");
    @Parameter
    protected Map<String, String> translatedUrls;
    @Parameter
    protected Map<String, String> config;
    @Parameter
    protected Map<String, String> system;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.doExecute();
        }
        catch (MojoExecutionException | MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to build assembly", e);
        }
    }

    protected void doExecute() throws Exception {
        File[] files;
        Object uri;
        File file;
        this.startupRepositories = this.nonNullList(this.startupRepositories);
        this.bootRepositories = this.nonNullList(this.bootRepositories);
        this.installedRepositories = this.nonNullList(this.installedRepositories);
        this.startupBundles = this.nonNullList(this.startupBundles);
        this.bootBundles = this.nonNullList(this.bootBundles);
        this.installedBundles = this.nonNullList(this.installedBundles);
        this.blacklistedBundles = this.nonNullList(this.blacklistedBundles);
        this.startupFeatures = this.nonNullList(this.startupFeatures);
        this.bootFeatures = this.nonNullList(this.bootFeatures);
        this.installedFeatures = this.nonNullList(this.installedFeatures);
        this.blacklistedFeatures = this.nonNullList(this.blacklistedFeatures);
        this.startupProfiles = this.nonNullList(this.startupProfiles);
        this.bootProfiles = this.nonNullList(this.bootProfiles);
        this.installedProfiles = this.nonNullList(this.installedProfiles);
        this.blacklistedProfiles = this.nonNullList(this.blacklistedProfiles);
        this.blacklistedRepositories = this.nonNullList(this.blacklistedRepositories);
        if (!(this.startupProfiles.isEmpty() && this.bootProfiles.isEmpty() && this.installedProfiles.isEmpty() || this.profilesUri != null)) {
            throw new IllegalArgumentException("profilesDirectory must be specified");
        }
        if (this.featureRepositories != null && !this.featureRepositories.isEmpty()) {
            this.getLog().warn((CharSequence)"Use of featureRepositories is deprecated, use startupRepositories, bootRepositories or installedRepositories instead");
            this.startupRepositories.addAll(this.featureRepositories);
            this.bootRepositories.addAll(this.featureRepositories);
            this.installedRepositories.addAll(this.featureRepositories);
        }
        StringBuilder remote = new StringBuilder();
        for (Object obj : this.project.getRemoteProjectRepositories()) {
            if (remote.length() > 0) {
                remote.append(",");
            }
            remote.append(this.invoke(obj, "getUrl"));
            remote.append("@id=").append(this.invoke(obj, "getId"));
            if (!((Boolean)this.invoke(this.getPolicy(obj, false), "isEnabled")).booleanValue()) {
                remote.append("@noreleases");
            }
            if (!((Boolean)this.invoke(this.getPolicy(obj, true), "isEnabled")).booleanValue()) continue;
            remote.append("@snapshots");
        }
        this.getLog().info((CharSequence)("Using repositories: " + remote.toString()));
        Builder builder = Builder.newInstance();
        builder.offline(this.mavenSession.isOffline());
        builder.localRepository(this.localRepo.getBasedir());
        builder.mavenRepositories(remote.toString());
        builder.javase(this.javase);
        if (this.config != null) {
            this.config.forEach((arg_0, arg_1) -> ((Builder)builder).config(arg_0, arg_1));
        }
        if (this.system != null) {
            this.system.forEach((arg_0, arg_1) -> ((Builder)builder).system(arg_0, arg_1));
        }
        builder.blacklistBundles(this.blacklistedBundles);
        builder.blacklistFeatures(this.blacklistedFeatures);
        builder.blacklistProfiles(this.blacklistedProfiles);
        builder.blacklistRepositories(this.blacklistedRepositories);
        builder.blacklistPolicy(this.blacklistPolicy);
        if (this.propertyFileEdits != null && (file = new File(this.propertyFileEdits)).exists()) {
            KarafPropertyEdits edits;
            try (FileInputStream editsStream = new FileInputStream(this.propertyFileEdits);){
                KarafPropertyInstructionsModelStaxReader kipmsr = new KarafPropertyInstructionsModelStaxReader();
                edits = kipmsr.read((InputStream)editsStream, true);
            }
            builder.propertyEdits(edits);
        }
        builder.pidsToExtract(this.pidsToExtract);
        HashMap<String, String> urls = new HashMap<String, String>();
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(this.project.getAttachedArtifacts());
        artifacts.add(this.project.getArtifact());
        for (Artifact artifact : artifacts) {
            if (artifact.getFile() == null || !artifact.getFile().exists()) continue;
            String mvnUrl = "mvn:" + artifact.getGroupId() + "/" + artifact.getArtifactId() + "/" + artifact.getVersion();
            Object type = artifact.getType();
            if ("bundle".equals(type)) {
                type = "jar";
            }
            if (!"jar".equals(type) || artifact.getClassifier() != null) {
                mvnUrl = mvnUrl + "/" + (String)type;
                if (artifact.getClassifier() != null) {
                    mvnUrl = mvnUrl + "/" + artifact.getClassifier();
                }
            }
            urls.put(mvnUrl, artifact.getFile().toURI().toString());
        }
        if (this.translatedUrls != null) {
            urls.putAll(this.translatedUrls);
        }
        builder.translatedUrls(urls);
        this.getLog().info((CharSequence)"Creating work directory");
        builder.homeDirectory(this.workDirectory.toPath());
        IoUtils.deleteRecursive(this.workDirectory);
        this.workDirectory.mkdirs();
        ArrayList<String> startupKars = new ArrayList<String>();
        ArrayList<String> bootKars = new ArrayList<String>();
        ArrayList<String> installedKars = new ArrayList<String>();
        this.getLog().info((CharSequence)"Loading kar and features repositories dependencies");
        block61: for (Object artifact : this.project.getDependencyArtifacts()) {
            Builder.Stage stage;
            switch (artifact.getScope()) {
                case "compile": {
                    stage = Builder.Stage.Startup;
                    break;
                }
                case "runtime": {
                    stage = Builder.Stage.Boot;
                    break;
                }
                case "provided": {
                    stage = Builder.Stage.Installed;
                    break;
                }
                default: {
                    continue block61;
                }
            }
            if ("kar".equals(artifact.getType())) {
                uri = this.artifactToMvn((Artifact)artifact);
                switch (stage) {
                    case Startup: {
                        startupKars.add((String)uri);
                        break;
                    }
                    case Boot: {
                        bootKars.add((String)uri);
                        break;
                    }
                    case Installed: {
                        installedKars.add((String)uri);
                    }
                }
                continue;
            }
            if ("features".equals(artifact.getClassifier()) || "karaf".equals(artifact.getClassifier())) {
                uri = this.artifactToMvn((Artifact)artifact);
                switch (stage) {
                    case Startup: {
                        this.startupRepositories.add((String)uri);
                        break;
                    }
                    case Boot: {
                        this.bootRepositories.add((String)uri);
                        break;
                    }
                    case Installed: {
                        this.installedRepositories.add((String)uri);
                    }
                }
                continue;
            }
            if (!"jar".equals(artifact.getType()) && !"bundle".equals(artifact.getType())) continue;
            uri = this.artifactToMvn((Artifact)artifact);
            switch (stage) {
                case Startup: {
                    this.startupBundles.add((String)uri);
                    break;
                }
                case Boot: {
                    this.bootBundles.add((String)uri);
                    break;
                }
                case Installed: {
                    this.installedBundles.add((String)uri);
                }
            }
        }
        builder.karafVersion(this.karafVersion).useReferenceUrls(this.useReferenceUrls).defaultAddAll(this.installAllFeaturesByDefault).ignoreDependencyFlag(this.ignoreDependencyFlag);
        if (this.profilesUri != null) {
            Arrays.stream(this.profilesUri.split(",")).map(String::trim).forEach(xva$0 -> builder.profilesUris(new String[]{xva$0}));
        }
        if (this.libraries != null) {
            builder.libraries(this.libraries.toArray(new String[this.libraries.size()]));
        }
        boolean hasFrameworkKar = false;
        for (String kar : startupKars) {
            if (!kar.startsWith("mvn:org.apache.karaf.features/framework/") && !kar.startsWith("mvn:org.apache.karaf.features/static/")) continue;
            hasFrameworkKar = true;
            startupKars.remove(kar);
            if (this.framework == null) {
                this.framework = kar.startsWith("mvn:org.apache.karaf.features/framework/") ? "framework" : "static-framework";
            }
            builder.kars(Builder.Stage.Startup, false, new String[]{kar});
            break;
        }
        if (!hasFrameworkKar) {
            String kar;
            Properties versions = new Properties();
            try {
                InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("versions.properties");
                uri = null;
                try {
                    versions.load(is);
                }
                catch (Throwable throwable) {
                    uri = throwable;
                    throw throwable;
                }
                finally {
                    if (is != null) {
                        if (uri != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)uri).addSuppressed(throwable);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            String realKarafVersion = versions.getProperty("karaf-version");
            switch (this.framework) {
                case "framework": {
                    kar = "mvn:org.apache.karaf.features/framework/" + realKarafVersion + "/xml/features";
                    break;
                }
                case "framework-logback": {
                    kar = "mvn:org.apache.karaf.features/framework/" + realKarafVersion + "/xml/features";
                    break;
                }
                case "static-framework": {
                    kar = "mvn:org.apache.karaf.features/static/" + realKarafVersion + "/xml/features";
                    break;
                }
                case "static-framework-logback": {
                    kar = "mvn:org.apache.karaf.features/static/" + realKarafVersion + "/xml/features";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported framework: " + this.framework);
                }
            }
            builder.kars(Builder.Stage.Startup, false, new String[]{kar});
        }
        if (!this.startupFeatures.contains(this.framework)) {
            builder.features(Builder.Stage.Startup, new String[]{this.framework});
        }
        builder.defaultStage(Builder.Stage.Startup).kars(this.toArray(startupKars)).repositories(this.startupFeatures.isEmpty() && this.startupProfiles.isEmpty() && this.installAllFeaturesByDefault, this.toArray(this.startupRepositories)).features(this.toArray(this.startupFeatures)).bundles(this.toArray(this.startupBundles)).profiles(this.toArray(this.startupProfiles));
        builder.defaultStage(Builder.Stage.Boot).kars(this.toArray(bootKars)).repositories(this.bootFeatures.isEmpty() && this.bootProfiles.isEmpty() && this.installAllFeaturesByDefault, this.toArray(this.bootRepositories)).features(this.toArray(this.bootFeatures)).bundles(this.toArray(this.bootBundles)).profiles(this.toArray(this.bootProfiles));
        builder.defaultStage(Builder.Stage.Installed).kars(this.toArray(installedKars)).repositories(this.installedFeatures.isEmpty() && this.installedProfiles.isEmpty() && this.installAllFeaturesByDefault, this.toArray(this.installedRepositories)).features(this.toArray(this.installedFeatures)).bundles(this.toArray(this.installedBundles)).profiles(this.toArray(this.installedProfiles));
        builder.generateAssembly();
        if (this.includeBuildOutputDirectory) {
            IoUtils.copyDirectory(new File(this.project.getBuild().getOutputDirectory()), this.workDirectory);
        }
        if (this.sourceDirectory.exists()) {
            IoUtils.copyDirectory(this.sourceDirectory, this.workDirectory);
        }
        if ((files = new File(this.workDirectory, "bin").listFiles()) != null) {
            for (File file2 : files) {
                if (file2.getName().endsWith(".bat")) continue;
                try {
                    Files.setPosixFilePermissions(file2.toPath(), PosixFilePermissions.fromString("rwxr-xr-x"));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private Object invoke(Object object, String getter) throws MojoExecutionException {
        try {
            return object.getClass().getMethod(getter, new Class[0]).invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to build remote repository from " + object.toString(), e);
        }
    }

    private Object getPolicy(Object object, boolean snapshots) throws MojoExecutionException {
        return this.invoke(object, "getPolicy", new Class[]{Boolean.TYPE}, new Object[]{snapshots});
    }

    private Object invoke(Object object, String getter, Class[] types, Object[] params) throws MojoExecutionException {
        try {
            return object.getClass().getMethod(getter, types).invoke(object, params);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to build remote repository from " + object.toString(), e);
        }
    }

    private String artifactToMvn(Artifact artifact) throws MojoExecutionException {
        String groupId = artifact.getGroupId();
        String artifactId = artifact.getArtifactId();
        String version = artifact.getBaseVersion();
        String type = artifact.getArtifactHandler().getExtension();
        String classifier = artifact.getClassifier();
        String uri = MavenUtil.isEmpty(classifier) ? ("jar".equals(type) ? String.format("mvn:%s/%s/%s", groupId, artifactId, version) : String.format("mvn:%s/%s/%s/%s", groupId, artifactId, version, type)) : String.format("mvn:%s/%s/%s/%s/%s", groupId, artifactId, version, type, classifier);
        return uri;
    }

    private String[] toArray(List<String> strings) {
        return strings.toArray(new String[strings.size()]);
    }

    private List<String> nonNullList(List<String> list) {
        return list == null ? new ArrayList() : list;
    }
}

