/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tools.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.karaf.tools.utils.KarafPropertiesFile;
import org.apache.karaf.tools.utils.model.KarafPropertyEdit;
import org.apache.karaf.tools.utils.model.KarafPropertyEdits;

public class KarafPropertiesEditor {
    private File inputEtc;
    private File outputEtc;
    private KarafPropertyEdits edits;

    public KarafPropertiesEditor setInputEtc(File inputEtc) {
        this.inputEtc = inputEtc;
        return this;
    }

    public KarafPropertiesEditor setOutputEtc(File outputEtc) {
        this.outputEtc = outputEtc;
        return this;
    }

    public KarafPropertiesEditor setEdits(KarafPropertyEdits edits) {
        this.edits = edits;
        return this;
    }

    public void run() throws IOException {
        HashMap<String, List> editsByFile = new HashMap<String, List>();
        for (KarafPropertyEdit karafPropertyEdit : this.edits.getEdits()) {
            editsByFile.computeIfAbsent(karafPropertyEdit.getFile(), k -> new ArrayList()).add(karafPropertyEdit);
        }
        for (Map.Entry entry : editsByFile.entrySet()) {
            File input = new File(this.inputEtc, (String)entry.getKey());
            KarafPropertiesFile propsFile = new KarafPropertiesFile(input);
            propsFile.load();
            List edits = (List)entry.getValue();
            for (KarafPropertyEdit edit : edits) {
                propsFile.apply(edit);
            }
            File outputFile = new File(this.outputEtc, (String)entry.getKey());
            propsFile.store(outputFile);
        }
    }
}

