/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.shaded.org.jboss.netty.handler.codec.http.websocketx;

import org.apache.kudu.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.kudu.shaded.org.jboss.netty.buffer.ChannelBuffers;
import org.apache.kudu.shaded.org.jboss.netty.channel.Channel;
import org.apache.kudu.shaded.org.jboss.netty.channel.ChannelFuture;
import org.apache.kudu.shaded.org.jboss.netty.channel.ChannelFutureListener;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.http.HttpRequest;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.http.HttpVersion;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocket13FrameDecoder;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocket13FrameEncoder;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketUtil;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketVersion;
import org.apache.kudu.shaded.org.jboss.netty.logging.InternalLogger;
import org.apache.kudu.shaded.org.jboss.netty.logging.InternalLoggerFactory;
import org.apache.kudu.shaded.org.jboss.netty.util.CharsetUtil;

public class WebSocketServerHandshaker13
extends WebSocketServerHandshaker {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketServerHandshaker13.class);
    public static final String WEBSOCKET_13_ACCEPT_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private final boolean allowExtensions;

    public WebSocketServerHandshaker13(String webSocketURL, String subprotocols, boolean allowExtensions) {
        this(webSocketURL, subprotocols, allowExtensions, Long.MAX_VALUE);
    }

    public WebSocketServerHandshaker13(String webSocketURL, String subprotocols, boolean allowExtensions, long maxFramePayloadLength) {
        super(WebSocketVersion.V13, webSocketURL, subprotocols, maxFramePayloadLength);
        this.allowExtensions = allowExtensions;
    }

    public ChannelFuture handshake(Channel channel, HttpRequest req) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Channel %s WS Version 13 server handshake", channel.getId()));
        }
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS);
        String key = req.headers().get("Sec-WebSocket-Key");
        if (key == null) {
            throw new WebSocketHandshakeException("not a WebSocket request: missing key");
        }
        String acceptSeed = key + WEBSOCKET_13_ACCEPT_GUID;
        ChannelBuffer sha1 = WebSocketUtil.sha1(ChannelBuffers.copiedBuffer(acceptSeed, CharsetUtil.US_ASCII));
        String accept = WebSocketUtil.base64(sha1);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("WS Version 13 Server Handshake key: %s. Response: %s.", key, accept));
        }
        res.setStatus(HttpResponseStatus.SWITCHING_PROTOCOLS);
        res.headers().add("Upgrade", "WebSocket".toLowerCase());
        res.headers().add("Connection", "Upgrade");
        res.headers().add("Sec-WebSocket-Accept", accept);
        String subprotocols = req.headers().get("Sec-WebSocket-Protocol");
        if (subprotocols != null) {
            String selectedSubprotocol = this.selectSubprotocol(subprotocols);
            if (selectedSubprotocol == null) {
                throw new WebSocketHandshakeException("Requested subprotocol(s) not supported: " + subprotocols);
            }
            res.headers().add("Sec-WebSocket-Protocol", selectedSubprotocol);
            this.setSelectedSubprotocol(selectedSubprotocol);
        }
        return this.writeHandshakeResponse(channel, res, new WebSocket13FrameEncoder(false), new WebSocket13FrameDecoder(true, this.allowExtensions, this.getMaxFramePayloadLength()));
    }

    public ChannelFuture close(Channel channel, CloseWebSocketFrame frame) {
        ChannelFuture f = channel.write(frame);
        f.addListener(ChannelFutureListener.CLOSE);
        return f;
    }
}

