/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.Marker;

public final class MarkerManager {
    private static final ConcurrentMap<String, Marker> MARKERS = new ConcurrentHashMap<String, Marker>();

    private MarkerManager() {
    }

    public static void clear() {
        MARKERS.clear();
    }

    public static Marker getMarker(String name) {
        MARKERS.putIfAbsent(name, new Log4jMarker(name));
        return (Marker)MARKERS.get(name);
    }

    @Deprecated
    public static Marker getMarker(String name, String parent) {
        Marker parentMarker = (Marker)MARKERS.get(parent);
        if (parentMarker == null) {
            throw new IllegalArgumentException("Parent Marker " + parent + " has not been defined");
        }
        Marker marker = MarkerManager.getMarker(name, parentMarker);
        return marker;
    }

    @Deprecated
    public static Marker getMarker(String name, Marker parent) {
        MARKERS.putIfAbsent(name, new Log4jMarker(name));
        return ((Marker)MARKERS.get(name)).addParents(parent);
    }

    public static class Log4jMarker
    implements Marker {
        private static final long serialVersionUID = 100L;
        private final String name;
        private volatile Marker[] parents;

        private Log4jMarker() {
            this.name = null;
            this.parents = null;
        }

        public Log4jMarker(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Marker name cannot be null.");
            }
            this.name = name;
            this.parents = null;
        }

        @Override
        public synchronized Marker addParents(Marker ... parents) {
            if (parents == null) {
                throw new IllegalArgumentException("A parent marker must be specified");
            }
            Marker[] localParents = this.parents;
            int count = 0;
            int size = parents.length;
            if (localParents != null) {
                Marker[] markerArray = parents;
                int n = parents.length;
                int n2 = 0;
                while (n2 < n) {
                    Marker parent = markerArray[n2];
                    if (!Log4jMarker.contains(parent, localParents) && !parent.isInstanceOf(this)) {
                        ++count;
                    }
                    ++n2;
                }
                if (count == 0) {
                    return this;
                }
                size = localParents.length + count;
            }
            Marker[] markers = new Marker[size];
            if (localParents != null) {
                System.arraycopy(localParents, 0, markers, 0, localParents.length);
            }
            int index = localParents == null ? 0 : localParents.length;
            Marker[] markerArray = parents;
            int n = parents.length;
            int n3 = 0;
            while (n3 < n) {
                Marker parent = markerArray[n3];
                if (localParents == null || !Log4jMarker.contains(parent, localParents) && !parent.isInstanceOf(this)) {
                    markers[index++] = parent;
                }
                ++n3;
            }
            this.parents = markers;
            return this;
        }

        @Override
        public synchronized boolean remove(Marker parent) {
            if (parent == null) {
                throw new IllegalArgumentException("A parent marker must be specified");
            }
            Marker[] localParents = this.parents;
            if (localParents == null) {
                return false;
            }
            int localParentsLength = localParents.length;
            if (localParentsLength == 1) {
                if (localParents[0].equals(parent)) {
                    this.parents = null;
                    return true;
                }
                return false;
            }
            int index = 0;
            Marker[] markers = new Marker[localParentsLength - 1];
            int i = 0;
            while (i < localParentsLength) {
                Marker marker = localParents[i];
                if (!marker.equals(parent)) {
                    if (index == localParentsLength - 1) {
                        return false;
                    }
                    markers[index++] = marker;
                }
                ++i;
            }
            this.parents = markers;
            return true;
        }

        @Override
        public Marker setParents(Marker ... markers) {
            if (markers == null || markers.length == 0) {
                this.parents = null;
            } else {
                Marker[] array = new Marker[markers.length];
                System.arraycopy(markers, 0, array, 0, markers.length);
                this.parents = array;
            }
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Marker[] getParents() {
            if (this.parents == null) {
                return null;
            }
            return Arrays.copyOf(this.parents, this.parents.length);
        }

        @Override
        public boolean hasParents() {
            return this.parents != null;
        }

        @Override
        public boolean isInstanceOf(Marker marker) {
            if (marker == null) {
                throw new IllegalArgumentException("A marker parameter is required");
            }
            if (this == marker) {
                return true;
            }
            Marker[] localParents = this.parents;
            if (localParents != null) {
                int localParentsLength = localParents.length;
                if (localParentsLength == 1) {
                    return Log4jMarker.checkParent(localParents[0], marker);
                }
                if (localParentsLength == 2) {
                    return Log4jMarker.checkParent(localParents[0], marker) || Log4jMarker.checkParent(localParents[1], marker);
                }
                int i = 0;
                while (i < localParentsLength) {
                    Marker localParent = localParents[i];
                    if (Log4jMarker.checkParent(localParent, marker)) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        @Override
        public boolean isInstanceOf(String markerName) {
            if (markerName == null) {
                throw new IllegalArgumentException("A marker name is required");
            }
            if (markerName.equals(this.getName())) {
                return true;
            }
            Marker marker = (Marker)MARKERS.get(markerName);
            if (marker == null) {
                return false;
            }
            Marker[] localParents = this.parents;
            if (localParents != null) {
                int localParentsLength = localParents.length;
                if (localParentsLength == 1) {
                    return Log4jMarker.checkParent(localParents[0], marker);
                }
                if (localParentsLength == 2) {
                    return Log4jMarker.checkParent(localParents[0], marker) || Log4jMarker.checkParent(localParents[1], marker);
                }
                int i = 0;
                while (i < localParentsLength) {
                    Marker localParent = localParents[i];
                    if (Log4jMarker.checkParent(localParent, marker)) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        private static boolean checkParent(Marker parent, Marker marker) {
            Marker[] localParents;
            if (parent == marker) {
                return true;
            }
            Marker[] markerArray = localParents = parent instanceof Log4jMarker ? ((Log4jMarker)parent).parents : parent.getParents();
            if (localParents != null) {
                int localParentsLength = localParents.length;
                if (localParentsLength == 1) {
                    return Log4jMarker.checkParent(localParents[0], marker);
                }
                if (localParentsLength == 2) {
                    return Log4jMarker.checkParent(localParents[0], marker) || Log4jMarker.checkParent(localParents[1], marker);
                }
                int i = 0;
                while (i < localParentsLength) {
                    Marker localParent = localParents[i];
                    if (Log4jMarker.checkParent(localParent, marker)) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        private static boolean contains(Marker parent, Marker ... localParents) {
            int i = 0;
            int localParentsLength = localParents.length;
            while (i < localParentsLength) {
                Marker marker = localParents[i];
                if (marker == parent) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Marker)) {
                return false;
            }
            Marker marker = (Marker)o;
            return this.name.equals(marker.getName());
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.name);
            Marker[] localParents = this.parents;
            if (localParents != null) {
                Log4jMarker.addParentInfo(sb, localParents);
            }
            return sb.toString();
        }

        private static void addParentInfo(StringBuilder sb, Marker ... parents) {
            sb.append("[ ");
            boolean first = true;
            int i = 0;
            int parentsLength = parents.length;
            while (i < parentsLength) {
                Marker[] p;
                Marker marker = parents[i];
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                sb.append(marker.getName());
                Marker[] markerArray = p = marker instanceof Log4jMarker ? ((Log4jMarker)marker).parents : marker.getParents();
                if (p != null) {
                    Log4jMarker.addParentInfo(sb, p);
                }
                ++i;
            }
            sb.append(" ]");
        }
    }
}

