/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;

public final class PropertiesUtil {
    private static final PropertiesUtil LOG4J_PROPERTIES = new PropertiesUtil("log4j2.component.properties");
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final Properties props;

    public PropertiesUtil(Properties props) {
        this.props = props;
    }

    static Properties loadClose(InputStream in, Object source) {
        Properties props;
        block12: {
            props = new Properties();
            if (in != null) {
                try {
                    try {
                        props.load(in);
                    }
                    catch (IOException e) {
                        LOGGER.error("Unable to read {}", source, e);
                        try {
                            in.close();
                        }
                        catch (IOException e2) {
                            LOGGER.error("Unable to close {}", source, e2);
                        }
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("Unable to close {}", source, e);
                    }
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.error("Unable to close {}", source, e);
                }
            }
        }
        return props;
    }

    public PropertiesUtil(String propertiesFileName) {
        Properties properties = new Properties();
        for (URL url : LoaderUtil.findResources(propertiesFileName)) {
            InputStream in = null;
            try {
                try {
                    in = url.openStream();
                    properties.load(in);
                }
                catch (IOException ioe) {
                    LOGGER.error("Unable to read {}", url.toString(), ioe);
                    if (in == null) continue;
                    try {
                        in.close();
                    }
                    catch (IOException ioe2) {
                        LOGGER.error("Unable to close {}", url.toString(), ioe2);
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {
                        LOGGER.error("Unable to close {}", url.toString(), ioe);
                    }
                }
                throw throwable;
            }
            if (in == null) continue;
            try {
                in.close();
            }
            catch (IOException ioe) {
                LOGGER.error("Unable to close {}", url.toString(), ioe);
            }
        }
        this.props = properties;
    }

    public static PropertiesUtil getProperties() {
        return LOG4J_PROPERTIES;
    }

    public String getStringProperty(String name) {
        String prop = null;
        try {
            prop = System.getProperty(name);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return prop == null ? this.props.getProperty(name) : prop;
    }

    public int getIntegerProperty(String name, int defaultValue) {
        String prop = null;
        try {
            prop = System.getProperty(name);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (prop == null) {
            prop = this.props.getProperty(name);
        }
        if (prop != null) {
            try {
                return Integer.parseInt(prop);
            }
            catch (Exception ignored) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public long getLongProperty(String name, long defaultValue) {
        String prop = null;
        try {
            prop = System.getProperty(name);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (prop == null) {
            prop = this.props.getProperty(name);
        }
        if (prop != null) {
            try {
                return Long.parseLong(prop);
            }
            catch (Exception ignored) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public String getStringProperty(String name, String defaultValue) {
        String prop = this.getStringProperty(name);
        return prop == null ? defaultValue : prop;
    }

    public boolean getBooleanProperty(String name) {
        return this.getBooleanProperty(name, false);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        String prop = this.getStringProperty(name);
        return prop == null ? defaultValue : "true".equalsIgnoreCase(prop);
    }

    public static Properties getSystemProperties() {
        try {
            return new Properties(System.getProperties());
        }
        catch (SecurityException ex) {
            LOGGER.error("Unable to access system properties.", (Throwable)ex);
            return new Properties();
        }
    }
}

