/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.StringLayout;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.Encoder;
import org.apache.logging.log4j.core.layout.LockingStringBuilderEncoder;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.core.util.StringEncoder;
import org.apache.logging.log4j.layout.template.json.JsonTemplateLayoutDefaults;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolverContext;
import org.apache.logging.log4j.layout.template.json.resolver.StackTraceElementObjectResolverContext;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolver;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolvers;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;
import org.apache.logging.log4j.layout.template.json.util.Recycler;
import org.apache.logging.log4j.layout.template.json.util.RecyclerFactory;
import org.apache.logging.log4j.layout.template.json.util.Uris;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="JsonTemplateLayout", category="Core", elementType="layout")
public class JsonTemplateLayout
implements StringLayout {
    private static final Map<String, String> CONTENT_FORMAT = Collections.singletonMap("version", "1");
    private final Charset charset;
    private final String contentType;
    private final TemplateResolver<LogEvent> eventResolver;
    private final String eventDelimiter;
    private final Recycler<Context> contextRecycler;

    private JsonTemplateLayout(Builder builder) {
        this.charset = builder.charset;
        this.contentType = "application/json; charset=" + this.charset;
        String eventDelimiterSuffix = builder.isNullEventDelimiterEnabled() ? "\u0000" : "";
        this.eventDelimiter = builder.eventDelimiter + eventDelimiterSuffix;
        Configuration configuration = builder.configuration;
        StrSubstitutor substitutor = configuration.getStrSubstitutor();
        JsonWriter jsonWriter = JsonWriter.newBuilder().setMaxStringLength(builder.maxStringLength).setTruncatedStringSuffix(builder.truncatedStringSuffix).build();
        TemplateResolver<StackTraceElement> stackTraceElementObjectResolver = builder.stackTraceEnabled ? JsonTemplateLayout.createStackTraceElementResolver(builder, substitutor, jsonWriter) : null;
        this.eventResolver = this.createEventResolver(builder, configuration, substitutor, this.charset, jsonWriter, stackTraceElementObjectResolver);
        this.contextRecycler = JsonTemplateLayout.createContextRecycler(builder, jsonWriter);
    }

    private static TemplateResolver<StackTraceElement> createStackTraceElementResolver(Builder builder, StrSubstitutor substitutor, JsonWriter jsonWriter) {
        StackTraceElementObjectResolverContext stackTraceElementObjectResolverContext = StackTraceElementObjectResolverContext.newBuilder().setSubstitutor(substitutor).setJsonWriter(jsonWriter).build();
        String stackTraceElementTemplate = JsonTemplateLayout.readStackTraceElementTemplate(builder);
        return TemplateResolvers.ofTemplate(stackTraceElementObjectResolverContext, stackTraceElementTemplate);
    }

    private TemplateResolver<LogEvent> createEventResolver(Builder builder, Configuration configuration, StrSubstitutor substitutor, Charset charset, JsonWriter jsonWriter, TemplateResolver<StackTraceElement> stackTraceElementObjectResolver) {
        String eventTemplate = JsonTemplateLayout.readEventTemplate(builder);
        float maxByteCountPerChar = builder.charset.newEncoder().maxBytesPerChar();
        int maxStringByteCount = Math.toIntExact(Math.round(maxByteCountPerChar * (float)builder.maxStringLength));
        EventResolverContext resolverContext = EventResolverContext.newBuilder().setConfiguration(configuration).setSubstitutor(substitutor).setCharset(charset).setJsonWriter(jsonWriter).setRecyclerFactory(builder.recyclerFactory).setMaxStringByteCount(maxStringByteCount).setLocationInfoEnabled(builder.locationInfoEnabled).setStackTraceEnabled(builder.stackTraceEnabled).setStackTraceElementObjectResolver(stackTraceElementObjectResolver).setEventTemplateAdditionalFields(builder.eventTemplateAdditionalFields.additionalFields).build();
        return TemplateResolvers.ofTemplate(resolverContext, eventTemplate);
    }

    private static String readEventTemplate(Builder builder) {
        return JsonTemplateLayout.readTemplate(builder.eventTemplate, builder.eventTemplateUri, builder.charset);
    }

    private static String readStackTraceElementTemplate(Builder builder) {
        return JsonTemplateLayout.readTemplate(builder.stackTraceElementTemplate, builder.stackTraceElementTemplateUri, builder.charset);
    }

    private static String readTemplate(String template, String templateUri, Charset charset) {
        return Strings.isBlank((String)template) ? Uris.readUri(templateUri, charset) : template;
    }

    private static Recycler<Context> createContextRecycler(Builder builder, JsonWriter jsonWriter) {
        Supplier<Context> supplier = JsonTemplateLayout.createContextSupplier(builder.charset, jsonWriter);
        return builder.recyclerFactory.create(supplier, Context::close);
    }

    private static Supplier<Context> createContextSupplier(Charset charset, JsonWriter jsonWriter) {
        return () -> {
            JsonWriter clonedJsonWriter = jsonWriter.clone();
            LockingStringBuilderEncoder encoder = Constants.ENABLE_DIRECT_ENCODERS ? new LockingStringBuilderEncoder(charset) : null;
            return new Context(clonedJsonWriter, (Encoder)encoder);
        };
    }

    public byte[] toByteArray(LogEvent event) {
        String eventJson = this.toSerializable(event);
        return StringEncoder.toBytes((String)eventJson, (Charset)this.charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toSerializable(LogEvent event) {
        Context context = this.acquireContext();
        JsonWriter jsonWriter = context.jsonWriter;
        StringBuilder stringBuilder = jsonWriter.getStringBuilder();
        try {
            this.eventResolver.resolve(event, jsonWriter);
            stringBuilder.append(this.eventDelimiter);
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            this.contextRecycler.release(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(LogEvent event, ByteBufferDestination destination) {
        Context context = this.acquireContext();
        JsonWriter jsonWriter = context.jsonWriter;
        StringBuilder stringBuilder = jsonWriter.getStringBuilder();
        Encoder<StringBuilder> encoder = context.encoder;
        try {
            this.eventResolver.resolve(event, jsonWriter);
            stringBuilder.append(this.eventDelimiter);
            if (encoder == null) {
                String eventJson = stringBuilder.toString();
                byte[] eventJsonBytes = StringEncoder.toBytes((String)eventJson, (Charset)this.charset);
                destination.writeBytes(eventJsonBytes, 0, eventJsonBytes.length);
            } else {
                encoder.encode((Object)stringBuilder, destination);
            }
        }
        finally {
            this.contextRecycler.release(context);
        }
    }

    Context acquireContext() {
        return this.contextRecycler.acquire();
    }

    public byte[] getFooter() {
        return null;
    }

    public byte[] getHeader() {
        return null;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Map<String, String> getContentFormat() {
        return CONTENT_FORMAT;
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    @Plugin(name="EventTemplateAdditionalField", category="Core", printObject=true)
    public static final class EventTemplateAdditionalField {
        private final String key;
        private final String value;
        private final Type type;

        private EventTemplateAdditionalField(Builder builder) {
            this.key = builder.key;
            this.value = builder.value;
            this.type = builder.type;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public Type getType() {
            return this.type;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            EventTemplateAdditionalField that = (EventTemplateAdditionalField)object;
            return this.key.equals(that.key) && this.value.equals(that.value) && this.type == that.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.key, this.value, this.type});
        }

        public String toString() {
            String formattedValue = Type.STRING.equals((Object)this.type) ? String.format("\"%s\"", this.value) : this.value;
            return String.format("%s=%s", this.key, formattedValue);
        }

        @PluginBuilderFactory
        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder
        implements org.apache.logging.log4j.core.util.Builder<EventTemplateAdditionalField> {
            private String key;
            private String value;
            private Type type = Type.STRING;

            public Builder setKey(String key) {
                this.key = key;
                return this;
            }

            public Builder setValue(String value) {
                this.value = value;
                return this;
            }

            public Builder setType(Type type) {
                this.type = type;
                return this;
            }

            public EventTemplateAdditionalField build() {
                this.validate();
                return new EventTemplateAdditionalField(this);
            }

            private void validate() {
                if (Strings.isBlank((String)this.key)) {
                    throw new IllegalArgumentException("blank key");
                }
                if (Strings.isBlank((String)this.value)) {
                    throw new IllegalArgumentException("blank value");
                }
                Objects.requireNonNull(this.type, "type");
            }
        }

        public static enum Type {
            STRING,
            JSON;

        }
    }

    @Plugin(name="EventTemplateAdditionalFields", category="Core", printObject=true)
    public static final class EventTemplateAdditionalFields {
        private static final EventTemplateAdditionalFields EMPTY = EventTemplateAdditionalFields.newBuilder().build();
        private final EventTemplateAdditionalField[] additionalFields;

        private EventTemplateAdditionalFields(Builder builder) {
            this.additionalFields = builder.additionalFields != null ? builder.additionalFields : new EventTemplateAdditionalField[]{};
        }

        public EventTemplateAdditionalField[] getAdditionalFields() {
            return this.additionalFields;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            EventTemplateAdditionalFields that = (EventTemplateAdditionalFields)object;
            return Arrays.equals(this.additionalFields, that.additionalFields);
        }

        public int hashCode() {
            return Arrays.hashCode(this.additionalFields);
        }

        public String toString() {
            return Arrays.toString(this.additionalFields);
        }

        @PluginBuilderFactory
        public static Builder newBuilder() {
            return new Builder();
        }

        static /* synthetic */ EventTemplateAdditionalFields access$1500() {
            return EMPTY;
        }

        public static class Builder
        implements org.apache.logging.log4j.core.util.Builder<EventTemplateAdditionalFields> {
            @PluginElement(value="AdditionalField")
            private EventTemplateAdditionalField[] additionalFields;

            private Builder() {
            }

            public EventTemplateAdditionalField[] getAdditionalFields() {
                return this.additionalFields;
            }

            public Builder setAdditionalFields(EventTemplateAdditionalField[] additionalFields) {
                this.additionalFields = additionalFields;
                return this;
            }

            public EventTemplateAdditionalFields build() {
                return new EventTemplateAdditionalFields(this);
            }
        }
    }

    public static final class Builder
    implements org.apache.logging.log4j.core.util.Builder<JsonTemplateLayout> {
        @PluginConfiguration
        private Configuration configuration;
        @PluginBuilderAttribute
        private Charset charset = JsonTemplateLayoutDefaults.getCharset();
        @PluginBuilderAttribute
        private boolean locationInfoEnabled = JsonTemplateLayoutDefaults.isLocationInfoEnabled();
        @PluginBuilderAttribute
        private boolean stackTraceEnabled = JsonTemplateLayoutDefaults.isStackTraceEnabled();
        @PluginBuilderAttribute
        private String eventTemplate = JsonTemplateLayoutDefaults.getEventTemplate();
        @PluginBuilderAttribute
        private String eventTemplateUri = JsonTemplateLayoutDefaults.getEventTemplateUri();
        @PluginElement(value="EventTemplateAdditionalFields")
        private EventTemplateAdditionalFields eventTemplateAdditionalFields = EventTemplateAdditionalFields.access$1500();
        @PluginBuilderAttribute
        private String stackTraceElementTemplate = JsonTemplateLayoutDefaults.getStackTraceElementTemplate();
        @PluginBuilderAttribute
        private String stackTraceElementTemplateUri = JsonTemplateLayoutDefaults.getStackTraceElementTemplateUri();
        @PluginBuilderAttribute
        private String eventDelimiter = JsonTemplateLayoutDefaults.getEventDelimiter();
        @PluginBuilderAttribute
        private boolean nullEventDelimiterEnabled = JsonTemplateLayoutDefaults.isNullEventDelimiterEnabled();
        @PluginBuilderAttribute
        private int maxStringLength = JsonTemplateLayoutDefaults.getMaxStringLength();
        @PluginBuilderAttribute
        private String truncatedStringSuffix = JsonTemplateLayoutDefaults.getTruncatedStringSuffix();
        @PluginBuilderAttribute
        private RecyclerFactory recyclerFactory = JsonTemplateLayoutDefaults.getRecyclerFactory();

        private Builder() {
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public Builder setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public Builder setCharset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public boolean isLocationInfoEnabled() {
            return this.locationInfoEnabled;
        }

        public Builder setLocationInfoEnabled(boolean locationInfoEnabled) {
            this.locationInfoEnabled = locationInfoEnabled;
            return this;
        }

        public boolean isStackTraceEnabled() {
            return this.stackTraceEnabled;
        }

        public Builder setStackTraceEnabled(boolean stackTraceEnabled) {
            this.stackTraceEnabled = stackTraceEnabled;
            return this;
        }

        public String getEventTemplate() {
            return this.eventTemplate;
        }

        public Builder setEventTemplate(String eventTemplate) {
            this.eventTemplate = eventTemplate;
            return this;
        }

        public String getEventTemplateUri() {
            return this.eventTemplateUri;
        }

        public Builder setEventTemplateUri(String eventTemplateUri) {
            this.eventTemplateUri = eventTemplateUri;
            return this;
        }

        public EventTemplateAdditionalFields getEventTemplateAdditionalFields() {
            return this.eventTemplateAdditionalFields;
        }

        public Builder setEventTemplateAdditionalFields(EventTemplateAdditionalFields eventTemplateAdditionalFields) {
            this.eventTemplateAdditionalFields = eventTemplateAdditionalFields;
            return this;
        }

        public String getStackTraceElementTemplate() {
            return this.stackTraceElementTemplate;
        }

        public Builder setStackTraceElementTemplate(String stackTraceElementTemplate) {
            this.stackTraceElementTemplate = stackTraceElementTemplate;
            return this;
        }

        public String getStackTraceElementTemplateUri() {
            return this.stackTraceElementTemplateUri;
        }

        public Builder setStackTraceElementTemplateUri(String stackTraceElementTemplateUri) {
            this.stackTraceElementTemplateUri = stackTraceElementTemplateUri;
            return this;
        }

        public String getEventDelimiter() {
            return this.eventDelimiter;
        }

        public Builder setEventDelimiter(String eventDelimiter) {
            this.eventDelimiter = eventDelimiter;
            return this;
        }

        public boolean isNullEventDelimiterEnabled() {
            return this.nullEventDelimiterEnabled;
        }

        public Builder setNullEventDelimiterEnabled(boolean nullEventDelimiterEnabled) {
            this.nullEventDelimiterEnabled = nullEventDelimiterEnabled;
            return this;
        }

        public int getMaxStringLength() {
            return this.maxStringLength;
        }

        public Builder setMaxStringLength(int maxStringLength) {
            this.maxStringLength = maxStringLength;
            return this;
        }

        public String getTruncatedStringSuffix() {
            return this.truncatedStringSuffix;
        }

        public Builder setTruncatedStringSuffix(String truncatedStringSuffix) {
            this.truncatedStringSuffix = truncatedStringSuffix;
            return this;
        }

        public RecyclerFactory getRecyclerFactory() {
            return this.recyclerFactory;
        }

        public Builder setRecyclerFactory(RecyclerFactory recyclerFactory) {
            this.recyclerFactory = recyclerFactory;
            return this;
        }

        public JsonTemplateLayout build() {
            this.validate();
            return new JsonTemplateLayout(this);
        }

        private void validate() {
            Objects.requireNonNull(this.configuration, "config");
            if (Strings.isBlank((String)this.eventTemplate) && Strings.isBlank((String)this.eventTemplateUri)) {
                throw new IllegalArgumentException("both eventTemplate and eventTemplateUri are blank");
            }
            Objects.requireNonNull(this.eventTemplateAdditionalFields, "eventTemplateAdditionalFields");
            if (this.stackTraceEnabled && Strings.isBlank((String)this.stackTraceElementTemplate) && Strings.isBlank((String)this.stackTraceElementTemplateUri)) {
                throw new IllegalArgumentException("both stackTraceElementTemplate and stackTraceElementTemplateUri are blank");
            }
            if (this.maxStringLength <= 0) {
                throw new IllegalArgumentException("was expecting a non-zero positive maxStringLength: " + this.maxStringLength);
            }
            Objects.requireNonNull(this.truncatedStringSuffix, "truncatedStringSuffix");
            Objects.requireNonNull(this.recyclerFactory, "recyclerFactory");
        }
    }

    static final class Context
    implements AutoCloseable {
        final JsonWriter jsonWriter;
        final Encoder<StringBuilder> encoder;

        private Context(JsonWriter jsonWriter, Encoder<StringBuilder> encoder) {
            this.jsonWriter = jsonWriter;
            this.encoder = encoder;
        }

        @Override
        public void close() {
            this.jsonWriter.close();
        }
    }
}

