/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolver;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolverContext;
import org.apache.logging.log4j.layout.template.json.resolver.ExceptionInternalResolverFactory;
import org.apache.logging.log4j.layout.template.json.resolver.StackTraceStringResolver;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverConfig;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;

class ExceptionResolver
implements EventResolver {
    private static final ExceptionInternalResolverFactory INTERNAL_RESOLVER_FACTORY = new ExceptionInternalResolverFactory(){

        @Override
        EventResolver createClassNameResolver() {
            return (logEvent, jsonWriter) -> {
                Throwable exception = logEvent.getThrown();
                if (exception == null) {
                    jsonWriter.writeNull();
                } else {
                    String exceptionClassName = exception.getClass().getCanonicalName();
                    jsonWriter.writeString(exceptionClassName);
                }
            };
        }

        @Override
        EventResolver createMessageResolver(EventResolverContext context) {
            return (logEvent, jsonWriter) -> {
                Throwable exception = logEvent.getThrown();
                if (exception == null) {
                    jsonWriter.writeNull();
                } else {
                    String exceptionMessage = exception.getMessage();
                    jsonWriter.writeString(exceptionMessage);
                }
            };
        }

        @Override
        EventResolver createStackTraceStringResolver(EventResolverContext context) {
            StackTraceStringResolver stackTraceStringResolver = new StackTraceStringResolver(context);
            return (logEvent, jsonWriter) -> {
                Throwable exception = logEvent.getThrown();
                if (exception == null) {
                    jsonWriter.writeNull();
                } else {
                    stackTraceStringResolver.resolve(exception, jsonWriter);
                }
            };
        }

        @Override
        EventResolver createStackTraceObjectResolver(EventResolverContext context) {
            return (logEvent, jsonWriter) -> {
                Throwable exception = logEvent.getThrown();
                if (exception == null) {
                    jsonWriter.writeNull();
                } else {
                    context.getStackTraceObjectResolver().resolve(exception, jsonWriter);
                }
            };
        }
    };
    private final boolean stackTraceEnabled;
    private final EventResolver internalResolver;

    ExceptionResolver(EventResolverContext context, TemplateResolverConfig config) {
        this.stackTraceEnabled = context.isStackTraceEnabled();
        this.internalResolver = INTERNAL_RESOLVER_FACTORY.createInternalResolver(context, config);
    }

    static String getName() {
        return "exception";
    }

    @Override
    public boolean isResolvable() {
        return this.stackTraceEnabled;
    }

    @Override
    public boolean isResolvable(LogEvent logEvent) {
        return this.stackTraceEnabled && logEvent.getThrown() != null;
    }

    @Override
    public void resolve(LogEvent logEvent, JsonWriter jsonWriter) {
        this.internalResolver.resolve(logEvent, jsonWriter);
    }
}

