/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.name;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Optional;
import org.apache.logging.log4j.plugins.name.NameProvider;
import org.apache.logging.log4j.util.ReflectionUtil;

public interface AnnotatedElementNameProvider<A extends Annotation> {
    public static String getName(AnnotatedElement element) {
        for (Annotation annotation : element.getAnnotations()) {
            Optional<String> specifiedName = AnnotatedElementNameProvider.getSpecifiedNameForAnnotation(annotation);
            if (!specifiedName.isPresent()) continue;
            return specifiedName.get();
        }
        if (element instanceof Field) {
            return ((Field)element).getName();
        }
        if (element instanceof Method) {
            Method method = (Method)element;
            String methodName = method.getName();
            if (methodName.startsWith("set")) {
                return Introspector.decapitalize(methodName.substring(3));
            }
            if (methodName.startsWith("with")) {
                return Introspector.decapitalize(methodName.substring(4));
            }
            return methodName;
        }
        if (element instanceof Parameter) {
            return ((Parameter)element).getName();
        }
        throw new IllegalArgumentException("Unknown element type for naming: " + element.getClass());
    }

    public static <A extends Annotation> Optional<String> getSpecifiedNameForAnnotation(A annotation) {
        return Optional.ofNullable(annotation.annotationType().getAnnotation(NameProvider.class)).map(NameProvider::value).flatMap(clazz -> {
            AnnotatedElementNameProvider factory = (AnnotatedElementNameProvider)ReflectionUtil.instantiate((Class)clazz);
            return factory.getSpecifiedName(annotation);
        });
    }

    public Optional<String> getSpecifiedName(A var1);
}

