/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.core;

import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseTokenizer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public final class StopAnalyzer
extends StopwordAnalyzerBase {
    public static final CharArraySet ENGLISH_STOP_WORDS_SET = StandardAnalyzer.ENGLISH_STOP_WORDS_SET;

    public StopAnalyzer() {
        this(ENGLISH_STOP_WORDS_SET);
    }

    public StopAnalyzer(CharArraySet stopWords) {
        super(stopWords);
    }

    public StopAnalyzer(Path stopwordsFile) throws IOException {
        this(StopAnalyzer.loadStopwordSet((Path)stopwordsFile));
    }

    public StopAnalyzer(Reader stopwords) throws IOException {
        this(StopAnalyzer.loadStopwordSet((Reader)stopwords));
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        LowerCaseTokenizer source = new LowerCaseTokenizer();
        return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)new StopFilter((TokenStream)source, this.stopwords));
    }

    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new LowerCaseFilter(in);
    }
}

