/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.MappedMultiFields;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.ReaderSlice;
import org.apache.lucene.util.BytesRef;

public abstract class FieldsConsumer
implements Closeable {
    protected FieldsConsumer() {
    }

    public abstract void write(Fields var1) throws IOException;

    public void merge(MergeState mergeState) throws IOException {
        ArrayList<Fields> fields = new ArrayList<Fields>();
        ArrayList<ReaderSlice> slices = new ArrayList<ReaderSlice>();
        int docBase = 0;
        for (int readerIndex = 0; readerIndex < mergeState.readers.size(); ++readerIndex) {
            AtomicReader reader = mergeState.readers.get(readerIndex);
            Fields f = reader.fields();
            int maxDoc = reader.maxDoc();
            if (f != null) {
                slices.add(new ReaderSlice(docBase, maxDoc, readerIndex));
                fields.add(f);
            }
            docBase += maxDoc;
        }
        MappedMultiFields mergedFields = new MappedMultiFields(mergeState, new MultiFields(fields.toArray(Fields.EMPTY_ARRAY), slices.toArray(ReaderSlice.EMPTY_ARRAY)));
        this.write(mergedFields);
    }

    public abstract Comparator<BytesRef> getComparator();

    @Override
    public abstract void close() throws IOException;
}

