/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.compressing;

import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentReader;

class MatchingReaders {
    final SegmentReader[] matchingSegmentReaders;
    final int count;

    MatchingReaders(MergeState mergeState) {
        int numReaders = mergeState.readers.size();
        int matchedCount = 0;
        this.matchingSegmentReaders = new SegmentReader[numReaders];
        for (int i = 0; i < numReaders; ++i) {
            AtomicReader reader = mergeState.readers.get(i);
            if (!(reader instanceof SegmentReader)) continue;
            SegmentReader segmentReader = (SegmentReader)reader;
            boolean same = true;
            FieldInfos segmentFieldInfos = segmentReader.getFieldInfos();
            for (FieldInfo fi : segmentFieldInfos) {
                FieldInfo other = mergeState.fieldInfos.fieldInfo(fi.number);
                if (other != null && other.name.equals(fi.name)) continue;
                same = false;
                break;
            }
            if (!same) continue;
            this.matchingSegmentReaders[i] = segmentReader;
            ++matchedCount;
        }
        this.count = matchedCount;
        if (mergeState.infoStream.isEnabled("SM")) {
            mergeState.infoStream.message("SM", "merge store matchedCount=" + this.count + " vs " + mergeState.readers.size());
            if (this.count != mergeState.readers.size()) {
                mergeState.infoStream.message("SM", "" + (mergeState.readers.size() - this.count) + " non-bulk merges");
            }
        }
    }
}

