/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene42;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.fst.BytesRefFSTEnum;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;
import org.apache.lucene.util.packed.BlockPackedReader;
import org.apache.lucene.util.packed.MonotonicBlockPackedReader;
import org.apache.lucene.util.packed.PackedInts;

class Lucene42DocValuesProducer
extends DocValuesProducer {
    private final Map<String, NumericEntry> numerics;
    private final Map<String, BinaryEntry> binaries;
    private final Map<String, FSTEntry> fsts;
    private final IndexInput data;
    private final int version;
    private final int numEntries;
    private final Map<String, NumericDocValues> numericInstances;
    private final Map<String, BinaryDocValues> binaryInstances;
    private final Map<String, FST<Long>> fstInstances;
    private final Map<String, Accountable> numericInfo;
    private final Map<String, Accountable> binaryInfo;
    private final Map<String, Accountable> addressInfo;
    private final int maxDoc;
    private final AtomicLong ramBytesUsed;
    static final byte NUMBER = 0;
    static final byte BYTES = 1;
    static final byte FST = 2;
    static final int BLOCK_SIZE = 4096;
    static final byte DELTA_COMPRESSED = 0;
    static final byte TABLE_COMPRESSED = 1;
    static final byte UNCOMPRESSED = 2;
    static final byte GCD_COMPRESSED = 3;
    static final int VERSION_START = 0;
    static final int VERSION_GCD_COMPRESSION = 1;
    static final int VERSION_CHECKSUM = 2;
    static final int VERSION_CURRENT = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene42DocValuesProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        boolean success;
        block11: {
            ChecksumIndexInput in;
            block10: {
                this.numericInstances = new HashMap<String, NumericDocValues>();
                this.binaryInstances = new HashMap<String, BinaryDocValues>();
                this.fstInstances = new HashMap<String, FST<Long>>();
                this.numericInfo = new HashMap<String, Accountable>();
                this.binaryInfo = new HashMap<String, Accountable>();
                this.addressInfo = new HashMap<String, Accountable>();
                this.maxDoc = state.segmentInfo.getDocCount();
                String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
                in = state.directory.openChecksumInput(metaName, state.context);
                success = false;
                this.ramBytesUsed = new AtomicLong(RamUsageEstimator.shallowSizeOfInstance(this.getClass()));
                try {
                    this.version = CodecUtil.checkHeader(in, metaCodec, 0, 2);
                    this.numerics = new HashMap<String, NumericEntry>();
                    this.binaries = new HashMap<String, BinaryEntry>();
                    this.fsts = new HashMap<String, FSTEntry>();
                    this.numEntries = this.readFields(in, state.fieldInfos);
                    if (this.version >= 2) {
                        CodecUtil.checkFooter(in);
                    } else {
                        CodecUtil.checkEOF(in);
                    }
                    success = true;
                    if (!success) break block10;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(in);
                        throw throwable;
                    } else {
                        IOUtils.closeWhileHandlingException(in);
                    }
                    throw throwable;
                }
                IOUtils.close(in);
                break block11;
            }
            IOUtils.closeWhileHandlingException(in);
        }
        String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
        this.data = state.directory.openInput(dataName, state.context);
        success = false;
        try {
            int version2 = CodecUtil.checkHeader(this.data, dataCodec, 0, 2);
            if (this.version != version2) {
                throw new CorruptIndexException("Format versions mismatch");
            }
            if (this.version >= 2) {
                CodecUtil.retrieveChecksum(this.data);
            }
            if (success = true) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this.data);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(this.data);
    }

    private int readFields(IndexInput meta, FieldInfos infos) throws IOException {
        int numEntries = 0;
        int fieldNumber = meta.readVInt();
        while (fieldNumber != -1) {
            Object entry;
            ++numEntries;
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber + " (resource=" + meta + ")");
            }
            byte fieldType = meta.readByte();
            if (fieldType == 0) {
                entry = new NumericEntry();
                ((NumericEntry)entry).offset = meta.readLong();
                ((NumericEntry)entry).format = meta.readByte();
                switch (((NumericEntry)entry).format) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                    default: {
                        throw new CorruptIndexException("Unknown format: " + ((NumericEntry)entry).format + ", input=" + meta);
                    }
                }
                if (((NumericEntry)entry).format != 2) {
                    ((NumericEntry)entry).packedIntsVersion = meta.readVInt();
                }
                this.numerics.put(info.name, (NumericEntry)entry);
            } else if (fieldType == 1) {
                entry = new BinaryEntry();
                ((BinaryEntry)entry).offset = meta.readLong();
                ((BinaryEntry)entry).numBytes = meta.readLong();
                ((BinaryEntry)entry).minLength = meta.readVInt();
                ((BinaryEntry)entry).maxLength = meta.readVInt();
                if (((BinaryEntry)entry).minLength != ((BinaryEntry)entry).maxLength) {
                    ((BinaryEntry)entry).packedIntsVersion = meta.readVInt();
                    ((BinaryEntry)entry).blockSize = meta.readVInt();
                }
                this.binaries.put(info.name, (BinaryEntry)entry);
            } else if (fieldType == 2) {
                entry = new FSTEntry();
                ((FSTEntry)entry).offset = meta.readLong();
                ((FSTEntry)entry).numOrds = meta.readVLong();
                this.fsts.put(info.name, (FSTEntry)entry);
            } else {
                throw new CorruptIndexException("invalid entry type: " + fieldType + ", input=" + meta);
            }
            fieldNumber = meta.readVInt();
        }
        return numEntries;
    }

    @Override
    public synchronized NumericDocValues getNumeric(FieldInfo field) throws IOException {
        NumericDocValues instance = this.numericInstances.get(field.name);
        if (instance == null) {
            instance = this.loadNumeric(field);
            this.numericInstances.put(field.name, instance);
        }
        return instance;
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed.get();
    }

    @Override
    public synchronized Iterable<? extends Accountable> getChildResources() {
        ArrayList<Accountable> resources = new ArrayList<Accountable>();
        resources.addAll(Accountables.namedAccountables("numeric field", this.numericInfo));
        resources.addAll(Accountables.namedAccountables("binary field", this.binaryInfo));
        resources.addAll(Accountables.namedAccountables("addresses field", this.addressInfo));
        resources.addAll(Accountables.namedAccountables("terms dict field", this.fstInstances));
        return Collections.unmodifiableList(resources);
    }

    @Override
    public void checkIntegrity() throws IOException {
        if (this.version >= 2) {
            CodecUtil.checksumEntireFile(this.data);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(entries=" + this.numEntries + ")";
    }

    private NumericDocValues loadNumeric(FieldInfo field) throws IOException {
        NumericEntry entry = this.numerics.get(field.name);
        this.data.seek(entry.offset);
        switch (entry.format) {
            case 1: {
                int size = this.data.readVInt();
                if (size > 256) {
                    throw new CorruptIndexException("TABLE_COMPRESSED cannot have more than 256 distinct values, input=" + this.data);
                }
                final long[] decode = new long[size];
                for (int i = 0; i < decode.length; ++i) {
                    decode[i] = this.data.readLong();
                }
                int formatID = this.data.readVInt();
                int bitsPerValue = this.data.readVInt();
                final PackedInts.Reader ordsReader = PackedInts.getReaderNoHeader(this.data, PackedInts.Format.byId(formatID), entry.packedIntsVersion, this.maxDoc, bitsPerValue);
                this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf(decode) + ordsReader.ramBytesUsed());
                this.numericInfo.put(field.name, ordsReader);
                return new NumericDocValues(){

                    @Override
                    public long get(int docID) {
                        return decode[(int)ordsReader.get(docID)];
                    }
                };
            }
            case 0: {
                int blockSize = this.data.readVInt();
                BlockPackedReader reader = new BlockPackedReader(this.data, entry.packedIntsVersion, blockSize, this.maxDoc, false);
                this.ramBytesUsed.addAndGet(reader.ramBytesUsed());
                this.numericInfo.put(field.name, reader);
                return reader;
            }
            case 2: {
                final byte[] bytes = new byte[this.maxDoc];
                this.data.readBytes(bytes, 0, bytes.length);
                this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf(bytes));
                this.numericInfo.put(field.name, Accountables.namedAccountable("byte array", this.maxDoc));
                return new NumericDocValues(){

                    @Override
                    public long get(int docID) {
                        return bytes[docID];
                    }
                };
            }
            case 3: {
                final long min = this.data.readLong();
                final long mult = this.data.readLong();
                int quotientBlockSize = this.data.readVInt();
                final BlockPackedReader quotientReader = new BlockPackedReader(this.data, entry.packedIntsVersion, quotientBlockSize, this.maxDoc, false);
                this.ramBytesUsed.addAndGet(quotientReader.ramBytesUsed());
                this.numericInfo.put(field.name, quotientReader);
                return new NumericDocValues(){

                    @Override
                    public long get(int docID) {
                        return min + mult * quotientReader.get(docID);
                    }
                };
            }
        }
        throw new AssertionError();
    }

    @Override
    public synchronized BinaryDocValues getBinary(FieldInfo field) throws IOException {
        BinaryDocValues instance = this.binaryInstances.get(field.name);
        if (instance == null) {
            instance = this.loadBinary(field);
            this.binaryInstances.put(field.name, instance);
        }
        return instance;
    }

    private BinaryDocValues loadBinary(FieldInfo field) throws IOException {
        BinaryEntry entry = this.binaries.get(field.name);
        this.data.seek(entry.offset);
        PagedBytes bytes = new PagedBytes(16);
        bytes.copy(this.data, entry.numBytes);
        final PagedBytes.Reader bytesReader = bytes.freeze(true);
        this.binaryInfo.put(field.name, bytesReader);
        if (entry.minLength == entry.maxLength) {
            final int fixedLength = entry.minLength;
            this.ramBytesUsed.addAndGet(bytesReader.ramBytesUsed());
            return new BinaryDocValues(){

                @Override
                public BytesRef get(int docID) {
                    BytesRef term = new BytesRef();
                    bytesReader.fillSlice(term, (long)fixedLength * (long)docID, fixedLength);
                    return term;
                }
            };
        }
        final MonotonicBlockPackedReader addresses = MonotonicBlockPackedReader.of(this.data, entry.packedIntsVersion, entry.blockSize, this.maxDoc, false);
        this.addressInfo.put(field.name, addresses);
        this.ramBytesUsed.addAndGet(bytesReader.ramBytesUsed() + addresses.ramBytesUsed());
        return new BinaryDocValues(){

            @Override
            public BytesRef get(int docID) {
                long startAddress = docID == 0 ? 0L : addresses.get(docID - 1);
                long endAddress = addresses.get(docID);
                BytesRef term = new BytesRef();
                bytesReader.fillSlice(term, startAddress, (int)(endAddress - startAddress));
                return term;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedDocValues getSorted(FieldInfo field) throws IOException {
        FST<Long> instance;
        final FSTEntry entry = this.fsts.get(field.name);
        Lucene42DocValuesProducer lucene42DocValuesProducer = this;
        synchronized (lucene42DocValuesProducer) {
            instance = this.fstInstances.get(field.name);
            if (instance == null) {
                this.data.seek(entry.offset);
                instance = new FST<Long>(this.data, PositiveIntOutputs.getSingleton());
                this.ramBytesUsed.addAndGet(instance.ramBytesUsed());
                this.fstInstances.put(field.name, instance);
            }
        }
        final NumericDocValues docToOrd = this.getNumeric(field);
        final FST<Long> fst = instance;
        final FST.BytesReader in = fst.getBytesReader();
        final FST.Arc firstArc = new FST.Arc();
        final FST.Arc scratchArc = new FST.Arc();
        final IntsRefBuilder scratchInts = new IntsRefBuilder();
        final BytesRefFSTEnum<Long> fstEnum = new BytesRefFSTEnum<Long>(fst);
        return new SortedDocValues(){
            final BytesRefBuilder term = new BytesRefBuilder();

            @Override
            public int getOrd(int docID) {
                return (int)docToOrd.get(docID);
            }

            @Override
            public BytesRef lookupOrd(int ord) {
                try {
                    in.setPosition(0L);
                    fst.getFirstArc(firstArc);
                    IntsRef output = Util.getByOutput(fst, ord, in, firstArc, scratchArc, scratchInts);
                    this.term.grow(output.length);
                    this.term.clear();
                    return Util.toBytesRef(output, this.term);
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
            }

            @Override
            public int lookupTerm(BytesRef key) {
                try {
                    BytesRefFSTEnum.InputOutput o = fstEnum.seekCeil(key);
                    if (o == null) {
                        return -this.getValueCount() - 1;
                    }
                    if (o.input.equals(key)) {
                        return ((Long)o.output).intValue();
                    }
                    return (int)(-((Long)o.output).longValue()) - 1;
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
            }

            @Override
            public int getValueCount() {
                return (int)entry.numOrds;
            }

            @Override
            public TermsEnum termsEnum() {
                return new FSTTermsEnum(fst);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
        FST<Long> instance;
        final FSTEntry entry = this.fsts.get(field.name);
        if (entry.numOrds == 0L) {
            return DocValues.emptySortedSet();
        }
        Lucene42DocValuesProducer lucene42DocValuesProducer = this;
        synchronized (lucene42DocValuesProducer) {
            instance = this.fstInstances.get(field.name);
            if (instance == null) {
                this.data.seek(entry.offset);
                instance = new FST<Long>(this.data, PositiveIntOutputs.getSingleton());
                this.ramBytesUsed.addAndGet(instance.ramBytesUsed());
                this.fstInstances.put(field.name, instance);
            }
        }
        final BinaryDocValues docToOrds = this.getBinary(field);
        final FST<Long> fst = instance;
        final FST.BytesReader in = fst.getBytesReader();
        final FST.Arc firstArc = new FST.Arc();
        final FST.Arc scratchArc = new FST.Arc();
        final IntsRefBuilder scratchInts = new IntsRefBuilder();
        final BytesRefFSTEnum<Long> fstEnum = new BytesRefFSTEnum<Long>(fst);
        final ByteArrayDataInput input = new ByteArrayDataInput();
        return new SortedSetDocValues(){
            final BytesRefBuilder term = new BytesRefBuilder();
            BytesRef ordsRef;
            long currentOrd;

            @Override
            public long nextOrd() {
                if (input.eof()) {
                    return -1L;
                }
                this.currentOrd += input.readVLong();
                return this.currentOrd;
            }

            @Override
            public void setDocument(int docID) {
                this.ordsRef = docToOrds.get(docID);
                input.reset(this.ordsRef.bytes, this.ordsRef.offset, this.ordsRef.length);
                this.currentOrd = 0L;
            }

            @Override
            public BytesRef lookupOrd(long ord) {
                try {
                    in.setPosition(0L);
                    fst.getFirstArc(firstArc);
                    IntsRef output = Util.getByOutput(fst, ord, in, firstArc, scratchArc, scratchInts);
                    this.term.grow(output.length);
                    this.term.clear();
                    return Util.toBytesRef(output, this.term);
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
            }

            @Override
            public long lookupTerm(BytesRef key) {
                try {
                    BytesRefFSTEnum.InputOutput o = fstEnum.seekCeil(key);
                    if (o == null) {
                        return -this.getValueCount() - 1L;
                    }
                    if (o.input.equals(key)) {
                        return ((Long)o.output).intValue();
                    }
                    return -((Long)o.output).longValue() - 1L;
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
            }

            @Override
            public long getValueCount() {
                return entry.numOrds;
            }

            @Override
            public TermsEnum termsEnum() {
                return new FSTTermsEnum(fst);
            }
        };
    }

    @Override
    public Bits getDocsWithField(FieldInfo field) throws IOException {
        if (field.getDocValuesType() == FieldInfo.DocValuesType.SORTED_SET) {
            return DocValues.docsWithValue(this.getSortedSet(field), this.maxDoc);
        }
        return new Bits.MatchAllBits(this.maxDoc);
    }

    @Override
    public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
        throw new IllegalStateException("Lucene 4.2 does not support SortedNumeric: how did you pull this off?");
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    static class FSTTermsEnum
    extends TermsEnum {
        final BytesRefFSTEnum<Long> in;
        final FST<Long> fst;
        final FST.BytesReader bytesReader;
        final FST.Arc<Long> firstArc = new FST.Arc();
        final FST.Arc<Long> scratchArc = new FST.Arc();
        final IntsRefBuilder scratchInts = new IntsRefBuilder();
        final BytesRefBuilder scratchBytes = new BytesRefBuilder();

        FSTTermsEnum(FST<Long> fst) {
            this.fst = fst;
            this.in = new BytesRefFSTEnum<Long>(fst);
            this.bytesReader = fst.getBytesReader();
        }

        @Override
        public BytesRef next() throws IOException {
            BytesRefFSTEnum.InputOutput<Long> io = this.in.next();
            if (io == null) {
                return null;
            }
            return io.input;
        }

        @Override
        public Comparator<BytesRef> getComparator() {
            return BytesRef.getUTF8SortedAsUnicodeComparator();
        }

        @Override
        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            if (this.in.seekCeil(text) == null) {
                return TermsEnum.SeekStatus.END;
            }
            if (this.term().equals(text)) {
                return TermsEnum.SeekStatus.FOUND;
            }
            return TermsEnum.SeekStatus.NOT_FOUND;
        }

        @Override
        public boolean seekExact(BytesRef text) throws IOException {
            return this.in.seekExact(text) != null;
        }

        @Override
        public void seekExact(long ord) throws IOException {
            this.bytesReader.setPosition(0L);
            this.fst.getFirstArc(this.firstArc);
            IntsRef output = Util.getByOutput(this.fst, ord, this.bytesReader, this.firstArc, this.scratchArc, this.scratchInts);
            BytesRefBuilder scratchBytes = new BytesRefBuilder();
            scratchBytes.clear();
            Util.toBytesRef(output, scratchBytes);
            this.in.seekExact(scratchBytes.get());
        }

        @Override
        public BytesRef term() throws IOException {
            return this.in.current().input;
        }

        @Override
        public long ord() throws IOException {
            return (Long)this.in.current().output;
        }

        @Override
        public int docFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long totalTermFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public DocsEnum docs(Bits liveDocs, DocsEnum reuse, int flags) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, int flags) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    static class FSTEntry {
        long offset;
        long numOrds;

        FSTEntry() {
        }
    }

    static class BinaryEntry {
        long offset;
        long numBytes;
        int minLength;
        int maxLength;
        int packedIntsVersion;
        int blockSize;

        BinaryEntry() {
        }
    }

    static class NumericEntry {
        long offset;
        byte format;
        int packedIntsVersion;

        NumericEntry() {
        }
    }
}

