/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene49;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.DirectReader;
import org.apache.lucene.util.packed.MonotonicBlockPackedReader;

class Lucene49DocValuesProducer
extends DocValuesProducer
implements Closeable {
    private final Map<String, NumericEntry> numerics;
    private final Map<String, BinaryEntry> binaries;
    private final Map<String, SortedSetEntry> sortedSets;
    private final Map<String, SortedSetEntry> sortedNumerics;
    private final Map<String, NumericEntry> ords;
    private final Map<String, NumericEntry> ordIndexes;
    private final AtomicLong ramBytesUsed;
    private final IndexInput data;
    private final int numFields;
    private final int maxDoc;
    private final int version;
    private final Map<String, MonotonicBlockPackedReader> addressInstances;
    private final Map<String, MonotonicBlockPackedReader> ordIndexInstances;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Lucene49DocValuesProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        block7: {
            boolean success;
            block8: {
                ChecksumIndexInput in;
                block6: {
                    this.addressInstances = new HashMap<String, MonotonicBlockPackedReader>();
                    this.ordIndexInstances = new HashMap<String, MonotonicBlockPackedReader>();
                    String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
                    in = state.directory.openChecksumInput(metaName, state.context);
                    this.maxDoc = state.segmentInfo.getDocCount();
                    success = false;
                    try {
                        this.version = CodecUtil.checkHeader(in, metaCodec, 0, 0);
                        this.numerics = new HashMap<String, NumericEntry>();
                        this.ords = new HashMap<String, NumericEntry>();
                        this.ordIndexes = new HashMap<String, NumericEntry>();
                        this.binaries = new HashMap<String, BinaryEntry>();
                        this.sortedSets = new HashMap<String, SortedSetEntry>();
                        this.sortedNumerics = new HashMap<String, SortedSetEntry>();
                        this.numFields = this.readFields(in, state.fieldInfos);
                        CodecUtil.checkFooter(in);
                        success = true;
                        if (!success) break block6;
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            IOUtils.close(in);
                            throw throwable;
                        }
                        IOUtils.closeWhileHandlingException(in);
                        throw throwable;
                    }
                    IOUtils.close(in);
                    break block8;
                }
                IOUtils.closeWhileHandlingException(in);
            }
            String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
            this.data = state.directory.openInput(dataName, state.context);
            success = false;
            try {
                int version2 = CodecUtil.checkHeader(this.data, dataCodec, 0, 0);
                if (this.version != version2) {
                    throw new CorruptIndexException("Format versions mismatch");
                }
                CodecUtil.retrieveChecksum(this.data);
                success = true;
                if (success) break block7;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException(this.data);
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(this.data);
        }
        this.ramBytesUsed = new AtomicLong(RamUsageEstimator.shallowSizeOfInstance(this.getClass()));
    }

    private void readSortedField(FieldInfo info, IndexInput meta) throws IOException {
        if (meta.readVInt() != info.number) {
            throw new CorruptIndexException("sorted entry for field: " + info.name + " is corrupt (resource=" + meta + ")");
        }
        if (meta.readByte() != 1) {
            throw new CorruptIndexException("sorted entry for field: " + info.name + " is corrupt (resource=" + meta + ")");
        }
        BinaryEntry b = Lucene49DocValuesProducer.readBinaryEntry(meta);
        this.binaries.put(info.name, b);
        if (meta.readVInt() != info.number) {
            throw new CorruptIndexException("sorted entry for field: " + info.name + " is corrupt (resource=" + meta + ")");
        }
        if (meta.readByte() != 0) {
            throw new CorruptIndexException("sorted entry for field: " + info.name + " is corrupt (resource=" + meta + ")");
        }
        NumericEntry n = Lucene49DocValuesProducer.readNumericEntry(meta);
        this.ords.put(info.name, n);
    }

    private void readSortedSetFieldWithAddresses(FieldInfo info, IndexInput meta) throws IOException {
        if (meta.readVInt() != info.number) {
            throw new CorruptIndexException("sortedset entry for field: " + info.name + " is corrupt (resource=" + meta + ")");
        }
        if (meta.readByte() != 1) {
            throw new CorruptIndexException("sortedset entry for field: " + info.name + " is corrupt (resource=" + meta + ")");
        }
        BinaryEntry b = Lucene49DocValuesProducer.readBinaryEntry(meta);
        this.binaries.put(info.name, b);
        if (meta.readVInt() != info.number) {
            throw new CorruptIndexException("sortedset entry for field: " + info.name + " is corrupt (resource=" + meta + ")");
        }
        if (meta.readByte() != 0) {
            throw new CorruptIndexException("sortedset entry for field: " + info.name + " is corrupt (resource=" + meta + ")");
        }
        NumericEntry n1 = Lucene49DocValuesProducer.readNumericEntry(meta);
        this.ords.put(info.name, n1);
        if (meta.readVInt() != info.number) {
            throw new CorruptIndexException("sortedset entry for field: " + info.name + " is corrupt (resource=" + meta + ")");
        }
        if (meta.readByte() != 0) {
            throw new CorruptIndexException("sortedset entry for field: " + info.name + " is corrupt (resource=" + meta + ")");
        }
        NumericEntry n2 = Lucene49DocValuesProducer.readNumericEntry(meta);
        this.ordIndexes.put(info.name, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int readFields(IndexInput meta, FieldInfos infos) throws IOException {
        int numFields = 0;
        int fieldNumber = meta.readVInt();
        while (fieldNumber != -1) {
            SortedSetEntry ss;
            ++numFields;
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber + " (resource=" + meta + ")");
            }
            byte type = meta.readByte();
            if (type == 0) {
                this.numerics.put(info.name, Lucene49DocValuesProducer.readNumericEntry(meta));
            } else if (type == 1) {
                BinaryEntry b = Lucene49DocValuesProducer.readBinaryEntry(meta);
                this.binaries.put(info.name, b);
            } else if (type == 2) {
                this.readSortedField(info, meta);
            } else if (type == 3) {
                ss = this.readSortedSetEntry(meta);
                this.sortedSets.put(info.name, ss);
                if (ss.format == 0) {
                    this.readSortedSetFieldWithAddresses(info, meta);
                } else {
                    if (ss.format != 1) throw new AssertionError();
                    if (meta.readVInt() != fieldNumber) {
                        throw new CorruptIndexException("sortedset entry for field: " + info.name + " is corrupt (resource=" + meta + ")");
                    }
                    if (meta.readByte() != 2) {
                        throw new CorruptIndexException("sortedset entry for field: " + info.name + " is corrupt (resource=" + meta + ")");
                    }
                    this.readSortedField(info, meta);
                }
            } else {
                if (type != 4) throw new CorruptIndexException("invalid type: " + type + ", resource=" + meta);
                ss = this.readSortedSetEntry(meta);
                this.sortedNumerics.put(info.name, ss);
                if (meta.readVInt() != fieldNumber) {
                    throw new CorruptIndexException("sortednumeric entry for field: " + info.name + " is corrupt (resource=" + meta + ")");
                }
                if (meta.readByte() != 0) {
                    throw new CorruptIndexException("sortednumeric entry for field: " + info.name + " is corrupt (resource=" + meta + ")");
                }
                this.numerics.put(info.name, Lucene49DocValuesProducer.readNumericEntry(meta));
                if (ss.format == 0) {
                    if (meta.readVInt() != fieldNumber) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + info.name + " is corrupt (resource=" + meta + ")");
                    }
                    if (meta.readByte() != 0) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + info.name + " is corrupt (resource=" + meta + ")");
                    }
                    NumericEntry ordIndex = Lucene49DocValuesProducer.readNumericEntry(meta);
                    this.ordIndexes.put(info.name, ordIndex);
                } else if (ss.format != 1) {
                    throw new AssertionError();
                }
            }
            fieldNumber = meta.readVInt();
        }
        return numFields;
    }

    static NumericEntry readNumericEntry(IndexInput meta) throws IOException {
        NumericEntry entry = new NumericEntry();
        entry.format = meta.readVInt();
        entry.missingOffset = meta.readLong();
        entry.offset = meta.readLong();
        entry.count = meta.readVLong();
        switch (entry.format) {
            case 1: {
                entry.minValue = meta.readLong();
                entry.gcd = meta.readLong();
                entry.bitsPerValue = meta.readVInt();
                break;
            }
            case 2: {
                int uniqueValues = meta.readVInt();
                if (uniqueValues > 256) {
                    throw new CorruptIndexException("TABLE_COMPRESSED cannot have more than 256 distinct values, input=" + meta);
                }
                entry.table = new long[uniqueValues];
                for (int i = 0; i < uniqueValues; ++i) {
                    entry.table[i] = meta.readLong();
                }
                entry.bitsPerValue = meta.readVInt();
                break;
            }
            case 0: {
                entry.minValue = meta.readLong();
                entry.bitsPerValue = meta.readVInt();
                break;
            }
            case 3: {
                entry.packedIntsVersion = meta.readVInt();
                entry.blockSize = meta.readVInt();
                break;
            }
            default: {
                throw new CorruptIndexException("Unknown format: " + entry.format + ", input=" + meta);
            }
        }
        entry.endOffset = meta.readLong();
        return entry;
    }

    static BinaryEntry readBinaryEntry(IndexInput meta) throws IOException {
        BinaryEntry entry = new BinaryEntry();
        entry.format = meta.readVInt();
        entry.missingOffset = meta.readLong();
        entry.minLength = meta.readVInt();
        entry.maxLength = meta.readVInt();
        entry.count = meta.readVLong();
        entry.offset = meta.readLong();
        switch (entry.format) {
            case 0: {
                break;
            }
            case 2: {
                entry.addressInterval = meta.readVInt();
                entry.addressesOffset = meta.readLong();
                entry.packedIntsVersion = meta.readVInt();
                entry.blockSize = meta.readVInt();
                break;
            }
            case 1: {
                entry.addressesOffset = meta.readLong();
                entry.packedIntsVersion = meta.readVInt();
                entry.blockSize = meta.readVInt();
                break;
            }
            default: {
                throw new CorruptIndexException("Unknown format: " + entry.format + ", input=" + meta);
            }
        }
        return entry;
    }

    SortedSetEntry readSortedSetEntry(IndexInput meta) throws IOException {
        SortedSetEntry entry = new SortedSetEntry();
        entry.format = meta.readVInt();
        if (entry.format != 1 && entry.format != 0) {
            throw new CorruptIndexException("Unknown format: " + entry.format + ", input=" + meta);
        }
        return entry;
    }

    @Override
    public NumericDocValues getNumeric(FieldInfo field) throws IOException {
        NumericEntry entry = this.numerics.get(field.name);
        return this.getNumeric(entry);
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed.get();
    }

    @Override
    public synchronized Iterable<? extends Accountable> getChildResources() {
        ArrayList<Accountable> resources = new ArrayList<Accountable>();
        resources.addAll(Accountables.namedAccountables("addresses field", this.addressInstances));
        resources.addAll(Accountables.namedAccountables("ord index field", this.ordIndexInstances));
        return Collections.unmodifiableList(resources);
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.data);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(fields=" + this.numFields + ")";
    }

    LongValues getNumeric(NumericEntry entry) throws IOException {
        RandomAccessInput slice = this.data.randomAccessSlice(entry.offset, entry.endOffset - entry.offset);
        switch (entry.format) {
            case 0: {
                final long delta = entry.minValue;
                final LongValues values = DirectReader.getInstance(slice, entry.bitsPerValue);
                return new LongValues(){

                    @Override
                    public long get(long id) {
                        return delta + values.get(id);
                    }
                };
            }
            case 1: {
                final long min = entry.minValue;
                final long mult = entry.gcd;
                final LongValues quotientReader = DirectReader.getInstance(slice, entry.bitsPerValue);
                return new LongValues(){

                    @Override
                    public long get(long id) {
                        return min + mult * quotientReader.get(id);
                    }
                };
            }
            case 2: {
                final long[] table = entry.table;
                final LongValues ords = DirectReader.getInstance(slice, entry.bitsPerValue);
                return new LongValues(){

                    @Override
                    public long get(long id) {
                        return table[(int)ords.get(id)];
                    }
                };
            }
        }
        throw new AssertionError();
    }

    @Override
    public BinaryDocValues getBinary(FieldInfo field) throws IOException {
        BinaryEntry bytes = this.binaries.get(field.name);
        switch (bytes.format) {
            case 0: {
                return this.getFixedBinary(field, bytes);
            }
            case 1: {
                return this.getVariableBinary(field, bytes);
            }
            case 2: {
                return this.getCompressedBinary(field, bytes);
            }
        }
        throw new AssertionError();
    }

    private BinaryDocValues getFixedBinary(FieldInfo field, final BinaryEntry bytes) {
        final IndexInput data = this.data.clone();
        return new LongBinaryDocValues(){
            final BytesRef term;
            {
                this.term = new BytesRef(bytes.maxLength);
                this.term.offset = 0;
                this.term.length = bytes.maxLength;
            }

            @Override
            public BytesRef get(long id) {
                long address = bytes.offset + id * (long)bytes.maxLength;
                try {
                    data.seek(address);
                    data.readBytes(this.term.bytes, 0, this.term.length);
                    return this.term;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private synchronized MonotonicBlockPackedReader getAddressInstance(IndexInput data, FieldInfo field, BinaryEntry bytes) throws IOException {
        MonotonicBlockPackedReader addrInstance = this.addressInstances.get(field.name);
        if (addrInstance == null) {
            data.seek(bytes.addressesOffset);
            addrInstance = MonotonicBlockPackedReader.of(data, bytes.packedIntsVersion, bytes.blockSize, bytes.count + 1L, false);
            this.addressInstances.put(field.name, addrInstance);
            this.ramBytesUsed.addAndGet(addrInstance.ramBytesUsed() + 4L);
        }
        MonotonicBlockPackedReader addresses = addrInstance;
        return addresses;
    }

    private BinaryDocValues getVariableBinary(FieldInfo field, final BinaryEntry bytes) throws IOException {
        final IndexInput data = this.data.clone();
        final MonotonicBlockPackedReader addresses = this.getAddressInstance(data, field, bytes);
        return new LongBinaryDocValues(){
            final BytesRef term;
            {
                this.term = new BytesRef(Math.max(0, bytes.maxLength));
            }

            @Override
            public BytesRef get(long id) {
                long startAddress = bytes.offset + addresses.get(id);
                long endAddress = bytes.offset + addresses.get(id + 1L);
                int length = (int)(endAddress - startAddress);
                try {
                    data.seek(startAddress);
                    data.readBytes(this.term.bytes, 0, length);
                    this.term.length = length;
                    return this.term;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private synchronized MonotonicBlockPackedReader getIntervalInstance(IndexInput data, FieldInfo field, BinaryEntry bytes) throws IOException {
        long interval = bytes.addressInterval;
        MonotonicBlockPackedReader addrInstance = this.addressInstances.get(field.name);
        if (addrInstance == null) {
            data.seek(bytes.addressesOffset);
            long size = bytes.count % interval == 0L ? bytes.count / interval : 1L + bytes.count / interval;
            addrInstance = MonotonicBlockPackedReader.of(data, bytes.packedIntsVersion, bytes.blockSize, size, false);
            this.addressInstances.put(field.name, addrInstance);
            this.ramBytesUsed.addAndGet(addrInstance.ramBytesUsed() + 4L);
        }
        MonotonicBlockPackedReader addresses = addrInstance;
        return addresses;
    }

    private BinaryDocValues getCompressedBinary(FieldInfo field, BinaryEntry bytes) throws IOException {
        IndexInput data = this.data.clone();
        MonotonicBlockPackedReader addresses = this.getIntervalInstance(data, field, bytes);
        return new CompressedBinaryDocValues(bytes, addresses, data);
    }

    @Override
    public SortedDocValues getSorted(FieldInfo field) throws IOException {
        final int valueCount = (int)this.binaries.get((Object)field.name).count;
        final BinaryDocValues binary = this.getBinary(field);
        NumericEntry entry = this.ords.get(field.name);
        final LongValues ordinals = this.getNumeric(entry);
        return new SortedDocValues(){

            @Override
            public int getOrd(int docID) {
                return (int)ordinals.get(docID);
            }

            @Override
            public BytesRef lookupOrd(int ord) {
                return binary.get(ord);
            }

            @Override
            public int getValueCount() {
                return valueCount;
            }

            @Override
            public int lookupTerm(BytesRef key) {
                if (binary instanceof CompressedBinaryDocValues) {
                    return (int)((CompressedBinaryDocValues)binary).lookupTerm(key);
                }
                return super.lookupTerm(key);
            }

            @Override
            public TermsEnum termsEnum() {
                if (binary instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)binary).getTermsEnum();
                }
                return super.termsEnum();
            }
        };
    }

    private synchronized MonotonicBlockPackedReader getOrdIndexInstance(IndexInput data, FieldInfo field, NumericEntry entry) throws IOException {
        MonotonicBlockPackedReader ordIndexInstance = this.ordIndexInstances.get(field.name);
        if (ordIndexInstance == null) {
            data.seek(entry.offset);
            ordIndexInstance = MonotonicBlockPackedReader.of(data, entry.packedIntsVersion, entry.blockSize, entry.count + 1L, false);
            this.ordIndexInstances.put(field.name, ordIndexInstance);
            this.ramBytesUsed.addAndGet(ordIndexInstance.ramBytesUsed() + 4L);
        }
        MonotonicBlockPackedReader ordIndex = ordIndexInstance;
        return ordIndex;
    }

    @Override
    public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
        SortedSetEntry ss = this.sortedNumerics.get(field.name);
        NumericEntry numericEntry = this.numerics.get(field.name);
        final LongValues values = this.getNumeric(numericEntry);
        if (ss.format == 1) {
            Bits docsWithField = this.getMissingBits(numericEntry.missingOffset);
            return DocValues.singleton(values, docsWithField);
        }
        if (ss.format == 0) {
            IndexInput data = this.data.clone();
            final MonotonicBlockPackedReader ordIndex = this.getOrdIndexInstance(data, field, this.ordIndexes.get(field.name));
            return new SortedNumericDocValues(){
                long startOffset;
                long endOffset;

                @Override
                public void setDocument(int doc) {
                    this.startOffset = ordIndex.get(doc);
                    this.endOffset = ordIndex.get((long)doc + 1L);
                }

                @Override
                public long valueAt(int index) {
                    return values.get(this.startOffset + (long)index);
                }

                @Override
                public int count() {
                    return (int)(this.endOffset - this.startOffset);
                }
            };
        }
        throw new AssertionError();
    }

    @Override
    public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
        SortedSetEntry ss = this.sortedSets.get(field.name);
        if (ss.format == 1) {
            SortedDocValues values = this.getSorted(field);
            return DocValues.singleton(values);
        }
        if (ss.format != 0) {
            throw new AssertionError();
        }
        IndexInput data = this.data.clone();
        final long valueCount = this.binaries.get((Object)field.name).count;
        final LongBinaryDocValues binary = (LongBinaryDocValues)this.getBinary(field);
        final LongValues ordinals = this.getNumeric(this.ords.get(field.name));
        final MonotonicBlockPackedReader ordIndex = this.getOrdIndexInstance(data, field, this.ordIndexes.get(field.name));
        return new RandomAccessOrds(){
            long startOffset;
            long offset;
            long endOffset;

            @Override
            public long nextOrd() {
                if (this.offset == this.endOffset) {
                    return -1L;
                }
                long ord = ordinals.get(this.offset);
                ++this.offset;
                return ord;
            }

            @Override
            public void setDocument(int docID) {
                this.startOffset = this.offset = ordIndex.get(docID);
                this.endOffset = ordIndex.get((long)docID + 1L);
            }

            @Override
            public BytesRef lookupOrd(long ord) {
                return binary.get(ord);
            }

            @Override
            public long getValueCount() {
                return valueCount;
            }

            @Override
            public long lookupTerm(BytesRef key) {
                if (binary instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)binary).lookupTerm(key);
                }
                return super.lookupTerm(key);
            }

            @Override
            public TermsEnum termsEnum() {
                if (binary instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)binary).getTermsEnum();
                }
                return super.termsEnum();
            }

            @Override
            public long ordAt(int index) {
                return ordinals.get(this.startOffset + (long)index);
            }

            @Override
            public int cardinality() {
                return (int)(this.endOffset - this.startOffset);
            }
        };
    }

    private Bits getMissingBits(long offset) throws IOException {
        if (offset == -1L) {
            return new Bits.MatchAllBits(this.maxDoc);
        }
        int length = (int)((long)this.maxDoc + 7L >>> 3);
        final RandomAccessInput in = this.data.randomAccessSlice(offset, length);
        return new Bits(){

            @Override
            public boolean get(int index) {
                try {
                    return (in.readByte(index >> 3) & 1 << (index & 7)) != 0;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public int length() {
                return Lucene49DocValuesProducer.this.maxDoc;
            }
        };
    }

    @Override
    public Bits getDocsWithField(FieldInfo field) throws IOException {
        switch (field.getDocValuesType()) {
            case SORTED_SET: {
                return DocValues.docsWithValue(this.getSortedSet(field), this.maxDoc);
            }
            case SORTED_NUMERIC: {
                return DocValues.docsWithValue(this.getSortedNumeric(field), this.maxDoc);
            }
            case SORTED: {
                return DocValues.docsWithValue(this.getSorted(field), this.maxDoc);
            }
            case BINARY: {
                BinaryEntry be = this.binaries.get(field.name);
                return this.getMissingBits(be.missingOffset);
            }
            case NUMERIC: {
                NumericEntry ne = this.numerics.get(field.name);
                return this.getMissingBits(ne.missingOffset);
            }
        }
        throw new AssertionError();
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    static class CompressedBinaryDocValues
    extends LongBinaryDocValues {
        final BinaryEntry bytes;
        final long interval;
        final long numValues;
        final long numIndexValues;
        final MonotonicBlockPackedReader addresses;
        final IndexInput data;
        final TermsEnum termsEnum;

        public CompressedBinaryDocValues(BinaryEntry bytes, MonotonicBlockPackedReader addresses, IndexInput data) throws IOException {
            this.bytes = bytes;
            this.interval = bytes.addressInterval;
            this.addresses = addresses;
            this.data = data;
            this.numValues = bytes.count;
            this.numIndexValues = addresses.size();
            this.termsEnum = this.getTermsEnum(data);
        }

        @Override
        public BytesRef get(long id) {
            try {
                this.termsEnum.seekExact(id);
                return this.termsEnum.term();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        long lookupTerm(BytesRef key) {
            try {
                TermsEnum.SeekStatus status = this.termsEnum.seekCeil(key);
                if (status == TermsEnum.SeekStatus.END) {
                    return -this.numValues - 1L;
                }
                if (status == TermsEnum.SeekStatus.FOUND) {
                    return this.termsEnum.ord();
                }
                return -this.termsEnum.ord() - 1L;
            }
            catch (IOException bogus) {
                throw new RuntimeException(bogus);
            }
        }

        TermsEnum getTermsEnum() {
            try {
                return this.getTermsEnum(this.data.clone());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private TermsEnum getTermsEnum(final IndexInput input) throws IOException {
            input.seek(this.bytes.offset);
            return new TermsEnum(){
                private long currentOrd = -1L;
                private final BytesRef term;
                {
                    this.term = new BytesRef(CompressedBinaryDocValues.this.bytes.maxLength < 0 ? 0 : CompressedBinaryDocValues.this.bytes.maxLength);
                }

                @Override
                public BytesRef next() throws IOException {
                    if (++this.currentOrd >= CompressedBinaryDocValues.this.numValues) {
                        return null;
                    }
                    int start = input.readVInt();
                    int suffix = input.readVInt();
                    input.readBytes(this.term.bytes, start, suffix);
                    this.term.length = start + suffix;
                    return this.term;
                }

                @Override
                public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
                    int cmp;
                    long low = 0L;
                    long high = CompressedBinaryDocValues.this.numIndexValues - 1L;
                    while (low <= high) {
                        long mid = low + high >>> 1;
                        this.seekExact(mid * CompressedBinaryDocValues.this.interval);
                        cmp = this.term.compareTo(text);
                        if (cmp < 0) {
                            low = mid + 1L;
                            continue;
                        }
                        if (cmp > 0) {
                            high = mid - 1L;
                            continue;
                        }
                        return TermsEnum.SeekStatus.FOUND;
                    }
                    if (CompressedBinaryDocValues.this.numIndexValues == 0L) {
                        return TermsEnum.SeekStatus.END;
                    }
                    long block = low - 1L;
                    this.seekExact(block < 0L ? -1L : block * CompressedBinaryDocValues.this.interval);
                    while (this.next() != null) {
                        cmp = this.term.compareTo(text);
                        if (cmp == 0) {
                            return TermsEnum.SeekStatus.FOUND;
                        }
                        if (cmp <= 0) continue;
                        return TermsEnum.SeekStatus.NOT_FOUND;
                    }
                    return TermsEnum.SeekStatus.END;
                }

                @Override
                public void seekExact(long ord) throws IOException {
                    long block = ord / CompressedBinaryDocValues.this.interval;
                    if (ord < this.currentOrd || block != this.currentOrd / CompressedBinaryDocValues.this.interval) {
                        this.currentOrd = ord - ord % CompressedBinaryDocValues.this.interval - 1L;
                        input.seek(CompressedBinaryDocValues.this.bytes.offset + CompressedBinaryDocValues.this.addresses.get(block));
                    }
                    while (this.currentOrd < ord) {
                        this.next();
                    }
                }

                @Override
                public BytesRef term() throws IOException {
                    return this.term;
                }

                @Override
                public long ord() throws IOException {
                    return this.currentOrd;
                }

                @Override
                public int docFreq() throws IOException {
                    throw new UnsupportedOperationException();
                }

                @Override
                public long totalTermFreq() throws IOException {
                    return -1L;
                }

                @Override
                public DocsEnum docs(Bits liveDocs, DocsEnum reuse, int flags) throws IOException {
                    throw new UnsupportedOperationException();
                }

                @Override
                public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, int flags) throws IOException {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Comparator<BytesRef> getComparator() {
                    return BytesRef.getUTF8SortedAsUnicodeComparator();
                }
            };
        }
    }

    static abstract class LongBinaryDocValues
    extends BinaryDocValues {
        LongBinaryDocValues() {
        }

        @Override
        public final BytesRef get(int docID) {
            return this.get((long)docID);
        }

        abstract BytesRef get(long var1);
    }

    static class SortedSetEntry {
        int format;

        private SortedSetEntry() {
        }
    }

    static class BinaryEntry {
        long missingOffset;
        long offset;
        int format;
        public long count;
        int minLength;
        int maxLength;
        public long addressesOffset;
        public long addressInterval;
        public int packedIntsVersion;
        public int blockSize;

        private BinaryEntry() {
        }
    }

    static class NumericEntry {
        long missingOffset;
        public long offset;
        public long endOffset;
        public int bitsPerValue;
        int format;
        public int packedIntsVersion;
        public long count;
        public int blockSize;
        long minValue;
        long gcd;
        long[] table;

        private NumericEntry() {
        }
    }
}

