/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene49;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.BlockPackedReader;
import org.apache.lucene.util.packed.PackedInts;

class Lucene49NormsProducer
extends NormsProducer {
    private final Map<String, NormsEntry> norms;
    private final IndexInput data;
    private final int version;
    final Map<String, NumericDocValues> instances;
    final Map<String, Accountable> instancesInfo;
    private final int maxDoc;
    private final AtomicLong ramBytesUsed;
    private final AtomicInteger activeCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene49NormsProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        boolean success;
        block8: {
            ChecksumIndexInput in;
            block7: {
                this.norms = new HashMap<String, NormsEntry>();
                this.instances = new HashMap<String, NumericDocValues>();
                this.instancesInfo = new HashMap<String, Accountable>();
                this.activeCount = new AtomicInteger();
                this.maxDoc = state.segmentInfo.getDocCount();
                String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
                in = state.directory.openChecksumInput(metaName, state.context);
                success = false;
                this.ramBytesUsed = new AtomicLong(RamUsageEstimator.shallowSizeOfInstance(this.getClass()));
                try {
                    this.version = CodecUtil.checkHeader(in, metaCodec, 0, 0);
                    this.readFields(in, state.fieldInfos);
                    CodecUtil.checkFooter(in);
                    success = true;
                    if (!success) break block7;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(in);
                        throw throwable;
                    } else {
                        IOUtils.closeWhileHandlingException(in);
                    }
                    throw throwable;
                }
                IOUtils.close(in);
                break block8;
            }
            IOUtils.closeWhileHandlingException(in);
        }
        String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
        this.data = state.directory.openInput(dataName, state.context);
        success = false;
        try {
            int version2 = CodecUtil.checkHeader(this.data, dataCodec, 0, 0);
            if (this.version != version2) {
                throw new CorruptIndexException("Format versions mismatch");
            }
            CodecUtil.retrieveChecksum(this.data);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this.data);
            throw throwable;
        }
    }

    private void readFields(IndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readVInt();
        while (fieldNumber != -1) {
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber + " (resource=" + meta + ")");
            }
            if (!info.hasNorms()) {
                throw new CorruptIndexException("Invalid field: " + info.name + " (resource=" + meta + ")");
            }
            NormsEntry entry = new NormsEntry();
            entry.format = meta.readByte();
            entry.offset = meta.readLong();
            switch (entry.format) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    throw new CorruptIndexException("Unknown format: " + entry.format + ", input=" + meta);
                }
            }
            this.norms.put(info.name, entry);
            fieldNumber = meta.readVInt();
        }
    }

    @Override
    public synchronized NumericDocValues getNorms(FieldInfo field) throws IOException {
        NumericDocValues instance = this.instances.get(field.name);
        if (instance == null) {
            instance = this.loadNorms(field);
            this.instances.put(field.name, instance);
            this.activeCount.incrementAndGet();
        }
        return instance;
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed.get();
    }

    @Override
    public synchronized Iterable<? extends Accountable> getChildResources() {
        return Accountables.namedAccountables("field", this.instancesInfo);
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.data);
    }

    private NumericDocValues loadNorms(FieldInfo field) throws IOException {
        NormsEntry entry = this.norms.get(field.name);
        switch (entry.format) {
            case 2: {
                this.instancesInfo.put(field.name, Accountables.namedAccountable("constant", 8L));
                this.ramBytesUsed.addAndGet(8L);
                final long v = entry.offset;
                return new NumericDocValues(){

                    @Override
                    public long get(int docID) {
                        return v;
                    }
                };
            }
            case 3: {
                this.data.seek(entry.offset);
                final byte[] bytes = new byte[this.maxDoc];
                this.data.readBytes(bytes, 0, bytes.length);
                this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf(bytes));
                this.instancesInfo.put(field.name, Accountables.namedAccountable("byte array", this.maxDoc));
                return new NumericDocValues(){

                    @Override
                    public long get(int docID) {
                        return bytes[docID];
                    }
                };
            }
            case 0: {
                this.data.seek(entry.offset);
                int packedIntsVersion = this.data.readVInt();
                int blockSize = this.data.readVInt();
                BlockPackedReader reader = new BlockPackedReader(this.data, packedIntsVersion, blockSize, this.maxDoc, false);
                this.ramBytesUsed.addAndGet(reader.ramBytesUsed());
                this.instancesInfo.put(field.name, Accountables.namedAccountable("delta compressed", reader));
                return reader;
            }
            case 1: {
                this.data.seek(entry.offset);
                int packedVersion = this.data.readVInt();
                int size = this.data.readVInt();
                if (size > 256) {
                    throw new CorruptIndexException("TABLE_COMPRESSED cannot have more than 256 distinct values, input=" + this.data);
                }
                final long[] decode = new long[size];
                for (int i = 0; i < decode.length; ++i) {
                    decode[i] = this.data.readLong();
                }
                int formatID = this.data.readVInt();
                int bitsPerValue = this.data.readVInt();
                final PackedInts.Reader ordsReader = PackedInts.getReaderNoHeader(this.data, PackedInts.Format.byId(formatID), packedVersion, this.maxDoc, bitsPerValue);
                this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf(decode) + ordsReader.ramBytesUsed());
                this.instancesInfo.put(field.name, Accountables.namedAccountable("table compressed", ordsReader));
                return new NumericDocValues(){

                    @Override
                    public long get(int docID) {
                        return decode[(int)ordsReader.get(docID)];
                    }
                };
            }
        }
        throw new AssertionError();
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(fields=" + this.norms.size() + ",active=" + this.activeCount.get() + ")";
    }

    static class NormsEntry {
        byte format;
        long offset;

        NormsEntry() {
        }
    }
}

