/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.perfield;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterAtomicReader;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;

public abstract class PerFieldPostingsFormat
extends PostingsFormat {
    public static final String PER_FIELD_NAME = "PerField40";
    public static final String PER_FIELD_FORMAT_KEY = PerFieldPostingsFormat.class.getSimpleName() + ".format";
    public static final String PER_FIELD_SUFFIX_KEY = PerFieldPostingsFormat.class.getSimpleName() + ".suffix";

    public PerFieldPostingsFormat() {
        super(PER_FIELD_NAME);
    }

    static String getSuffix(String formatName, String suffix) {
        return formatName + "_" + suffix;
    }

    static String getFullSegmentSuffix(String fieldName, String outerSegmentSuffix, String segmentSuffix) {
        if (outerSegmentSuffix.length() == 0) {
            return segmentSuffix;
        }
        throw new IllegalStateException("cannot embed PerFieldPostingsFormat inside itself (field \"" + fieldName + "\" returned PerFieldPostingsFormat)");
    }

    @Override
    public final FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        return new FieldsWriter(state);
    }

    @Override
    public final FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new FieldsReader(state);
    }

    public abstract PostingsFormat getPostingsFormatForField(String var1);

    private static class FieldsReader
    extends FieldsProducer {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(FieldsReader.class);
        private final Map<String, FieldsProducer> fields = new TreeMap<String, FieldsProducer>();
        private final Map<String, FieldsProducer> formats = new HashMap<String, FieldsProducer>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FieldsReader(SegmentReadState readState) throws IOException {
            boolean success = false;
            try {
                for (FieldInfo fi : readState.fieldInfos) {
                    if (!fi.isIndexed()) continue;
                    String fieldName = fi.name;
                    String formatName = fi.getAttribute(PER_FIELD_FORMAT_KEY);
                    if (formatName == null) continue;
                    String suffix = fi.getAttribute(PER_FIELD_SUFFIX_KEY);
                    assert (suffix != null);
                    PostingsFormat format = PostingsFormat.forName(formatName);
                    String segmentSuffix = PerFieldPostingsFormat.getSuffix(formatName, suffix);
                    if (!this.formats.containsKey(segmentSuffix)) {
                        this.formats.put(segmentSuffix, format.fieldsProducer(new SegmentReadState(readState, segmentSuffix)));
                    }
                    this.fields.put(fieldName, this.formats.get(segmentSuffix));
                }
                success = true;
            }
            finally {
                if (!success) {
                    IOUtils.closeWhileHandlingException(this.formats.values());
                }
            }
        }

        @Override
        public Iterator<String> iterator() {
            return Collections.unmodifiableSet(this.fields.keySet()).iterator();
        }

        @Override
        public Terms terms(String field) throws IOException {
            FieldsProducer fieldsProducer = this.fields.get(field);
            return fieldsProducer == null ? null : fieldsProducer.terms(field);
        }

        @Override
        public int size() {
            return this.fields.size();
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.formats.values());
        }

        @Override
        public long ramBytesUsed() {
            long ramBytesUsed = BASE_RAM_BYTES_USED;
            ramBytesUsed += (long)this.fields.size() * 2L * (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
            ramBytesUsed += (long)this.formats.size() * 2L * (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
            for (Map.Entry<String, FieldsProducer> entry : this.formats.entrySet()) {
                ramBytesUsed += entry.getValue().ramBytesUsed();
            }
            return ramBytesUsed;
        }

        @Override
        public Iterable<? extends Accountable> getChildResources() {
            return Accountables.namedAccountables("format", this.formats);
        }

        @Override
        public void checkIntegrity() throws IOException {
            for (FieldsProducer producer : this.formats.values()) {
                producer.checkIntegrity();
            }
        }

        public String toString() {
            return "PerFieldPostings(formats=" + this.formats.size() + ")";
        }
    }

    private class FieldsWriter
    extends FieldsConsumer {
        final SegmentWriteState writeState;
        final List<Closeable> toClose = new ArrayList<Closeable>();

        public FieldsWriter(SegmentWriteState writeState) {
            this.writeState = writeState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(Fields fields) throws IOException {
            PostingsFormat format;
            HashMap<PostingsFormat, FieldsGroup> formatToGroups = new HashMap<PostingsFormat, FieldsGroup>();
            HashMap<String, Integer> suffixes = new HashMap<String, Integer>();
            for (String field : fields) {
                FieldInfo fieldInfo = this.writeState.fieldInfos.fieldInfo(field);
                format = PerFieldPostingsFormat.this.getPostingsFormatForField(field);
                if (format == null) {
                    throw new IllegalStateException("invalid null PostingsFormat for field=\"" + field + "\"");
                }
                String formatName = format.getName();
                FieldsGroup group = (FieldsGroup)formatToGroups.get(format);
                if (group == null) {
                    Integer suffix = (Integer)suffixes.get(formatName);
                    suffix = suffix == null ? Integer.valueOf(0) : Integer.valueOf(suffix + 1);
                    suffixes.put(formatName, suffix);
                    String segmentSuffix = PerFieldPostingsFormat.getFullSegmentSuffix(field, this.writeState.segmentSuffix, PerFieldPostingsFormat.getSuffix(formatName, Integer.toString(suffix)));
                    group = new FieldsGroup();
                    group.state = new SegmentWriteState(this.writeState, segmentSuffix);
                    group.suffix = suffix;
                    formatToGroups.put(format, group);
                } else assert (suffixes.containsKey(formatName));
                group.fields.add(field);
                String previousValue = fieldInfo.putAttribute(PER_FIELD_FORMAT_KEY, formatName);
                assert (previousValue == null);
                previousValue = fieldInfo.putAttribute(PER_FIELD_SUFFIX_KEY, Integer.toString(group.suffix));
                assert (previousValue == null);
            }
            boolean success = false;
            try {
                for (Map.Entry ent : formatToGroups.entrySet()) {
                    format = (PostingsFormat)ent.getKey();
                    final FieldsGroup group = (FieldsGroup)ent.getValue();
                    FilterAtomicReader.FilterFields maskedFields = new FilterAtomicReader.FilterFields(fields){

                        @Override
                        public Iterator<String> iterator() {
                            return group.fields.iterator();
                        }
                    };
                    FieldsConsumer consumer = format.fieldsConsumer(group.state);
                    this.toClose.add(consumer);
                    consumer.write(maskedFields);
                }
                success = true;
            }
            finally {
                if (!success) {
                    IOUtils.closeWhileHandlingException(this.toClose);
                }
            }
        }

        @Override
        public Comparator<BytesRef> getComparator() {
            return BytesRef.getUTF8SortedAsUnicodeComparator();
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.toClose);
        }
    }

    static class FieldsGroup {
        final Set<String> fields = new TreeSet<String>();
        int suffix;
        SegmentWriteState state;

        FieldsGroup() {
        }
    }
}

