/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.FieldInfosWriter;
import org.apache.lucene.codecs.NormsConsumer;
import org.apache.lucene.codecs.NormsFormat;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.index.BinaryDocValuesWriter;
import org.apache.lucene.index.DocConsumer;
import org.apache.lucene.index.DocValuesWriter;
import org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.FreqProxTermsWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.NormValuesWriter;
import org.apache.lucene.index.NumericDocValuesWriter;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.SortedDocValuesWriter;
import org.apache.lucene.index.SortedNumericDocValuesWriter;
import org.apache.lucene.index.SortedSetDocValuesWriter;
import org.apache.lucene.index.TermVectorsConsumer;
import org.apache.lucene.index.TermsHash;
import org.apache.lucene.index.TermsHashPerField;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;

final class DefaultIndexingChain
extends DocConsumer {
    final Counter bytesUsed;
    final DocumentsWriterPerThread.DocState docState;
    final DocumentsWriterPerThread docWriter;
    final FieldInfos.Builder fieldInfos;
    final TermsHash termsHash;
    private StoredFieldsWriter storedFieldsWriter;
    private int lastStoredDocID;
    private PerField[] fieldHash = new PerField[2];
    private int hashMask = 1;
    private int totalFieldCount;
    private long nextFieldGen;
    private PerField[] fields = new PerField[1];

    public DefaultIndexingChain(DocumentsWriterPerThread docWriter) throws IOException {
        this.docWriter = docWriter;
        this.fieldInfos = docWriter.getFieldInfosBuilder();
        this.docState = docWriter.docState;
        this.bytesUsed = docWriter.bytesUsed;
        TermVectorsConsumer termVectorsWriter = new TermVectorsConsumer(docWriter);
        this.termsHash = new FreqProxTermsWriter(docWriter, termVectorsWriter);
    }

    private void initStoredFieldsWriter() throws IOException {
        if (this.storedFieldsWriter == null) {
            this.storedFieldsWriter = this.docWriter.codec.storedFieldsFormat().fieldsWriter(this.docWriter.directory, this.docWriter.getSegmentInfo(), IOContext.DEFAULT);
        }
    }

    @Override
    public void flush(SegmentWriteState state) throws IOException {
        int numDocs = state.segmentInfo.getDocCount();
        this.writeNorms(state);
        this.writeDocValues(state);
        this.initStoredFieldsWriter();
        this.fillStoredFields(numDocs);
        this.storedFieldsWriter.finish(state.fieldInfos, numDocs);
        this.storedFieldsWriter.close();
        HashMap<String, TermsHashPerField> fieldsToFlush = new HashMap<String, TermsHashPerField>();
        for (int i = 0; i < this.fieldHash.length; ++i) {
            PerField perField = this.fieldHash[i];
            while (perField != null) {
                if (perField.invertState != null) {
                    fieldsToFlush.put(perField.fieldInfo.name, perField.termsHashPerField);
                }
                perField = perField.next;
            }
        }
        this.termsHash.flush(fieldsToFlush, state);
        FieldInfosWriter infosWriter = this.docWriter.codec.fieldInfosFormat().getFieldInfosWriter();
        infosWriter.write(state.directory, state.segmentInfo.name, "", state.fieldInfos, IOContext.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDocValues(SegmentWriteState state) throws IOException {
        block9: {
            DocValuesConsumer dvConsumer;
            block8: {
                int docCount = state.segmentInfo.getDocCount();
                dvConsumer = null;
                boolean success = false;
                try {
                    for (int i = 0; i < this.fieldHash.length; ++i) {
                        PerField perField = this.fieldHash[i];
                        while (perField != null) {
                            if (perField.docValuesWriter != null) {
                                if (dvConsumer == null) {
                                    DocValuesFormat fmt = state.segmentInfo.getCodec().docValuesFormat();
                                    dvConsumer = fmt.fieldsConsumer(state);
                                }
                                perField.docValuesWriter.finish(docCount);
                                perField.docValuesWriter.flush(state, dvConsumer);
                                perField.docValuesWriter = null;
                            }
                            perField = perField.next;
                        }
                    }
                    success = true;
                    if (!success) break block8;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(dvConsumer);
                    } else {
                        IOUtils.closeWhileHandlingException(dvConsumer);
                    }
                    throw throwable;
                }
                IOUtils.close(dvConsumer);
                break block9;
            }
            IOUtils.closeWhileHandlingException(dvConsumer);
        }
    }

    private void fillStoredFields(int docID) throws IOException {
        while (this.lastStoredDocID < docID) {
            this.startStoredFields();
            this.finishStoredFields();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNorms(SegmentWriteState state) throws IOException {
        block12: {
            NormsConsumer normsConsumer;
            block11: {
                boolean success = false;
                normsConsumer = null;
                try {
                    if (state.fieldInfos.hasNorms()) {
                        NormsFormat normsFormat = state.segmentInfo.getCodec().normsFormat();
                        assert (normsFormat != null);
                        normsConsumer = normsFormat.normsConsumer(state);
                        for (FieldInfo fi : state.fieldInfos) {
                            PerField perField = this.getPerField(fi.name);
                            assert (perField != null);
                            if (fi.omitsNorms()) continue;
                            if (perField.norms != null) {
                                perField.norms.finish(state.segmentInfo.getDocCount());
                                perField.norms.flush(state, normsConsumer);
                                assert (fi.getNormType() == FieldInfo.DocValuesType.NUMERIC);
                                continue;
                            }
                            if (fi.isIndexed()) assert (fi.getNormType() == null) : "got " + (Object)((Object)fi.getNormType()) + "; field=" + fi.name;
                        }
                    }
                    if (!(success = true)) break block11;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(normsConsumer);
                    } else {
                        IOUtils.closeWhileHandlingException(normsConsumer);
                    }
                    throw throwable;
                }
                IOUtils.close(normsConsumer);
                break block12;
            }
            IOUtils.closeWhileHandlingException(normsConsumer);
        }
    }

    @Override
    public void abort() {
        try {
            this.storedFieldsWriter.abort();
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            this.termsHash.abort();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Arrays.fill(this.fieldHash, null);
    }

    private void rehash() {
        int newHashSize = this.fieldHash.length * 2;
        assert (newHashSize > this.fieldHash.length);
        PerField[] newHashArray = new PerField[newHashSize];
        int newHashMask = newHashSize - 1;
        for (int j = 0; j < this.fieldHash.length; ++j) {
            PerField fp0 = this.fieldHash[j];
            while (fp0 != null) {
                int hashPos2 = fp0.fieldInfo.name.hashCode() & newHashMask;
                PerField nextFP0 = fp0.next;
                fp0.next = newHashArray[hashPos2];
                newHashArray[hashPos2] = fp0;
                fp0 = nextFP0;
            }
        }
        this.fieldHash = newHashArray;
        this.hashMask = newHashMask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startStoredFields() throws IOException {
        boolean success = false;
        try {
            this.initStoredFieldsWriter();
            this.storedFieldsWriter.startDocument();
            success = true;
        }
        finally {
            if (!success) {
                this.docWriter.setAborting();
            }
        }
        ++this.lastStoredDocID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishStoredFields() throws IOException {
        boolean success = false;
        try {
            this.storedFieldsWriter.finishDocument();
            success = true;
        }
        finally {
            if (!success) {
                this.docWriter.setAborting();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processDocument() throws IOException {
        int fieldCount = 0;
        long fieldGen = this.nextFieldGen++;
        this.termsHash.startDocument();
        this.fillStoredFields(this.docState.docID);
        this.startStoredFields();
        try {
            for (IndexableField indexableField : this.docState.doc) {
                fieldCount = this.processField(indexableField, fieldGen, fieldCount);
            }
        }
        finally {
            if (!this.docWriter.aborting) {
                for (int i = 0; i < fieldCount; ++i) {
                    this.fields[i].finish();
                }
                this.finishStoredFields();
            }
        }
        boolean success = false;
        try {
            this.termsHash.finishDocument();
            success = true;
        }
        finally {
            if (!success) {
                this.docWriter.setAborting();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processField(IndexableField field, long fieldGen, int fieldCount) throws IOException {
        FieldInfo.DocValuesType dvType;
        String fieldName = field.name();
        IndexableFieldType fieldType = field.fieldType();
        PerField fp = null;
        if (fieldType.indexed()) {
            if (fieldType.omitNorms() && field.boost() != 1.0f) {
                throw new UnsupportedOperationException("You cannot set an index-time boost: norms are omitted for field '" + field.name() + "'");
            }
            fp = this.getOrAddField(fieldName, fieldType, true);
            boolean first = fp.fieldGen != fieldGen;
            fp.invert(field, first);
            if (first) {
                this.fields[fieldCount++] = fp;
                fp.fieldGen = fieldGen;
            }
        } else {
            DefaultIndexingChain.verifyUnIndexedFieldType(fieldName, fieldType);
        }
        if (fieldType.stored()) {
            if (fp == null) {
                fp = this.getOrAddField(fieldName, fieldType, false);
            }
            if (fieldType.stored()) {
                boolean success = false;
                try {
                    this.storedFieldsWriter.writeField(fp.fieldInfo, field);
                    success = true;
                }
                finally {
                    if (!success) {
                        this.docWriter.setAborting();
                    }
                }
            }
        }
        if ((dvType = fieldType.docValueType()) != null) {
            if (fp == null) {
                fp = this.getOrAddField(fieldName, fieldType, false);
            }
            this.indexDocValue(fp, dvType, field);
        }
        return fieldCount;
    }

    private static void verifyUnIndexedFieldType(String name, IndexableFieldType ft) {
        if (ft.storeTermVectors()) {
            throw new IllegalArgumentException("cannot store term vectors for a field that is not indexed (field=\"" + name + "\")");
        }
        if (ft.storeTermVectorPositions()) {
            throw new IllegalArgumentException("cannot store term vector positions for a field that is not indexed (field=\"" + name + "\")");
        }
        if (ft.storeTermVectorOffsets()) {
            throw new IllegalArgumentException("cannot store term vector offsets for a field that is not indexed (field=\"" + name + "\")");
        }
        if (ft.storeTermVectorPayloads()) {
            throw new IllegalArgumentException("cannot store term vector payloads for a field that is not indexed (field=\"" + name + "\")");
        }
    }

    private void indexDocValue(PerField fp, FieldInfo.DocValuesType dvType, IndexableField field) throws IOException {
        boolean hasDocValues = fp.fieldInfo.hasDocValues();
        fp.fieldInfo.setDocValuesType(dvType);
        if (!hasDocValues) {
            this.fieldInfos.globalFieldNumbers.setDocValuesType(fp.fieldInfo.number, fp.fieldInfo.name, dvType);
        }
        int docID = this.docState.docID;
        switch (dvType) {
            case NUMERIC: {
                if (fp.docValuesWriter == null) {
                    fp.docValuesWriter = new NumericDocValuesWriter(fp.fieldInfo, this.bytesUsed);
                }
                ((NumericDocValuesWriter)fp.docValuesWriter).addValue(docID, field.numericValue().longValue());
                break;
            }
            case BINARY: {
                if (fp.docValuesWriter == null) {
                    fp.docValuesWriter = new BinaryDocValuesWriter(fp.fieldInfo, this.bytesUsed);
                }
                ((BinaryDocValuesWriter)fp.docValuesWriter).addValue(docID, field.binaryValue());
                break;
            }
            case SORTED: {
                if (fp.docValuesWriter == null) {
                    fp.docValuesWriter = new SortedDocValuesWriter(fp.fieldInfo, this.bytesUsed);
                }
                ((SortedDocValuesWriter)fp.docValuesWriter).addValue(docID, field.binaryValue());
                break;
            }
            case SORTED_NUMERIC: {
                if (fp.docValuesWriter == null) {
                    fp.docValuesWriter = new SortedNumericDocValuesWriter(fp.fieldInfo, this.bytesUsed);
                }
                ((SortedNumericDocValuesWriter)fp.docValuesWriter).addValue(docID, field.numericValue().longValue());
                break;
            }
            case SORTED_SET: {
                if (fp.docValuesWriter == null) {
                    fp.docValuesWriter = new SortedSetDocValuesWriter(fp.fieldInfo, this.bytesUsed);
                }
                ((SortedSetDocValuesWriter)fp.docValuesWriter).addValue(docID, field.binaryValue());
                break;
            }
            default: {
                throw new AssertionError((Object)("unrecognized DocValues.Type: " + (Object)((Object)dvType)));
            }
        }
    }

    private PerField getPerField(String name) {
        int hashPos = name.hashCode() & this.hashMask;
        PerField fp = this.fieldHash[hashPos];
        while (fp != null && !fp.fieldInfo.name.equals(name)) {
            fp = fp.next;
        }
        return fp;
    }

    private PerField getOrAddField(String name, IndexableFieldType fieldType, boolean invert) {
        int hashPos = name.hashCode() & this.hashMask;
        PerField fp = this.fieldHash[hashPos];
        while (fp != null && !fp.fieldInfo.name.equals(name)) {
            fp = fp.next;
        }
        if (fp == null) {
            FieldInfo fi = this.fieldInfos.addOrUpdate(name, fieldType);
            fp = new PerField(fi, invert);
            fp.next = this.fieldHash[hashPos];
            this.fieldHash[hashPos] = fp;
            ++this.totalFieldCount;
            if (this.totalFieldCount >= this.fieldHash.length / 2) {
                this.rehash();
            }
            if (this.totalFieldCount > this.fields.length) {
                PerField[] newFields = new PerField[ArrayUtil.oversize(this.totalFieldCount, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
                System.arraycopy(this.fields, 0, newFields, 0, this.fields.length);
                this.fields = newFields;
            }
        } else {
            fp.fieldInfo.update(fieldType);
            if (invert && fp.invertState == null) {
                fp.setInvertState();
            }
        }
        return fp;
    }

    private final class PerField
    implements Comparable<PerField> {
        final FieldInfo fieldInfo;
        final Similarity similarity;
        FieldInvertState invertState;
        TermsHashPerField termsHashPerField;
        DocValuesWriter docValuesWriter;
        long fieldGen = -1L;
        PerField next;
        NormValuesWriter norms;
        TokenStream tokenStream;

        public PerField(FieldInfo fieldInfo, boolean invert) {
            this.fieldInfo = fieldInfo;
            this.similarity = DefaultIndexingChain.this.docState.similarity;
            if (invert) {
                this.setInvertState();
            }
        }

        void setInvertState() {
            this.invertState = new FieldInvertState(this.fieldInfo.name);
            this.termsHashPerField = DefaultIndexingChain.this.termsHash.addField(this.invertState, this.fieldInfo);
        }

        @Override
        public int compareTo(PerField other) {
            return this.fieldInfo.name.compareTo(other.fieldInfo.name);
        }

        public void finish() throws IOException {
            if (!this.fieldInfo.omitsNorms()) {
                if (this.norms == null) {
                    this.fieldInfo.setNormValueType(FieldInfo.DocValuesType.NUMERIC);
                    this.norms = new NormValuesWriter(this.fieldInfo, DefaultIndexingChain.this.docState.docWriter.bytesUsed);
                }
                this.norms.addValue(DefaultIndexingChain.this.docState.docID, this.similarity.computeNorm(this.invertState));
            }
            this.termsHashPerField.finish();
        }

        public void invert(IndexableField field, boolean first) throws IOException {
            IndexableFieldType fieldType;
            if (first) {
                this.invertState.reset();
            }
            boolean analyzed = (fieldType = field.fieldType()).tokenized() && DefaultIndexingChain.this.docState.analyzer != null;
            boolean checkOffsets = fieldType.indexOptions() == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS;
            int lastStartOffset = 0;
            int lastPosition = 0;
            boolean aborting = false;
            boolean succeededInProcessingField = false;
            try (TokenStream stream = this.tokenStream = field.tokenStream(DefaultIndexingChain.this.docState.analyzer, this.tokenStream);){
                stream.reset();
                this.invertState.setAttributeSource(stream);
                this.termsHashPerField.start(field, first);
                while (stream.incrementToken()) {
                    int posIncr = this.invertState.posIncrAttribute.getPositionIncrement();
                    this.invertState.position += posIncr;
                    if (this.invertState.position < lastPosition) {
                        if (posIncr == 0) {
                            throw new IllegalArgumentException("first position increment must be > 0 (got 0) for field '" + field.name() + "'");
                        }
                        throw new IllegalArgumentException("position increments (and gaps) must be >= 0 (got " + posIncr + ") for field '" + field.name() + "'");
                    }
                    lastPosition = this.invertState.position;
                    if (posIncr == 0) {
                        ++this.invertState.numOverlap;
                    }
                    if (checkOffsets) {
                        int startOffset = this.invertState.offset + this.invertState.offsetAttribute.startOffset();
                        int endOffset = this.invertState.offset + this.invertState.offsetAttribute.endOffset();
                        if (startOffset < lastStartOffset || endOffset < startOffset) {
                            throw new IllegalArgumentException("startOffset must be non-negative, and endOffset must be >= startOffset, and offsets must not go backwards startOffset=" + startOffset + ",endOffset=" + endOffset + ",lastStartOffset=" + lastStartOffset + " for field '" + field.name() + "'");
                        }
                        lastStartOffset = startOffset;
                    }
                    aborting = true;
                    this.termsHashPerField.add();
                    aborting = false;
                    ++this.invertState.length;
                }
                stream.end();
                this.invertState.position += this.invertState.posIncrAttribute.getPositionIncrement();
                this.invertState.offset += this.invertState.offsetAttribute.endOffset();
                succeededInProcessingField = true;
            }
            catch (BytesRefHash.MaxBytesLengthExceededException e) {
                aborting = false;
                byte[] prefix = new byte[30];
                BytesRef bigTerm = this.invertState.termAttribute.getBytesRef();
                System.arraycopy(bigTerm.bytes, bigTerm.offset, prefix, 0, 30);
                String msg = "Document contains at least one immense term in field=\"" + this.fieldInfo.name + "\" (whose UTF8 encoding is longer than the max length " + 32766 + "), all of which were skipped.  Please correct the analyzer to not produce such terms.  The prefix of the first immense term is: '" + Arrays.toString(prefix) + "...', original message: " + e.getMessage();
                if (DefaultIndexingChain.this.docState.infoStream.isEnabled("IW")) {
                    DefaultIndexingChain.this.docState.infoStream.message("IW", "ERROR: " + msg);
                }
                throw new IllegalArgumentException(msg, e);
            }
            finally {
                if (!succeededInProcessingField && aborting) {
                    DefaultIndexingChain.this.docState.docWriter.setAborting();
                }
                if (!succeededInProcessingField && DefaultIndexingChain.this.docState.infoStream.isEnabled("DW")) {
                    DefaultIndexingChain.this.docState.infoStream.message("DW", "An exception was thrown while processing field " + this.fieldInfo.name);
                }
            }
            if (analyzed) {
                this.invertState.position += DefaultIndexingChain.this.docState.analyzer.getPositionIncrementGap(this.fieldInfo.name);
                this.invertState.offset += DefaultIndexingChain.this.docState.analyzer.getOffsetGap(this.fieldInfo.name);
            }
            this.invertState.boost *= field.boost();
        }
    }
}

