/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.CompoundFileDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.CloseableThreadLocal;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;

final class SegmentCoreReaders
implements Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SegmentCoreReaders.class);
    private final AtomicInteger ref = new AtomicInteger(1);
    final FieldsProducer fields;
    final NormsProducer normsProducer;
    final int termsIndexDivisor;
    final StoredFieldsReader fieldsReaderOrig;
    final TermVectorsReader termVectorsReaderOrig;
    final CompoundFileDirectory cfsReader;
    final CloseableThreadLocal<StoredFieldsReader> fieldsReaderLocal = new CloseableThreadLocal<StoredFieldsReader>(){

        @Override
        protected StoredFieldsReader initialValue() {
            return SegmentCoreReaders.this.fieldsReaderOrig.clone();
        }
    };
    final CloseableThreadLocal<TermVectorsReader> termVectorsLocal = new CloseableThreadLocal<TermVectorsReader>(){

        @Override
        protected TermVectorsReader initialValue() {
            return SegmentCoreReaders.this.termVectorsReaderOrig == null ? null : SegmentCoreReaders.this.termVectorsReaderOrig.clone();
        }
    };
    final CloseableThreadLocal<Map<String, Object>> normsLocal = new CloseableThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };
    private final Set<AtomicReader.CoreClosedListener> coreClosedListeners = Collections.synchronizedSet(new LinkedHashSet());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SegmentCoreReaders(SegmentReader owner, Directory dir, SegmentCommitInfo si, IOContext context, int termsIndexDivisor) throws IOException {
        if (termsIndexDivisor == 0) {
            throw new IllegalArgumentException("indexDivisor must be < 0 (don't load terms index) or greater than 0 (got 0)");
        }
        Codec codec = si.info.getCodec();
        boolean success = false;
        try {
            Directory cfsDir;
            if (si.info.getUseCompoundFile()) {
                this.cfsReader = new CompoundFileDirectory(dir, IndexFileNames.segmentFileName(si.info.name, "", "cfs"), context, false);
                cfsDir = this.cfsReader;
            } else {
                this.cfsReader = null;
                cfsDir = dir;
            }
            FieldInfos fieldInfos = owner.fieldInfos;
            this.termsIndexDivisor = termsIndexDivisor;
            PostingsFormat format = codec.postingsFormat();
            SegmentReadState segmentReadState = new SegmentReadState(cfsDir, si.info, fieldInfos, context, termsIndexDivisor);
            this.fields = format.fieldsProducer(segmentReadState);
            assert (this.fields != null);
            if (fieldInfos.hasNorms()) {
                this.normsProducer = codec.normsFormat().normsProducer(segmentReadState);
                assert (this.normsProducer != null);
            } else {
                this.normsProducer = null;
            }
            this.fieldsReaderOrig = si.info.getCodec().storedFieldsFormat().fieldsReader(cfsDir, si.info, fieldInfos, context);
            this.termVectorsReaderOrig = fieldInfos.hasVectors() ? si.info.getCodec().termVectorsFormat().vectorsReader(cfsDir, si.info, fieldInfos, context) : null;
            success = true;
        }
        finally {
            if (!success) {
                this.decRef();
            }
        }
    }

    int getRefCount() {
        return this.ref.get();
    }

    void incRef() {
        int count;
        while ((count = this.ref.get()) > 0) {
            if (!this.ref.compareAndSet(count, count + 1)) continue;
            return;
        }
        throw new AlreadyClosedException("SegmentCoreReaders is already closed");
    }

    NumericDocValues getNormValues(FieldInfos infos, String field) throws IOException {
        Map<String, Object> normFields = this.normsLocal.get();
        NumericDocValues norms = (NumericDocValues)normFields.get(field);
        if (norms != null) {
            return norms;
        }
        FieldInfo fi = infos.fieldInfo(field);
        if (fi == null || !fi.hasNorms()) {
            return null;
        }
        assert (this.normsProducer != null);
        norms = this.normsProducer.getNorms(fi);
        normFields.put(field, norms);
        return norms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decRef() throws IOException {
        if (this.ref.decrementAndGet() == 0) {
            Throwable th = null;
            try {
                IOUtils.close(this.termVectorsLocal, this.fieldsReaderLocal, this.normsLocal, this.fields, this.termVectorsReaderOrig, this.fieldsReaderOrig, this.cfsReader, this.normsProducer);
            }
            catch (Throwable throwable) {
                th = throwable;
            }
            finally {
                this.notifyCoreClosedListeners(th);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCoreClosedListeners(Throwable th) {
        Set<AtomicReader.CoreClosedListener> set = this.coreClosedListeners;
        synchronized (set) {
            for (AtomicReader.CoreClosedListener listener : this.coreClosedListeners) {
                try {
                    listener.onClose(this);
                }
                catch (Throwable t) {
                    if (th == null) {
                        th = t;
                        continue;
                    }
                    th.addSuppressed(t);
                }
            }
            IOUtils.reThrowUnchecked(th);
        }
    }

    void addCoreClosedListener(AtomicReader.CoreClosedListener listener) {
        this.coreClosedListeners.add(listener);
    }

    void removeCoreClosedListener(AtomicReader.CoreClosedListener listener) {
        this.coreClosedListeners.remove(listener);
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + (this.normsProducer != null ? this.normsProducer.ramBytesUsed() : 0L) + (this.fields != null ? this.fields.ramBytesUsed() : 0L) + (this.fieldsReaderOrig != null ? this.fieldsReaderOrig.ramBytesUsed() : 0L) + (this.termVectorsReaderOrig != null ? this.termVectorsReaderOrig.ramBytesUsed() : 0L);
    }

    @Override
    public Iterable<? extends Accountable> getChildResources() {
        return Collections.emptyList();
    }
}

