/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.Version;

class SegmentDocValuesProducer
extends DocValuesProducer {
    private static final long LONG_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Long.class);
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SegmentDocValuesProducer.class);
    final Map<String, DocValuesProducer> dvProducersByField = new HashMap<String, DocValuesProducer>();
    final Set<DocValuesProducer> dvProducers = Collections.newSetFromMap(new IdentityHashMap());
    final List<Long> dvGens = new ArrayList<Long>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SegmentDocValuesProducer(SegmentCommitInfo si, Directory dir, FieldInfos fieldInfos, SegmentDocValues segDocValues, DocValuesFormat dvFormat, int termIndexDivisor) throws IOException {
        boolean success = false;
        try {
            Version ver = si.info.getVersion();
            if (ver != null && ver.onOrAfter(Version.LUCENE_4_9_0)) {
                DocValuesProducer baseProducer = null;
                for (FieldInfo fieldInfo : fieldInfos) {
                    if (!fieldInfo.hasDocValues()) continue;
                    long docValuesGen = fieldInfo.getDocValuesGen();
                    if (docValuesGen == -1L) {
                        if (baseProducer == null) {
                            baseProducer = segDocValues.getDocValuesProducer(docValuesGen, si, IOContext.READ, dir, dvFormat, fieldInfos, termIndexDivisor);
                            this.dvGens.add(docValuesGen);
                            this.dvProducers.add(baseProducer);
                        }
                        this.dvProducersByField.put(fieldInfo.name, baseProducer);
                        continue;
                    }
                    assert (!this.dvGens.contains(docValuesGen));
                    DocValuesProducer dvp = segDocValues.getDocValuesProducer(docValuesGen, si, IOContext.READ, dir, dvFormat, new FieldInfos(new FieldInfo[]{fieldInfo}), termIndexDivisor);
                    this.dvGens.add(docValuesGen);
                    this.dvProducers.add(dvp);
                    this.dvProducersByField.put(fieldInfo.name, dvp);
                }
            } else {
                HashMap<Long, ArrayList<FieldInfo>> genInfos = new HashMap<Long, ArrayList<FieldInfo>>();
                for (FieldInfo fieldInfo : fieldInfos) {
                    if (!fieldInfo.hasDocValues()) continue;
                    ArrayList<FieldInfo> genFieldInfos = (ArrayList<FieldInfo>)genInfos.get(fieldInfo.getDocValuesGen());
                    if (genFieldInfos == null) {
                        genFieldInfos = new ArrayList<FieldInfo>();
                        genInfos.put(fieldInfo.getDocValuesGen(), genFieldInfos);
                    }
                    genFieldInfos.add(fieldInfo);
                }
                for (Map.Entry entry : genInfos.entrySet()) {
                    long docValuesGen = (Long)entry.getKey();
                    List infos = (List)entry.getValue();
                    DocValuesProducer dvp = docValuesGen == -1L ? segDocValues.getDocValuesProducer(docValuesGen, si, IOContext.READ, dir, dvFormat, fieldInfos, termIndexDivisor) : segDocValues.getDocValuesProducer(docValuesGen, si, IOContext.READ, dir, dvFormat, new FieldInfos(infos.toArray(new FieldInfo[infos.size()])), termIndexDivisor);
                    this.dvGens.add(docValuesGen);
                    this.dvProducers.add(dvp);
                    for (FieldInfo fi : infos) {
                        this.dvProducersByField.put(fi.name, dvp);
                    }
                }
            }
            success = true;
        }
        finally {
            if (!success) {
                try {
                    segDocValues.decRef(this.dvGens);
                }
                catch (Throwable t) {}
            }
        }
    }

    @Override
    public NumericDocValues getNumeric(FieldInfo field) throws IOException {
        DocValuesProducer dvProducer = this.dvProducersByField.get(field.name);
        assert (dvProducer != null);
        return dvProducer.getNumeric(field);
    }

    @Override
    public BinaryDocValues getBinary(FieldInfo field) throws IOException {
        DocValuesProducer dvProducer = this.dvProducersByField.get(field.name);
        assert (dvProducer != null);
        return dvProducer.getBinary(field);
    }

    @Override
    public SortedDocValues getSorted(FieldInfo field) throws IOException {
        DocValuesProducer dvProducer = this.dvProducersByField.get(field.name);
        assert (dvProducer != null);
        return dvProducer.getSorted(field);
    }

    @Override
    public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
        DocValuesProducer dvProducer = this.dvProducersByField.get(field.name);
        assert (dvProducer != null);
        return dvProducer.getSortedNumeric(field);
    }

    @Override
    public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
        DocValuesProducer dvProducer = this.dvProducersByField.get(field.name);
        assert (dvProducer != null);
        return dvProducer.getSortedSet(field);
    }

    @Override
    public Bits getDocsWithField(FieldInfo field) throws IOException {
        DocValuesProducer dvProducer = this.dvProducersByField.get(field.name);
        assert (dvProducer != null);
        return dvProducer.getDocsWithField(field);
    }

    @Override
    public void checkIntegrity() throws IOException {
        for (DocValuesProducer producer : this.dvProducers) {
            producer.checkIntegrity();
        }
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long ramBytesUsed() {
        long ramBytesUsed = BASE_RAM_BYTES_USED;
        ramBytesUsed += (long)this.dvGens.size() * LONG_RAM_BYTES_USED;
        ramBytesUsed += (long)(this.dvProducers.size() * RamUsageEstimator.NUM_BYTES_OBJECT_REF);
        ramBytesUsed += (long)(this.dvProducersByField.size() * 2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF);
        for (DocValuesProducer producer : this.dvProducers) {
            ramBytesUsed += producer.ramBytesUsed();
        }
        return ramBytesUsed;
    }

    @Override
    public Iterable<? extends Accountable> getChildResources() {
        ArrayList<Accountable> resources = new ArrayList<Accountable>();
        for (Accountable accountable : this.dvProducers) {
            resources.add(Accountables.namedAccountable("delegate", accountable));
        }
        return Collections.unmodifiableList(resources);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(producers=" + this.dvProducers.size() + ")";
    }
}

