/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.FieldInfosWriter;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.NormsConsumer;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.codecs.TermVectorsWriter;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;

final class SegmentMerger {
    private final Directory directory;
    private final int termIndexInterval;
    private final Codec codec;
    private final IOContext context;
    private final MergeState mergeState;
    private final FieldInfos.Builder fieldInfosBuilder;

    SegmentMerger(List<AtomicReader> readers, SegmentInfo segmentInfo, InfoStream infoStream, Directory dir, int termIndexInterval, MergeState.CheckAbort checkAbort, FieldInfos.FieldNumbers fieldNumbers, IOContext context, boolean validate) throws IOException {
        if (validate) {
            for (AtomicReader reader : readers) {
                reader.checkIntegrity();
            }
        }
        this.mergeState = new MergeState(readers, segmentInfo, infoStream, checkAbort);
        this.directory = dir;
        this.termIndexInterval = termIndexInterval;
        this.codec = segmentInfo.getCodec();
        this.context = context;
        this.fieldInfosBuilder = new FieldInfos.Builder(fieldNumbers);
        this.mergeState.segmentInfo.setDocCount(this.setDocMaps());
    }

    boolean shouldMerge() {
        return this.mergeState.segmentInfo.getDocCount() > 0;
    }

    MergeState merge() throws IOException {
        long t1;
        if (!this.shouldMerge()) {
            throw new IllegalStateException("Merge would result in 0 document segment");
        }
        this.mergeFieldInfos();
        long t0 = 0L;
        if (this.mergeState.infoStream.isEnabled("SM")) {
            t0 = System.nanoTime();
        }
        int numMerged = this.mergeFields();
        if (this.mergeState.infoStream.isEnabled("SM")) {
            long t12 = System.nanoTime();
            this.mergeState.infoStream.message("SM", (t12 - t0) / 1000000L + " msec to merge stored fields [" + numMerged + " docs]");
        }
        assert (numMerged == this.mergeState.segmentInfo.getDocCount());
        SegmentWriteState segmentWriteState = new SegmentWriteState(this.mergeState.infoStream, this.directory, this.mergeState.segmentInfo, this.mergeState.fieldInfos, this.termIndexInterval, null, this.context);
        if (this.mergeState.infoStream.isEnabled("SM")) {
            t0 = System.nanoTime();
        }
        this.mergeTerms(segmentWriteState);
        if (this.mergeState.infoStream.isEnabled("SM")) {
            t1 = System.nanoTime();
            this.mergeState.infoStream.message("SM", (t1 - t0) / 1000000L + " msec to merge postings [" + numMerged + " docs]");
        }
        if (this.mergeState.infoStream.isEnabled("SM")) {
            t0 = System.nanoTime();
        }
        if (this.mergeState.fieldInfos.hasDocValues()) {
            this.mergeDocValues(segmentWriteState);
        }
        if (this.mergeState.infoStream.isEnabled("SM")) {
            t1 = System.nanoTime();
            this.mergeState.infoStream.message("SM", (t1 - t0) / 1000000L + " msec to merge doc values [" + numMerged + " docs]");
        }
        if (this.mergeState.fieldInfos.hasNorms()) {
            if (this.mergeState.infoStream.isEnabled("SM")) {
                t0 = System.nanoTime();
            }
            this.mergeNorms(segmentWriteState);
            if (this.mergeState.infoStream.isEnabled("SM")) {
                t1 = System.nanoTime();
                this.mergeState.infoStream.message("SM", (t1 - t0) / 1000000L + " msec to merge norms [" + numMerged + " docs]");
            }
        }
        if (this.mergeState.fieldInfos.hasVectors()) {
            if (this.mergeState.infoStream.isEnabled("SM")) {
                t0 = System.nanoTime();
            }
            numMerged = this.mergeVectors();
            if (this.mergeState.infoStream.isEnabled("SM")) {
                t1 = System.nanoTime();
                this.mergeState.infoStream.message("SM", (t1 - t0) / 1000000L + " msec to merge vectors [" + numMerged + " docs]");
            }
            assert (numMerged == this.mergeState.segmentInfo.getDocCount());
        }
        FieldInfosWriter fieldInfosWriter = this.codec.fieldInfosFormat().getFieldInfosWriter();
        fieldInfosWriter.write(this.directory, this.mergeState.segmentInfo.name, "", this.mergeState.fieldInfos, this.context);
        return this.mergeState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeDocValues(SegmentWriteState segmentWriteState) throws IOException {
        block5: {
            DocValuesConsumer consumer;
            block4: {
                consumer = this.codec.docValuesFormat().fieldsConsumer(segmentWriteState);
                boolean success = false;
                try {
                    consumer.merge(this.mergeState);
                    success = true;
                    if (!success) break block4;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(consumer);
                    } else {
                        IOUtils.closeWhileHandlingException(consumer);
                    }
                    throw throwable;
                }
                IOUtils.close(consumer);
                break block5;
            }
            IOUtils.closeWhileHandlingException(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeNorms(SegmentWriteState segmentWriteState) throws IOException {
        block5: {
            NormsConsumer consumer;
            block4: {
                consumer = this.codec.normsFormat().normsConsumer(segmentWriteState);
                boolean success = false;
                try {
                    consumer.merge(this.mergeState);
                    success = true;
                    if (!success) break block4;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(consumer);
                    } else {
                        IOUtils.closeWhileHandlingException(consumer);
                    }
                    throw throwable;
                }
                IOUtils.close(consumer);
                break block5;
            }
            IOUtils.closeWhileHandlingException(consumer);
        }
    }

    public void mergeFieldInfos() throws IOException {
        for (AtomicReader reader : this.mergeState.readers) {
            FieldInfos readerFieldInfos = reader.getFieldInfos();
            for (FieldInfo fi : readerFieldInfos) {
                this.fieldInfosBuilder.add(fi);
            }
        }
        this.mergeState.fieldInfos = this.fieldInfosBuilder.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int mergeFields() throws IOException {
        int numDocs;
        block5: {
            StoredFieldsWriter fieldsWriter;
            block4: {
                fieldsWriter = this.codec.storedFieldsFormat().fieldsWriter(this.directory, this.mergeState.segmentInfo, this.context);
                boolean success = false;
                try {
                    numDocs = fieldsWriter.merge(this.mergeState);
                    success = true;
                    if (!success) break block4;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(fieldsWriter);
                    } else {
                        IOUtils.closeWhileHandlingException(fieldsWriter);
                    }
                    throw throwable;
                }
                IOUtils.close(fieldsWriter);
                break block5;
            }
            IOUtils.closeWhileHandlingException(fieldsWriter);
        }
        return numDocs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int mergeVectors() throws IOException {
        int numDocs;
        block5: {
            TermVectorsWriter termVectorsWriter;
            block4: {
                termVectorsWriter = this.codec.termVectorsFormat().vectorsWriter(this.directory, this.mergeState.segmentInfo, this.context);
                boolean success = false;
                try {
                    numDocs = termVectorsWriter.merge(this.mergeState);
                    success = true;
                    if (!success) break block4;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(termVectorsWriter);
                    } else {
                        IOUtils.closeWhileHandlingException(termVectorsWriter);
                    }
                    throw throwable;
                }
                IOUtils.close(termVectorsWriter);
                break block5;
            }
            IOUtils.closeWhileHandlingException(termVectorsWriter);
        }
        return numDocs;
    }

    private int setDocMaps() throws IOException {
        int numReaders = this.mergeState.readers.size();
        this.mergeState.docMaps = new MergeState.DocMap[numReaders];
        this.mergeState.docBase = new int[numReaders];
        int docBase = 0;
        for (int i = 0; i < this.mergeState.readers.size(); ++i) {
            MergeState.DocMap docMap;
            AtomicReader reader = this.mergeState.readers.get(i);
            this.mergeState.docBase[i] = docBase;
            this.mergeState.docMaps[i] = docMap = MergeState.DocMap.build(reader);
            docBase += docMap.numDocs();
        }
        return docBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeTerms(SegmentWriteState segmentWriteState) throws IOException {
        block5: {
            FieldsConsumer consumer;
            block4: {
                consumer = this.codec.postingsFormat().fieldsConsumer(segmentWriteState);
                boolean success = false;
                try {
                    consumer.merge(this.mergeState);
                    success = true;
                    if (!success) break block4;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(consumer);
                    } else {
                        IOUtils.closeWhileHandlingException(consumer);
                    }
                    throw throwable;
                }
                IOUtils.close(consumer);
                break block5;
            }
            IOUtils.closeWhileHandlingException(consumer);
        }
    }
}

