/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentCoreReaders;
import org.apache.lucene.index.SegmentDocValues;
import org.apache.lucene.index.SegmentDocValuesProducer;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.store.CompoundFileDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.CloseableThreadLocal;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;

public final class SegmentReader
extends AtomicReader
implements Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SegmentReader.class) + RamUsageEstimator.shallowSizeOfInstance(SegmentDocValues.class);
    private final SegmentCommitInfo si;
    private final Bits liveDocs;
    private final int numDocs;
    final SegmentCoreReaders core;
    final SegmentDocValues segDocValues;
    final CloseableThreadLocal<Map<String, Object>> docValuesLocal = new CloseableThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };
    final CloseableThreadLocal<Map<String, Bits>> docsWithFieldLocal = new CloseableThreadLocal<Map<String, Bits>>(){

        @Override
        protected Map<String, Bits> initialValue() {
            return new HashMap<String, Bits>();
        }
    };
    final DocValuesProducer docValuesProducer;
    final FieldInfos fieldInfos;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SegmentReader(SegmentCommitInfo si, int termInfosIndexDivisor, IOContext context) throws IOException {
        this.si = si;
        this.fieldInfos = SegmentReader.readFieldInfos(si);
        this.core = new SegmentCoreReaders(this, si.info.dir, si, context, termInfosIndexDivisor);
        this.segDocValues = new SegmentDocValues();
        boolean success = false;
        Codec codec = si.info.getCodec();
        try {
            if (si.hasDeletions()) {
                this.liveDocs = codec.liveDocsFormat().readLiveDocs(this.directory(), si, IOContext.READONCE);
            } else {
                assert (si.getDelCount() == 0);
                this.liveDocs = null;
            }
            this.numDocs = si.info.getDocCount() - si.getDelCount();
            this.docValuesProducer = this.fieldInfos.hasDocValues() ? this.initDocValuesProducer(codec) : null;
            success = true;
        }
        finally {
            if (!success) {
                this.doClose();
            }
        }
    }

    SegmentReader(SegmentCommitInfo si, SegmentReader sr) throws IOException {
        this(si, sr, si.info.getCodec().liveDocsFormat().readLiveDocs(si.info.dir, si, IOContext.READONCE), si.info.getDocCount() - si.getDelCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SegmentReader(SegmentCommitInfo si, SegmentReader sr, Bits liveDocs, int numDocs) throws IOException {
        this.si = si;
        this.liveDocs = liveDocs;
        this.numDocs = numDocs;
        this.core = sr.core;
        this.core.incRef();
        this.segDocValues = sr.segDocValues;
        boolean success = false;
        try {
            Codec codec = si.info.getCodec();
            this.fieldInfos = si.getFieldInfosGen() == -1L ? sr.fieldInfos : SegmentReader.readFieldInfos(si);
            this.docValuesProducer = this.fieldInfos.hasDocValues() ? this.initDocValuesProducer(codec) : null;
            success = true;
        }
        finally {
            if (!success) {
                this.doClose();
            }
        }
    }

    private DocValuesProducer initDocValuesProducer(Codec codec) throws IOException {
        Directory dir = this.core.cfsReader != null ? this.core.cfsReader : this.si.info.dir;
        DocValuesFormat dvFormat = codec.docValuesFormat();
        int termsIndexDivisor = this.getTermInfosIndexDivisor();
        if (!this.si.hasFieldUpdates()) {
            return this.segDocValues.getDocValuesProducer(-1L, this.si, IOContext.READ, dir, dvFormat, this.fieldInfos, termsIndexDivisor);
        }
        return new SegmentDocValuesProducer(this.si, dir, this.fieldInfos, this.segDocValues, dvFormat, termsIndexDivisor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FieldInfos readFieldInfos(SegmentCommitInfo info) throws IOException {
        boolean closeDir;
        Directory dir;
        if (info.getFieldInfosGen() == -1L && info.info.getUseCompoundFile()) {
            dir = new CompoundFileDirectory(info.info.dir, IndexFileNames.segmentFileName(info.info.name, "", "cfs"), IOContext.READONCE, false);
            closeDir = true;
        } else {
            dir = info.info.dir;
            closeDir = false;
        }
        try {
            String segmentSuffix = info.getFieldInfosGen() == -1L ? "" : Long.toString(info.getFieldInfosGen(), 36);
            Codec codec = info.info.getCodec();
            FieldInfosFormat fisFormat = codec.fieldInfosFormat();
            FieldInfos fieldInfos = fisFormat.getFieldInfosReader().read(dir, info.info.name, segmentSuffix, IOContext.READONCE);
            return fieldInfos;
        }
        finally {
            if (closeDir) {
                dir.close();
            }
        }
    }

    @Override
    public Bits getLiveDocs() {
        this.ensureOpen();
        return this.liveDocs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() throws IOException {
        try {
            this.core.decRef();
        }
        catch (Throwable throwable) {
            try {
                IOUtils.close(this.docValuesLocal, this.docsWithFieldLocal);
            }
            finally {
                if (this.docValuesProducer instanceof SegmentDocValuesProducer) {
                    this.segDocValues.decRef(((SegmentDocValuesProducer)this.docValuesProducer).dvGens);
                } else if (this.docValuesProducer != null) {
                    this.segDocValues.decRef(Collections.singletonList(-1L));
                }
            }
            throw throwable;
        }
        try {
            IOUtils.close(this.docValuesLocal, this.docsWithFieldLocal);
        }
        finally {
            if (this.docValuesProducer instanceof SegmentDocValuesProducer) {
                this.segDocValues.decRef(((SegmentDocValuesProducer)this.docValuesProducer).dvGens);
            } else if (this.docValuesProducer != null) {
                this.segDocValues.decRef(Collections.singletonList(-1L));
            }
        }
    }

    @Override
    public FieldInfos getFieldInfos() {
        this.ensureOpen();
        return this.fieldInfos;
    }

    @Override
    public void document(int docID, StoredFieldVisitor visitor) throws IOException {
        this.checkBounds(docID);
        this.getFieldsReader().visitDocument(docID, visitor);
    }

    @Override
    public FieldsProducer fields() {
        this.ensureOpen();
        return this.core.fields;
    }

    @Override
    public int numDocs() {
        return this.numDocs;
    }

    @Override
    public int maxDoc() {
        return this.si.info.getDocCount();
    }

    public TermVectorsReader getTermVectorsReader() {
        this.ensureOpen();
        return this.core.termVectorsLocal.get();
    }

    public StoredFieldsReader getFieldsReader() {
        this.ensureOpen();
        return this.core.fieldsReaderLocal.get();
    }

    public NormsProducer getNormsReader() {
        this.ensureOpen();
        return this.core.normsProducer;
    }

    public DocValuesProducer getDocValuesReader() {
        this.ensureOpen();
        return this.docValuesProducer;
    }

    @Override
    public Fields getTermVectors(int docID) throws IOException {
        TermVectorsReader termVectorsReader = this.getTermVectorsReader();
        if (termVectorsReader == null) {
            return null;
        }
        this.checkBounds(docID);
        return termVectorsReader.get(docID);
    }

    private void checkBounds(int docID) {
        if (docID < 0 || docID >= this.maxDoc()) {
            throw new IndexOutOfBoundsException("docID must be >= 0 and < maxDoc=" + this.maxDoc() + " (got docID=" + docID + ")");
        }
    }

    public String toString() {
        return this.si.toString(this.si.info.dir, this.si.info.getDocCount() - this.numDocs - this.si.getDelCount());
    }

    public String getSegmentName() {
        return this.si.info.name;
    }

    public SegmentCommitInfo getSegmentInfo() {
        return this.si;
    }

    public Directory directory() {
        return this.si.info.dir;
    }

    @Override
    public Object getCoreCacheKey() {
        return this.core;
    }

    @Override
    public Object getCombinedCoreAndDeletesKey() {
        return this;
    }

    public int getTermInfosIndexDivisor() {
        return this.core.termsIndexDivisor;
    }

    private FieldInfo getDVField(String field, FieldInfo.DocValuesType type) {
        FieldInfo fi = this.fieldInfos.fieldInfo(field);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() == null) {
            return null;
        }
        if (fi.getDocValuesType() != type) {
            return null;
        }
        return fi;
    }

    @Override
    public NumericDocValues getNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        Map<String, Object> dvFields = this.docValuesLocal.get();
        Object previous = dvFields.get(field);
        if (previous != null && previous instanceof NumericDocValues) {
            return (NumericDocValues)previous;
        }
        FieldInfo fi = this.getDVField(field, FieldInfo.DocValuesType.NUMERIC);
        if (fi == null) {
            return null;
        }
        NumericDocValues dv = this.docValuesProducer.getNumeric(fi);
        dvFields.put(field, dv);
        return dv;
    }

    @Override
    public Bits getDocsWithField(String field) throws IOException {
        this.ensureOpen();
        Map<String, Bits> dvFields = this.docsWithFieldLocal.get();
        Bits previous = dvFields.get(field);
        if (previous != null) {
            return previous;
        }
        FieldInfo fi = this.fieldInfos.fieldInfo(field);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() == null) {
            return null;
        }
        Bits dv = this.docValuesProducer.getDocsWithField(fi);
        dvFields.put(field, dv);
        return dv;
    }

    @Override
    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field, FieldInfo.DocValuesType.BINARY);
        if (fi == null) {
            return null;
        }
        Map<String, Object> dvFields = this.docValuesLocal.get();
        BinaryDocValues dvs = (BinaryDocValues)dvFields.get(field);
        if (dvs == null) {
            dvs = this.docValuesProducer.getBinary(fi);
            dvFields.put(field, dvs);
        }
        return dvs;
    }

    @Override
    public SortedDocValues getSortedDocValues(String field) throws IOException {
        this.ensureOpen();
        Map<String, Object> dvFields = this.docValuesLocal.get();
        Object previous = dvFields.get(field);
        if (previous != null && previous instanceof SortedDocValues) {
            return (SortedDocValues)previous;
        }
        FieldInfo fi = this.getDVField(field, FieldInfo.DocValuesType.SORTED);
        if (fi == null) {
            return null;
        }
        SortedDocValues dv = this.docValuesProducer.getSorted(fi);
        dvFields.put(field, dv);
        return dv;
    }

    @Override
    public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        Map<String, Object> dvFields = this.docValuesLocal.get();
        Object previous = dvFields.get(field);
        if (previous != null && previous instanceof SortedNumericDocValues) {
            return (SortedNumericDocValues)previous;
        }
        FieldInfo fi = this.getDVField(field, FieldInfo.DocValuesType.SORTED_NUMERIC);
        if (fi == null) {
            return null;
        }
        SortedNumericDocValues dv = this.docValuesProducer.getSortedNumeric(fi);
        dvFields.put(field, dv);
        return dv;
    }

    @Override
    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        this.ensureOpen();
        Map<String, Object> dvFields = this.docValuesLocal.get();
        Object previous = dvFields.get(field);
        if (previous != null && previous instanceof SortedSetDocValues) {
            return (SortedSetDocValues)previous;
        }
        FieldInfo fi = this.getDVField(field, FieldInfo.DocValuesType.SORTED_SET);
        if (fi == null) {
            return null;
        }
        SortedSetDocValues dv = this.docValuesProducer.getSortedSet(fi);
        dvFields.put(field, dv);
        return dv;
    }

    @Override
    public NumericDocValues getNormValues(String field) throws IOException {
        this.ensureOpen();
        return this.core.getNormValues(this.fieldInfos, field);
    }

    @Override
    public void addCoreClosedListener(AtomicReader.CoreClosedListener listener) {
        this.ensureOpen();
        this.core.addCoreClosedListener(listener);
    }

    @Override
    public void removeCoreClosedListener(AtomicReader.CoreClosedListener listener) {
        this.ensureOpen();
        this.core.removeCoreClosedListener(listener);
    }

    @Override
    public long ramBytesUsed() {
        this.ensureOpen();
        long ramBytesUsed = BASE_RAM_BYTES_USED;
        if (this.docValuesProducer != null) {
            ramBytesUsed += this.docValuesProducer.ramBytesUsed();
        }
        if (this.core != null) {
            ramBytesUsed += this.core.ramBytesUsed();
        }
        return ramBytesUsed;
    }

    @Override
    public Iterable<? extends Accountable> getChildResources() {
        this.ensureOpen();
        ArrayList<Accountable> resources = new ArrayList<Accountable>();
        if (this.core.fields != null) {
            resources.add(Accountables.namedAccountable("postings", this.core.fields));
        }
        if (this.core.normsProducer != null) {
            resources.add(Accountables.namedAccountable("norms", this.core.normsProducer));
        }
        if (this.docValuesProducer != null) {
            resources.add(Accountables.namedAccountable("docvalues", this.docValuesProducer));
        }
        if (this.getFieldsReader() != null) {
            resources.add(Accountables.namedAccountable("stored fields", this.getFieldsReader()));
        }
        if (this.getTermVectorsReader() != null) {
            resources.add(Accountables.namedAccountable("term vectors", this.getTermVectorsReader()));
        }
        return resources;
    }

    @Override
    public void checkIntegrity() throws IOException {
        this.ensureOpen();
        this.getFieldsReader().checkIntegrity();
        TermVectorsReader termVectorsReader = this.getTermVectorsReader();
        if (termVectorsReader != null) {
            termVectorsReader.checkIntegrity();
        }
        if (this.core.fields != null) {
            this.core.fields.checkIntegrity();
        }
        if (this.core.normsProducer != null) {
            this.core.normsProducer.checkIntegrity();
        }
        if (this.docValuesProducer != null) {
            this.docValuesProducer.checkIntegrity();
        }
    }
}

