/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.store.Directory;

public final class IOUtils {
    @Deprecated
    public static final Charset CHARSET_UTF_8 = StandardCharsets.UTF_8;
    public static final String UTF_8 = StandardCharsets.UTF_8.name();

    private IOUtils() {
    }

    public static void close(Closeable ... objects) throws IOException {
        IOUtils.close(Arrays.asList(objects));
    }

    public static void close(Iterable<? extends Closeable> objects) throws IOException {
        Throwable th = null;
        for (Closeable closeable : objects) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Throwable t) {
                IOUtils.addSuppressed(th, t);
                if (th != null) continue;
                th = t;
            }
        }
        IOUtils.reThrow(th);
    }

    public static void closeWhileHandlingException(Closeable ... objects) {
        IOUtils.closeWhileHandlingException(Arrays.asList(objects));
    }

    public static void closeWhileHandlingException(Iterable<? extends Closeable> objects) {
        for (Closeable closeable : objects) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private static void addSuppressed(Throwable exception, Throwable suppressed) {
        if (exception != null && suppressed != null) {
            exception.addSuppressed(suppressed);
        }
    }

    public static Reader getDecodingReader(InputStream stream, Charset charSet) {
        CharsetDecoder charSetDecoder = charSet.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        return new BufferedReader(new InputStreamReader(stream, charSetDecoder));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Reader getDecodingReader(File file, Charset charSet) throws IOException {
        Reader reader;
        block3: {
            FileInputStream stream = null;
            boolean success = false;
            try {
                stream = new FileInputStream(file);
                Reader reader2 = IOUtils.getDecodingReader(stream, charSet);
                success = true;
                reader = reader2;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.close(stream);
                }
                throw throwable;
            }
            IOUtils.close(stream);
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Reader getDecodingReader(Class<?> clazz, String resource, Charset charSet) throws IOException {
        Reader reader;
        block3: {
            InputStream stream = null;
            boolean success = false;
            try {
                stream = clazz.getResourceAsStream(resource);
                Reader reader2 = IOUtils.getDecodingReader(stream, charSet);
                success = true;
                reader = reader2;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.close(stream);
                }
                throw throwable;
            }
            IOUtils.close(stream);
        }
        return reader;
    }

    public static void deleteFilesIgnoringExceptions(Directory dir, String ... files) {
        for (String name : files) {
            try {
                dir.deleteFile(name);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
    }

    public static void deleteFilesIgnoringExceptions(File ... files) {
        IOUtils.deleteFilesIgnoringExceptions(Arrays.asList(files));
    }

    public static void deleteFilesIgnoringExceptions(Iterable<? extends File> files) {
        for (File file : files) {
            if (file == null) continue;
            try {
                Files.delete(file.toPath());
            }
            catch (Throwable throwable) {}
        }
    }

    public static void deleteFilesIfExist(File ... files) throws IOException {
        IOUtils.deleteFilesIfExist(Arrays.asList(files));
    }

    public static void deleteFilesIfExist(Iterable<? extends File> files) throws IOException {
        Throwable th = null;
        for (File file : files) {
            try {
                if (file == null) continue;
                Files.deleteIfExists(file.toPath());
            }
            catch (Throwable t) {
                IOUtils.addSuppressed(th, t);
                if (th != null) continue;
                th = t;
            }
        }
        IOUtils.reThrow(th);
    }

    public static void rm(File ... locations) throws IOException {
        LinkedHashMap<File, Throwable> unremoved = IOUtils.rm(new LinkedHashMap<File, Throwable>(), locations);
        if (!unremoved.isEmpty()) {
            StringBuilder b = new StringBuilder("Could not remove the following files (in the order of attempts):\n");
            for (Map.Entry<File, Throwable> kv : unremoved.entrySet()) {
                b.append("   ").append(kv.getKey().getAbsolutePath()).append(": ").append(kv.getValue()).append("\n");
            }
            throw new IOException(b.toString());
        }
    }

    private static LinkedHashMap<File, Throwable> rm(LinkedHashMap<File, Throwable> unremoved, File ... locations) {
        if (locations != null) {
            for (File location : locations) {
                if (location == null || !location.exists()) continue;
                if (location.isDirectory()) {
                    IOUtils.rm(unremoved, location.listFiles());
                }
                try {
                    Files.delete(location.toPath());
                }
                catch (Throwable cause) {
                    unremoved.put(location, cause);
                }
            }
        }
        return unremoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File source, File target) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            int len;
            fis = new FileInputStream(source);
            fos = new FileOutputStream(target);
            byte[] buffer = new byte[8192];
            while ((len = fis.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(fis, fos);
            throw throwable;
        }
        IOUtils.close(fis, fos);
    }

    public static void reThrow(Throwable th) throws IOException {
        if (th != null) {
            if (th instanceof IOException) {
                throw (IOException)th;
            }
            IOUtils.reThrowUnchecked(th);
        }
    }

    public static void reThrowUnchecked(Throwable th) {
        if (th != null) {
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            if (th instanceof Error) {
                throw (Error)th;
            }
            throw new RuntimeException(th);
        }
    }

    /*
     * Exception decompiling
     */
    public static void fsync(File fileToSync, boolean isDir) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

