/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Locale;

public final class Version {
    @Deprecated
    public static final Version LUCENE_3_0_0 = new Version(3, 0, 0);
    @Deprecated
    public static final Version LUCENE_3_1_0 = new Version(3, 1, 0);
    @Deprecated
    public static final Version LUCENE_3_2_0 = new Version(3, 2, 0);
    @Deprecated
    public static final Version LUCENE_3_3_0 = new Version(3, 3, 0);
    @Deprecated
    public static final Version LUCENE_3_4_0 = new Version(3, 4, 0);
    @Deprecated
    public static final Version LUCENE_3_5_0 = new Version(3, 5, 0);
    @Deprecated
    public static final Version LUCENE_3_6_0 = new Version(3, 6, 0);
    @Deprecated
    public static final Version LUCENE_4_0_0_ALPHA = new Version(4, 0, 0, 0);
    @Deprecated
    public static final Version LUCENE_4_0_0_BETA = new Version(4, 0, 0, 1);
    @Deprecated
    public static final Version LUCENE_4_0_0 = new Version(4, 0, 0, 2);
    @Deprecated
    public static final Version LUCENE_4_1_0 = new Version(4, 1, 0);
    @Deprecated
    public static final Version LUCENE_4_2_0 = new Version(4, 2, 0);
    @Deprecated
    public static final Version LUCENE_4_2_1 = new Version(4, 2, 1);
    @Deprecated
    public static final Version LUCENE_4_3_0 = new Version(4, 3, 0);
    @Deprecated
    public static final Version LUCENE_4_3_1 = new Version(4, 3, 1);
    @Deprecated
    public static final Version LUCENE_4_4_0 = new Version(4, 4, 0);
    @Deprecated
    public static final Version LUCENE_4_5_0 = new Version(4, 5, 0);
    @Deprecated
    public static final Version LUCENE_4_5_1 = new Version(4, 5, 1);
    @Deprecated
    public static final Version LUCENE_4_6_0 = new Version(4, 6, 0);
    @Deprecated
    public static final Version LUCENE_4_6_1 = new Version(4, 6, 1);
    @Deprecated
    public static final Version LUCENE_4_7_0 = new Version(4, 7, 0);
    @Deprecated
    public static final Version LUCENE_4_7_1 = new Version(4, 7, 1);
    @Deprecated
    public static final Version LUCENE_4_7_2 = new Version(4, 7, 2);
    @Deprecated
    public static final Version LUCENE_4_8_0 = new Version(4, 8, 0);
    @Deprecated
    public static final Version LUCENE_4_8_1 = new Version(4, 8, 1);
    @Deprecated
    public static final Version LUCENE_4_9_0 = new Version(4, 9, 0);
    @Deprecated
    public static final Version LUCENE_4_10_0 = new Version(4, 10, 0);
    public static final Version LUCENE_4_11_0;
    public static final Version LATEST;
    @Deprecated
    public static final Version LUCENE_CURRENT;
    @Deprecated
    public static final Version LUCENE_30;
    @Deprecated
    public static final Version LUCENE_31;
    @Deprecated
    public static final Version LUCENE_32;
    @Deprecated
    public static final Version LUCENE_33;
    @Deprecated
    public static final Version LUCENE_34;
    @Deprecated
    public static final Version LUCENE_35;
    @Deprecated
    public static final Version LUCENE_36;
    @Deprecated
    public static final Version LUCENE_40;
    @Deprecated
    public static final Version LUCENE_41;
    @Deprecated
    public static final Version LUCENE_42;
    @Deprecated
    public static final Version LUCENE_43;
    @Deprecated
    public static final Version LUCENE_44;
    @Deprecated
    public static final Version LUCENE_45;
    @Deprecated
    public static final Version LUCENE_46;
    @Deprecated
    public static final Version LUCENE_47;
    @Deprecated
    public static final Version LUCENE_48;
    @Deprecated
    public static final Version LUCENE_3_0;
    @Deprecated
    public static final Version LUCENE_3_1;
    @Deprecated
    public static final Version LUCENE_3_2;
    @Deprecated
    public static final Version LUCENE_3_3;
    @Deprecated
    public static final Version LUCENE_3_4;
    @Deprecated
    public static final Version LUCENE_3_5;
    @Deprecated
    public static final Version LUCENE_3_6;
    @Deprecated
    public static final Version LUCENE_4_0;
    @Deprecated
    public static final Version LUCENE_4_1;
    @Deprecated
    public static final Version LUCENE_4_2;
    @Deprecated
    public static final Version LUCENE_4_3;
    @Deprecated
    public static final Version LUCENE_4_4;
    @Deprecated
    public static final Version LUCENE_4_5;
    @Deprecated
    public static final Version LUCENE_4_6;
    @Deprecated
    public static final Version LUCENE_4_7;
    @Deprecated
    public static final Version LUCENE_4_8;
    @Deprecated
    public static final Version LUCENE_4_9;
    public final int major;
    public final int minor;
    public final int bugfix;
    public final int prerelease;
    private final int encodedValue;

    public static Version parse(String version) {
        if (version == null) {
            return null;
        }
        String[] pieces = version.split("\\.");
        if (pieces.length < 2 || pieces.length > 4) {
            throw new IllegalArgumentException("Version is not in form major.minor.bugfix(.prerelease): " + version);
        }
        int major = Integer.parseInt(pieces[0]);
        int minor = Integer.parseInt(pieces[1]);
        int bugfix = 0;
        int prerelease = 0;
        if (pieces.length > 2) {
            bugfix = Integer.parseInt(pieces[2]);
        }
        if (pieces.length > 3 && (prerelease = Integer.parseInt(pieces[3])) == 0) {
            throw new IllegalArgumentException("Invalid value " + prerelease + " for prerelease of version " + version + ", should be 1 or 2");
        }
        return new Version(major, minor, bugfix, prerelease);
    }

    public static Version parseLeniently(String version) {
        switch (version = version.toUpperCase(Locale.ROOT)) {
            case "LATEST": 
            case "LUCENE_CURRENT": {
                return LATEST;
            }
            case "LUCENE_4_0_0": {
                return LUCENE_4_0_0;
            }
            case "LUCENE_4_0_0_ALPHA": {
                return LUCENE_4_0_0_ALPHA;
            }
            case "LUCENE_4_0_0_BETA": {
                return LUCENE_4_0_0_BETA;
            }
        }
        version = version.replaceFirst("^LUCENE_(\\d+)_(\\d+)_(\\d+)$", "$1.$2.$3").replaceFirst("^LUCENE_(\\d+)_(\\d+)$", "$1.$2.0").replaceFirst("^LUCENE_(\\d)(\\d)$", "$1.$2.0");
        return Version.parse(version);
    }

    private Version(int major, int minor, int bugfix) {
        this(major, minor, bugfix, 0);
    }

    private Version(int major, int minor, int bugfix, int prerelease) {
        this.major = major;
        this.minor = minor;
        this.bugfix = bugfix;
        this.prerelease = prerelease;
        if (major > 4 || major < 3) {
            throw new IllegalArgumentException("Lucene 4.x only supports 4.x and 3.x versions");
        }
        if (minor > 255 | minor < 0) {
            throw new IllegalArgumentException("Illegal minor version: " + minor);
        }
        if (bugfix > 255 | bugfix < 0) {
            throw new IllegalArgumentException("Illegal bugfix version: " + bugfix);
        }
        if (prerelease > 2 | prerelease < 0) {
            throw new IllegalArgumentException("Illegal prerelease version: " + prerelease);
        }
        if (prerelease != 0 && (minor != 0 || bugfix != 0)) {
            throw new IllegalArgumentException("Prerelease version only supported with major release");
        }
        this.encodedValue = major << 18 | minor << 10 | bugfix << 2 | prerelease;
    }

    public boolean onOrAfter(Version other) {
        return this.encodedValue >= other.encodedValue;
    }

    public String toString() {
        int major = this.encodedValue >>> 18 & 0xFF;
        int minor = this.encodedValue >>> 10 & 0xFF;
        int bugfix = this.encodedValue >>> 2 & 0xFF;
        int prerelease = this.encodedValue & 3;
        if (prerelease == 0) {
            return "" + major + "." + minor + "." + bugfix;
        }
        return "" + major + "." + minor + "." + bugfix + "." + prerelease;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof Version && ((Version)o).encodedValue == this.encodedValue;
    }

    public int hashCode() {
        return this.encodedValue;
    }

    static {
        LUCENE_CURRENT = LATEST = (LUCENE_4_11_0 = new Version(4, 11, 0));
        LUCENE_30 = LUCENE_3_0_0;
        LUCENE_31 = LUCENE_3_1_0;
        LUCENE_32 = LUCENE_3_2_0;
        LUCENE_33 = LUCENE_3_3_0;
        LUCENE_34 = LUCENE_3_4_0;
        LUCENE_35 = LUCENE_3_5_0;
        LUCENE_36 = LUCENE_3_6_0;
        LUCENE_40 = LUCENE_4_0_0_ALPHA;
        LUCENE_41 = LUCENE_4_1_0;
        LUCENE_42 = LUCENE_4_2_0;
        LUCENE_43 = LUCENE_4_3_0;
        LUCENE_44 = LUCENE_4_4_0;
        LUCENE_45 = LUCENE_4_5_0;
        LUCENE_46 = LUCENE_4_6_0;
        LUCENE_47 = LUCENE_4_7_0;
        LUCENE_48 = LUCENE_4_8_0;
        LUCENE_3_0 = LUCENE_3_0_0;
        LUCENE_3_1 = LUCENE_3_1_0;
        LUCENE_3_2 = LUCENE_3_2_0;
        LUCENE_3_3 = LUCENE_3_3_0;
        LUCENE_3_4 = LUCENE_3_4_0;
        LUCENE_3_5 = LUCENE_3_5_0;
        LUCENE_3_6 = LUCENE_3_6_0;
        LUCENE_4_0 = LUCENE_4_0_0_ALPHA;
        LUCENE_4_1 = LUCENE_4_1_0;
        LUCENE_4_2 = LUCENE_4_2_0;
        LUCENE_4_3 = LUCENE_4_3_0;
        LUCENE_4_4 = LUCENE_4_4_0;
        LUCENE_4_5 = LUCENE_4_5_0;
        LUCENE_4_6 = LUCENE_4_6_0;
        LUCENE_4_7 = LUCENE_4_7_0;
        LUCENE_4_8 = LUCENE_4_8_0;
        LUCENE_4_9 = LUCENE_4_9_0;
    }
}

