/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexDocument;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.StorableField;
import org.apache.lucene.index.StoredDocument;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FilterIterator;

public final class Document
implements IndexDocument {
    private final List<Field> fields = new ArrayList<Field>();
    private static final String[] NO_STRINGS = new String[0];

    public Document() {
    }

    public Document(StoredDocument storedDoc) {
        for (StorableField field : storedDoc.getFields()) {
            Field newField = new Field(field.name(), (FieldType)field.fieldType());
            newField.fieldsData = field.stringValue();
            if (newField.fieldsData == null) {
                newField.fieldsData = field.numericValue();
            }
            if (newField.fieldsData == null) {
                newField.fieldsData = field.binaryValue();
            }
            if (newField.fieldsData == null) {
                newField.fieldsData = field.readerValue();
            }
            this.add(newField);
        }
    }

    public final void add(Field field) {
        this.fields.add(field);
    }

    public final void removeField(String name) {
        Iterator<Field> it = this.fields.iterator();
        while (it.hasNext()) {
            Field field = it.next();
            if (!field.name().equals(name)) continue;
            it.remove();
            return;
        }
    }

    public final void removeFields(String name) {
        Iterator<Field> it = this.fields.iterator();
        while (it.hasNext()) {
            Field field = it.next();
            if (!field.name().equals(name)) continue;
            it.remove();
        }
    }

    public final BytesRef[] getBinaryValues(String name) {
        ArrayList<BytesRef> result = new ArrayList<BytesRef>();
        Iterator<StorableField> it = this.storedFieldsIterator();
        while (it.hasNext()) {
            BytesRef bytes;
            StorableField field = it.next();
            if (!field.name().equals(name) || (bytes = field.binaryValue()) == null) continue;
            result.add(bytes);
        }
        return result.toArray(new BytesRef[result.size()]);
    }

    public final BytesRef getBinaryValue(String name) {
        Iterator<StorableField> it = this.storedFieldsIterator();
        while (it.hasNext()) {
            BytesRef bytes;
            StorableField field = it.next();
            if (!field.name().equals(name) || (bytes = field.binaryValue()) == null) continue;
            return bytes;
        }
        return null;
    }

    public final Field getField(String name) {
        for (Field field : this.fields) {
            if (!field.name().equals(name)) continue;
            return field;
        }
        return null;
    }

    public Field[] getFields(String name) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field field : this.fields) {
            if (!field.name().equals(name)) continue;
            result.add(field);
        }
        return result.toArray(new Field[result.size()]);
    }

    public final List<Field> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public final String[] getValues(String name) {
        ArrayList<String> result = new ArrayList<String>();
        Iterator<StorableField> it = this.storedFieldsIterator();
        while (it.hasNext()) {
            StorableField field = it.next();
            if (!field.name().equals(name) || field.stringValue() == null) continue;
            result.add(field.stringValue());
        }
        if (result.size() == 0) {
            return NO_STRINGS;
        }
        return result.toArray(new String[result.size()]);
    }

    public final String get(String name) {
        Iterator<StorableField> it = this.storedFieldsIterator();
        while (it.hasNext()) {
            StorableField field = it.next();
            if (!field.name().equals(name) || field.stringValue() == null) continue;
            return field.stringValue();
        }
        return null;
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Document<");
        for (int i = 0; i < this.fields.size(); ++i) {
            IndexableField field = this.fields.get(i);
            buffer.append(field.toString());
            if (i == this.fields.size() - 1) continue;
            buffer.append(" ");
        }
        buffer.append(">");
        return buffer.toString();
    }

    public Iterable<IndexableField> indexableFields() {
        return new Iterable<IndexableField>(){

            @Override
            public Iterator<IndexableField> iterator() {
                return Document.this.indexedFieldsIterator();
            }
        };
    }

    public Iterable<StorableField> storableFields() {
        return new Iterable<StorableField>(){

            @Override
            public Iterator<StorableField> iterator() {
                return Document.this.storedFieldsIterator();
            }
        };
    }

    private Iterator<StorableField> storedFieldsIterator() {
        return new FilterIterator<StorableField, Field>(this.fields.iterator()){

            @Override
            protected boolean predicateFunction(Field field) {
                return field.type.stored() || field.type.docValueType() != null;
            }
        };
    }

    private Iterator<IndexableField> indexedFieldsIterator() {
        return new FilterIterator<IndexableField, Field>(this.fields.iterator()){

            @Override
            protected boolean predicateFunction(Field field) {
                return field.type.indexed();
            }
        };
    }

    public void clear() {
        this.fields.clear();
    }
}

